/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGPU)

#include "JSGPUBindGroupLayoutBinding.h"

#include "JSDOMConvertNumbers.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEBGPU)

template<> GPUBindGroupLayoutBinding convertDictionary<GPUBindGroupLayoutBinding>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GPUBindGroupLayoutBinding result;
    JSValue bindingValue;
    if (isNullOrUndefined)
        bindingValue = jsUndefined();
    else {
        bindingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "binding"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bindingValue.isUndefined()) {
        result.binding = convert<IDLUnsignedLong>(lexicalGlobalObject, bindingValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "binding", "GPUBindGroupLayoutBinding", "unsigned long");
        return { };
    }
    JSValue typeValue;
    if (isNullOrUndefined)
        typeValue = jsUndefined();
    else {
        typeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "type"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!typeValue.isUndefined()) {
        result.type = convert<IDLEnumeration<GPUBindingType>>(lexicalGlobalObject, typeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "type", "GPUBindGroupLayoutBinding", "GPUBindingType");
        return { };
    }
    JSValue visibilityValue;
    if (isNullOrUndefined)
        visibilityValue = jsUndefined();
    else {
        visibilityValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "visibility"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!visibilityValue.isUndefined()) {
        result.visibility = convert<IDLUnsignedLong>(lexicalGlobalObject, visibilityValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "visibility", "GPUBindGroupLayoutBinding", "unsigned long");
        return { };
    }
    return result;
}

#endif

String convertEnumerationToString(GPUBindingType enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("uniform-buffer"),
        MAKE_STATIC_STRING_IMPL("dynamic-uniform-buffer"),
        MAKE_STATIC_STRING_IMPL("sampler"),
        MAKE_STATIC_STRING_IMPL("sampled-texture"),
        MAKE_STATIC_STRING_IMPL("storage-buffer"),
        MAKE_STATIC_STRING_IMPL("dynamic-storage-buffer"),
    };
    static_assert(static_cast<size_t>(GPUBindingType::UniformBuffer) == 0, "GPUBindingType::UniformBuffer is not 0 as expected");
    static_assert(static_cast<size_t>(GPUBindingType::DynamicUniformBuffer) == 1, "GPUBindingType::DynamicUniformBuffer is not 1 as expected");
    static_assert(static_cast<size_t>(GPUBindingType::Sampler) == 2, "GPUBindingType::Sampler is not 2 as expected");
    static_assert(static_cast<size_t>(GPUBindingType::SampledTexture) == 3, "GPUBindingType::SampledTexture is not 3 as expected");
    static_assert(static_cast<size_t>(GPUBindingType::StorageBuffer) == 4, "GPUBindingType::StorageBuffer is not 4 as expected");
    static_assert(static_cast<size_t>(GPUBindingType::DynamicStorageBuffer) == 5, "GPUBindingType::DynamicStorageBuffer is not 5 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, GPUBindingType enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<GPUBindingType> parseEnumeration<GPUBindingType>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "uniform-buffer")
        return GPUBindingType::UniformBuffer;
    if (stringValue == "dynamic-uniform-buffer")
        return GPUBindingType::DynamicUniformBuffer;
    if (stringValue == "sampler")
        return GPUBindingType::Sampler;
    if (stringValue == "sampled-texture")
        return GPUBindingType::SampledTexture;
    if (stringValue == "storage-buffer")
        return GPUBindingType::StorageBuffer;
    if (stringValue == "dynamic-storage-buffer")
        return GPUBindingType::DynamicStorageBuffer;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<GPUBindingType>()
{
    return "\"uniform-buffer\", \"dynamic-uniform-buffer\", \"sampler\", \"sampled-texture\", \"storage-buffer\", \"dynamic-storage-buffer\"";
}

} // namespace WebCore

#endif // ENABLE(WEBGPU)
