/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGPU)

#include "JSGPUCanvasContext.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSGPUTextureFormat.h"
#include "JSHTMLCanvasElement.h"
#include "JSWebGPUDevice.h"
#include "JSWebGPUSwapChain.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEBGPU)

template<> WebGPUSwapChainDescriptor convertDictionary<WebGPUSwapChainDescriptor>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    WebGPUSwapChainDescriptor result;
    JSValue deviceValue;
    if (isNullOrUndefined)
        deviceValue = jsUndefined();
    else {
        deviceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "device"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!deviceValue.isUndefined()) {
        result.device = convert<IDLInterface<WebGPUDevice>>(lexicalGlobalObject, deviceValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "device", "WebGPUSwapChainDescriptor", "WebGPUDevice");
        return { };
    }
    JSValue formatValue;
    if (isNullOrUndefined)
        formatValue = jsUndefined();
    else {
        formatValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "format"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!formatValue.isUndefined()) {
        result.format = convert<IDLEnumeration<GPUTextureFormat>>(lexicalGlobalObject, formatValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "format", "WebGPUSwapChainDescriptor", "GPUTextureFormat");
        return { };
    }
    JSValue usageValue;
    if (isNullOrUndefined)
        usageValue = jsUndefined();
    else {
        usageValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "usage"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!usageValue.isUndefined()) {
        result.usage = convert<IDLUnsignedLong>(lexicalGlobalObject, usageValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

#endif

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsGPUCanvasContextPrototypeFunctionConfigureSwapChain(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsGPUCanvasContextConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSGPUCanvasContextConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsGPUCanvasContextCanvas(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSGPUCanvasContextPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSGPUCanvasContextPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGPUCanvasContextPrototype* ptr = new (NotNull, JSC::allocateCell<JSGPUCanvasContextPrototype>(vm.heap)) JSGPUCanvasContextPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGPUCanvasContextPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUCanvasContextPrototype, JSGPUCanvasContextPrototype::Base);

using JSGPUCanvasContextConstructor = JSDOMConstructorNotConstructable<JSGPUCanvasContext>;

template<> JSValue JSGPUCanvasContextConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSGPUCanvasContextConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSGPUCanvasContext::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("GPUCanvasContext"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSGPUCanvasContextConstructor::s_info = { "GPUCanvasContext", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUCanvasContextConstructor) };

/* Hash table for prototype */

static const HashTableValue JSGPUCanvasContextPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsGPUCanvasContextConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSGPUCanvasContextConstructor) } },
    { "canvas", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsGPUCanvasContextCanvas), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "configureSwapChain", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsGPUCanvasContextPrototypeFunctionConfigureSwapChain), (intptr_t) (1) } },
};

const ClassInfo JSGPUCanvasContextPrototype::s_info = { "GPUCanvasContextPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUCanvasContextPrototype) };

void JSGPUCanvasContextPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGPUCanvasContext::info(), JSGPUCanvasContextPrototypeTableValues, *this);
}

const ClassInfo JSGPUCanvasContext::s_info = { "GPUCanvasContext", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUCanvasContext) };

JSGPUCanvasContext::JSGPUCanvasContext(Structure* structure, JSDOMGlobalObject& globalObject, Ref<GPUCanvasContext>&& impl)
    : JSDOMWrapper<GPUCanvasContext>(structure, globalObject, WTFMove(impl))
{
}

void JSGPUCanvasContext::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(std::is_base_of<ActiveDOMObject, GPUCanvasContext>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

}

JSObject* JSGPUCanvasContext::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSGPUCanvasContextPrototype::create(vm, &globalObject, JSGPUCanvasContextPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSGPUCanvasContext::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSGPUCanvasContext>(vm, globalObject);
}

JSValue JSGPUCanvasContext::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSGPUCanvasContextConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSGPUCanvasContext::destroy(JSC::JSCell* cell)
{
    JSGPUCanvasContext* thisObject = static_cast<JSGPUCanvasContext*>(cell);
    thisObject->JSGPUCanvasContext::~JSGPUCanvasContext();
}

template<> inline JSGPUCanvasContext* IDLAttribute<JSGPUCanvasContext>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSGPUCanvasContext*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSGPUCanvasContext* IDLOperation<JSGPUCanvasContext>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSGPUCanvasContext*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsGPUCanvasContextConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGPUCanvasContextPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSGPUCanvasContext::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSGPUCanvasContextConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGPUCanvasContextPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsGPUCanvasContextCanvasGetter(JSGlobalObject& lexicalGlobalObject, JSGPUCanvasContext& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<HTMLCanvasElement>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.canvas());
    return result;
}

EncodedJSValue jsGPUCanvasContextCanvas(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSGPUCanvasContext>::get<jsGPUCanvasContextCanvasGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "canvas");
}

static inline JSC::EncodedJSValue jsGPUCanvasContextPrototypeFunctionConfigureSwapChainBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSGPUCanvasContext>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto descriptor = convert<IDLDictionary<WebGPUSwapChainDescriptor>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<WebGPUSwapChain>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.configureSwapChain(WTFMove(descriptor))));
}

EncodedJSValue JSC_HOST_CALL jsGPUCanvasContextPrototypeFunctionConfigureSwapChain(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSGPUCanvasContext>::call<jsGPUCanvasContextPrototypeFunctionConfigureSwapChainBody>(*lexicalGlobalObject, *callFrame, "configureSwapChain");
}

void JSGPUCanvasContext::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSGPUCanvasContext*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSGPUCanvasContextOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsGPUCanvasContext = jsCast<JSGPUCanvasContext*>(handle.slot()->asCell());
    if (jsGPUCanvasContext->wrapped().hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSGPUCanvasContextOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGPUCanvasContext = static_cast<JSGPUCanvasContext*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsGPUCanvasContext->wrapped(), jsGPUCanvasContext);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7GPUCanvasContext@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore16GPUCanvasContextE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<GPUCanvasContext>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7GPUCanvasContext@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore16GPUCanvasContextE[2];
#endif

    // If this fails GPUCanvasContext does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<GPUCanvasContext>::value, "GPUCanvasContext is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // GPUCanvasContext has subclasses. If GPUCanvasContext has subclasses that get passed
    // to toJS() we currently require GPUCanvasContext you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<GPUCanvasContext>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, GPUCanvasContext& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

GPUCanvasContext* JSGPUCanvasContext::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGPUCanvasContext*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGPU)
