/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGPU)

#include "JSGPUColorStateDescriptor.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNumbers.h"
#include "JSGPUBlendDescriptor.h"
#include "JSGPUTextureFormat.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEBGPU)

template<> GPUColorStateDescriptor convertDictionary<GPUColorStateDescriptor>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GPUColorStateDescriptor result;
    JSValue alphaBlendValue;
    if (isNullOrUndefined)
        alphaBlendValue = jsUndefined();
    else {
        alphaBlendValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "alphaBlend"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!alphaBlendValue.isUndefined()) {
        result.alphaBlend = convert<IDLDictionary<GPUBlendDescriptor>>(lexicalGlobalObject, alphaBlendValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "alphaBlend", "GPUColorStateDescriptor", "GPUBlendDescriptor");
        return { };
    }
    JSValue colorBlendValue;
    if (isNullOrUndefined)
        colorBlendValue = jsUndefined();
    else {
        colorBlendValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "colorBlend"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!colorBlendValue.isUndefined()) {
        result.colorBlend = convert<IDLDictionary<GPUBlendDescriptor>>(lexicalGlobalObject, colorBlendValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "colorBlend", "GPUColorStateDescriptor", "GPUBlendDescriptor");
        return { };
    }
    JSValue formatValue;
    if (isNullOrUndefined)
        formatValue = jsUndefined();
    else {
        formatValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "format"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!formatValue.isUndefined()) {
        result.format = convert<IDLEnumeration<GPUTextureFormat>>(lexicalGlobalObject, formatValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "format", "GPUColorStateDescriptor", "GPUTextureFormat");
        return { };
    }
    JSValue writeMaskValue;
    if (isNullOrUndefined)
        writeMaskValue = jsUndefined();
    else {
        writeMaskValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "writeMask"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!writeMaskValue.isUndefined()) {
        result.writeMask = convert<IDLUnsignedLong>(lexicalGlobalObject, writeMaskValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEBGPU)
