/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGPU)

#include "JSGPUCompareFunction.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(GPUCompareFunction enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("never"),
        MAKE_STATIC_STRING_IMPL("less"),
        MAKE_STATIC_STRING_IMPL("equal"),
        MAKE_STATIC_STRING_IMPL("less-equal"),
        MAKE_STATIC_STRING_IMPL("greater"),
        MAKE_STATIC_STRING_IMPL("not-equal"),
        MAKE_STATIC_STRING_IMPL("greater-equal"),
        MAKE_STATIC_STRING_IMPL("always"),
    };
    static_assert(static_cast<size_t>(GPUCompareFunction::Never) == 0, "GPUCompareFunction::Never is not 0 as expected");
    static_assert(static_cast<size_t>(GPUCompareFunction::Less) == 1, "GPUCompareFunction::Less is not 1 as expected");
    static_assert(static_cast<size_t>(GPUCompareFunction::Equal) == 2, "GPUCompareFunction::Equal is not 2 as expected");
    static_assert(static_cast<size_t>(GPUCompareFunction::LessEqual) == 3, "GPUCompareFunction::LessEqual is not 3 as expected");
    static_assert(static_cast<size_t>(GPUCompareFunction::Greater) == 4, "GPUCompareFunction::Greater is not 4 as expected");
    static_assert(static_cast<size_t>(GPUCompareFunction::NotEqual) == 5, "GPUCompareFunction::NotEqual is not 5 as expected");
    static_assert(static_cast<size_t>(GPUCompareFunction::GreaterEqual) == 6, "GPUCompareFunction::GreaterEqual is not 6 as expected");
    static_assert(static_cast<size_t>(GPUCompareFunction::Always) == 7, "GPUCompareFunction::Always is not 7 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, GPUCompareFunction enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<GPUCompareFunction> parseEnumeration<GPUCompareFunction>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "never")
        return GPUCompareFunction::Never;
    if (stringValue == "less")
        return GPUCompareFunction::Less;
    if (stringValue == "equal")
        return GPUCompareFunction::Equal;
    if (stringValue == "less-equal")
        return GPUCompareFunction::LessEqual;
    if (stringValue == "greater")
        return GPUCompareFunction::Greater;
    if (stringValue == "not-equal")
        return GPUCompareFunction::NotEqual;
    if (stringValue == "greater-equal")
        return GPUCompareFunction::GreaterEqual;
    if (stringValue == "always")
        return GPUCompareFunction::Always;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<GPUCompareFunction>()
{
    return "\"never\", \"less\", \"equal\", \"less-equal\", \"greater\", \"not-equal\", \"greater-equal\", \"always\"";
}

} // namespace WebCore

#endif // ENABLE(WEBGPU)
