/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGPU)

#include "JSGPURequestAdapterOptions.h"

#include "JSDOMConvertNullable.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEBGPU)

template<> GPURequestAdapterOptions convertDictionary<GPURequestAdapterOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GPURequestAdapterOptions result;
    JSValue powerPreferenceValue;
    if (isNullOrUndefined)
        powerPreferenceValue = jsUndefined();
    else {
        powerPreferenceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "powerPreference"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!powerPreferenceValue.isUndefined()) {
        result.powerPreference = convert<IDLNullable<IDLEnumeration<GPUPowerPreference>>>(lexicalGlobalObject, powerPreferenceValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

#endif

String convertEnumerationToString(GPUPowerPreference enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("low-power"),
        MAKE_STATIC_STRING_IMPL("high-performance"),
    };
    static_assert(static_cast<size_t>(GPUPowerPreference::LowPower) == 0, "GPUPowerPreference::LowPower is not 0 as expected");
    static_assert(static_cast<size_t>(GPUPowerPreference::HighPerformance) == 1, "GPUPowerPreference::HighPerformance is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, GPUPowerPreference enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<GPUPowerPreference> parseEnumeration<GPUPowerPreference>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "low-power")
        return GPUPowerPreference::LowPower;
    if (stringValue == "high-performance")
        return GPUPowerPreference::HighPerformance;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<GPUPowerPreference>()
{
    return "\"low-power\", \"high-performance\"";
}

} // namespace WebCore

#endif // ENABLE(WEBGPU)
