/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGPU)

#include "JSGPUTextureDescriptor.h"

#include "JSDOMConvertNumbers.h"
#include "JSGPUExtent3D.h"
#include "JSGPUTextureFormat.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEBGPU)

template<> GPUTextureDescriptor convertDictionary<GPUTextureDescriptor>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GPUTextureDescriptor result;
    JSValue arrayLayerCountValue;
    if (isNullOrUndefined)
        arrayLayerCountValue = jsUndefined();
    else {
        arrayLayerCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "arrayLayerCount"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!arrayLayerCountValue.isUndefined()) {
        result.arrayLayerCount = convert<IDLUnsignedLong>(lexicalGlobalObject, arrayLayerCountValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.arrayLayerCount = 1;
    JSValue dimensionValue;
    if (isNullOrUndefined)
        dimensionValue = jsUndefined();
    else {
        dimensionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "dimension"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!dimensionValue.isUndefined()) {
        result.dimension = convert<IDLEnumeration<GPUTextureDimension>>(lexicalGlobalObject, dimensionValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.dimension = GPUTextureDimension::_2d;
    JSValue formatValue;
    if (isNullOrUndefined)
        formatValue = jsUndefined();
    else {
        formatValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "format"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!formatValue.isUndefined()) {
        result.format = convert<IDLEnumeration<GPUTextureFormat>>(lexicalGlobalObject, formatValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "format", "GPUTextureDescriptor", "GPUTextureFormat");
        return { };
    }
    JSValue mipLevelCountValue;
    if (isNullOrUndefined)
        mipLevelCountValue = jsUndefined();
    else {
        mipLevelCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "mipLevelCount"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!mipLevelCountValue.isUndefined()) {
        result.mipLevelCount = convert<IDLUnsignedLong>(lexicalGlobalObject, mipLevelCountValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.mipLevelCount = 1;
    JSValue sampleCountValue;
    if (isNullOrUndefined)
        sampleCountValue = jsUndefined();
    else {
        sampleCountValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "sampleCount"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!sampleCountValue.isUndefined()) {
        result.sampleCount = convert<IDLUnsignedLong>(lexicalGlobalObject, sampleCountValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.sampleCount = 1;
    JSValue sizeValue;
    if (isNullOrUndefined)
        sizeValue = jsUndefined();
    else {
        sizeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "size"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!sizeValue.isUndefined()) {
        result.size = convert<IDLDictionary<GPUExtent3D>>(lexicalGlobalObject, sizeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "size", "GPUTextureDescriptor", "GPUExtent3D");
        return { };
    }
    JSValue usageValue;
    if (isNullOrUndefined)
        usageValue = jsUndefined();
    else {
        usageValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "usage"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!usageValue.isUndefined()) {
        result.usage = convert<IDLUnsignedLong>(lexicalGlobalObject, usageValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "usage", "GPUTextureDescriptor", "unsigned long");
        return { };
    }
    return result;
}

#endif

String convertEnumerationToString(GPUTextureDimension enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("1d"),
        MAKE_STATIC_STRING_IMPL("2d"),
        MAKE_STATIC_STRING_IMPL("3d"),
    };
    static_assert(static_cast<size_t>(GPUTextureDimension::_1d) == 0, "GPUTextureDimension::_1d is not 0 as expected");
    static_assert(static_cast<size_t>(GPUTextureDimension::_2d) == 1, "GPUTextureDimension::_2d is not 1 as expected");
    static_assert(static_cast<size_t>(GPUTextureDimension::_3d) == 2, "GPUTextureDimension::_3d is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, GPUTextureDimension enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<GPUTextureDimension> parseEnumeration<GPUTextureDimension>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "1d")
        return GPUTextureDimension::_1d;
    if (stringValue == "2d")
        return GPUTextureDimension::_2d;
    if (stringValue == "3d")
        return GPUTextureDimension::_3d;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<GPUTextureDimension>()
{
    return "\"1d\", \"2d\", \"3d\"";
}

} // namespace WebCore

#endif // ENABLE(WEBGPU)
