/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGPU)

#include "JSGPUVertexBufferDescriptor.h"

#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSGPUVertexAttributeDescriptor.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEBGPU)

template<> GPUVertexBufferDescriptor convertDictionary<GPUVertexBufferDescriptor>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GPUVertexBufferDescriptor result;
    JSValue attributeSetValue;
    if (isNullOrUndefined)
        attributeSetValue = jsUndefined();
    else {
        attributeSetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "attributeSet"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!attributeSetValue.isUndefined()) {
        result.attributeSet = convert<IDLSequence<IDLDictionary<GPUVertexAttributeDescriptor>>>(lexicalGlobalObject, attributeSetValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue stepModeValue;
    if (isNullOrUndefined)
        stepModeValue = jsUndefined();
    else {
        stepModeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "stepMode"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!stepModeValue.isUndefined()) {
        result.stepMode = convert<IDLEnumeration<GPUInputStepMode>>(lexicalGlobalObject, stepModeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.stepMode = GPUInputStepMode::Vertex;
    JSValue strideValue;
    if (isNullOrUndefined)
        strideValue = jsUndefined();
    else {
        strideValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "stride"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!strideValue.isUndefined()) {
        result.stride = convert<IDLUnsignedLongLong>(lexicalGlobalObject, strideValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "stride", "GPUVertexBufferDescriptor", "unsigned long long");
        return { };
    }
    return result;
}

#endif

String convertEnumerationToString(GPUInputStepMode enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("vertex"),
        MAKE_STATIC_STRING_IMPL("instance"),
    };
    static_assert(static_cast<size_t>(GPUInputStepMode::Vertex) == 0, "GPUInputStepMode::Vertex is not 0 as expected");
    static_assert(static_cast<size_t>(GPUInputStepMode::Instance) == 1, "GPUInputStepMode::Instance is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, GPUInputStepMode enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<GPUInputStepMode> parseEnumeration<GPUInputStepMode>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "vertex")
        return GPUInputStepMode::Vertex;
    if (stringValue == "instance")
        return GPUInputStepMode::Instance;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<GPUInputStepMode>()
{
    return "\"vertex\", \"instance\"";
}

} // namespace WebCore

#endif // ENABLE(WEBGPU)
