/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(GEOLOCATION)

#include "JSGeolocationCoordinates.h"

#include "ActiveDOMObject.h"
#include "Document.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsGeolocationCoordinatesConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSGeolocationCoordinatesConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsGeolocationCoordinatesLatitude(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsGeolocationCoordinatesLongitude(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsGeolocationCoordinatesAltitude(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsGeolocationCoordinatesAccuracy(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsGeolocationCoordinatesAltitudeAccuracy(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsGeolocationCoordinatesHeading(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsGeolocationCoordinatesSpeed(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsGeolocationCoordinatesFloorLevel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSGeolocationCoordinatesPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSGeolocationCoordinatesPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGeolocationCoordinatesPrototype* ptr = new (NotNull, JSC::allocateCell<JSGeolocationCoordinatesPrototype>(vm.heap)) JSGeolocationCoordinatesPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGeolocationCoordinatesPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGeolocationCoordinatesPrototype, JSGeolocationCoordinatesPrototype::Base);

using JSGeolocationCoordinatesConstructor = JSDOMConstructorNotConstructable<JSGeolocationCoordinates>;

template<> JSValue JSGeolocationCoordinatesConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSGeolocationCoordinatesConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSGeolocationCoordinates::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("GeolocationCoordinates"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSGeolocationCoordinatesConstructor::s_info = { "GeolocationCoordinates", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGeolocationCoordinatesConstructor) };

/* Hash table for prototype */

static const HashTableValue JSGeolocationCoordinatesPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsGeolocationCoordinatesConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSGeolocationCoordinatesConstructor) } },
    { "latitude", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsGeolocationCoordinatesLatitude), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "longitude", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsGeolocationCoordinatesLongitude), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "altitude", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsGeolocationCoordinatesAltitude), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "accuracy", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsGeolocationCoordinatesAccuracy), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "altitudeAccuracy", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsGeolocationCoordinatesAltitudeAccuracy), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "heading", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsGeolocationCoordinatesHeading), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "speed", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsGeolocationCoordinatesSpeed), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "floorLevel", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsGeolocationCoordinatesFloorLevel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSGeolocationCoordinatesPrototype::s_info = { "GeolocationCoordinatesPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGeolocationCoordinatesPrototype) };

void JSGeolocationCoordinatesPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGeolocationCoordinates::info(), JSGeolocationCoordinatesPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().geolocationFloorLevelEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("floorLevel"), strlen("floorLevel"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
}

const ClassInfo JSGeolocationCoordinates::s_info = { "GeolocationCoordinates", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGeolocationCoordinates) };

JSGeolocationCoordinates::JSGeolocationCoordinates(Structure* structure, JSDOMGlobalObject& globalObject, Ref<GeolocationCoordinates>&& impl)
    : JSDOMWrapper<GeolocationCoordinates>(structure, globalObject, WTFMove(impl))
{
}

void JSGeolocationCoordinates::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, GeolocationCoordinates>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSGeolocationCoordinates::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSGeolocationCoordinatesPrototype::create(vm, &globalObject, JSGeolocationCoordinatesPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSGeolocationCoordinates::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSGeolocationCoordinates>(vm, globalObject);
}

JSValue JSGeolocationCoordinates::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSGeolocationCoordinatesConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSGeolocationCoordinates::destroy(JSC::JSCell* cell)
{
    JSGeolocationCoordinates* thisObject = static_cast<JSGeolocationCoordinates*>(cell);
    thisObject->JSGeolocationCoordinates::~JSGeolocationCoordinates();
}

template<> inline JSGeolocationCoordinates* IDLAttribute<JSGeolocationCoordinates>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSGeolocationCoordinates*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsGeolocationCoordinatesConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGeolocationCoordinatesPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSGeolocationCoordinates::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSGeolocationCoordinatesConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGeolocationCoordinatesPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsGeolocationCoordinatesLatitudeGetter(JSGlobalObject& lexicalGlobalObject, JSGeolocationCoordinates& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.latitude());
    return result;
}

EncodedJSValue jsGeolocationCoordinatesLatitude(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSGeolocationCoordinates>::get<jsGeolocationCoordinatesLatitudeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "latitude");
}

static inline JSValue jsGeolocationCoordinatesLongitudeGetter(JSGlobalObject& lexicalGlobalObject, JSGeolocationCoordinates& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.longitude());
    return result;
}

EncodedJSValue jsGeolocationCoordinatesLongitude(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSGeolocationCoordinates>::get<jsGeolocationCoordinatesLongitudeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "longitude");
}

static inline JSValue jsGeolocationCoordinatesAltitudeGetter(JSGlobalObject& lexicalGlobalObject, JSGeolocationCoordinates& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLUnrestrictedDouble>>(lexicalGlobalObject, throwScope, impl.altitude());
    return result;
}

EncodedJSValue jsGeolocationCoordinatesAltitude(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSGeolocationCoordinates>::get<jsGeolocationCoordinatesAltitudeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "altitude");
}

static inline JSValue jsGeolocationCoordinatesAccuracyGetter(JSGlobalObject& lexicalGlobalObject, JSGeolocationCoordinates& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.accuracy());
    return result;
}

EncodedJSValue jsGeolocationCoordinatesAccuracy(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSGeolocationCoordinates>::get<jsGeolocationCoordinatesAccuracyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "accuracy");
}

static inline JSValue jsGeolocationCoordinatesAltitudeAccuracyGetter(JSGlobalObject& lexicalGlobalObject, JSGeolocationCoordinates& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLUnrestrictedDouble>>(lexicalGlobalObject, throwScope, impl.altitudeAccuracy());
    return result;
}

EncodedJSValue jsGeolocationCoordinatesAltitudeAccuracy(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSGeolocationCoordinates>::get<jsGeolocationCoordinatesAltitudeAccuracyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "altitudeAccuracy");
}

static inline JSValue jsGeolocationCoordinatesHeadingGetter(JSGlobalObject& lexicalGlobalObject, JSGeolocationCoordinates& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLUnrestrictedDouble>>(lexicalGlobalObject, throwScope, impl.heading());
    return result;
}

EncodedJSValue jsGeolocationCoordinatesHeading(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSGeolocationCoordinates>::get<jsGeolocationCoordinatesHeadingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "heading");
}

static inline JSValue jsGeolocationCoordinatesSpeedGetter(JSGlobalObject& lexicalGlobalObject, JSGeolocationCoordinates& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLUnrestrictedDouble>>(lexicalGlobalObject, throwScope, impl.speed());
    return result;
}

EncodedJSValue jsGeolocationCoordinatesSpeed(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSGeolocationCoordinates>::get<jsGeolocationCoordinatesSpeedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "speed");
}

static inline JSValue jsGeolocationCoordinatesFloorLevelGetter(JSGlobalObject& lexicalGlobalObject, JSGeolocationCoordinates& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLUnrestrictedDouble>>(lexicalGlobalObject, throwScope, impl.floorLevel());
    return result;
}

EncodedJSValue jsGeolocationCoordinatesFloorLevel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSGeolocationCoordinates>::get<jsGeolocationCoordinatesFloorLevelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "floorLevel");
}

void JSGeolocationCoordinates::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSGeolocationCoordinates*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSGeolocationCoordinatesOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSGeolocationCoordinatesOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGeolocationCoordinates = static_cast<JSGeolocationCoordinates*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsGeolocationCoordinates->wrapped(), jsGeolocationCoordinates);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<GeolocationCoordinates>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to GeolocationCoordinates.
    static_assert(!std::is_polymorphic<GeolocationCoordinates>::value, "GeolocationCoordinates is polymorphic but the IDL claims it is not");
    return createWrapper<GeolocationCoordinates>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, GeolocationCoordinates& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

GeolocationCoordinates* JSGeolocationCoordinates::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGeolocationCoordinates*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(GEOLOCATION)
