/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(GEOLOCATION)

#include "JSGeolocationPosition.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMWrapperCache.h"
#include "JSGeolocationCoordinates.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsGeolocationPositionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSGeolocationPositionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsGeolocationPositionCoords(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsGeolocationPositionTimestamp(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSGeolocationPositionPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSGeolocationPositionPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGeolocationPositionPrototype* ptr = new (NotNull, JSC::allocateCell<JSGeolocationPositionPrototype>(vm.heap)) JSGeolocationPositionPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGeolocationPositionPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGeolocationPositionPrototype, JSGeolocationPositionPrototype::Base);

using JSGeolocationPositionConstructor = JSDOMConstructorNotConstructable<JSGeolocationPosition>;

template<> JSValue JSGeolocationPositionConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSGeolocationPositionConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSGeolocationPosition::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("GeolocationPosition"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSGeolocationPositionConstructor::s_info = { "GeolocationPosition", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGeolocationPositionConstructor) };

/* Hash table for prototype */

static const HashTableValue JSGeolocationPositionPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsGeolocationPositionConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSGeolocationPositionConstructor) } },
    { "coords", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsGeolocationPositionCoords), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "timestamp", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsGeolocationPositionTimestamp), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSGeolocationPositionPrototype::s_info = { "GeolocationPositionPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGeolocationPositionPrototype) };

void JSGeolocationPositionPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGeolocationPosition::info(), JSGeolocationPositionPrototypeTableValues, *this);
}

const ClassInfo JSGeolocationPosition::s_info = { "GeolocationPosition", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGeolocationPosition) };

JSGeolocationPosition::JSGeolocationPosition(Structure* structure, JSDOMGlobalObject& globalObject, Ref<GeolocationPosition>&& impl)
    : JSDOMWrapper<GeolocationPosition>(structure, globalObject, WTFMove(impl))
{
}

void JSGeolocationPosition::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, GeolocationPosition>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSGeolocationPosition::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSGeolocationPositionPrototype::create(vm, &globalObject, JSGeolocationPositionPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSGeolocationPosition::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSGeolocationPosition>(vm, globalObject);
}

JSValue JSGeolocationPosition::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSGeolocationPositionConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSGeolocationPosition::destroy(JSC::JSCell* cell)
{
    JSGeolocationPosition* thisObject = static_cast<JSGeolocationPosition*>(cell);
    thisObject->JSGeolocationPosition::~JSGeolocationPosition();
}

template<> inline JSGeolocationPosition* IDLAttribute<JSGeolocationPosition>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSGeolocationPosition*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsGeolocationPositionConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGeolocationPositionPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSGeolocationPosition::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSGeolocationPositionConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGeolocationPositionPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsGeolocationPositionCoordsGetter(JSGlobalObject& lexicalGlobalObject, JSGeolocationPosition& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<GeolocationCoordinates>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.coords());
    return result;
}

EncodedJSValue jsGeolocationPositionCoords(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSGeolocationPosition>::get<jsGeolocationPositionCoordsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "coords");
}

static inline JSValue jsGeolocationPositionTimestampGetter(JSGlobalObject& lexicalGlobalObject, JSGeolocationPosition& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLongLong>(lexicalGlobalObject, throwScope, impl.timestamp());
    return result;
}

EncodedJSValue jsGeolocationPositionTimestamp(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSGeolocationPosition>::get<jsGeolocationPositionTimestampGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "timestamp");
}

void JSGeolocationPosition::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSGeolocationPosition*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSGeolocationPositionOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSGeolocationPositionOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGeolocationPosition = static_cast<JSGeolocationPosition*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsGeolocationPosition->wrapped(), jsGeolocationPosition);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<GeolocationPosition>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to GeolocationPosition.
    static_assert(!std::is_polymorphic<GeolocationPosition>::value, "GeolocationPosition is polymorphic but the IDL claims it is not");
    return createWrapper<GeolocationPosition>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, GeolocationPosition& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

GeolocationPosition* JSGeolocationPosition::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGeolocationPosition*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(GEOLOCATION)
