/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLAppletElement.h"

#include "ActiveDOMObject.h"
#include "HTMLNames.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "JSPluginElementFunctions.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsHTMLAppletElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLAppletElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLAppletElementAlign(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLAppletElementAlign(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLAppletElementAlt(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLAppletElementAlt(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLAppletElementArchive(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLAppletElementArchive(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLAppletElementCode(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLAppletElementCode(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLAppletElementCodeBase(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLAppletElementCodeBase(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLAppletElementHeight(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLAppletElementHeight(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLAppletElementHspace(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLAppletElementHspace(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLAppletElementName(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLAppletElementName(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLAppletElementObject(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLAppletElementObject(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLAppletElementVspace(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLAppletElementVspace(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLAppletElementWidth(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLAppletElementWidth(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSHTMLAppletElementPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSHTMLAppletElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLAppletElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLAppletElementPrototype>(vm.heap)) JSHTMLAppletElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLAppletElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSHTMLAppletElementPrototype, JSHTMLAppletElementPrototype::Base);

using JSHTMLAppletElementConstructor = JSDOMConstructorNotConstructable<JSHTMLAppletElement>;

template<> JSValue JSHTMLAppletElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLAppletElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSHTMLAppletElement::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("HTMLAppletElement"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSHTMLAppletElementConstructor::s_info = { "HTMLAppletElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLAppletElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSHTMLAppletElementPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAppletElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLAppletElementConstructor) } },
    { "align", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAppletElementAlign), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLAppletElementAlign) } },
    { "alt", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAppletElementAlt), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLAppletElementAlt) } },
    { "archive", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAppletElementArchive), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLAppletElementArchive) } },
    { "code", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAppletElementCode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLAppletElementCode) } },
    { "codeBase", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAppletElementCodeBase), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLAppletElementCodeBase) } },
    { "height", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAppletElementHeight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLAppletElementHeight) } },
    { "hspace", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAppletElementHspace), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLAppletElementHspace) } },
    { "name", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAppletElementName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLAppletElementName) } },
    { "object", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAppletElementObject), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLAppletElementObject) } },
    { "vspace", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAppletElementVspace), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLAppletElementVspace) } },
    { "width", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLAppletElementWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLAppletElementWidth) } },
};

const ClassInfo JSHTMLAppletElementPrototype::s_info = { "HTMLAppletElementPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLAppletElementPrototype) };

void JSHTMLAppletElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLAppletElement::info(), JSHTMLAppletElementPrototypeTableValues, *this);
}

const ClassInfo JSHTMLAppletElement::s_info = { "HTMLAppletElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLAppletElement) };

JSHTMLAppletElement::JSHTMLAppletElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLAppletElement>&& impl)
    : JSHTMLElement(structure, globalObject, WTFMove(impl))
{
}

void JSHTMLAppletElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, HTMLAppletElement>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSHTMLAppletElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSHTMLAppletElementPrototype::create(vm, &globalObject, JSHTMLAppletElementPrototype::createStructure(vm, &globalObject, JSHTMLElement::prototype(vm, globalObject)));
}

JSObject* JSHTMLAppletElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSHTMLAppletElement>(vm, globalObject);
}

JSValue JSHTMLAppletElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLAppletElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

bool JSHTMLAppletElement::getOwnPropertySlot(JSObject* object, JSGlobalObject* lexicalGlobalObject, PropertyName propertyName, PropertySlot& slot)
{
    auto* thisObject = jsCast<JSHTMLAppletElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    if (pluginElementCustomGetOwnPropertySlot(thisObject, lexicalGlobalObject, propertyName, slot))
        return true;
    return JSObject::getOwnPropertySlot(object, lexicalGlobalObject, propertyName, slot);
}

bool JSHTMLAppletElement::getOwnPropertySlotByIndex(JSObject* object, JSGlobalObject* lexicalGlobalObject, unsigned index, PropertySlot& slot)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto* thisObject = jsCast<JSHTMLAppletElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    auto propertyName = Identifier::from(vm, index);
    if (pluginElementCustomGetOwnPropertySlot(thisObject, lexicalGlobalObject, propertyName, slot))
        return true;
    return JSObject::getOwnPropertySlotByIndex(object, lexicalGlobalObject, index, slot);
}

bool JSHTMLAppletElement::put(JSCell* cell, JSGlobalObject* lexicalGlobalObject, PropertyName propertyName, JSValue value, PutPropertySlot& putPropertySlot)
{
    auto* thisObject = jsCast<JSHTMLAppletElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());

    bool putResult = false;
    if (pluginElementCustomPut(thisObject, lexicalGlobalObject, propertyName, value, putPropertySlot, putResult))
        return putResult;

    return JSObject::put(thisObject, lexicalGlobalObject, propertyName, value, putPropertySlot);
}

bool JSHTMLAppletElement::putByIndex(JSCell* cell, JSGlobalObject* lexicalGlobalObject, unsigned index, JSValue value, bool shouldThrow)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto* thisObject = jsCast<JSHTMLAppletElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());

    auto propertyName = Identifier::from(vm, index);
    PutPropertySlot putPropertySlot(thisObject, shouldThrow);
    bool putResult = false;
    if (pluginElementCustomPut(thisObject, lexicalGlobalObject, propertyName, value, putPropertySlot, putResult))
        return putResult;

    return JSObject::putByIndex(cell, lexicalGlobalObject, index, value, shouldThrow);
}

CallType JSHTMLAppletElement::getCallData(JSCell* cell, CallData& callData)
{
    auto* thisObject = jsCast<JSHTMLAppletElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());

    return pluginElementCustomGetCallData(thisObject, callData);
}

template<> inline JSHTMLAppletElement* IDLAttribute<JSHTMLAppletElement>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSHTMLAppletElement*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsHTMLAppletElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLAppletElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSHTMLAppletElement::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSHTMLAppletElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLAppletElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsHTMLAppletElementAlignGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLAppletElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::alignAttr));
    return result;
}

EncodedJSValue jsHTMLAppletElementAlign(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLAppletElement>::get<jsHTMLAppletElementAlignGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "align");
}

static inline bool setJSHTMLAppletElementAlignSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLAppletElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::alignAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLAppletElementAlign(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLAppletElement>::set<setJSHTMLAppletElementAlignSetter>(*lexicalGlobalObject, thisValue, encodedValue, "align");
}

static inline JSValue jsHTMLAppletElementAltGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLAppletElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::altAttr));
    return result;
}

EncodedJSValue jsHTMLAppletElementAlt(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLAppletElement>::get<jsHTMLAppletElementAltGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "alt");
}

static inline bool setJSHTMLAppletElementAltSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLAppletElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::altAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLAppletElementAlt(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLAppletElement>::set<setJSHTMLAppletElementAltSetter>(*lexicalGlobalObject, thisValue, encodedValue, "alt");
}

static inline JSValue jsHTMLAppletElementArchiveGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLAppletElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::archiveAttr));
    return result;
}

EncodedJSValue jsHTMLAppletElementArchive(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLAppletElement>::get<jsHTMLAppletElementArchiveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "archive");
}

static inline bool setJSHTMLAppletElementArchiveSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLAppletElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::archiveAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLAppletElementArchive(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLAppletElement>::set<setJSHTMLAppletElementArchiveSetter>(*lexicalGlobalObject, thisValue, encodedValue, "archive");
}

static inline JSValue jsHTMLAppletElementCodeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLAppletElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::codeAttr));
    return result;
}

EncodedJSValue jsHTMLAppletElementCode(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLAppletElement>::get<jsHTMLAppletElementCodeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "code");
}

static inline bool setJSHTMLAppletElementCodeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLAppletElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::codeAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLAppletElementCode(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLAppletElement>::set<setJSHTMLAppletElementCodeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "code");
}

static inline JSValue jsHTMLAppletElementCodeBaseGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLAppletElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.getURLAttribute(WebCore::HTMLNames::codebaseAttr));
    return result;
}

EncodedJSValue jsHTMLAppletElementCodeBase(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLAppletElement>::get<jsHTMLAppletElementCodeBaseGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "codeBase");
}

static inline bool setJSHTMLAppletElementCodeBaseSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLAppletElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUSVString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::codebaseAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLAppletElementCodeBase(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLAppletElement>::set<setJSHTMLAppletElementCodeBaseSetter>(*lexicalGlobalObject, thisValue, encodedValue, "codeBase");
}

static inline JSValue jsHTMLAppletElementHeightGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLAppletElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::heightAttr));
    return result;
}

EncodedJSValue jsHTMLAppletElementHeight(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLAppletElement>::get<jsHTMLAppletElementHeightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "height");
}

static inline bool setJSHTMLAppletElementHeightSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLAppletElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::heightAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLAppletElementHeight(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLAppletElement>::set<setJSHTMLAppletElementHeightSetter>(*lexicalGlobalObject, thisValue, encodedValue, "height");
}

static inline JSValue jsHTMLAppletElementHspaceGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLAppletElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, std::max(0, impl.getIntegralAttribute(WebCore::HTMLNames::hspaceAttr)));
    return result;
}

EncodedJSValue jsHTMLAppletElementHspace(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLAppletElement>::get<jsHTMLAppletElementHspaceGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "hspace");
}

static inline bool setJSHTMLAppletElementHspaceSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLAppletElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnsignedLong>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setUnsignedIntegralAttribute(WebCore::HTMLNames::hspaceAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLAppletElementHspace(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLAppletElement>::set<setJSHTMLAppletElementHspaceSetter>(*lexicalGlobalObject, thisValue, encodedValue, "hspace");
}

static inline JSValue jsHTMLAppletElementNameGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLAppletElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.getNameAttribute());
    return result;
}

EncodedJSValue jsHTMLAppletElementName(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLAppletElement>::get<jsHTMLAppletElementNameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "name");
}

static inline bool setJSHTMLAppletElementNameSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLAppletElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::nameAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLAppletElementName(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLAppletElement>::set<setJSHTMLAppletElementNameSetter>(*lexicalGlobalObject, thisValue, encodedValue, "name");
}

static inline JSValue jsHTMLAppletElementObjectGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLAppletElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.getURLAttribute(WebCore::HTMLNames::objectAttr));
    return result;
}

EncodedJSValue jsHTMLAppletElementObject(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLAppletElement>::get<jsHTMLAppletElementObjectGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "object");
}

static inline bool setJSHTMLAppletElementObjectSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLAppletElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUSVString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::objectAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLAppletElementObject(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLAppletElement>::set<setJSHTMLAppletElementObjectSetter>(*lexicalGlobalObject, thisValue, encodedValue, "object");
}

static inline JSValue jsHTMLAppletElementVspaceGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLAppletElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, std::max(0, impl.getIntegralAttribute(WebCore::HTMLNames::vspaceAttr)));
    return result;
}

EncodedJSValue jsHTMLAppletElementVspace(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLAppletElement>::get<jsHTMLAppletElementVspaceGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "vspace");
}

static inline bool setJSHTMLAppletElementVspaceSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLAppletElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnsignedLong>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setUnsignedIntegralAttribute(WebCore::HTMLNames::vspaceAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLAppletElementVspace(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLAppletElement>::set<setJSHTMLAppletElementVspaceSetter>(*lexicalGlobalObject, thisValue, encodedValue, "vspace");
}

static inline JSValue jsHTMLAppletElementWidthGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLAppletElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::widthAttr));
    return result;
}

EncodedJSValue jsHTMLAppletElementWidth(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLAppletElement>::get<jsHTMLAppletElementWidthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "width");
}

static inline bool setJSHTMLAppletElementWidthSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLAppletElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::widthAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLAppletElementWidth(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLAppletElement>::set<setJSHTMLAppletElementWidthSetter>(*lexicalGlobalObject, thisValue, encodedValue, "width");
}

void JSHTMLAppletElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSHTMLAppletElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}
