/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLMarqueeElement.h"

#include "ActiveDOMObject.h"
#include "CustomElementReactionQueue.h"
#include "HTMLNames.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsHTMLMarqueeElementPrototypeFunctionStart(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLMarqueeElementPrototypeFunctionStop(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsHTMLMarqueeElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMarqueeElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMarqueeElementBehavior(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMarqueeElementBehavior(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMarqueeElementBgColor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMarqueeElementBgColor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMarqueeElementDirection(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMarqueeElementDirection(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMarqueeElementHeight(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMarqueeElementHeight(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMarqueeElementHspace(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMarqueeElementHspace(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMarqueeElementLoop(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMarqueeElementLoop(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMarqueeElementScrollAmount(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMarqueeElementScrollAmount(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMarqueeElementScrollDelay(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMarqueeElementScrollDelay(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMarqueeElementTrueSpeed(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMarqueeElementTrueSpeed(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMarqueeElementVspace(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMarqueeElementVspace(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMarqueeElementWidth(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMarqueeElementWidth(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSHTMLMarqueeElementPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSHTMLMarqueeElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLMarqueeElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLMarqueeElementPrototype>(vm.heap)) JSHTMLMarqueeElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLMarqueeElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSHTMLMarqueeElementPrototype, JSHTMLMarqueeElementPrototype::Base);

using JSHTMLMarqueeElementConstructor = JSDOMConstructorNotConstructable<JSHTMLMarqueeElement>;

template<> JSValue JSHTMLMarqueeElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLMarqueeElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSHTMLMarqueeElement::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("HTMLMarqueeElement"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSHTMLMarqueeElementConstructor::s_info = { "HTMLMarqueeElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLMarqueeElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSHTMLMarqueeElementPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMarqueeElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMarqueeElementConstructor) } },
    { "behavior", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMarqueeElementBehavior), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMarqueeElementBehavior) } },
    { "bgColor", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMarqueeElementBgColor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMarqueeElementBgColor) } },
    { "direction", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMarqueeElementDirection), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMarqueeElementDirection) } },
    { "height", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMarqueeElementHeight), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMarqueeElementHeight) } },
    { "hspace", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMarqueeElementHspace), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMarqueeElementHspace) } },
    { "loop", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMarqueeElementLoop), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMarqueeElementLoop) } },
    { "scrollAmount", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMarqueeElementScrollAmount), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMarqueeElementScrollAmount) } },
    { "scrollDelay", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMarqueeElementScrollDelay), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMarqueeElementScrollDelay) } },
    { "trueSpeed", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMarqueeElementTrueSpeed), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMarqueeElementTrueSpeed) } },
    { "vspace", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMarqueeElementVspace), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMarqueeElementVspace) } },
    { "width", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMarqueeElementWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMarqueeElementWidth) } },
    { "start", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLMarqueeElementPrototypeFunctionStart), (intptr_t) (0) } },
    { "stop", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLMarqueeElementPrototypeFunctionStop), (intptr_t) (0) } },
};

const ClassInfo JSHTMLMarqueeElementPrototype::s_info = { "HTMLMarqueeElementPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLMarqueeElementPrototype) };

void JSHTMLMarqueeElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLMarqueeElement::info(), JSHTMLMarqueeElementPrototypeTableValues, *this);
}

const ClassInfo JSHTMLMarqueeElement::s_info = { "HTMLMarqueeElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLMarqueeElement) };

JSHTMLMarqueeElement::JSHTMLMarqueeElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLMarqueeElement>&& impl)
    : JSHTMLElement(structure, globalObject, WTFMove(impl))
{
}

void JSHTMLMarqueeElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(std::is_base_of<ActiveDOMObject, HTMLMarqueeElement>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

}

JSObject* JSHTMLMarqueeElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSHTMLMarqueeElementPrototype::create(vm, &globalObject, JSHTMLMarqueeElementPrototype::createStructure(vm, &globalObject, JSHTMLElement::prototype(vm, globalObject)));
}

JSObject* JSHTMLMarqueeElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSHTMLMarqueeElement>(vm, globalObject);
}

JSValue JSHTMLMarqueeElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLMarqueeElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSHTMLMarqueeElement* IDLAttribute<JSHTMLMarqueeElement>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSHTMLMarqueeElement*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSHTMLMarqueeElement* IDLOperation<JSHTMLMarqueeElement>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSHTMLMarqueeElement*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsHTMLMarqueeElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLMarqueeElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSHTMLMarqueeElement::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSHTMLMarqueeElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLMarqueeElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsHTMLMarqueeElementBehaviorGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMarqueeElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::behaviorAttr));
    return result;
}

EncodedJSValue jsHTMLMarqueeElementBehavior(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMarqueeElement>::get<jsHTMLMarqueeElementBehaviorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "behavior");
}

static inline bool setJSHTMLMarqueeElementBehaviorSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMarqueeElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::behaviorAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLMarqueeElementBehavior(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLMarqueeElement>::set<setJSHTMLMarqueeElementBehaviorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "behavior");
}

static inline JSValue jsHTMLMarqueeElementBgColorGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMarqueeElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::bgcolorAttr));
    return result;
}

EncodedJSValue jsHTMLMarqueeElementBgColor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMarqueeElement>::get<jsHTMLMarqueeElementBgColorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "bgColor");
}

static inline bool setJSHTMLMarqueeElementBgColorSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMarqueeElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::bgcolorAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLMarqueeElementBgColor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLMarqueeElement>::set<setJSHTMLMarqueeElementBgColorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "bgColor");
}

static inline JSValue jsHTMLMarqueeElementDirectionGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMarqueeElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::directionAttr));
    return result;
}

EncodedJSValue jsHTMLMarqueeElementDirection(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMarqueeElement>::get<jsHTMLMarqueeElementDirectionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "direction");
}

static inline bool setJSHTMLMarqueeElementDirectionSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMarqueeElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::directionAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLMarqueeElementDirection(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLMarqueeElement>::set<setJSHTMLMarqueeElementDirectionSetter>(*lexicalGlobalObject, thisValue, encodedValue, "direction");
}

static inline JSValue jsHTMLMarqueeElementHeightGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMarqueeElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::heightAttr));
    return result;
}

EncodedJSValue jsHTMLMarqueeElementHeight(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMarqueeElement>::get<jsHTMLMarqueeElementHeightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "height");
}

static inline bool setJSHTMLMarqueeElementHeightSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMarqueeElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::heightAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLMarqueeElementHeight(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLMarqueeElement>::set<setJSHTMLMarqueeElementHeightSetter>(*lexicalGlobalObject, thisValue, encodedValue, "height");
}

static inline JSValue jsHTMLMarqueeElementHspaceGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMarqueeElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, std::max(0, impl.getIntegralAttribute(WebCore::HTMLNames::hspaceAttr)));
    return result;
}

EncodedJSValue jsHTMLMarqueeElementHspace(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMarqueeElement>::get<jsHTMLMarqueeElementHspaceGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "hspace");
}

static inline bool setJSHTMLMarqueeElementHspaceSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMarqueeElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnsignedLong>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setUnsignedIntegralAttribute(WebCore::HTMLNames::hspaceAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLMarqueeElementHspace(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLMarqueeElement>::set<setJSHTMLMarqueeElementHspaceSetter>(*lexicalGlobalObject, thisValue, encodedValue, "hspace");
}

static inline JSValue jsHTMLMarqueeElementLoopGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMarqueeElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.loop());
    return result;
}

EncodedJSValue jsHTMLMarqueeElementLoop(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMarqueeElement>::get<jsHTMLMarqueeElementLoopGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "loop");
}

static inline bool setJSHTMLMarqueeElementLoopSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMarqueeElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLLong>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setLoop(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLMarqueeElementLoop(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLMarqueeElement>::set<setJSHTMLMarqueeElementLoopSetter>(*lexicalGlobalObject, thisValue, encodedValue, "loop");
}

static inline JSValue jsHTMLMarqueeElementScrollAmountGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMarqueeElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.scrollAmount());
    return result;
}

EncodedJSValue jsHTMLMarqueeElementScrollAmount(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMarqueeElement>::get<jsHTMLMarqueeElementScrollAmountGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "scrollAmount");
}

static inline bool setJSHTMLMarqueeElementScrollAmountSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMarqueeElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnsignedLong>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setScrollAmount(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLMarqueeElementScrollAmount(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLMarqueeElement>::set<setJSHTMLMarqueeElementScrollAmountSetter>(*lexicalGlobalObject, thisValue, encodedValue, "scrollAmount");
}

static inline JSValue jsHTMLMarqueeElementScrollDelayGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMarqueeElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.scrollDelay());
    return result;
}

EncodedJSValue jsHTMLMarqueeElementScrollDelay(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMarqueeElement>::get<jsHTMLMarqueeElementScrollDelayGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "scrollDelay");
}

static inline bool setJSHTMLMarqueeElementScrollDelaySetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMarqueeElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnsignedLong>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setScrollDelay(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLMarqueeElementScrollDelay(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLMarqueeElement>::set<setJSHTMLMarqueeElementScrollDelaySetter>(*lexicalGlobalObject, thisValue, encodedValue, "scrollDelay");
}

static inline JSValue jsHTMLMarqueeElementTrueSpeedGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMarqueeElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasAttributeWithoutSynchronization(WebCore::HTMLNames::truespeedAttr));
    return result;
}

EncodedJSValue jsHTMLMarqueeElementTrueSpeed(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMarqueeElement>::get<jsHTMLMarqueeElementTrueSpeedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "trueSpeed");
}

static inline bool setJSHTMLMarqueeElementTrueSpeedSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMarqueeElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::HTMLNames::truespeedAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLMarqueeElementTrueSpeed(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLMarqueeElement>::set<setJSHTMLMarqueeElementTrueSpeedSetter>(*lexicalGlobalObject, thisValue, encodedValue, "trueSpeed");
}

static inline JSValue jsHTMLMarqueeElementVspaceGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMarqueeElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, std::max(0, impl.getIntegralAttribute(WebCore::HTMLNames::vspaceAttr)));
    return result;
}

EncodedJSValue jsHTMLMarqueeElementVspace(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMarqueeElement>::get<jsHTMLMarqueeElementVspaceGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "vspace");
}

static inline bool setJSHTMLMarqueeElementVspaceSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMarqueeElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnsignedLong>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setUnsignedIntegralAttribute(WebCore::HTMLNames::vspaceAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLMarqueeElementVspace(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLMarqueeElement>::set<setJSHTMLMarqueeElementVspaceSetter>(*lexicalGlobalObject, thisValue, encodedValue, "vspace");
}

static inline JSValue jsHTMLMarqueeElementWidthGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMarqueeElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::widthAttr));
    return result;
}

EncodedJSValue jsHTMLMarqueeElementWidth(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMarqueeElement>::get<jsHTMLMarqueeElementWidthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "width");
}

static inline bool setJSHTMLMarqueeElementWidthSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMarqueeElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::widthAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLMarqueeElementWidth(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLMarqueeElement>::set<setJSHTMLMarqueeElementWidthSetter>(*lexicalGlobalObject, thisValue, encodedValue, "width");
}

static inline JSC::EncodedJSValue jsHTMLMarqueeElementPrototypeFunctionStartBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLMarqueeElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.start();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLMarqueeElementPrototypeFunctionStart(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSHTMLMarqueeElement>::call<jsHTMLMarqueeElementPrototypeFunctionStartBody>(*lexicalGlobalObject, *callFrame, "start");
}

static inline JSC::EncodedJSValue jsHTMLMarqueeElementPrototypeFunctionStopBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLMarqueeElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.stop();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLMarqueeElementPrototypeFunctionStop(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSHTMLMarqueeElement>::call<jsHTMLMarqueeElementPrototypeFunctionStopBody>(*lexicalGlobalObject, *callFrame, "stop");
}

void JSHTMLMarqueeElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSHTMLMarqueeElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSHTMLMarqueeElementOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsHTMLMarqueeElement = jsCast<JSHTMLMarqueeElement*>(handle.slot()->asCell());
    if (jsHTMLMarqueeElement->wrapped().hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    if (jsHTMLMarqueeElement->wrapped().isFiringEventListeners()) {
        if (UNLIKELY(reason))
            *reason = "EventTarget firing event listeners";
        return true;
    }
    if (JSNodeOwner::isReachableFromOpaqueRoots(handle, 0, visitor, reason))
        return true;
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSHTMLMarqueeElementOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsHTMLMarqueeElement = static_cast<JSHTMLMarqueeElement*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsHTMLMarqueeElement->wrapped(), jsHTMLMarqueeElement);
}


}
