/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO)

#include "JSHTMLMediaElement.h"

#include "ActiveDOMObject.h"
#include "CustomElementReactionQueue.h"
#include "Document.h"
#include "EventNames.h"
#include "HTMLNames.h"
#include "JSBlob.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertDate.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSMediaController.h"
#include "JSMediaError.h"
//+TELESCOPE_LIB_CHANGES
//2/2/2021
//Enable MediaSource for MediaElement
#if ENABLE(MEDIA_SOURCE)
#include "JSMediaSource.h"
#endif
//-TELESCOPE_LIB_CHANGES
#include "JSTimeRanges.h"
#include "JSVideoPlaybackQuality.h"
#include "Quirks.h"
#include "RuntimeEnabledFeatures.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>

#if ENABLE(ENCRYPTED_MEDIA)
#include "JSEventListener.h"
#include "JSMediaKeys.h"
#endif

#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
#include "JSWebKitMediaKeys.h"
#endif

#if ENABLE(MEDIA_SESSION) && ENABLE(VIDEO)
#include "HTMLMediaElementMediaSession.h"
#include "JSMediaSession.h"
#endif

#if ENABLE(VIDEO_TRACK)
#include "JSAudioTrackList.h"
#include "JSTextTrack.h"
#include "JSTextTrackList.h"
#include "JSVideoTrackList.h"
#endif


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionLoad(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionCanPlayType(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionGetStartDate(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionPlay(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionPause(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionFastSeek(JSC::JSGlobalObject*, JSC::CallFrame*);
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionWebkitSetMediaKeys(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(ENCRYPTED_MEDIA)
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionSetMediaKeys(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(VIDEO_TRACK)
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionAddTextTrack(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionGetVideoPlaybackQuality(JSC::JSGlobalObject*, JSC::CallFrame*);
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionWebkitShowPlaybackTargetPicker(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif

// Attributes

JSC::EncodedJSValue jsHTMLMediaElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMediaElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMediaElementError(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLMediaElementSrc(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMediaElementSrc(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMediaElementSrcObject(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMediaElementSrcObject(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMediaElementCurrentSrc(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLMediaElementCrossOrigin(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMediaElementCrossOrigin(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMediaElementNetworkState(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLMediaElementPreload(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMediaElementPreload(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMediaElementBuffered(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLMediaElementReadyState(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLMediaElementSeeking(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLMediaElementCurrentTime(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMediaElementCurrentTime(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMediaElementDuration(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLMediaElementPaused(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLMediaElementDefaultPlaybackRate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMediaElementDefaultPlaybackRate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMediaElementPlaybackRate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMediaElementPlaybackRate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMediaElementPlayed(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLMediaElementSeekable(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLMediaElementEnded(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLMediaElementAutoplay(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMediaElementAutoplay(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMediaElementLoop(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMediaElementLoop(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMediaElementControls(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMediaElementControls(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMediaElementVolume(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMediaElementVolume(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMediaElementMuted(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMediaElementMuted(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMediaElementDefaultMuted(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMediaElementDefaultMuted(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMediaElementWebkitPreservesPitch(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMediaElementWebkitPreservesPitch(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMediaElementWebkitHasClosedCaptions(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLMediaElementWebkitClosedCaptionsVisible(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMediaElementWebkitClosedCaptionsVisible(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(MEDIA_STATISTICS)
JSC::EncodedJSValue jsHTMLMediaElementWebkitAudioDecodedByteCount(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(MEDIA_STATISTICS)
JSC::EncodedJSValue jsHTMLMediaElementWebkitVideoDecodedByteCount(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
JSC::EncodedJSValue jsHTMLMediaElementWebkitKeys(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(ENCRYPTED_MEDIA)
JSC::EncodedJSValue jsHTMLMediaElementMediaKeys(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(ENCRYPTED_MEDIA)
JSC::EncodedJSValue jsHTMLMediaElementOnencrypted(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMediaElementOnencrypted(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(ENCRYPTED_MEDIA)
JSC::EncodedJSValue jsHTMLMediaElementOnwaitingforkey(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMediaElementOnwaitingforkey(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(VIDEO_TRACK)
JSC::EncodedJSValue jsHTMLMediaElementAudioTracks(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(VIDEO_TRACK)
JSC::EncodedJSValue jsHTMLMediaElementTextTracks(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(VIDEO_TRACK)
JSC::EncodedJSValue jsHTMLMediaElementVideoTracks(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
JSC::EncodedJSValue jsHTMLMediaElementMediaGroup(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMediaElementMediaGroup(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLMediaElementController(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMediaElementController(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
JSC::EncodedJSValue jsHTMLMediaElementWebkitCurrentPlaybackTargetIsWireless(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(MEDIA_SESSION) && ENABLE(VIDEO)
JSC::EncodedJSValue jsHTMLMediaElementKind(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMediaElementKind(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif
#if ENABLE(MEDIA_SESSION) && ENABLE(VIDEO)
JSC::EncodedJSValue jsHTMLMediaElementSession(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLMediaElementSession(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
#endif

class JSHTMLMediaElementPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSHTMLMediaElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLMediaElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLMediaElementPrototype>(vm.heap)) JSHTMLMediaElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLMediaElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSHTMLMediaElementPrototype, JSHTMLMediaElementPrototype::Base);

using JSHTMLMediaElementConstructor = JSDOMConstructorNotConstructable<JSHTMLMediaElement>;

/* Hash table for constructor */

static const HashTableValue JSHTMLMediaElementConstructorTableValues[] =
{
    { "NETWORK_EMPTY", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "NETWORK_IDLE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "NETWORK_LOADING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "NETWORK_NO_SOURCE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "HAVE_NOTHING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "HAVE_METADATA", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "HAVE_CURRENT_DATA", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "HAVE_FUTURE_DATA", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "HAVE_ENOUGH_DATA", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(4) } },
};

static_assert(HTMLMediaElement::NETWORK_EMPTY == 0, "NETWORK_EMPTY in HTMLMediaElement does not match value from IDL");
static_assert(HTMLMediaElement::NETWORK_IDLE == 1, "NETWORK_IDLE in HTMLMediaElement does not match value from IDL");
static_assert(HTMLMediaElement::NETWORK_LOADING == 2, "NETWORK_LOADING in HTMLMediaElement does not match value from IDL");
static_assert(HTMLMediaElement::NETWORK_NO_SOURCE == 3, "NETWORK_NO_SOURCE in HTMLMediaElement does not match value from IDL");
static_assert(HTMLMediaElement::HAVE_NOTHING == 0, "HAVE_NOTHING in HTMLMediaElement does not match value from IDL");
static_assert(HTMLMediaElement::HAVE_METADATA == 1, "HAVE_METADATA in HTMLMediaElement does not match value from IDL");
static_assert(HTMLMediaElement::HAVE_CURRENT_DATA == 2, "HAVE_CURRENT_DATA in HTMLMediaElement does not match value from IDL");
static_assert(HTMLMediaElement::HAVE_FUTURE_DATA == 3, "HAVE_FUTURE_DATA in HTMLMediaElement does not match value from IDL");
static_assert(HTMLMediaElement::HAVE_ENOUGH_DATA == 4, "HAVE_ENOUGH_DATA in HTMLMediaElement does not match value from IDL");

template<> JSValue JSHTMLMediaElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLMediaElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSHTMLMediaElement::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("HTMLMediaElement"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSHTMLMediaElement::info(), JSHTMLMediaElementConstructorTableValues, *this);
}

template<> const ClassInfo JSHTMLMediaElementConstructor::s_info = { "HTMLMediaElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLMediaElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSHTMLMediaElementPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementConstructor) } },
    { "error", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementError), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "src", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementSrc), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementSrc) } },
    { "srcObject", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementSrcObject), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementSrcObject) } },
    { "currentSrc", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementCurrentSrc), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "crossOrigin", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementCrossOrigin), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementCrossOrigin) } },
    { "networkState", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementNetworkState), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "preload", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementPreload), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementPreload) } },
    { "buffered", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementBuffered), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "readyState", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementReadyState), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "seeking", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementSeeking), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "currentTime", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementCurrentTime), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementCurrentTime) } },
    { "duration", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementDuration), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "paused", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementPaused), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "defaultPlaybackRate", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementDefaultPlaybackRate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementDefaultPlaybackRate) } },
    { "playbackRate", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementPlaybackRate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementPlaybackRate) } },
    { "played", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementPlayed), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "seekable", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementSeekable), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "ended", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementEnded), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "autoplay", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementAutoplay), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementAutoplay) } },
    { "loop", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementLoop), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementLoop) } },
    { "controls", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementControls), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementControls) } },
    { "volume", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementVolume), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementVolume) } },
    { "muted", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementMuted), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementMuted) } },
    { "defaultMuted", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementDefaultMuted), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementDefaultMuted) } },
    { "webkitPreservesPitch", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementWebkitPreservesPitch), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementWebkitPreservesPitch) } },
    { "webkitHasClosedCaptions", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementWebkitHasClosedCaptions), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "webkitClosedCaptionsVisible", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementWebkitClosedCaptionsVisible), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementWebkitClosedCaptionsVisible) } },
#if ENABLE(MEDIA_STATISTICS)
    { "webkitAudioDecodedByteCount", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementWebkitAudioDecodedByteCount), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_STATISTICS)
    { "webkitVideoDecodedByteCount", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementWebkitVideoDecodedByteCount), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
    { "webkitKeys", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementWebkitKeys), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(ENCRYPTED_MEDIA)
    { "mediaKeys", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementMediaKeys), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(ENCRYPTED_MEDIA)
    { "onencrypted", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementOnencrypted), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementOnencrypted) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(ENCRYPTED_MEDIA)
    { "onwaitingforkey", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementOnwaitingforkey), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementOnwaitingforkey) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO_TRACK)
    { "audioTracks", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementAudioTracks), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO_TRACK)
    { "textTracks", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementTextTracks), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO_TRACK)
    { "videoTracks", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementVideoTracks), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "mediaGroup", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementMediaGroup), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementMediaGroup) } },
    { "controller", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementController), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementController) } },
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
    { "webkitCurrentPlaybackTargetIsWireless", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementWebkitCurrentPlaybackTargetIsWireless), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_SESSION) && ENABLE(VIDEO)
    { "kind", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementKind), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementKind) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_SESSION) && ENABLE(VIDEO)
    { "session", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementSession), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLMediaElementSession) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "load", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLMediaElementPrototypeFunctionLoad), (intptr_t) (0) } },
    { "canPlayType", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLMediaElementPrototypeFunctionCanPlayType), (intptr_t) (1) } },
    { "getStartDate", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLMediaElementPrototypeFunctionGetStartDate), (intptr_t) (0) } },
    { "play", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLMediaElementPrototypeFunctionPlay), (intptr_t) (0) } },
    { "pause", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLMediaElementPrototypeFunctionPause), (intptr_t) (0) } },
    { "fastSeek", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLMediaElementPrototypeFunctionFastSeek), (intptr_t) (1) } },
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
    { "webkitSetMediaKeys", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLMediaElementPrototypeFunctionWebkitSetMediaKeys), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(ENCRYPTED_MEDIA)
    { "setMediaKeys", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLMediaElementPrototypeFunctionSetMediaKeys), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO_TRACK)
    { "addTextTrack", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLMediaElementPrototypeFunctionAddTextTrack), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "getVideoPlaybackQuality", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLMediaElementPrototypeFunctionGetVideoPlaybackQuality), (intptr_t) (0) } },
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
    { "webkitShowPlaybackTargetPicker", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLMediaElementPrototypeFunctionWebkitShowPlaybackTargetPicker), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "NETWORK_EMPTY", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "NETWORK_IDLE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "NETWORK_LOADING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "NETWORK_NO_SOURCE", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "HAVE_NOTHING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0) } },
    { "HAVE_METADATA", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "HAVE_CURRENT_DATA", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "HAVE_FUTURE_DATA", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(3) } },
    { "HAVE_ENOUGH_DATA", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(4) } },
};

const ClassInfo JSHTMLMediaElementPrototype::s_info = { "HTMLMediaElementPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLMediaElementPrototype) };

void JSHTMLMediaElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLMediaElement::info(), JSHTMLMediaElementPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
    if (!RuntimeEnabledFeatures::sharedFeatures().legacyEncryptedMediaAPIEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("webkitSetMediaKeys"), strlen("webkitSetMediaKeys"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
#if ENABLE(ENCRYPTED_MEDIA)
    if (!(!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().hasBrokenEncryptedMediaAPISupportQuirk() && RuntimeEnabledFeatures::sharedFeatures().encryptedMediaAPIEnabled())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("setMediaKeys"), strlen("setMediaKeys"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
    if (!RuntimeEnabledFeatures::sharedFeatures().legacyEncryptedMediaAPIEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("webkitKeys"), strlen("webkitKeys"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
#if ENABLE(ENCRYPTED_MEDIA)
    if (!(!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().hasBrokenEncryptedMediaAPISupportQuirk() && RuntimeEnabledFeatures::sharedFeatures().encryptedMediaAPIEnabled())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("mediaKeys"), strlen("mediaKeys"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
#if ENABLE(ENCRYPTED_MEDIA)
    if (!(!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().hasBrokenEncryptedMediaAPISupportQuirk() && RuntimeEnabledFeatures::sharedFeatures().encryptedMediaAPIEnabled())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("onencrypted"), strlen("onencrypted"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
#if ENABLE(ENCRYPTED_MEDIA)
    if (!(!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->quirks().hasBrokenEncryptedMediaAPISupportQuirk() && RuntimeEnabledFeatures::sharedFeatures().encryptedMediaAPIEnabled())) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("onwaitingforkey"), strlen("onwaitingforkey"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
#endif
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
}

const ClassInfo JSHTMLMediaElement::s_info = { "HTMLMediaElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLMediaElement) };

JSHTMLMediaElement::JSHTMLMediaElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLMediaElement>&& impl)
    : JSHTMLElement(structure, globalObject, WTFMove(impl))
{
}

void JSHTMLMediaElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(std::is_base_of<ActiveDOMObject, HTMLMediaElement>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

}

JSObject* JSHTMLMediaElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSHTMLMediaElementPrototype::create(vm, &globalObject, JSHTMLMediaElementPrototype::createStructure(vm, &globalObject, JSHTMLElement::prototype(vm, globalObject)));
}

JSObject* JSHTMLMediaElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSHTMLMediaElement>(vm, globalObject);
}

JSValue JSHTMLMediaElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLMediaElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSHTMLMediaElement* IDLAttribute<JSHTMLMediaElement>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSHTMLMediaElement*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSHTMLMediaElement* IDLOperation<JSHTMLMediaElement>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSHTMLMediaElement*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsHTMLMediaElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLMediaElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSHTMLMediaElement::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSHTMLMediaElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLMediaElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsHTMLMediaElementErrorGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<MediaError>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.error());
    return result;
}

EncodedJSValue jsHTMLMediaElementError(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementErrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "error");
}

static inline JSValue jsHTMLMediaElementSrcGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.getURLAttribute(WebCore::HTMLNames::srcAttr));
    return result;
}

EncodedJSValue jsHTMLMediaElementSrc(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementSrcGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "src");
}

static inline bool setJSHTMLMediaElementSrcSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUSVString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::srcAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLMediaElementSrc(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElementSrcSetter>(*lexicalGlobalObject, thisValue, encodedValue, "src");
}

static inline JSValue jsHTMLMediaElementSrcObjectGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    //+TELESCOPE_LIB_CHANGES
    //2/2/2021
    //Enable MediaSource for MediaElement
    JSValue result = toJS<IDLNullable<IDLUnion<
#if ENABLE(MEDIA_SOURCE)
        IDLInterface<MediaSource>,
#endif
        IDLInterface<Blob>>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.srcObject());
    //-TELESCOPE_LIB_CHANGES
    return result;
}

EncodedJSValue jsHTMLMediaElementSrcObject(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementSrcObjectGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "srcObject");
}

static inline bool setJSHTMLMediaElementSrcObjectSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    //+TELESCOPE_LIB_CHANGES
    //2/2/2021
    //Enable MediaSource for MediaElement
    auto nativeValue = convert<IDLNullable<IDLUnion<
#if ENABLE(MEDIA_SOURCE)
        IDLInterface<MediaSource>,
#endif
        IDLInterface<Blob>>>>(lexicalGlobalObject, value);
    //-TELESCOPE_LIB_CHANGES
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setSrcObject(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLMediaElementSrcObject(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElementSrcObjectSetter>(*lexicalGlobalObject, thisValue, encodedValue, "srcObject");
}

static inline JSValue jsHTMLMediaElementCurrentSrcGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.currentSrc());
    return result;
}

EncodedJSValue jsHTMLMediaElementCurrentSrc(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementCurrentSrcGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "currentSrc");
}

static inline JSValue jsHTMLMediaElementCrossOriginGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.crossOrigin());
    return result;
}

EncodedJSValue jsHTMLMediaElementCrossOrigin(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementCrossOriginGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "crossOrigin");
}

static inline bool setJSHTMLMediaElementCrossOriginSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setCrossOrigin(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLMediaElementCrossOrigin(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElementCrossOriginSetter>(*lexicalGlobalObject, thisValue, encodedValue, "crossOrigin");
}

static inline JSValue jsHTMLMediaElementNetworkStateGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.networkState());
    return result;
}

EncodedJSValue jsHTMLMediaElementNetworkState(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementNetworkStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "networkState");
}

static inline JSValue jsHTMLMediaElementPreloadGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.preload());
    return result;
}

EncodedJSValue jsHTMLMediaElementPreload(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementPreloadGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "preload");
}

static inline bool setJSHTMLMediaElementPreloadSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setPreload(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLMediaElementPreload(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElementPreloadSetter>(*lexicalGlobalObject, thisValue, encodedValue, "preload");
}

static inline JSValue jsHTMLMediaElementBufferedGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<TimeRanges>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.buffered());
    return result;
}

EncodedJSValue jsHTMLMediaElementBuffered(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementBufferedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "buffered");
}

static inline JSValue jsHTMLMediaElementReadyStateGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedShort>(lexicalGlobalObject, throwScope, impl.readyState());
    return result;
}

EncodedJSValue jsHTMLMediaElementReadyState(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementReadyStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "readyState");
}

static inline JSValue jsHTMLMediaElementSeekingGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.seeking());
    return result;
}

EncodedJSValue jsHTMLMediaElementSeeking(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementSeekingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "seeking");
}

static inline JSValue jsHTMLMediaElementCurrentTimeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.currentTimeForBindings());
    return result;
}

EncodedJSValue jsHTMLMediaElementCurrentTime(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementCurrentTimeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "currentTime");
}

static inline bool setJSHTMLMediaElementCurrentTimeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setCurrentTimeForBindings(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLMediaElementCurrentTime(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElementCurrentTimeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "currentTime");
}

static inline JSValue jsHTMLMediaElementDurationGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.duration());
    return result;
}

EncodedJSValue jsHTMLMediaElementDuration(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementDurationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "duration");
}

static inline JSValue jsHTMLMediaElementPausedGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.paused());
    return result;
}

EncodedJSValue jsHTMLMediaElementPaused(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementPausedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "paused");
}

static inline JSValue jsHTMLMediaElementDefaultPlaybackRateGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.defaultPlaybackRate());
    return result;
}

EncodedJSValue jsHTMLMediaElementDefaultPlaybackRate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementDefaultPlaybackRateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "defaultPlaybackRate");
}

static inline bool setJSHTMLMediaElementDefaultPlaybackRateSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setDefaultPlaybackRate(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLMediaElementDefaultPlaybackRate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElementDefaultPlaybackRateSetter>(*lexicalGlobalObject, thisValue, encodedValue, "defaultPlaybackRate");
}

static inline JSValue jsHTMLMediaElementPlaybackRateGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.playbackRate());
    return result;
}

EncodedJSValue jsHTMLMediaElementPlaybackRate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementPlaybackRateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "playbackRate");
}

static inline bool setJSHTMLMediaElementPlaybackRateSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setPlaybackRate(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLMediaElementPlaybackRate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElementPlaybackRateSetter>(*lexicalGlobalObject, thisValue, encodedValue, "playbackRate");
}

static inline JSValue jsHTMLMediaElementPlayedGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<TimeRanges>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.played());
    return result;
}

EncodedJSValue jsHTMLMediaElementPlayed(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementPlayedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "played");
}

static inline JSValue jsHTMLMediaElementSeekableGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<TimeRanges>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.seekable());
    return result;
}

EncodedJSValue jsHTMLMediaElementSeekable(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementSeekableGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "seekable");
}

static inline JSValue jsHTMLMediaElementEndedGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.ended());
    return result;
}

EncodedJSValue jsHTMLMediaElementEnded(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementEndedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ended");
}

static inline JSValue jsHTMLMediaElementAutoplayGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasAttributeWithoutSynchronization(WebCore::HTMLNames::autoplayAttr));
    return result;
}

EncodedJSValue jsHTMLMediaElementAutoplay(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementAutoplayGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "autoplay");
}

static inline bool setJSHTMLMediaElementAutoplaySetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::HTMLNames::autoplayAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLMediaElementAutoplay(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElementAutoplaySetter>(*lexicalGlobalObject, thisValue, encodedValue, "autoplay");
}

static inline JSValue jsHTMLMediaElementLoopGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasAttributeWithoutSynchronization(WebCore::HTMLNames::loopAttr));
    return result;
}

EncodedJSValue jsHTMLMediaElementLoop(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementLoopGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "loop");
}

static inline bool setJSHTMLMediaElementLoopSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::HTMLNames::loopAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLMediaElementLoop(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElementLoopSetter>(*lexicalGlobalObject, thisValue, encodedValue, "loop");
}

static inline JSValue jsHTMLMediaElementControlsGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.controls());
    return result;
}

EncodedJSValue jsHTMLMediaElementControls(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementControlsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "controls");
}

static inline bool setJSHTMLMediaElementControlsSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setControls(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLMediaElementControls(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElementControlsSetter>(*lexicalGlobalObject, thisValue, encodedValue, "controls");
}

static inline JSValue jsHTMLMediaElementVolumeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.volume());
    return result;
}

EncodedJSValue jsHTMLMediaElementVolume(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementVolumeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "volume");
}

static inline bool setJSHTMLMediaElementVolumeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setVolume(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLMediaElementVolume(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElementVolumeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "volume");
}

static inline JSValue jsHTMLMediaElementMutedGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.muted());
    return result;
}

EncodedJSValue jsHTMLMediaElementMuted(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementMutedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "muted");
}

static inline bool setJSHTMLMediaElementMutedSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setMuted(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLMediaElementMuted(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElementMutedSetter>(*lexicalGlobalObject, thisValue, encodedValue, "muted");
}

static inline JSValue jsHTMLMediaElementDefaultMutedGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasAttributeWithoutSynchronization(WebCore::HTMLNames::mutedAttr));
    return result;
}

EncodedJSValue jsHTMLMediaElementDefaultMuted(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementDefaultMutedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "defaultMuted");
}

static inline bool setJSHTMLMediaElementDefaultMutedSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::HTMLNames::mutedAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLMediaElementDefaultMuted(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElementDefaultMutedSetter>(*lexicalGlobalObject, thisValue, encodedValue, "defaultMuted");
}

static inline JSValue jsHTMLMediaElementWebkitPreservesPitchGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.webkitPreservesPitch());
    return result;
}

EncodedJSValue jsHTMLMediaElementWebkitPreservesPitch(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementWebkitPreservesPitchGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "webkitPreservesPitch");
}

static inline bool setJSHTMLMediaElementWebkitPreservesPitchSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setWebkitPreservesPitch(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLMediaElementWebkitPreservesPitch(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElementWebkitPreservesPitchSetter>(*lexicalGlobalObject, thisValue, encodedValue, "webkitPreservesPitch");
}

static inline JSValue jsHTMLMediaElementWebkitHasClosedCaptionsGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.webkitHasClosedCaptions());
    return result;
}

EncodedJSValue jsHTMLMediaElementWebkitHasClosedCaptions(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementWebkitHasClosedCaptionsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "webkitHasClosedCaptions");
}

static inline JSValue jsHTMLMediaElementWebkitClosedCaptionsVisibleGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.webkitClosedCaptionsVisible());
    return result;
}

EncodedJSValue jsHTMLMediaElementWebkitClosedCaptionsVisible(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementWebkitClosedCaptionsVisibleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "webkitClosedCaptionsVisible");
}

static inline bool setJSHTMLMediaElementWebkitClosedCaptionsVisibleSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setWebkitClosedCaptionsVisible(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLMediaElementWebkitClosedCaptionsVisible(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElementWebkitClosedCaptionsVisibleSetter>(*lexicalGlobalObject, thisValue, encodedValue, "webkitClosedCaptionsVisible");
}

#if ENABLE(MEDIA_STATISTICS)
static inline JSValue jsHTMLMediaElementWebkitAudioDecodedByteCountGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.webkitAudioDecodedByteCount());
    return result;
}

EncodedJSValue jsHTMLMediaElementWebkitAudioDecodedByteCount(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementWebkitAudioDecodedByteCountGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "webkitAudioDecodedByteCount");
}

#endif

#if ENABLE(MEDIA_STATISTICS)
static inline JSValue jsHTMLMediaElementWebkitVideoDecodedByteCountGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.webkitVideoDecodedByteCount());
    return result;
}

EncodedJSValue jsHTMLMediaElementWebkitVideoDecodedByteCount(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementWebkitVideoDecodedByteCountGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "webkitVideoDecodedByteCount");
}

#endif

#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
static inline JSValue jsHTMLMediaElementWebkitKeysGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<WebKitMediaKeys>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.webkitKeys());
    return result;
}

EncodedJSValue jsHTMLMediaElementWebkitKeys(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementWebkitKeysGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "webkitKeys");
}

#endif

#if ENABLE(ENCRYPTED_MEDIA)
static inline JSValue jsHTMLMediaElementMediaKeysGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<MediaKeys>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.mediaKeys());
    return result;
}

EncodedJSValue jsHTMLMediaElementMediaKeys(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementMediaKeysGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "mediaKeys");
}

#endif

#if ENABLE(ENCRYPTED_MEDIA)
static inline JSValue jsHTMLMediaElementOnencryptedGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().encryptedEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLMediaElementOnencrypted(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementOnencryptedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onencrypted");
}

#endif

#if ENABLE(ENCRYPTED_MEDIA)
static inline bool setJSHTMLMediaElementOnencryptedSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().encryptedEvent, value);
    return true;
}

bool setJSHTMLMediaElementOnencrypted(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElementOnencryptedSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onencrypted");
}

#endif

#if ENABLE(ENCRYPTED_MEDIA)
static inline JSValue jsHTMLMediaElementOnwaitingforkeyGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().waitingforkeyEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsHTMLMediaElementOnwaitingforkey(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementOnwaitingforkeyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onwaitingforkey");
}

#endif

#if ENABLE(ENCRYPTED_MEDIA)
static inline bool setJSHTMLMediaElementOnwaitingforkeySetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().waitingforkeyEvent, value);
    return true;
}

bool setJSHTMLMediaElementOnwaitingforkey(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElementOnwaitingforkeySetter>(*lexicalGlobalObject, thisValue, encodedValue, "onwaitingforkey");
}

#endif

#if ENABLE(VIDEO_TRACK)
static inline JSValue jsHTMLMediaElementAudioTracksGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<AudioTrackList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.ensureAudioTracks());
    return result;
}

EncodedJSValue jsHTMLMediaElementAudioTracks(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementAudioTracksGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "audioTracks");
}

#endif

#if ENABLE(VIDEO_TRACK)
static inline JSValue jsHTMLMediaElementTextTracksGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<TextTrackList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.ensureTextTracks());
    return result;
}

EncodedJSValue jsHTMLMediaElementTextTracks(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementTextTracksGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "textTracks");
}

#endif

#if ENABLE(VIDEO_TRACK)
static inline JSValue jsHTMLMediaElementVideoTracksGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<VideoTrackList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.ensureVideoTracks());
    return result;
}

EncodedJSValue jsHTMLMediaElementVideoTracks(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementVideoTracksGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "videoTracks");
}

#endif

static inline JSValue jsHTMLMediaElementMediaGroupGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::mediagroupAttr));
    return result;
}

EncodedJSValue jsHTMLMediaElementMediaGroup(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementMediaGroupGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "mediaGroup");
}

static inline bool setJSHTMLMediaElementMediaGroupSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::mediagroupAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLMediaElementMediaGroup(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElementMediaGroupSetter>(*lexicalGlobalObject, thisValue, encodedValue, "mediaGroup");
}

static inline JSValue jsHTMLMediaElementControllerGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<MediaController>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.controllerForBindings());
    return result;
}

EncodedJSValue jsHTMLMediaElementController(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementControllerGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "controller");
}

static inline bool setJSHTMLMediaElementControllerSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLInterface<MediaController>>>(lexicalGlobalObject, value, [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwAttributeTypeError(lexicalGlobalObject, scope, "HTMLMediaElement", "controller", "MediaController"); });
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setControllerForBindings(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLMediaElementController(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElementControllerSetter>(*lexicalGlobalObject, thisValue, encodedValue, "controller");
}

#if ENABLE(WIRELESS_PLAYBACK_TARGET)
static inline JSValue jsHTMLMediaElementWebkitCurrentPlaybackTargetIsWirelessGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.webkitCurrentPlaybackTargetIsWireless());
    return result;
}

EncodedJSValue jsHTMLMediaElementWebkitCurrentPlaybackTargetIsWireless(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementWebkitCurrentPlaybackTargetIsWirelessGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "webkitCurrentPlaybackTargetIsWireless");
}

#endif

#if ENABLE(MEDIA_SESSION) && ENABLE(VIDEO)
static inline JSValue jsHTMLMediaElementKindGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, WebCore::HTMLMediaElementMediaSession::kind(impl));
    return result;
}

EncodedJSValue jsHTMLMediaElementKind(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementKindGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "kind");
}

#endif

#if ENABLE(MEDIA_SESSION) && ENABLE(VIDEO)
static inline bool setJSHTMLMediaElementKindSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return WebCore::HTMLMediaElementMediaSession::setKind(impl, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLMediaElementKind(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElementKindSetter>(*lexicalGlobalObject, thisValue, encodedValue, "kind");
}

#endif

#if ENABLE(MEDIA_SESSION) && ENABLE(VIDEO)
static inline JSValue jsHTMLMediaElementSessionGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<MediaSession>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, WebCore::HTMLMediaElementMediaSession::session(impl));
    return result;
}

EncodedJSValue jsHTMLMediaElementSession(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLMediaElement>::get<jsHTMLMediaElementSessionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "session");
}

#endif

#if ENABLE(MEDIA_SESSION) && ENABLE(VIDEO)
static inline bool setJSHTMLMediaElementSessionSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLMediaElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLInterface<MediaSession>>>(lexicalGlobalObject, value, [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwAttributeTypeError(lexicalGlobalObject, scope, "HTMLMediaElement", "session", "MediaSession"); });
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return WebCore::HTMLMediaElementMediaSession::setSession(impl, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLMediaElementSession(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLMediaElement>::set<setJSHTMLMediaElementSessionSetter>(*lexicalGlobalObject, thisValue, encodedValue, "session");
}

#endif

static inline JSC::EncodedJSValue jsHTMLMediaElementPrototypeFunctionLoadBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLMediaElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.load();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionLoad(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSHTMLMediaElement>::call<jsHTMLMediaElementPrototypeFunctionLoadBody>(*lexicalGlobalObject, *callFrame, "load");
}

static inline JSC::EncodedJSValue jsHTMLMediaElementPrototypeFunctionCanPlayTypeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLMediaElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto type = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.canPlayType(WTFMove(type))));
}

EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionCanPlayType(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSHTMLMediaElement>::call<jsHTMLMediaElementPrototypeFunctionCanPlayTypeBody>(*lexicalGlobalObject, *callFrame, "canPlayType");
}

static inline JSC::EncodedJSValue jsHTMLMediaElementPrototypeFunctionGetStartDateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLMediaElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLDate>(*lexicalGlobalObject, impl.getStartDate()));
}

EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionGetStartDate(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSHTMLMediaElement>::call<jsHTMLMediaElementPrototypeFunctionGetStartDateBody>(*lexicalGlobalObject, *callFrame, "getStartDate");
}

static inline JSC::EncodedJSValue jsHTMLMediaElementPrototypeFunctionPlayBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSHTMLMediaElement>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.play(WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionPlay(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSHTMLMediaElement>::call<jsHTMLMediaElementPrototypeFunctionPlayBody>(*lexicalGlobalObject, *callFrame, "play");
}

static inline JSC::EncodedJSValue jsHTMLMediaElementPrototypeFunctionPauseBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLMediaElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.pause();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionPause(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSHTMLMediaElement>::call<jsHTMLMediaElementPrototypeFunctionPauseBody>(*lexicalGlobalObject, *callFrame, "pause");
}

static inline JSC::EncodedJSValue jsHTMLMediaElementPrototypeFunctionFastSeekBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLMediaElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto time = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.fastSeek(WTFMove(time));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionFastSeek(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSHTMLMediaElement>::call<jsHTMLMediaElementPrototypeFunctionFastSeekBody>(*lexicalGlobalObject, *callFrame, "fastSeek");
}

#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
static inline JSC::EncodedJSValue jsHTMLMediaElementPrototypeFunctionWebkitSetMediaKeysBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLMediaElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto mediaKeys = convert<IDLNullable<IDLInterface<WebKitMediaKeys>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "mediaKeys", "HTMLMediaElement", "webkitSetMediaKeys", "WebKitMediaKeys"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.webkitSetMediaKeys(WTFMove(mediaKeys));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionWebkitSetMediaKeys(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSHTMLMediaElement>::call<jsHTMLMediaElementPrototypeFunctionWebkitSetMediaKeysBody>(*lexicalGlobalObject, *callFrame, "webkitSetMediaKeys");
}

#endif

#if ENABLE(ENCRYPTED_MEDIA)
static inline JSC::EncodedJSValue jsHTMLMediaElementPrototypeFunctionSetMediaKeysBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSHTMLMediaElement>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto mediaKeys = convert<IDLNullable<IDLInterface<MediaKeys>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "mediaKeys", "HTMLMediaElement", "setMediaKeys", "MediaKeys"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setMediaKeys(WTFMove(mediaKeys), WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionSetMediaKeys(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSHTMLMediaElement>::call<jsHTMLMediaElementPrototypeFunctionSetMediaKeysBody>(*lexicalGlobalObject, *callFrame, "setMediaKeys");
}

#endif

#if ENABLE(VIDEO_TRACK)
static inline JSC::EncodedJSValue jsHTMLMediaElementPrototypeFunctionAddTextTrackBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLMediaElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto kind = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto label = callFrame->argument(1).isUndefined() ? emptyString() : convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto language = callFrame->argument(2).isUndefined() ? emptyString() : convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<TextTrack>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.addTextTrack(WTFMove(kind), WTFMove(label), WTFMove(language))));
}

EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionAddTextTrack(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSHTMLMediaElement>::call<jsHTMLMediaElementPrototypeFunctionAddTextTrackBody>(*lexicalGlobalObject, *callFrame, "addTextTrack");
}

#endif

static inline JSC::EncodedJSValue jsHTMLMediaElementPrototypeFunctionGetVideoPlaybackQualityBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLMediaElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<VideoPlaybackQuality>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getVideoPlaybackQuality()));
}

EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionGetVideoPlaybackQuality(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSHTMLMediaElement>::call<jsHTMLMediaElementPrototypeFunctionGetVideoPlaybackQualityBody>(*lexicalGlobalObject, *callFrame, "getVideoPlaybackQuality");
}

#if ENABLE(WIRELESS_PLAYBACK_TARGET)
static inline JSC::EncodedJSValue jsHTMLMediaElementPrototypeFunctionWebkitShowPlaybackTargetPickerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLMediaElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.webkitShowPlaybackTargetPicker();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionWebkitShowPlaybackTargetPicker(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSHTMLMediaElement>::call<jsHTMLMediaElementPrototypeFunctionWebkitShowPlaybackTargetPickerBody>(*lexicalGlobalObject, *callFrame, "webkitShowPlaybackTargetPicker");
}

#endif

void JSHTMLMediaElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSHTMLMediaElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSHTMLMediaElementOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsHTMLMediaElement = jsCast<JSHTMLMediaElement*>(handle.slot()->asCell());
    if (jsHTMLMediaElement->wrapped().hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    if (jsHTMLMediaElement->wrapped().isFiringEventListeners()) {
        if (UNLIKELY(reason))
            *reason = "EventTarget firing event listeners";
        return true;
    }
    if (JSNodeOwner::isReachableFromOpaqueRoots(handle, 0, visitor, reason))
        return true;
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSHTMLMediaElementOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsHTMLMediaElement = static_cast<JSHTMLMediaElement*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsHTMLMediaElement->wrapped(), jsHTMLMediaElement);
}

HTMLMediaElement* JSHTMLMediaElement::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSHTMLMediaElement*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(VIDEO)
