/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLPreElement.h"

#include "ActiveDOMObject.h"
#include "CustomElementReactionQueue.h"
#include "HTMLNames.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsHTMLPreElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLPreElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLPreElementWidth(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLPreElementWidth(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLPreElementWrap(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLPreElementWrap(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSHTMLPreElementPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSHTMLPreElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLPreElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLPreElementPrototype>(vm.heap)) JSHTMLPreElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLPreElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSHTMLPreElementPrototype, JSHTMLPreElementPrototype::Base);

using JSHTMLPreElementConstructor = JSDOMConstructorNotConstructable<JSHTMLPreElement>;

template<> JSValue JSHTMLPreElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLPreElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSHTMLPreElement::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("HTMLPreElement"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSHTMLPreElementConstructor::s_info = { "HTMLPreElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLPreElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSHTMLPreElementPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLPreElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLPreElementConstructor) } },
    { "width", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLPreElementWidth), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLPreElementWidth) } },
    { "wrap", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLPreElementWrap), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLPreElementWrap) } },
};

const ClassInfo JSHTMLPreElementPrototype::s_info = { "HTMLPreElementPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLPreElementPrototype) };

void JSHTMLPreElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLPreElement::info(), JSHTMLPreElementPrototypeTableValues, *this);
}

const ClassInfo JSHTMLPreElement::s_info = { "HTMLPreElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLPreElement) };

JSHTMLPreElement::JSHTMLPreElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLPreElement>&& impl)
    : JSHTMLElement(structure, globalObject, WTFMove(impl))
{
}

void JSHTMLPreElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, HTMLPreElement>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSHTMLPreElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSHTMLPreElementPrototype::create(vm, &globalObject, JSHTMLPreElementPrototype::createStructure(vm, &globalObject, JSHTMLElement::prototype(vm, globalObject)));
}

JSObject* JSHTMLPreElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSHTMLPreElement>(vm, globalObject);
}

JSValue JSHTMLPreElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLPreElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSHTMLPreElement* IDLAttribute<JSHTMLPreElement>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSHTMLPreElement*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsHTMLPreElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLPreElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSHTMLPreElement::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSHTMLPreElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLPreElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsHTMLPreElementWidthGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLPreElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.getIntegralAttribute(WebCore::HTMLNames::widthAttr));
    return result;
}

EncodedJSValue jsHTMLPreElementWidth(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLPreElement>::get<jsHTMLPreElementWidthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "width");
}

static inline bool setJSHTMLPreElementWidthSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLPreElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLLong>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setIntegralAttribute(WebCore::HTMLNames::widthAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLPreElementWidth(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLPreElement>::set<setJSHTMLPreElementWidthSetter>(*lexicalGlobalObject, thisValue, encodedValue, "width");
}

static inline JSValue jsHTMLPreElementWrapGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLPreElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasAttributeWithoutSynchronization(WebCore::HTMLNames::wrapAttr));
    return result;
}

EncodedJSValue jsHTMLPreElementWrap(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLPreElement>::get<jsHTMLPreElementWrapGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "wrap");
}

static inline bool setJSHTMLPreElementWrapSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLPreElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::HTMLNames::wrapAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLPreElementWrap(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLPreElement>::set<setJSHTMLPreElementWrapSetter>(*lexicalGlobalObject, thisValue, encodedValue, "wrap");
}

void JSHTMLPreElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSHTMLPreElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}
