/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLScriptElement.h"

#include "ActiveDOMObject.h"
#include "CustomElementReactionQueue.h"
#include "Document.h"
#include "HTMLNames.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "RuntimeEnabledFeatures.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsHTMLScriptElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLScriptElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLScriptElementText(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLScriptElementText(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLScriptElementHtmlFor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLScriptElementHtmlFor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLScriptElementEvent(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLScriptElementEvent(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLScriptElementCharset(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLScriptElementCharset(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLScriptElementAsync(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLScriptElementAsync(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLScriptElementDefer(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLScriptElementDefer(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLScriptElementSrc(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLScriptElementSrc(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLScriptElementType(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLScriptElementType(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLScriptElementCrossOrigin(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLScriptElementCrossOrigin(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLScriptElementNonce(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLScriptElementNonce(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLScriptElementNoModule(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLScriptElementNoModule(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLScriptElementIntegrity(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLScriptElementIntegrity(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLScriptElementReferrerPolicy(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLScriptElementReferrerPolicy(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSHTMLScriptElementPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSHTMLScriptElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLScriptElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLScriptElementPrototype>(vm.heap)) JSHTMLScriptElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLScriptElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSHTMLScriptElementPrototype, JSHTMLScriptElementPrototype::Base);

using JSHTMLScriptElementConstructor = JSDOMConstructorNotConstructable<JSHTMLScriptElement>;

template<> JSValue JSHTMLScriptElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLScriptElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSHTMLScriptElement::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("HTMLScriptElement"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSHTMLScriptElementConstructor::s_info = { "HTMLScriptElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLScriptElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSHTMLScriptElementPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLScriptElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLScriptElementConstructor) } },
    { "text", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLScriptElementText), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLScriptElementText) } },
    { "htmlFor", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLScriptElementHtmlFor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLScriptElementHtmlFor) } },
    { "event", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLScriptElementEvent), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLScriptElementEvent) } },
    { "charset", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLScriptElementCharset), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLScriptElementCharset) } },
    { "async", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLScriptElementAsync), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLScriptElementAsync) } },
    { "defer", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLScriptElementDefer), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLScriptElementDefer) } },
    { "src", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLScriptElementSrc), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLScriptElementSrc) } },
    { "type", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLScriptElementType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLScriptElementType) } },
    { "crossOrigin", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLScriptElementCrossOrigin), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLScriptElementCrossOrigin) } },
    { "nonce", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLScriptElementNonce), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLScriptElementNonce) } },
    { "noModule", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLScriptElementNoModule), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLScriptElementNoModule) } },
    { "integrity", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLScriptElementIntegrity), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLScriptElementIntegrity) } },
    { "referrerPolicy", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLScriptElementReferrerPolicy), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLScriptElementReferrerPolicy) } },
};

const ClassInfo JSHTMLScriptElementPrototype::s_info = { "HTMLScriptElementPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLScriptElementPrototype) };

void JSHTMLScriptElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLScriptElement::info(), JSHTMLScriptElementPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settings().subresourceIntegrityEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("integrity"), strlen("integrity"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().referrerPolicyAttributeEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("referrerPolicy"), strlen("referrerPolicy"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
}

const ClassInfo JSHTMLScriptElement::s_info = { "HTMLScriptElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLScriptElement) };

JSHTMLScriptElement::JSHTMLScriptElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLScriptElement>&& impl)
    : JSHTMLElement(structure, globalObject, WTFMove(impl))
{
}

void JSHTMLScriptElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, HTMLScriptElement>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSHTMLScriptElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSHTMLScriptElementPrototype::create(vm, &globalObject, JSHTMLScriptElementPrototype::createStructure(vm, &globalObject, JSHTMLElement::prototype(vm, globalObject)));
}

JSObject* JSHTMLScriptElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSHTMLScriptElement>(vm, globalObject);
}

JSValue JSHTMLScriptElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLScriptElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSHTMLScriptElement* IDLAttribute<JSHTMLScriptElement>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSHTMLScriptElement*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsHTMLScriptElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLScriptElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSHTMLScriptElement::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSHTMLScriptElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLScriptElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsHTMLScriptElementTextGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLScriptElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.text());
    return result;
}

EncodedJSValue jsHTMLScriptElementText(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLScriptElement>::get<jsHTMLScriptElementTextGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "text");
}

static inline bool setJSHTMLScriptElementTextSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLScriptElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setText(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLScriptElementText(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLScriptElement>::set<setJSHTMLScriptElementTextSetter>(*lexicalGlobalObject, thisValue, encodedValue, "text");
}

static inline JSValue jsHTMLScriptElementHtmlForGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLScriptElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::forAttr));
    return result;
}

EncodedJSValue jsHTMLScriptElementHtmlFor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLScriptElement>::get<jsHTMLScriptElementHtmlForGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "htmlFor");
}

static inline bool setJSHTMLScriptElementHtmlForSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLScriptElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::forAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLScriptElementHtmlFor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLScriptElement>::set<setJSHTMLScriptElementHtmlForSetter>(*lexicalGlobalObject, thisValue, encodedValue, "htmlFor");
}

static inline JSValue jsHTMLScriptElementEventGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLScriptElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::eventAttr));
    return result;
}

EncodedJSValue jsHTMLScriptElementEvent(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLScriptElement>::get<jsHTMLScriptElementEventGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "event");
}

static inline bool setJSHTMLScriptElementEventSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLScriptElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::eventAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLScriptElementEvent(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLScriptElement>::set<setJSHTMLScriptElementEventSetter>(*lexicalGlobalObject, thisValue, encodedValue, "event");
}

static inline JSValue jsHTMLScriptElementCharsetGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLScriptElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::charsetAttr));
    return result;
}

EncodedJSValue jsHTMLScriptElementCharset(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLScriptElement>::get<jsHTMLScriptElementCharsetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "charset");
}

static inline bool setJSHTMLScriptElementCharsetSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLScriptElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::charsetAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLScriptElementCharset(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLScriptElement>::set<setJSHTMLScriptElementCharsetSetter>(*lexicalGlobalObject, thisValue, encodedValue, "charset");
}

static inline JSValue jsHTMLScriptElementAsyncGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLScriptElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.async());
    return result;
}

EncodedJSValue jsHTMLScriptElementAsync(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLScriptElement>::get<jsHTMLScriptElementAsyncGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "async");
}

static inline bool setJSHTMLScriptElementAsyncSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLScriptElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAsync(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLScriptElementAsync(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLScriptElement>::set<setJSHTMLScriptElementAsyncSetter>(*lexicalGlobalObject, thisValue, encodedValue, "async");
}

static inline JSValue jsHTMLScriptElementDeferGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLScriptElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasAttributeWithoutSynchronization(WebCore::HTMLNames::deferAttr));
    return result;
}

EncodedJSValue jsHTMLScriptElementDefer(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLScriptElement>::get<jsHTMLScriptElementDeferGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "defer");
}

static inline bool setJSHTMLScriptElementDeferSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLScriptElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::HTMLNames::deferAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLScriptElementDefer(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLScriptElement>::set<setJSHTMLScriptElementDeferSetter>(*lexicalGlobalObject, thisValue, encodedValue, "defer");
}

static inline JSValue jsHTMLScriptElementSrcGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLScriptElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.getURLAttribute(WebCore::HTMLNames::srcAttr));
    return result;
}

EncodedJSValue jsHTMLScriptElementSrc(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLScriptElement>::get<jsHTMLScriptElementSrcGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "src");
}

static inline bool setJSHTMLScriptElementSrcSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLScriptElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUSVString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::srcAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLScriptElementSrc(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLScriptElement>::set<setJSHTMLScriptElementSrcSetter>(*lexicalGlobalObject, thisValue, encodedValue, "src");
}

static inline JSValue jsHTMLScriptElementTypeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLScriptElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::typeAttr));
    return result;
}

EncodedJSValue jsHTMLScriptElementType(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLScriptElement>::get<jsHTMLScriptElementTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "type");
}

static inline bool setJSHTMLScriptElementTypeSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLScriptElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::typeAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLScriptElementType(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLScriptElement>::set<setJSHTMLScriptElementTypeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "type");
}

static inline JSValue jsHTMLScriptElementCrossOriginGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLScriptElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.crossOrigin());
    return result;
}

EncodedJSValue jsHTMLScriptElementCrossOrigin(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLScriptElement>::get<jsHTMLScriptElementCrossOriginGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "crossOrigin");
}

static inline bool setJSHTMLScriptElementCrossOriginSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLScriptElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setCrossOrigin(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLScriptElementCrossOrigin(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLScriptElement>::set<setJSHTMLScriptElementCrossOriginSetter>(*lexicalGlobalObject, thisValue, encodedValue, "crossOrigin");
}

static inline JSValue jsHTMLScriptElementNonceGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLScriptElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::nonceAttr));
    return result;
}

EncodedJSValue jsHTMLScriptElementNonce(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLScriptElement>::get<jsHTMLScriptElementNonceGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "nonce");
}

static inline bool setJSHTMLScriptElementNonceSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLScriptElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::nonceAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLScriptElementNonce(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLScriptElement>::set<setJSHTMLScriptElementNonceSetter>(*lexicalGlobalObject, thisValue, encodedValue, "nonce");
}

static inline JSValue jsHTMLScriptElementNoModuleGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLScriptElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasAttributeWithoutSynchronization(WebCore::HTMLNames::nomoduleAttr));
    return result;
}

EncodedJSValue jsHTMLScriptElementNoModule(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLScriptElement>::get<jsHTMLScriptElementNoModuleGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "noModule");
}

static inline bool setJSHTMLScriptElementNoModuleSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLScriptElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::HTMLNames::nomoduleAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLScriptElementNoModule(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLScriptElement>::set<setJSHTMLScriptElementNoModuleSetter>(*lexicalGlobalObject, thisValue, encodedValue, "noModule");
}

static inline JSValue jsHTMLScriptElementIntegrityGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLScriptElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::integrityAttr));
    return result;
}

EncodedJSValue jsHTMLScriptElementIntegrity(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLScriptElement>::get<jsHTMLScriptElementIntegrityGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "integrity");
}

static inline bool setJSHTMLScriptElementIntegritySetter(JSGlobalObject& lexicalGlobalObject, JSHTMLScriptElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::integrityAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLScriptElementIntegrity(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLScriptElement>::set<setJSHTMLScriptElementIntegritySetter>(*lexicalGlobalObject, thisValue, encodedValue, "integrity");
}

static inline JSValue jsHTMLScriptElementReferrerPolicyGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLScriptElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.referrerPolicyForBindings());
    return result;
}

EncodedJSValue jsHTMLScriptElementReferrerPolicy(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLScriptElement>::get<jsHTMLScriptElementReferrerPolicyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "referrerPolicy");
}

static inline bool setJSHTMLScriptElementReferrerPolicySetter(JSGlobalObject& lexicalGlobalObject, JSHTMLScriptElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setReferrerPolicyForBindings(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLScriptElementReferrerPolicy(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLScriptElement>::set<setJSHTMLScriptElementReferrerPolicySetter>(*lexicalGlobalObject, thisValue, encodedValue, "referrerPolicy");
}

void JSHTMLScriptElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSHTMLScriptElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}
