/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLTextAreaElement.h"

#include "ActiveDOMObject.h"
#include "CustomElementReactionQueue.h"
#include "HTMLNames.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSHTMLFormElement.h"
#include "JSNodeList.h"
#include "JSValidityState.h"
#include "RuntimeEnabledFeatures.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsHTMLTextAreaElementPrototypeFunctionCheckValidity(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLTextAreaElementPrototypeFunctionReportValidity(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLTextAreaElementPrototypeFunctionSetCustomValidity(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLTextAreaElementPrototypeFunctionSelect(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLTextAreaElementPrototypeFunctionSetRangeText(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsHTMLTextAreaElementPrototypeFunctionSetSelectionRange(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsHTMLTextAreaElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLTextAreaElementConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLTextAreaElementAutofocus(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLTextAreaElementAutofocus(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLTextAreaElementDirName(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLTextAreaElementDirName(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLTextAreaElementDisabled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLTextAreaElementDisabled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLTextAreaElementForm(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLTextAreaElementMinLength(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLTextAreaElementMinLength(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLTextAreaElementMaxLength(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLTextAreaElementMaxLength(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLTextAreaElementName(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLTextAreaElementName(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLTextAreaElementPlaceholder(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLTextAreaElementPlaceholder(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLTextAreaElementReadOnly(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLTextAreaElementReadOnly(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLTextAreaElementRequired(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLTextAreaElementRequired(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLTextAreaElementRows(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLTextAreaElementRows(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLTextAreaElementCols(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLTextAreaElementCols(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLTextAreaElementWrap(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLTextAreaElementWrap(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLTextAreaElementType(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLTextAreaElementDefaultValue(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLTextAreaElementDefaultValue(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLTextAreaElementValue(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLTextAreaElementValue(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLTextAreaElementTextLength(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLTextAreaElementWillValidate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLTextAreaElementValidity(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLTextAreaElementValidationMessage(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLTextAreaElementLabels(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsHTMLTextAreaElementSelectionStart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLTextAreaElementSelectionStart(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLTextAreaElementSelectionEnd(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLTextAreaElementSelectionEnd(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLTextAreaElementSelectionDirection(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLTextAreaElementSelectionDirection(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsHTMLTextAreaElementAutocomplete(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSHTMLTextAreaElementAutocomplete(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSHTMLTextAreaElementPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSHTMLTextAreaElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLTextAreaElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLTextAreaElementPrototype>(vm.heap)) JSHTMLTextAreaElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLTextAreaElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSHTMLTextAreaElementPrototype, JSHTMLTextAreaElementPrototype::Base);

using JSHTMLTextAreaElementConstructor = JSDOMConstructorNotConstructable<JSHTMLTextAreaElement>;

template<> JSValue JSHTMLTextAreaElementConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLTextAreaElementConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSHTMLTextAreaElement::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("HTMLTextAreaElement"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSHTMLTextAreaElementConstructor::s_info = { "HTMLTextAreaElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLTextAreaElementConstructor) };

/* Hash table for prototype */

static const HashTableValue JSHTMLTextAreaElementPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLTextAreaElementConstructor) } },
    { "autofocus", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementAutofocus), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLTextAreaElementAutofocus) } },
    { "dirName", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementDirName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLTextAreaElementDirName) } },
    { "disabled", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementDisabled), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLTextAreaElementDisabled) } },
    { "form", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementForm), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "minLength", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementMinLength), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLTextAreaElementMinLength) } },
    { "maxLength", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementMaxLength), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLTextAreaElementMaxLength) } },
    { "name", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLTextAreaElementName) } },
    { "placeholder", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementPlaceholder), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLTextAreaElementPlaceholder) } },
    { "readOnly", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementReadOnly), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLTextAreaElementReadOnly) } },
    { "required", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementRequired), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLTextAreaElementRequired) } },
    { "rows", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementRows), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLTextAreaElementRows) } },
    { "cols", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementCols), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLTextAreaElementCols) } },
    { "wrap", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementWrap), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLTextAreaElementWrap) } },
    { "type", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "defaultValue", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementDefaultValue), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLTextAreaElementDefaultValue) } },
    { "value", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementValue), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLTextAreaElementValue) } },
    { "textLength", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementTextLength), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "willValidate", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementWillValidate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "validity", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementValidity), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "validationMessage", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementValidationMessage), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "labels", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementLabels), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "selectionStart", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementSelectionStart), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLTextAreaElementSelectionStart) } },
    { "selectionEnd", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementSelectionEnd), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLTextAreaElementSelectionEnd) } },
    { "selectionDirection", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementSelectionDirection), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLTextAreaElementSelectionDirection) } },
    { "autocomplete", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTextAreaElementAutocomplete), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSHTMLTextAreaElementAutocomplete) } },
    { "checkValidity", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLTextAreaElementPrototypeFunctionCheckValidity), (intptr_t) (0) } },
    { "reportValidity", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLTextAreaElementPrototypeFunctionReportValidity), (intptr_t) (0) } },
    { "setCustomValidity", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLTextAreaElementPrototypeFunctionSetCustomValidity), (intptr_t) (1) } },
    { "select", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLTextAreaElementPrototypeFunctionSelect), (intptr_t) (0) } },
    { "setRangeText", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLTextAreaElementPrototypeFunctionSetRangeText), (intptr_t) (1) } },
    { "setSelectionRange", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsHTMLTextAreaElementPrototypeFunctionSetSelectionRange), (intptr_t) (0) } },
};

const ClassInfo JSHTMLTextAreaElementPrototype::s_info = { "HTMLTextAreaElementPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLTextAreaElementPrototype) };

void JSHTMLTextAreaElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLTextAreaElement::info(), JSHTMLTextAreaElementPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!RuntimeEnabledFeatures::sharedFeatures().interactiveFormValidationEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("reportValidity"), strlen("reportValidity"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
}

const ClassInfo JSHTMLTextAreaElement::s_info = { "HTMLTextAreaElement", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLTextAreaElement) };

JSHTMLTextAreaElement::JSHTMLTextAreaElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLTextAreaElement>&& impl)
    : JSHTMLElement(structure, globalObject, WTFMove(impl))
{
}

void JSHTMLTextAreaElement::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, HTMLTextAreaElement>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSHTMLTextAreaElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSHTMLTextAreaElementPrototype::create(vm, &globalObject, JSHTMLTextAreaElementPrototype::createStructure(vm, &globalObject, JSHTMLElement::prototype(vm, globalObject)));
}

JSObject* JSHTMLTextAreaElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSHTMLTextAreaElement>(vm, globalObject);
}

JSValue JSHTMLTextAreaElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLTextAreaElementConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSHTMLTextAreaElement* IDLAttribute<JSHTMLTextAreaElement>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSHTMLTextAreaElement*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSHTMLTextAreaElement* IDLOperation<JSHTMLTextAreaElement>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSHTMLTextAreaElement*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsHTMLTextAreaElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLTextAreaElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSHTMLTextAreaElement::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSHTMLTextAreaElementConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLTextAreaElementPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsHTMLTextAreaElementAutofocusGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasAttributeWithoutSynchronization(WebCore::HTMLNames::autofocusAttr));
    return result;
}

EncodedJSValue jsHTMLTextAreaElementAutofocus(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLTextAreaElement>::get<jsHTMLTextAreaElementAutofocusGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "autofocus");
}

static inline bool setJSHTMLTextAreaElementAutofocusSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::HTMLNames::autofocusAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLTextAreaElementAutofocus(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLTextAreaElement>::set<setJSHTMLTextAreaElementAutofocusSetter>(*lexicalGlobalObject, thisValue, encodedValue, "autofocus");
}

static inline JSValue jsHTMLTextAreaElementDirNameGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::dirnameAttr));
    return result;
}

EncodedJSValue jsHTMLTextAreaElementDirName(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLTextAreaElement>::get<jsHTMLTextAreaElementDirNameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "dirName");
}

static inline bool setJSHTMLTextAreaElementDirNameSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::dirnameAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLTextAreaElementDirName(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLTextAreaElement>::set<setJSHTMLTextAreaElementDirNameSetter>(*lexicalGlobalObject, thisValue, encodedValue, "dirName");
}

static inline JSValue jsHTMLTextAreaElementDisabledGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasAttributeWithoutSynchronization(WebCore::HTMLNames::disabledAttr));
    return result;
}

EncodedJSValue jsHTMLTextAreaElementDisabled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLTextAreaElement>::get<jsHTMLTextAreaElementDisabledGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "disabled");
}

static inline bool setJSHTMLTextAreaElementDisabledSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::HTMLNames::disabledAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLTextAreaElementDisabled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLTextAreaElement>::set<setJSHTMLTextAreaElementDisabledSetter>(*lexicalGlobalObject, thisValue, encodedValue, "disabled");
}

static inline JSValue jsHTMLTextAreaElementFormGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<HTMLFormElement>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.form());
    return result;
}

EncodedJSValue jsHTMLTextAreaElementForm(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLTextAreaElement>::get<jsHTMLTextAreaElementFormGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "form");
}

static inline JSValue jsHTMLTextAreaElementMinLengthGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.minLength());
    return result;
}

EncodedJSValue jsHTMLTextAreaElementMinLength(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLTextAreaElement>::get<jsHTMLTextAreaElementMinLengthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "minLength");
}

static inline bool setJSHTMLTextAreaElementMinLengthSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLLong>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setMinLength(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLTextAreaElementMinLength(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLTextAreaElement>::set<setJSHTMLTextAreaElementMinLengthSetter>(*lexicalGlobalObject, thisValue, encodedValue, "minLength");
}

static inline JSValue jsHTMLTextAreaElementMaxLengthGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.maxLength());
    return result;
}

EncodedJSValue jsHTMLTextAreaElementMaxLength(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLTextAreaElement>::get<jsHTMLTextAreaElementMaxLengthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "maxLength");
}

static inline bool setJSHTMLTextAreaElementMaxLengthSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLLong>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setMaxLength(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLTextAreaElementMaxLength(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLTextAreaElement>::set<setJSHTMLTextAreaElementMaxLengthSetter>(*lexicalGlobalObject, thisValue, encodedValue, "maxLength");
}

static inline JSValue jsHTMLTextAreaElementNameGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.getNameAttribute());
    return result;
}

EncodedJSValue jsHTMLTextAreaElementName(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLTextAreaElement>::get<jsHTMLTextAreaElementNameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "name");
}

static inline bool setJSHTMLTextAreaElementNameSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::nameAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLTextAreaElementName(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLTextAreaElement>::set<setJSHTMLTextAreaElementNameSetter>(*lexicalGlobalObject, thisValue, encodedValue, "name");
}

static inline JSValue jsHTMLTextAreaElementPlaceholderGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::placeholderAttr));
    return result;
}

EncodedJSValue jsHTMLTextAreaElementPlaceholder(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLTextAreaElement>::get<jsHTMLTextAreaElementPlaceholderGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "placeholder");
}

static inline bool setJSHTMLTextAreaElementPlaceholderSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::placeholderAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLTextAreaElementPlaceholder(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLTextAreaElement>::set<setJSHTMLTextAreaElementPlaceholderSetter>(*lexicalGlobalObject, thisValue, encodedValue, "placeholder");
}

static inline JSValue jsHTMLTextAreaElementReadOnlyGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasAttributeWithoutSynchronization(WebCore::HTMLNames::readonlyAttr));
    return result;
}

EncodedJSValue jsHTMLTextAreaElementReadOnly(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLTextAreaElement>::get<jsHTMLTextAreaElementReadOnlyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "readOnly");
}

static inline bool setJSHTMLTextAreaElementReadOnlySetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::HTMLNames::readonlyAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLTextAreaElementReadOnly(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLTextAreaElement>::set<setJSHTMLTextAreaElementReadOnlySetter>(*lexicalGlobalObject, thisValue, encodedValue, "readOnly");
}

static inline JSValue jsHTMLTextAreaElementRequiredGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasAttributeWithoutSynchronization(WebCore::HTMLNames::requiredAttr));
    return result;
}

EncodedJSValue jsHTMLTextAreaElementRequired(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLTextAreaElement>::get<jsHTMLTextAreaElementRequiredGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "required");
}

static inline bool setJSHTMLTextAreaElementRequiredSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::HTMLNames::requiredAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLTextAreaElementRequired(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLTextAreaElement>::set<setJSHTMLTextAreaElementRequiredSetter>(*lexicalGlobalObject, thisValue, encodedValue, "required");
}

static inline JSValue jsHTMLTextAreaElementRowsGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.rows());
    return result;
}

EncodedJSValue jsHTMLTextAreaElementRows(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLTextAreaElement>::get<jsHTMLTextAreaElementRowsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "rows");
}

static inline bool setJSHTMLTextAreaElementRowsSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnsignedLong>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setRows(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLTextAreaElementRows(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLTextAreaElement>::set<setJSHTMLTextAreaElementRowsSetter>(*lexicalGlobalObject, thisValue, encodedValue, "rows");
}

static inline JSValue jsHTMLTextAreaElementColsGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.cols());
    return result;
}

EncodedJSValue jsHTMLTextAreaElementCols(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLTextAreaElement>::get<jsHTMLTextAreaElementColsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "cols");
}

static inline bool setJSHTMLTextAreaElementColsSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnsignedLong>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setCols(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLTextAreaElementCols(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLTextAreaElement>::set<setJSHTMLTextAreaElementColsSetter>(*lexicalGlobalObject, thisValue, encodedValue, "cols");
}

static inline JSValue jsHTMLTextAreaElementWrapGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::wrapAttr));
    return result;
}

EncodedJSValue jsHTMLTextAreaElementWrap(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLTextAreaElement>::get<jsHTMLTextAreaElementWrapGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "wrap");
}

static inline bool setJSHTMLTextAreaElementWrapSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::wrapAttr, WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLTextAreaElementWrap(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLTextAreaElement>::set<setJSHTMLTextAreaElementWrapSetter>(*lexicalGlobalObject, thisValue, encodedValue, "wrap");
}

static inline JSValue jsHTMLTextAreaElementTypeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.type());
    return result;
}

EncodedJSValue jsHTMLTextAreaElementType(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLTextAreaElement>::get<jsHTMLTextAreaElementTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "type");
}

static inline JSValue jsHTMLTextAreaElementDefaultValueGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.defaultValue());
    return result;
}

EncodedJSValue jsHTMLTextAreaElementDefaultValue(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLTextAreaElement>::get<jsHTMLTextAreaElementDefaultValueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "defaultValue");
}

static inline bool setJSHTMLTextAreaElementDefaultValueSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setDefaultValue(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLTextAreaElementDefaultValue(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLTextAreaElement>::set<setJSHTMLTextAreaElementDefaultValueSetter>(*lexicalGlobalObject, thisValue, encodedValue, "defaultValue");
}

static inline JSValue jsHTMLTextAreaElementValueGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.value());
    return result;
}

EncodedJSValue jsHTMLTextAreaElementValue(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLTextAreaElement>::get<jsHTMLTextAreaElementValueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "value");
}

static inline bool setJSHTMLTextAreaElementValueSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLTreatNullAsEmptyAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setValue(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLTextAreaElementValue(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLTextAreaElement>::set<setJSHTMLTextAreaElementValueSetter>(*lexicalGlobalObject, thisValue, encodedValue, "value");
}

static inline JSValue jsHTMLTextAreaElementTextLengthGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.textLength());
    return result;
}

EncodedJSValue jsHTMLTextAreaElementTextLength(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLTextAreaElement>::get<jsHTMLTextAreaElementTextLengthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "textLength");
}

static inline JSValue jsHTMLTextAreaElementWillValidateGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.willValidate());
    return result;
}

EncodedJSValue jsHTMLTextAreaElementWillValidate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLTextAreaElement>::get<jsHTMLTextAreaElementWillValidateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "willValidate");
}

static inline JSValue jsHTMLTextAreaElementValidityGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<ValidityState>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.validity());
    return result;
}

EncodedJSValue jsHTMLTextAreaElementValidity(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLTextAreaElement>::get<jsHTMLTextAreaElementValidityGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "validity");
}

static inline JSValue jsHTMLTextAreaElementValidationMessageGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.validationMessage());
    return result;
}

EncodedJSValue jsHTMLTextAreaElementValidationMessage(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLTextAreaElement>::get<jsHTMLTextAreaElementValidationMessageGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "validationMessage");
}

static inline JSValue jsHTMLTextAreaElementLabelsGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<NodeList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.labels());
    return result;
}

EncodedJSValue jsHTMLTextAreaElementLabels(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLTextAreaElement>::get<jsHTMLTextAreaElementLabelsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "labels");
}

static inline JSValue jsHTMLTextAreaElementSelectionStartGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.selectionStart());
    return result;
}

EncodedJSValue jsHTMLTextAreaElementSelectionStart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLTextAreaElement>::get<jsHTMLTextAreaElementSelectionStartGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "selectionStart");
}

static inline bool setJSHTMLTextAreaElementSelectionStartSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLLong>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setSelectionStart(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLTextAreaElementSelectionStart(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLTextAreaElement>::set<setJSHTMLTextAreaElementSelectionStartSetter>(*lexicalGlobalObject, thisValue, encodedValue, "selectionStart");
}

static inline JSValue jsHTMLTextAreaElementSelectionEndGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.selectionEnd());
    return result;
}

EncodedJSValue jsHTMLTextAreaElementSelectionEnd(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLTextAreaElement>::get<jsHTMLTextAreaElementSelectionEndGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "selectionEnd");
}

static inline bool setJSHTMLTextAreaElementSelectionEndSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLLong>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setSelectionEnd(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLTextAreaElementSelectionEnd(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLTextAreaElement>::set<setJSHTMLTextAreaElementSelectionEndSetter>(*lexicalGlobalObject, thisValue, encodedValue, "selectionEnd");
}

static inline JSValue jsHTMLTextAreaElementSelectionDirectionGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.selectionDirection());
    return result;
}

EncodedJSValue jsHTMLTextAreaElementSelectionDirection(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLTextAreaElement>::get<jsHTMLTextAreaElementSelectionDirectionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "selectionDirection");
}

static inline bool setJSHTMLTextAreaElementSelectionDirectionSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setSelectionDirection(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLTextAreaElementSelectionDirection(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLTextAreaElement>::set<setJSHTMLTextAreaElementSelectionDirectionSetter>(*lexicalGlobalObject, thisValue, encodedValue, "selectionDirection");
}

static inline JSValue jsHTMLTextAreaElementAutocompleteGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.autocomplete());
    return result;
}

EncodedJSValue jsHTMLTextAreaElementAutocomplete(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSHTMLTextAreaElement>::get<jsHTMLTextAreaElementAutocompleteGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "autocomplete");
}

static inline bool setJSHTMLTextAreaElementAutocompleteSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLTextAreaElement& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setAutocomplete(WTFMove(nativeValue));
    });
    return true;
}

bool setJSHTMLTextAreaElementAutocomplete(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSHTMLTextAreaElement>::set<setJSHTMLTextAreaElementAutocompleteSetter>(*lexicalGlobalObject, thisValue, encodedValue, "autocomplete");
}

static inline JSC::EncodedJSValue jsHTMLTextAreaElementPrototypeFunctionCheckValidityBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLTextAreaElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLBoolean>(impl.checkValidity()));
}

EncodedJSValue JSC_HOST_CALL jsHTMLTextAreaElementPrototypeFunctionCheckValidity(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSHTMLTextAreaElement>::call<jsHTMLTextAreaElementPrototypeFunctionCheckValidityBody>(*lexicalGlobalObject, *callFrame, "checkValidity");
}

static inline JSC::EncodedJSValue jsHTMLTextAreaElementPrototypeFunctionReportValidityBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLTextAreaElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLBoolean>(impl.reportValidity()));
}

EncodedJSValue JSC_HOST_CALL jsHTMLTextAreaElementPrototypeFunctionReportValidity(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSHTMLTextAreaElement>::call<jsHTMLTextAreaElementPrototypeFunctionReportValidityBody>(*lexicalGlobalObject, *callFrame, "reportValidity");
}

static inline JSC::EncodedJSValue jsHTMLTextAreaElementPrototypeFunctionSetCustomValidityBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLTextAreaElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto error = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setCustomValidity(WTFMove(error));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLTextAreaElementPrototypeFunctionSetCustomValidity(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSHTMLTextAreaElement>::call<jsHTMLTextAreaElementPrototypeFunctionSetCustomValidityBody>(*lexicalGlobalObject, *callFrame, "setCustomValidity");
}

static inline JSC::EncodedJSValue jsHTMLTextAreaElementPrototypeFunctionSelectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLTextAreaElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.select();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLTextAreaElementPrototypeFunctionSelect(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSHTMLTextAreaElement>::call<jsHTMLTextAreaElementPrototypeFunctionSelectBody>(*lexicalGlobalObject, *callFrame, "select");
}

static inline JSC::EncodedJSValue jsHTMLTextAreaElementPrototypeFunctionSetRangeText1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLTextAreaElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto replacement = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setRangeText(WTFMove(replacement)));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsHTMLTextAreaElementPrototypeFunctionSetRangeText2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLTextAreaElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto replacement = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto start = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto end = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto selectionMode = callFrame->argument(3).isUndefined() ? String() : convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setRangeText(WTFMove(replacement), WTFMove(start), WTFMove(end), WTFMove(selectionMode)));
    return JSValue::encode(jsUndefined());
}

static inline JSC::EncodedJSValue jsHTMLTextAreaElementPrototypeFunctionSetRangeTextOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLTextAreaElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(4, callFrame->argumentCount());
    if (argsCount == 1) {
        return jsHTMLTextAreaElementPrototypeFunctionSetRangeText1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 3) {
        return jsHTMLTextAreaElementPrototypeFunctionSetRangeText2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    if (argsCount == 4) {
        return jsHTMLTextAreaElementPrototypeFunctionSetRangeText2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 1 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsHTMLTextAreaElementPrototypeFunctionSetRangeText(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSHTMLTextAreaElement>::call<jsHTMLTextAreaElementPrototypeFunctionSetRangeTextOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "setRangeText");
}

static inline JSC::EncodedJSValue jsHTMLTextAreaElementPrototypeFunctionSetSelectionRangeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSHTMLTextAreaElement>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto start = convert<IDLLong>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto end = convert<IDLLong>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto direction = callFrame->argument(2).isUndefined() ? String() : convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setSelectionRange(WTFMove(start), WTFMove(end), WTFMove(direction));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLTextAreaElementPrototypeFunctionSetSelectionRange(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSHTMLTextAreaElement>::call<jsHTMLTextAreaElementPrototypeFunctionSetSelectionRangeBody>(*lexicalGlobalObject, *callFrame, "setSelectionRange");
}

void JSHTMLTextAreaElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSHTMLTextAreaElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}


}
