/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#if ENABLE(VIDEO)

#include "HTMLVideoElement.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMWrapper.h"
#include "JSHTMLMediaElement.h"
#include "JSNode.h"
#include <wtf/NeverDestroyed.h>

namespace WebCore {

class WEBCORE_EXPORT JSHTMLVideoElement : public JSHTMLMediaElement {
public:
    using Base = JSHTMLMediaElement;
    using DOMWrapped = HTMLVideoElement;
    static JSHTMLVideoElement* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<HTMLVideoElement>&& impl)
    {
        JSHTMLVideoElement* ptr = new (NotNull, JSC::allocateCell<JSHTMLVideoElement>(globalObject->vm().heap)) JSHTMLVideoElement(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::VM&, JSDOMGlobalObject&);
    static JSC::JSObject* prototype(JSC::VM&, JSDOMGlobalObject&);
    static HTMLVideoElement* toWrapped(JSC::VM&, JSC::JSValue);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::JSType(JSElementType), StructureFlags), info());
    }

    static JSC::JSValue getConstructor(JSC::VM&, const JSC::JSGlobalObject*);
    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);
    HTMLVideoElement& wrapped() const
    {
        return static_cast<HTMLVideoElement&>(Base::wrapped());
    }
protected:
    JSHTMLVideoElement(JSC::Structure*, JSDOMGlobalObject&, Ref<HTMLVideoElement>&&);

    void finishCreation(JSC::VM&);
};

class JSHTMLVideoElementOwner : public JSNodeOwner {
public:
    virtual bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::SlotVisitor&, const char**);
    virtual void finalize(JSC::Handle<JSC::Unknown>, void* context);
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld&, HTMLVideoElement*)
{
    static NeverDestroyed<JSHTMLVideoElementOwner> owner;
    return &owner.get();
}

inline void* wrapperKey(HTMLVideoElement* wrappableObject)
{
    return wrappableObject;
}


template<> struct JSDOMWrapperConverterTraits<HTMLVideoElement> {
    using WrapperClass = JSHTMLVideoElement;
    using ToWrappedReturnType = HTMLVideoElement*;
};
#if ENABLE(VIDEO_PRESENTATION_MODE)

String convertEnumerationToString(HTMLVideoElement::VideoPresentationMode);
template<> JSC::JSString* convertEnumerationToJS(JSC::JSGlobalObject&, HTMLVideoElement::VideoPresentationMode);

template<> Optional<HTMLVideoElement::VideoPresentationMode> parseEnumeration<HTMLVideoElement::VideoPresentationMode>(JSC::JSGlobalObject&, JSC::JSValue);
template<> const char* expectedEnumerationValues<HTMLVideoElement::VideoPresentationMode>();

#endif


} // namespace WebCore

#endif // ENABLE(VIDEO)
