/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(INDEXED_DATABASE)

#include "JSIDBCursorDirection.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(IDBCursorDirection enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("next"),
        MAKE_STATIC_STRING_IMPL("nextunique"),
        MAKE_STATIC_STRING_IMPL("prev"),
        MAKE_STATIC_STRING_IMPL("prevunique"),
    };
    static_assert(static_cast<size_t>(IDBCursorDirection::Next) == 0, "IDBCursorDirection::Next is not 0 as expected");
    static_assert(static_cast<size_t>(IDBCursorDirection::Nextunique) == 1, "IDBCursorDirection::Nextunique is not 1 as expected");
    static_assert(static_cast<size_t>(IDBCursorDirection::Prev) == 2, "IDBCursorDirection::Prev is not 2 as expected");
    static_assert(static_cast<size_t>(IDBCursorDirection::Prevunique) == 3, "IDBCursorDirection::Prevunique is not 3 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, IDBCursorDirection enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<IDBCursorDirection> parseEnumeration<IDBCursorDirection>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "next")
        return IDBCursorDirection::Next;
    if (stringValue == "nextunique")
        return IDBCursorDirection::Nextunique;
    if (stringValue == "prev")
        return IDBCursorDirection::Prev;
    if (stringValue == "prevunique")
        return IDBCursorDirection::Prevunique;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<IDBCursorDirection>()
{
    return "\"next\", \"nextunique\", \"prev\", \"prevunique\"";
}

} // namespace WebCore

#endif // ENABLE(INDEXED_DATABASE)
