/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(INDEXED_DATABASE)

#include "JSIDBKeyRange.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertIndexedDB.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSIDBKeyRange.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsIDBKeyRangeConstructorFunctionOnly(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBKeyRangeConstructorFunctionLowerBound(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBKeyRangeConstructorFunctionUpperBound(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBKeyRangeConstructorFunctionBound(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsIDBKeyRangePrototypeFunctionIncludes(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsIDBKeyRangeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSIDBKeyRangeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsIDBKeyRangeLower(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsIDBKeyRangeUpper(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsIDBKeyRangeLowerOpen(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsIDBKeyRangeUpperOpen(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSIDBKeyRangePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSIDBKeyRangePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSIDBKeyRangePrototype* ptr = new (NotNull, JSC::allocateCell<JSIDBKeyRangePrototype>(vm.heap)) JSIDBKeyRangePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSIDBKeyRangePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSIDBKeyRangePrototype, JSIDBKeyRangePrototype::Base);

using JSIDBKeyRangeConstructor = JSDOMConstructorNotConstructable<JSIDBKeyRange>;

/* Hash table for constructor */

static const HashTableValue JSIDBKeyRangeConstructorTableValues[] =
{
    { "only", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsIDBKeyRangeConstructorFunctionOnly), (intptr_t) (1) } },
    { "lowerBound", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsIDBKeyRangeConstructorFunctionLowerBound), (intptr_t) (1) } },
    { "upperBound", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsIDBKeyRangeConstructorFunctionUpperBound), (intptr_t) (1) } },
    { "bound", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsIDBKeyRangeConstructorFunctionBound), (intptr_t) (2) } },
};

template<> JSValue JSIDBKeyRangeConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSIDBKeyRangeConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSIDBKeyRange::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("IDBKeyRange"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSIDBKeyRange::info(), JSIDBKeyRangeConstructorTableValues, *this);
}

template<> const ClassInfo JSIDBKeyRangeConstructor::s_info = { "IDBKeyRange", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBKeyRangeConstructor) };

/* Hash table for prototype */

static const HashTableValue JSIDBKeyRangePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBKeyRangeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSIDBKeyRangeConstructor) } },
    { "lower", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBKeyRangeLower), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "upper", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBKeyRangeUpper), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "lowerOpen", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBKeyRangeLowerOpen), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "upperOpen", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIDBKeyRangeUpperOpen), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "includes", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsIDBKeyRangePrototypeFunctionIncludes), (intptr_t) (1) } },
};

const ClassInfo JSIDBKeyRangePrototype::s_info = { "IDBKeyRangePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBKeyRangePrototype) };

void JSIDBKeyRangePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSIDBKeyRange::info(), JSIDBKeyRangePrototypeTableValues, *this);
}

const ClassInfo JSIDBKeyRange::s_info = { "IDBKeyRange", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIDBKeyRange) };

JSIDBKeyRange::JSIDBKeyRange(Structure* structure, JSDOMGlobalObject& globalObject, Ref<IDBKeyRange>&& impl)
    : JSDOMWrapper<IDBKeyRange>(structure, globalObject, WTFMove(impl))
{
}

void JSIDBKeyRange::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, IDBKeyRange>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSIDBKeyRange::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSIDBKeyRangePrototype::create(vm, &globalObject, JSIDBKeyRangePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSIDBKeyRange::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSIDBKeyRange>(vm, globalObject);
}

JSValue JSIDBKeyRange::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIDBKeyRangeConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSIDBKeyRange::destroy(JSC::JSCell* cell)
{
    JSIDBKeyRange* thisObject = static_cast<JSIDBKeyRange*>(cell);
    thisObject->JSIDBKeyRange::~JSIDBKeyRange();
}

template<> inline JSIDBKeyRange* IDLAttribute<JSIDBKeyRange>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSIDBKeyRange*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSIDBKeyRange* IDLOperation<JSIDBKeyRange>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSIDBKeyRange*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsIDBKeyRangeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSIDBKeyRangePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSIDBKeyRange::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSIDBKeyRangeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSIDBKeyRangePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsIDBKeyRangeLowerGetter(JSGlobalObject& lexicalGlobalObject, JSIDBKeyRange& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLIDBKey>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.lower());
    return result;
}

EncodedJSValue jsIDBKeyRangeLower(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIDBKeyRange>::get<jsIDBKeyRangeLowerGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "lower");
}

static inline JSValue jsIDBKeyRangeUpperGetter(JSGlobalObject& lexicalGlobalObject, JSIDBKeyRange& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLIDBKey>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.upper());
    return result;
}

EncodedJSValue jsIDBKeyRangeUpper(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIDBKeyRange>::get<jsIDBKeyRangeUpperGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "upper");
}

static inline JSValue jsIDBKeyRangeLowerOpenGetter(JSGlobalObject& lexicalGlobalObject, JSIDBKeyRange& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.lowerOpen());
    return result;
}

EncodedJSValue jsIDBKeyRangeLowerOpen(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIDBKeyRange>::get<jsIDBKeyRangeLowerOpenGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "lowerOpen");
}

static inline JSValue jsIDBKeyRangeUpperOpenGetter(JSGlobalObject& lexicalGlobalObject, JSIDBKeyRange& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.upperOpen());
    return result;
}

EncodedJSValue jsIDBKeyRangeUpperOpen(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIDBKeyRange>::get<jsIDBKeyRangeUpperOpenGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "upperOpen");
}

static inline JSC::EncodedJSValue jsIDBKeyRangeConstructorFunctionOnlyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto value = convert<IDLAny>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<IDBKeyRange>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, IDBKeyRange::only(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(value))));
}

EncodedJSValue JSC_HOST_CALL jsIDBKeyRangeConstructorFunctionOnly(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSIDBKeyRange>::callStatic<jsIDBKeyRangeConstructorFunctionOnlyBody>(*lexicalGlobalObject, *callFrame, "only");
}

static inline JSC::EncodedJSValue jsIDBKeyRangeConstructorFunctionLowerBoundBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto lower = convert<IDLAny>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto open = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<IDBKeyRange>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, IDBKeyRange::lowerBound(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(lower), WTFMove(open))));
}

EncodedJSValue JSC_HOST_CALL jsIDBKeyRangeConstructorFunctionLowerBound(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSIDBKeyRange>::callStatic<jsIDBKeyRangeConstructorFunctionLowerBoundBody>(*lexicalGlobalObject, *callFrame, "lowerBound");
}

static inline JSC::EncodedJSValue jsIDBKeyRangeConstructorFunctionUpperBoundBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto upper = convert<IDLAny>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto open = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<IDBKeyRange>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, IDBKeyRange::upperBound(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(upper), WTFMove(open))));
}

EncodedJSValue JSC_HOST_CALL jsIDBKeyRangeConstructorFunctionUpperBound(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSIDBKeyRange>::callStatic<jsIDBKeyRangeConstructorFunctionUpperBoundBody>(*lexicalGlobalObject, *callFrame, "upperBound");
}

static inline JSC::EncodedJSValue jsIDBKeyRangeConstructorFunctionBoundBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto lower = convert<IDLAny>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto upper = convert<IDLAny>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto lowerOpen = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->argument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto upperOpen = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->argument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<IDBKeyRange>>(*lexicalGlobalObject, *jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), throwScope, IDBKeyRange::bound(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(lower), WTFMove(upper), WTFMove(lowerOpen), WTFMove(upperOpen))));
}

EncodedJSValue JSC_HOST_CALL jsIDBKeyRangeConstructorFunctionBound(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSIDBKeyRange>::callStatic<jsIDBKeyRangeConstructorFunctionBoundBody>(*lexicalGlobalObject, *callFrame, "bound");
}

static inline JSC::EncodedJSValue jsIDBKeyRangePrototypeFunctionIncludesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIDBKeyRange>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto key = convert<IDLAny>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.includes(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(key))));
}

EncodedJSValue JSC_HOST_CALL jsIDBKeyRangePrototypeFunctionIncludes(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSIDBKeyRange>::call<jsIDBKeyRangePrototypeFunctionIncludesBody>(*lexicalGlobalObject, *callFrame, "includes");
}

void JSIDBKeyRange::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSIDBKeyRange*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSIDBKeyRangeOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSIDBKeyRangeOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsIDBKeyRange = static_cast<JSIDBKeyRange*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsIDBKeyRange->wrapped(), jsIDBKeyRange);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<IDBKeyRange>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to IDBKeyRange.
    static_assert(!std::is_polymorphic<IDBKeyRange>::value, "IDBKeyRange is polymorphic but the IDL claims it is not");
    return createWrapper<IDBKeyRange>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, IDBKeyRange& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

IDBKeyRange* JSIDBKeyRange::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSIDBKeyRange*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(INDEXED_DATABASE)
