/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(INDEXED_DATABASE)

#include "JSIDBTransactionMode.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(IDBTransactionMode enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("readonly"),
        MAKE_STATIC_STRING_IMPL("readwrite"),
        MAKE_STATIC_STRING_IMPL("versionchange"),
    };
    static_assert(static_cast<size_t>(IDBTransactionMode::Readonly) == 0, "IDBTransactionMode::Readonly is not 0 as expected");
    static_assert(static_cast<size_t>(IDBTransactionMode::Readwrite) == 1, "IDBTransactionMode::Readwrite is not 1 as expected");
    static_assert(static_cast<size_t>(IDBTransactionMode::Versionchange) == 2, "IDBTransactionMode::Versionchange is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, IDBTransactionMode enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<IDBTransactionMode> parseEnumeration<IDBTransactionMode>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "readonly")
        return IDBTransactionMode::Readonly;
    if (stringValue == "readwrite")
        return IDBTransactionMode::Readwrite;
    if (stringValue == "versionchange")
        return IDBTransactionMode::Versionchange;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<IDBTransactionMode>()
{
    return "\"readonly\", \"readwrite\", \"versionchange\"";
}

} // namespace WebCore

#endif // ENABLE(INDEXED_DATABASE)
