/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#if ENABLE(INDEXED_DATABASE)

#include "IDBVersionChangeEvent.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMWrapper.h"
#include "JSEvent.h"

namespace WebCore {

class JSIDBVersionChangeEvent : public JSEvent {
public:
    using Base = JSEvent;
    using DOMWrapped = IDBVersionChangeEvent;
    static JSIDBVersionChangeEvent* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<IDBVersionChangeEvent>&& impl)
    {
        JSIDBVersionChangeEvent* ptr = new (NotNull, JSC::allocateCell<JSIDBVersionChangeEvent>(globalObject->vm().heap)) JSIDBVersionChangeEvent(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::VM&, JSDOMGlobalObject&);
    static JSC::JSObject* prototype(JSC::VM&, JSDOMGlobalObject&);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::JSType(JSEventType), StructureFlags), info());
    }

    static JSC::JSValue getConstructor(JSC::VM&, const JSC::JSGlobalObject*);
    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);
    IDBVersionChangeEvent& wrapped() const
    {
        return static_cast<IDBVersionChangeEvent&>(Base::wrapped());
    }
protected:
    JSIDBVersionChangeEvent(JSC::Structure*, JSDOMGlobalObject&, Ref<IDBVersionChangeEvent>&&);

    void finishCreation(JSC::VM&);
};

JSC::JSValue toJS(JSC::JSGlobalObject*, JSDOMGlobalObject*, IDBVersionChangeEvent&);
inline JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, IDBVersionChangeEvent* impl) { return impl ? toJS(lexicalGlobalObject, globalObject, *impl) : JSC::jsNull(); }
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject*, Ref<IDBVersionChangeEvent>&&);
inline JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RefPtr<IDBVersionChangeEvent>&& impl) { return impl ? toJSNewlyCreated(lexicalGlobalObject, globalObject, impl.releaseNonNull()) : JSC::jsNull(); }

template<> struct JSDOMWrapperConverterTraits<IDBVersionChangeEvent> {
    using WrapperClass = JSIDBVersionChangeEvent;
    using ToWrappedReturnType = IDBVersionChangeEvent*;
};
template<> IDBVersionChangeEvent::Init convertDictionary<IDBVersionChangeEvent::Init>(JSC::JSGlobalObject&, JSC::JSValue);


} // namespace WebCore

#endif // ENABLE(INDEXED_DATABASE)
