/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSIdleDeadline.h"

#include "ActiveDOMObject.h"
#include "Document.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsIdleDeadlinePrototypeFunctionTimeRemaining(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsIdleDeadlineConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSIdleDeadlineConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsIdleDeadlineDidTimeout(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSIdleDeadlinePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSIdleDeadlinePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSIdleDeadlinePrototype* ptr = new (NotNull, JSC::allocateCell<JSIdleDeadlinePrototype>(vm.heap)) JSIdleDeadlinePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSIdleDeadlinePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSIdleDeadlinePrototype, JSIdleDeadlinePrototype::Base);

using JSIdleDeadlineConstructor = JSDOMConstructorNotConstructable<JSIdleDeadline>;

template<> JSValue JSIdleDeadlineConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSIdleDeadlineConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSIdleDeadline::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("IdleDeadline"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSIdleDeadlineConstructor::s_info = { "IdleDeadline", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIdleDeadlineConstructor) };

/* Hash table for prototype */

static const HashTableValue JSIdleDeadlinePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIdleDeadlineConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSIdleDeadlineConstructor) } },
    { "didTimeout", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIdleDeadlineDidTimeout), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "timeRemaining", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsIdleDeadlinePrototypeFunctionTimeRemaining), (intptr_t) (0) } },
};

const ClassInfo JSIdleDeadlinePrototype::s_info = { "IdleDeadlinePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIdleDeadlinePrototype) };

void JSIdleDeadlinePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSIdleDeadline::info(), JSIdleDeadlinePrototypeTableValues, *this);
}

const ClassInfo JSIdleDeadline::s_info = { "IdleDeadline", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIdleDeadline) };

JSIdleDeadline::JSIdleDeadline(Structure* structure, JSDOMGlobalObject& globalObject, Ref<IdleDeadline>&& impl)
    : JSDOMWrapper<IdleDeadline>(structure, globalObject, WTFMove(impl))
{
}

void JSIdleDeadline::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, IdleDeadline>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSIdleDeadline::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSIdleDeadlinePrototype::create(vm, &globalObject, JSIdleDeadlinePrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSIdleDeadline::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSIdleDeadline>(vm, globalObject);
}

JSValue JSIdleDeadline::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIdleDeadlineConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSIdleDeadline::destroy(JSC::JSCell* cell)
{
    JSIdleDeadline* thisObject = static_cast<JSIdleDeadline*>(cell);
    thisObject->JSIdleDeadline::~JSIdleDeadline();
}

template<> inline JSIdleDeadline* IDLAttribute<JSIdleDeadline>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSIdleDeadline*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSIdleDeadline* IDLOperation<JSIdleDeadline>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSIdleDeadline*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsIdleDeadlineConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSIdleDeadlinePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSIdleDeadline::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSIdleDeadlineConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSIdleDeadlinePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsIdleDeadlineDidTimeoutGetter(JSGlobalObject& lexicalGlobalObject, JSIdleDeadline& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto* context = jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return jsUndefined();
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.didTimeout(document));
    return result;
}

EncodedJSValue jsIdleDeadlineDidTimeout(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIdleDeadline>::get<jsIdleDeadlineDidTimeoutGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "didTimeout");
}

static inline JSC::EncodedJSValue jsIdleDeadlinePrototypeFunctionTimeRemainingBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIdleDeadline>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    return JSValue::encode(toJS<IDLDouble>(impl.timeRemaining(document)));
}

EncodedJSValue JSC_HOST_CALL jsIdleDeadlinePrototypeFunctionTimeRemaining(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSIdleDeadline>::call<jsIdleDeadlinePrototypeFunctionTimeRemainingBody>(*lexicalGlobalObject, *callFrame, "timeRemaining");
}

void JSIdleDeadline::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSIdleDeadline*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSIdleDeadlineOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSIdleDeadlineOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsIdleDeadline = static_cast<JSIdleDeadline*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsIdleDeadline->wrapped(), jsIdleDeadline);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<IdleDeadline>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to IdleDeadline.
    static_assert(!std::is_polymorphic<IdleDeadline>::value, "IdleDeadline is polymorphic but the IDL claims it is not");
    return createWrapper<IdleDeadline>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, IdleDeadline& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

IdleDeadline* JSIdleDeadline::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSIdleDeadline*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
