/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSInspectorAuditAccessibilityObject.h"

#include "ActiveDOMObject.h"
#include "Document.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSNode.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

template<> InspectorAuditAccessibilityObject::ComputedProperties convertDictionary<InspectorAuditAccessibilityObject::ComputedProperties>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    InspectorAuditAccessibilityObject::ComputedProperties result;
    JSValue busyValue;
    if (isNullOrUndefined)
        busyValue = jsUndefined();
    else {
        busyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "busy"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!busyValue.isUndefined()) {
        result.busy = convert<IDLNullable<IDLBoolean>>(lexicalGlobalObject, busyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue checkedValue;
    if (isNullOrUndefined)
        checkedValue = jsUndefined();
    else {
        checkedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "checked"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!checkedValue.isUndefined()) {
        result.checked = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, checkedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue currentStateValue;
    if (isNullOrUndefined)
        currentStateValue = jsUndefined();
    else {
        currentStateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "currentState"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!currentStateValue.isUndefined()) {
        result.currentState = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, currentStateValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue disabledValue;
    if (isNullOrUndefined)
        disabledValue = jsUndefined();
    else {
        disabledValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "disabled"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!disabledValue.isUndefined()) {
        result.disabled = convert<IDLNullable<IDLBoolean>>(lexicalGlobalObject, disabledValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue expandedValue;
    if (isNullOrUndefined)
        expandedValue = jsUndefined();
    else {
        expandedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "expanded"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!expandedValue.isUndefined()) {
        result.expanded = convert<IDLNullable<IDLBoolean>>(lexicalGlobalObject, expandedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue focusedValue;
    if (isNullOrUndefined)
        focusedValue = jsUndefined();
    else {
        focusedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "focused"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!focusedValue.isUndefined()) {
        result.focused = convert<IDLNullable<IDLBoolean>>(lexicalGlobalObject, focusedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue headingLevelValue;
    if (isNullOrUndefined)
        headingLevelValue = jsUndefined();
    else {
        headingLevelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "headingLevel"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!headingLevelValue.isUndefined()) {
        result.headingLevel = convert<IDLNullable<IDLLong>>(lexicalGlobalObject, headingLevelValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue hiddenValue;
    if (isNullOrUndefined)
        hiddenValue = jsUndefined();
    else {
        hiddenValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "hidden"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!hiddenValue.isUndefined()) {
        result.hidden = convert<IDLNullable<IDLBoolean>>(lexicalGlobalObject, hiddenValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue hierarchicalLevelValue;
    if (isNullOrUndefined)
        hierarchicalLevelValue = jsUndefined();
    else {
        hierarchicalLevelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "hierarchicalLevel"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!hierarchicalLevelValue.isUndefined()) {
        result.hierarchicalLevel = convert<IDLNullable<IDLLong>>(lexicalGlobalObject, hierarchicalLevelValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue ignoredValue;
    if (isNullOrUndefined)
        ignoredValue = jsUndefined();
    else {
        ignoredValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "ignored"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!ignoredValue.isUndefined()) {
        result.ignored = convert<IDLNullable<IDLBoolean>>(lexicalGlobalObject, ignoredValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue ignoredByDefaultValue;
    if (isNullOrUndefined)
        ignoredByDefaultValue = jsUndefined();
    else {
        ignoredByDefaultValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "ignoredByDefault"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!ignoredByDefaultValue.isUndefined()) {
        result.ignoredByDefault = convert<IDLNullable<IDLBoolean>>(lexicalGlobalObject, ignoredByDefaultValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue invalidStatusValue;
    if (isNullOrUndefined)
        invalidStatusValue = jsUndefined();
    else {
        invalidStatusValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "invalidStatus"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!invalidStatusValue.isUndefined()) {
        result.invalidStatus = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, invalidStatusValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue isPopUpButtonValue;
    if (isNullOrUndefined)
        isPopUpButtonValue = jsUndefined();
    else {
        isPopUpButtonValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "isPopUpButton"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!isPopUpButtonValue.isUndefined()) {
        result.isPopUpButton = convert<IDLNullable<IDLBoolean>>(lexicalGlobalObject, isPopUpButtonValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue labelValue;
    if (isNullOrUndefined)
        labelValue = jsUndefined();
    else {
        labelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "label"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!labelValue.isUndefined()) {
        result.label = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, labelValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue liveRegionAtomicValue;
    if (isNullOrUndefined)
        liveRegionAtomicValue = jsUndefined();
    else {
        liveRegionAtomicValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "liveRegionAtomic"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!liveRegionAtomicValue.isUndefined()) {
        result.liveRegionAtomic = convert<IDLNullable<IDLBoolean>>(lexicalGlobalObject, liveRegionAtomicValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue liveRegionRelevantValue;
    if (isNullOrUndefined)
        liveRegionRelevantValue = jsUndefined();
    else {
        liveRegionRelevantValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "liveRegionRelevant"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!liveRegionRelevantValue.isUndefined()) {
        result.liveRegionRelevant = convert<IDLNullable<IDLSequence<IDLDOMString>>>(lexicalGlobalObject, liveRegionRelevantValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue liveRegionStatusValue;
    if (isNullOrUndefined)
        liveRegionStatusValue = jsUndefined();
    else {
        liveRegionStatusValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "liveRegionStatus"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!liveRegionStatusValue.isUndefined()) {
        result.liveRegionStatus = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, liveRegionStatusValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue pressedValue;
    if (isNullOrUndefined)
        pressedValue = jsUndefined();
    else {
        pressedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "pressed"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!pressedValue.isUndefined()) {
        result.pressed = convert<IDLNullable<IDLBoolean>>(lexicalGlobalObject, pressedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue readonlyValue;
    if (isNullOrUndefined)
        readonlyValue = jsUndefined();
    else {
        readonlyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "readonly"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!readonlyValue.isUndefined()) {
        result.readonly = convert<IDLNullable<IDLBoolean>>(lexicalGlobalObject, readonlyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue requiredValue;
    if (isNullOrUndefined)
        requiredValue = jsUndefined();
    else {
        requiredValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "required"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!requiredValue.isUndefined()) {
        result.required = convert<IDLNullable<IDLBoolean>>(lexicalGlobalObject, requiredValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue roleValue;
    if (isNullOrUndefined)
        roleValue = jsUndefined();
    else {
        roleValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "role"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!roleValue.isUndefined()) {
        result.role = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, roleValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue selectedValue;
    if (isNullOrUndefined)
        selectedValue = jsUndefined();
    else {
        selectedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "selected"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!selectedValue.isUndefined()) {
        result.selected = convert<IDLNullable<IDLBoolean>>(lexicalGlobalObject, selectedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const InspectorAuditAccessibilityObject::ComputedProperties& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLNullable<IDLBoolean>::isNullValue(dictionary.busy)) {
        auto busyValue = toJS<IDLNullable<IDLBoolean>>(IDLNullable<IDLBoolean>::extractValueFromNullable(dictionary.busy));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "busy"), busyValue);
    }
    if (!IDLNullable<IDLDOMString>::isNullValue(dictionary.checked)) {
        auto checkedValue = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, IDLNullable<IDLDOMString>::extractValueFromNullable(dictionary.checked));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "checked"), checkedValue);
    }
    if (!IDLNullable<IDLDOMString>::isNullValue(dictionary.currentState)) {
        auto currentStateValue = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, IDLNullable<IDLDOMString>::extractValueFromNullable(dictionary.currentState));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "currentState"), currentStateValue);
    }
    if (!IDLNullable<IDLBoolean>::isNullValue(dictionary.disabled)) {
        auto disabledValue = toJS<IDLNullable<IDLBoolean>>(IDLNullable<IDLBoolean>::extractValueFromNullable(dictionary.disabled));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "disabled"), disabledValue);
    }
    if (!IDLNullable<IDLBoolean>::isNullValue(dictionary.expanded)) {
        auto expandedValue = toJS<IDLNullable<IDLBoolean>>(IDLNullable<IDLBoolean>::extractValueFromNullable(dictionary.expanded));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "expanded"), expandedValue);
    }
    if (!IDLNullable<IDLBoolean>::isNullValue(dictionary.focused)) {
        auto focusedValue = toJS<IDLNullable<IDLBoolean>>(IDLNullable<IDLBoolean>::extractValueFromNullable(dictionary.focused));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "focused"), focusedValue);
    }
    if (!IDLNullable<IDLLong>::isNullValue(dictionary.headingLevel)) {
        auto headingLevelValue = toJS<IDLNullable<IDLLong>>(IDLNullable<IDLLong>::extractValueFromNullable(dictionary.headingLevel));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "headingLevel"), headingLevelValue);
    }
    if (!IDLNullable<IDLBoolean>::isNullValue(dictionary.hidden)) {
        auto hiddenValue = toJS<IDLNullable<IDLBoolean>>(IDLNullable<IDLBoolean>::extractValueFromNullable(dictionary.hidden));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "hidden"), hiddenValue);
    }
    if (!IDLNullable<IDLLong>::isNullValue(dictionary.hierarchicalLevel)) {
        auto hierarchicalLevelValue = toJS<IDLNullable<IDLLong>>(IDLNullable<IDLLong>::extractValueFromNullable(dictionary.hierarchicalLevel));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "hierarchicalLevel"), hierarchicalLevelValue);
    }
    if (!IDLNullable<IDLBoolean>::isNullValue(dictionary.ignored)) {
        auto ignoredValue = toJS<IDLNullable<IDLBoolean>>(IDLNullable<IDLBoolean>::extractValueFromNullable(dictionary.ignored));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "ignored"), ignoredValue);
    }
    if (!IDLNullable<IDLBoolean>::isNullValue(dictionary.ignoredByDefault)) {
        auto ignoredByDefaultValue = toJS<IDLNullable<IDLBoolean>>(IDLNullable<IDLBoolean>::extractValueFromNullable(dictionary.ignoredByDefault));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "ignoredByDefault"), ignoredByDefaultValue);
    }
    if (!IDLNullable<IDLDOMString>::isNullValue(dictionary.invalidStatus)) {
        auto invalidStatusValue = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, IDLNullable<IDLDOMString>::extractValueFromNullable(dictionary.invalidStatus));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "invalidStatus"), invalidStatusValue);
    }
    if (!IDLNullable<IDLBoolean>::isNullValue(dictionary.isPopUpButton)) {
        auto isPopUpButtonValue = toJS<IDLNullable<IDLBoolean>>(IDLNullable<IDLBoolean>::extractValueFromNullable(dictionary.isPopUpButton));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "isPopUpButton"), isPopUpButtonValue);
    }
    if (!IDLNullable<IDLDOMString>::isNullValue(dictionary.label)) {
        auto labelValue = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, IDLNullable<IDLDOMString>::extractValueFromNullable(dictionary.label));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "label"), labelValue);
    }
    if (!IDLNullable<IDLBoolean>::isNullValue(dictionary.liveRegionAtomic)) {
        auto liveRegionAtomicValue = toJS<IDLNullable<IDLBoolean>>(IDLNullable<IDLBoolean>::extractValueFromNullable(dictionary.liveRegionAtomic));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "liveRegionAtomic"), liveRegionAtomicValue);
    }
    if (!IDLNullable<IDLSequence<IDLDOMString>>::isNullValue(dictionary.liveRegionRelevant)) {
        auto liveRegionRelevantValue = toJS<IDLNullable<IDLSequence<IDLDOMString>>>(lexicalGlobalObject, globalObject, IDLNullable<IDLSequence<IDLDOMString>>::extractValueFromNullable(dictionary.liveRegionRelevant));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "liveRegionRelevant"), liveRegionRelevantValue);
    }
    if (!IDLNullable<IDLDOMString>::isNullValue(dictionary.liveRegionStatus)) {
        auto liveRegionStatusValue = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, IDLNullable<IDLDOMString>::extractValueFromNullable(dictionary.liveRegionStatus));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "liveRegionStatus"), liveRegionStatusValue);
    }
    if (!IDLNullable<IDLBoolean>::isNullValue(dictionary.pressed)) {
        auto pressedValue = toJS<IDLNullable<IDLBoolean>>(IDLNullable<IDLBoolean>::extractValueFromNullable(dictionary.pressed));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "pressed"), pressedValue);
    }
    if (!IDLNullable<IDLBoolean>::isNullValue(dictionary.readonly)) {
        auto readonlyValue = toJS<IDLNullable<IDLBoolean>>(IDLNullable<IDLBoolean>::extractValueFromNullable(dictionary.readonly));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "readonly"), readonlyValue);
    }
    if (!IDLNullable<IDLBoolean>::isNullValue(dictionary.required)) {
        auto requiredValue = toJS<IDLNullable<IDLBoolean>>(IDLNullable<IDLBoolean>::extractValueFromNullable(dictionary.required));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "required"), requiredValue);
    }
    if (!IDLNullable<IDLDOMString>::isNullValue(dictionary.role)) {
        auto roleValue = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, IDLNullable<IDLDOMString>::extractValueFromNullable(dictionary.role));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "role"), roleValue);
    }
    if (!IDLNullable<IDLBoolean>::isNullValue(dictionary.selected)) {
        auto selectedValue = toJS<IDLNullable<IDLBoolean>>(IDLNullable<IDLBoolean>::extractValueFromNullable(dictionary.selected));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "selected"), selectedValue);
    }
    return result;
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsInspectorAuditAccessibilityObjectPrototypeFunctionGetElementsByComputedRole(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorAuditAccessibilityObjectPrototypeFunctionGetActiveDescendant(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorAuditAccessibilityObjectPrototypeFunctionGetChildNodes(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorAuditAccessibilityObjectPrototypeFunctionGetComputedProperties(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorAuditAccessibilityObjectPrototypeFunctionGetControlledNodes(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorAuditAccessibilityObjectPrototypeFunctionGetFlowedNodes(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorAuditAccessibilityObjectPrototypeFunctionGetMouseEventNode(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorAuditAccessibilityObjectPrototypeFunctionGetOwnedNodes(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorAuditAccessibilityObjectPrototypeFunctionGetParentNode(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorAuditAccessibilityObjectPrototypeFunctionGetSelectedChildNodes(JSC::JSGlobalObject*, JSC::CallFrame*);

class JSInspectorAuditAccessibilityObjectPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSInspectorAuditAccessibilityObjectPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSInspectorAuditAccessibilityObjectPrototype* ptr = new (NotNull, JSC::allocateCell<JSInspectorAuditAccessibilityObjectPrototype>(vm.heap)) JSInspectorAuditAccessibilityObjectPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSInspectorAuditAccessibilityObjectPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSInspectorAuditAccessibilityObjectPrototype, JSInspectorAuditAccessibilityObjectPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSInspectorAuditAccessibilityObjectPrototypeTableValues[] =
{
    { "getElementsByComputedRole", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorAuditAccessibilityObjectPrototypeFunctionGetElementsByComputedRole), (intptr_t) (1) } },
    { "getActiveDescendant", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorAuditAccessibilityObjectPrototypeFunctionGetActiveDescendant), (intptr_t) (1) } },
    { "getChildNodes", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorAuditAccessibilityObjectPrototypeFunctionGetChildNodes), (intptr_t) (1) } },
    { "getComputedProperties", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorAuditAccessibilityObjectPrototypeFunctionGetComputedProperties), (intptr_t) (1) } },
    { "getControlledNodes", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorAuditAccessibilityObjectPrototypeFunctionGetControlledNodes), (intptr_t) (1) } },
    { "getFlowedNodes", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorAuditAccessibilityObjectPrototypeFunctionGetFlowedNodes), (intptr_t) (1) } },
    { "getMouseEventNode", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorAuditAccessibilityObjectPrototypeFunctionGetMouseEventNode), (intptr_t) (1) } },
    { "getOwnedNodes", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorAuditAccessibilityObjectPrototypeFunctionGetOwnedNodes), (intptr_t) (1) } },
    { "getParentNode", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorAuditAccessibilityObjectPrototypeFunctionGetParentNode), (intptr_t) (1) } },
    { "getSelectedChildNodes", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorAuditAccessibilityObjectPrototypeFunctionGetSelectedChildNodes), (intptr_t) (1) } },
};

const ClassInfo JSInspectorAuditAccessibilityObjectPrototype::s_info = { "InspectorAuditAccessibilityObjectPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSInspectorAuditAccessibilityObjectPrototype) };

void JSInspectorAuditAccessibilityObjectPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSInspectorAuditAccessibilityObject::info(), JSInspectorAuditAccessibilityObjectPrototypeTableValues, *this);
}

const ClassInfo JSInspectorAuditAccessibilityObject::s_info = { "InspectorAuditAccessibilityObject", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSInspectorAuditAccessibilityObject) };

JSInspectorAuditAccessibilityObject::JSInspectorAuditAccessibilityObject(Structure* structure, JSDOMGlobalObject& globalObject, Ref<InspectorAuditAccessibilityObject>&& impl)
    : JSDOMWrapper<InspectorAuditAccessibilityObject>(structure, globalObject, WTFMove(impl))
{
}

void JSInspectorAuditAccessibilityObject::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, InspectorAuditAccessibilityObject>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSInspectorAuditAccessibilityObject::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSInspectorAuditAccessibilityObjectPrototype::create(vm, &globalObject, JSInspectorAuditAccessibilityObjectPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSInspectorAuditAccessibilityObject::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSInspectorAuditAccessibilityObject>(vm, globalObject);
}

void JSInspectorAuditAccessibilityObject::destroy(JSC::JSCell* cell)
{
    JSInspectorAuditAccessibilityObject* thisObject = static_cast<JSInspectorAuditAccessibilityObject*>(cell);
    thisObject->JSInspectorAuditAccessibilityObject::~JSInspectorAuditAccessibilityObject();
}

template<> inline JSInspectorAuditAccessibilityObject* IDLOperation<JSInspectorAuditAccessibilityObject>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSInspectorAuditAccessibilityObject*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

static inline JSC::EncodedJSValue jsInspectorAuditAccessibilityObjectPrototypeFunctionGetElementsByComputedRoleBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorAuditAccessibilityObject>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    auto role = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto container = convert<IDLNullable<IDLInterface<Node>>>(*lexicalGlobalObject, callFrame->argument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "container", "InspectorAuditAccessibilityObject", "getElementsByComputedRole", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLSequence<IDLInterface<Node>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getElementsByComputedRole(document, WTFMove(role), WTFMove(container))));
}

EncodedJSValue JSC_HOST_CALL jsInspectorAuditAccessibilityObjectPrototypeFunctionGetElementsByComputedRole(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorAuditAccessibilityObject>::call<jsInspectorAuditAccessibilityObjectPrototypeFunctionGetElementsByComputedRoleBody>(*lexicalGlobalObject, *callFrame, "getElementsByComputedRole");
}

static inline JSC::EncodedJSValue jsInspectorAuditAccessibilityObjectPrototypeFunctionGetActiveDescendantBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorAuditAccessibilityObject>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto node = convert<IDLInterface<Node>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "InspectorAuditAccessibilityObject", "getActiveDescendant", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLInterface<Node>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getActiveDescendant(*node)));
}

EncodedJSValue JSC_HOST_CALL jsInspectorAuditAccessibilityObjectPrototypeFunctionGetActiveDescendant(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorAuditAccessibilityObject>::call<jsInspectorAuditAccessibilityObjectPrototypeFunctionGetActiveDescendantBody>(*lexicalGlobalObject, *callFrame, "getActiveDescendant");
}

static inline JSC::EncodedJSValue jsInspectorAuditAccessibilityObjectPrototypeFunctionGetChildNodesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorAuditAccessibilityObject>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto node = convert<IDLInterface<Node>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "InspectorAuditAccessibilityObject", "getChildNodes", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLSequence<IDLInterface<Node>>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getChildNodes(*node)));
}

EncodedJSValue JSC_HOST_CALL jsInspectorAuditAccessibilityObjectPrototypeFunctionGetChildNodes(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorAuditAccessibilityObject>::call<jsInspectorAuditAccessibilityObjectPrototypeFunctionGetChildNodesBody>(*lexicalGlobalObject, *callFrame, "getChildNodes");
}

static inline JSC::EncodedJSValue jsInspectorAuditAccessibilityObjectPrototypeFunctionGetComputedPropertiesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorAuditAccessibilityObject>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto node = convert<IDLInterface<Node>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "InspectorAuditAccessibilityObject", "getComputedProperties", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLDictionary<InspectorAuditAccessibilityObject::ComputedProperties>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getComputedProperties(*node)));
}

EncodedJSValue JSC_HOST_CALL jsInspectorAuditAccessibilityObjectPrototypeFunctionGetComputedProperties(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorAuditAccessibilityObject>::call<jsInspectorAuditAccessibilityObjectPrototypeFunctionGetComputedPropertiesBody>(*lexicalGlobalObject, *callFrame, "getComputedProperties");
}

static inline JSC::EncodedJSValue jsInspectorAuditAccessibilityObjectPrototypeFunctionGetControlledNodesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorAuditAccessibilityObject>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto node = convert<IDLInterface<Node>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "InspectorAuditAccessibilityObject", "getControlledNodes", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLSequence<IDLInterface<Node>>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getControlledNodes(*node)));
}

EncodedJSValue JSC_HOST_CALL jsInspectorAuditAccessibilityObjectPrototypeFunctionGetControlledNodes(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorAuditAccessibilityObject>::call<jsInspectorAuditAccessibilityObjectPrototypeFunctionGetControlledNodesBody>(*lexicalGlobalObject, *callFrame, "getControlledNodes");
}

static inline JSC::EncodedJSValue jsInspectorAuditAccessibilityObjectPrototypeFunctionGetFlowedNodesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorAuditAccessibilityObject>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto node = convert<IDLInterface<Node>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "InspectorAuditAccessibilityObject", "getFlowedNodes", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLSequence<IDLInterface<Node>>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getFlowedNodes(*node)));
}

EncodedJSValue JSC_HOST_CALL jsInspectorAuditAccessibilityObjectPrototypeFunctionGetFlowedNodes(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorAuditAccessibilityObject>::call<jsInspectorAuditAccessibilityObjectPrototypeFunctionGetFlowedNodesBody>(*lexicalGlobalObject, *callFrame, "getFlowedNodes");
}

static inline JSC::EncodedJSValue jsInspectorAuditAccessibilityObjectPrototypeFunctionGetMouseEventNodeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorAuditAccessibilityObject>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto node = convert<IDLInterface<Node>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "InspectorAuditAccessibilityObject", "getMouseEventNode", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLInterface<Node>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getMouseEventNode(*node)));
}

EncodedJSValue JSC_HOST_CALL jsInspectorAuditAccessibilityObjectPrototypeFunctionGetMouseEventNode(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorAuditAccessibilityObject>::call<jsInspectorAuditAccessibilityObjectPrototypeFunctionGetMouseEventNodeBody>(*lexicalGlobalObject, *callFrame, "getMouseEventNode");
}

static inline JSC::EncodedJSValue jsInspectorAuditAccessibilityObjectPrototypeFunctionGetOwnedNodesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorAuditAccessibilityObject>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto node = convert<IDLInterface<Node>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "InspectorAuditAccessibilityObject", "getOwnedNodes", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLSequence<IDLInterface<Node>>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getOwnedNodes(*node)));
}

EncodedJSValue JSC_HOST_CALL jsInspectorAuditAccessibilityObjectPrototypeFunctionGetOwnedNodes(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorAuditAccessibilityObject>::call<jsInspectorAuditAccessibilityObjectPrototypeFunctionGetOwnedNodesBody>(*lexicalGlobalObject, *callFrame, "getOwnedNodes");
}

static inline JSC::EncodedJSValue jsInspectorAuditAccessibilityObjectPrototypeFunctionGetParentNodeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorAuditAccessibilityObject>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto node = convert<IDLInterface<Node>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "InspectorAuditAccessibilityObject", "getParentNode", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLInterface<Node>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getParentNode(*node)));
}

EncodedJSValue JSC_HOST_CALL jsInspectorAuditAccessibilityObjectPrototypeFunctionGetParentNode(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorAuditAccessibilityObject>::call<jsInspectorAuditAccessibilityObjectPrototypeFunctionGetParentNodeBody>(*lexicalGlobalObject, *callFrame, "getParentNode");
}

static inline JSC::EncodedJSValue jsInspectorAuditAccessibilityObjectPrototypeFunctionGetSelectedChildNodesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorAuditAccessibilityObject>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto node = convert<IDLInterface<Node>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "InspectorAuditAccessibilityObject", "getSelectedChildNodes", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLSequence<IDLInterface<Node>>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getSelectedChildNodes(*node)));
}

EncodedJSValue JSC_HOST_CALL jsInspectorAuditAccessibilityObjectPrototypeFunctionGetSelectedChildNodes(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorAuditAccessibilityObject>::call<jsInspectorAuditAccessibilityObjectPrototypeFunctionGetSelectedChildNodesBody>(*lexicalGlobalObject, *callFrame, "getSelectedChildNodes");
}

void JSInspectorAuditAccessibilityObject::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSInspectorAuditAccessibilityObject*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSInspectorAuditAccessibilityObjectOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSInspectorAuditAccessibilityObjectOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsInspectorAuditAccessibilityObject = static_cast<JSInspectorAuditAccessibilityObject*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsInspectorAuditAccessibilityObject->wrapped(), jsInspectorAuditAccessibilityObject);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<InspectorAuditAccessibilityObject>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to InspectorAuditAccessibilityObject.
    static_assert(!std::is_polymorphic<InspectorAuditAccessibilityObject>::value, "InspectorAuditAccessibilityObject is polymorphic but the IDL claims it is not");
    return createWrapper<InspectorAuditAccessibilityObject>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, InspectorAuditAccessibilityObject& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

InspectorAuditAccessibilityObject* JSInspectorAuditAccessibilityObject::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSInspectorAuditAccessibilityObject*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
