/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSInspectorAuditDOMObject.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSNode.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsInspectorAuditDOMObjectPrototypeFunctionHasEventListeners(JSC::JSGlobalObject*, JSC::CallFrame*);

class JSInspectorAuditDOMObjectPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSInspectorAuditDOMObjectPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSInspectorAuditDOMObjectPrototype* ptr = new (NotNull, JSC::allocateCell<JSInspectorAuditDOMObjectPrototype>(vm.heap)) JSInspectorAuditDOMObjectPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSInspectorAuditDOMObjectPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSInspectorAuditDOMObjectPrototype, JSInspectorAuditDOMObjectPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSInspectorAuditDOMObjectPrototypeTableValues[] =
{
    { "hasEventListeners", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorAuditDOMObjectPrototypeFunctionHasEventListeners), (intptr_t) (1) } },
};

const ClassInfo JSInspectorAuditDOMObjectPrototype::s_info = { "InspectorAuditDOMObjectPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSInspectorAuditDOMObjectPrototype) };

void JSInspectorAuditDOMObjectPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSInspectorAuditDOMObject::info(), JSInspectorAuditDOMObjectPrototypeTableValues, *this);
}

const ClassInfo JSInspectorAuditDOMObject::s_info = { "InspectorAuditDOMObject", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSInspectorAuditDOMObject) };

JSInspectorAuditDOMObject::JSInspectorAuditDOMObject(Structure* structure, JSDOMGlobalObject& globalObject, Ref<InspectorAuditDOMObject>&& impl)
    : JSDOMWrapper<InspectorAuditDOMObject>(structure, globalObject, WTFMove(impl))
{
}

void JSInspectorAuditDOMObject::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, InspectorAuditDOMObject>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSInspectorAuditDOMObject::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSInspectorAuditDOMObjectPrototype::create(vm, &globalObject, JSInspectorAuditDOMObjectPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSInspectorAuditDOMObject::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSInspectorAuditDOMObject>(vm, globalObject);
}

void JSInspectorAuditDOMObject::destroy(JSC::JSCell* cell)
{
    JSInspectorAuditDOMObject* thisObject = static_cast<JSInspectorAuditDOMObject*>(cell);
    thisObject->JSInspectorAuditDOMObject::~JSInspectorAuditDOMObject();
}

template<> inline JSInspectorAuditDOMObject* IDLOperation<JSInspectorAuditDOMObject>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSInspectorAuditDOMObject*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

static inline JSC::EncodedJSValue jsInspectorAuditDOMObjectPrototypeFunctionHasEventListenersBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorAuditDOMObject>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto node = convert<IDLInterface<Node>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "InspectorAuditDOMObject", "hasEventListeners", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto type = callFrame->argument(1).isUndefined() ? String() : convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.hasEventListeners(*node, WTFMove(type))));
}

EncodedJSValue JSC_HOST_CALL jsInspectorAuditDOMObjectPrototypeFunctionHasEventListeners(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorAuditDOMObject>::call<jsInspectorAuditDOMObjectPrototypeFunctionHasEventListenersBody>(*lexicalGlobalObject, *callFrame, "hasEventListeners");
}

void JSInspectorAuditDOMObject::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSInspectorAuditDOMObject*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSInspectorAuditDOMObjectOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSInspectorAuditDOMObjectOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsInspectorAuditDOMObject = static_cast<JSInspectorAuditDOMObject*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsInspectorAuditDOMObject->wrapped(), jsInspectorAuditDOMObject);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<InspectorAuditDOMObject>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to InspectorAuditDOMObject.
    static_assert(!std::is_polymorphic<InspectorAuditDOMObject>::value, "InspectorAuditDOMObject is polymorphic but the IDL claims it is not");
    return createWrapper<InspectorAuditDOMObject>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, InspectorAuditDOMObject& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

InspectorAuditDOMObject* JSInspectorAuditDOMObject::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSInspectorAuditDOMObject*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
