/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSInspectorAuditResourcesObject.h"

#include "ActiveDOMObject.h"
#include "Document.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

template<> InspectorAuditResourcesObject::Resource convertDictionary<InspectorAuditResourcesObject::Resource>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    InspectorAuditResourcesObject::Resource result;
    JSValue idValue;
    if (isNullOrUndefined)
        idValue = jsUndefined();
    else {
        idValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "id"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!idValue.isUndefined()) {
        result.id = convert<IDLDOMString>(lexicalGlobalObject, idValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue mimeTypeValue;
    if (isNullOrUndefined)
        mimeTypeValue = jsUndefined();
    else {
        mimeTypeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "mimeType"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!mimeTypeValue.isUndefined()) {
        result.mimeType = convert<IDLDOMString>(lexicalGlobalObject, mimeTypeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue urlValue;
    if (isNullOrUndefined)
        urlValue = jsUndefined();
    else {
        urlValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "url"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!urlValue.isUndefined()) {
        result.url = convert<IDLDOMString>(lexicalGlobalObject, urlValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const InspectorAuditResourcesObject::Resource& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLDOMString::isNullValue(dictionary.id)) {
        auto idValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.id));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "id"), idValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.mimeType)) {
        auto mimeTypeValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.mimeType));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "mimeType"), mimeTypeValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.url)) {
        auto urlValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.url));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "url"), urlValue);
    }
    return result;
}

template<> InspectorAuditResourcesObject::ResourceContent convertDictionary<InspectorAuditResourcesObject::ResourceContent>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    InspectorAuditResourcesObject::ResourceContent result;
    JSValue base64EncodedValue;
    if (isNullOrUndefined)
        base64EncodedValue = jsUndefined();
    else {
        base64EncodedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "base64Encoded"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!base64EncodedValue.isUndefined()) {
        result.base64Encoded = convert<IDLBoolean>(lexicalGlobalObject, base64EncodedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue dataValue;
    if (isNullOrUndefined)
        dataValue = jsUndefined();
    else {
        dataValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "data"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!dataValue.isUndefined()) {
        result.data = convert<IDLDOMString>(lexicalGlobalObject, dataValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const InspectorAuditResourcesObject::ResourceContent& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLBoolean::isNullValue(dictionary.base64Encoded)) {
        auto base64EncodedValue = toJS<IDLBoolean>(IDLBoolean::extractValueFromNullable(dictionary.base64Encoded));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "base64Encoded"), base64EncodedValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.data)) {
        auto dataValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.data));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "data"), dataValue);
    }
    return result;
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsInspectorAuditResourcesObjectPrototypeFunctionGetResources(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorAuditResourcesObjectPrototypeFunctionGetResourceContent(JSC::JSGlobalObject*, JSC::CallFrame*);

class JSInspectorAuditResourcesObjectPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSInspectorAuditResourcesObjectPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSInspectorAuditResourcesObjectPrototype* ptr = new (NotNull, JSC::allocateCell<JSInspectorAuditResourcesObjectPrototype>(vm.heap)) JSInspectorAuditResourcesObjectPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSInspectorAuditResourcesObjectPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSInspectorAuditResourcesObjectPrototype, JSInspectorAuditResourcesObjectPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSInspectorAuditResourcesObjectPrototypeTableValues[] =
{
    { "getResources", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorAuditResourcesObjectPrototypeFunctionGetResources), (intptr_t) (0) } },
    { "getResourceContent", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorAuditResourcesObjectPrototypeFunctionGetResourceContent), (intptr_t) (1) } },
};

const ClassInfo JSInspectorAuditResourcesObjectPrototype::s_info = { "InspectorAuditResourcesObjectPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSInspectorAuditResourcesObjectPrototype) };

void JSInspectorAuditResourcesObjectPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSInspectorAuditResourcesObject::info(), JSInspectorAuditResourcesObjectPrototypeTableValues, *this);
}

const ClassInfo JSInspectorAuditResourcesObject::s_info = { "InspectorAuditResourcesObject", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSInspectorAuditResourcesObject) };

JSInspectorAuditResourcesObject::JSInspectorAuditResourcesObject(Structure* structure, JSDOMGlobalObject& globalObject, Ref<InspectorAuditResourcesObject>&& impl)
    : JSDOMWrapper<InspectorAuditResourcesObject>(structure, globalObject, WTFMove(impl))
{
}

void JSInspectorAuditResourcesObject::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, InspectorAuditResourcesObject>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSInspectorAuditResourcesObject::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSInspectorAuditResourcesObjectPrototype::create(vm, &globalObject, JSInspectorAuditResourcesObjectPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSInspectorAuditResourcesObject::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSInspectorAuditResourcesObject>(vm, globalObject);
}

void JSInspectorAuditResourcesObject::destroy(JSC::JSCell* cell)
{
    JSInspectorAuditResourcesObject* thisObject = static_cast<JSInspectorAuditResourcesObject*>(cell);
    thisObject->JSInspectorAuditResourcesObject::~JSInspectorAuditResourcesObject();
}

template<> inline JSInspectorAuditResourcesObject* IDLOperation<JSInspectorAuditResourcesObject>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSInspectorAuditResourcesObject*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

static inline JSC::EncodedJSValue jsInspectorAuditResourcesObjectPrototypeFunctionGetResourcesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorAuditResourcesObject>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    return JSValue::encode(toJS<IDLSequence<IDLDictionary<InspectorAuditResourcesObject::Resource>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getResources(document)));
}

EncodedJSValue JSC_HOST_CALL jsInspectorAuditResourcesObjectPrototypeFunctionGetResources(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorAuditResourcesObject>::call<jsInspectorAuditResourcesObjectPrototypeFunctionGetResourcesBody>(*lexicalGlobalObject, *callFrame, "getResources");
}

static inline JSC::EncodedJSValue jsInspectorAuditResourcesObjectPrototypeFunctionGetResourceContentBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorAuditResourcesObject>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    auto id = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDictionary<InspectorAuditResourcesObject::ResourceContent>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getResourceContent(document, WTFMove(id))));
}

EncodedJSValue JSC_HOST_CALL jsInspectorAuditResourcesObjectPrototypeFunctionGetResourceContent(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorAuditResourcesObject>::call<jsInspectorAuditResourcesObjectPrototypeFunctionGetResourceContentBody>(*lexicalGlobalObject, *callFrame, "getResourceContent");
}

void JSInspectorAuditResourcesObject::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSInspectorAuditResourcesObject*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSInspectorAuditResourcesObjectOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSInspectorAuditResourcesObjectOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsInspectorAuditResourcesObject = static_cast<JSInspectorAuditResourcesObject*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsInspectorAuditResourcesObject->wrapped(), jsInspectorAuditResourcesObject);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<InspectorAuditResourcesObject>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to InspectorAuditResourcesObject.
    static_assert(!std::is_polymorphic<InspectorAuditResourcesObject>::value, "InspectorAuditResourcesObject is polymorphic but the IDL claims it is not");
    return createWrapper<InspectorAuditResourcesObject>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, InspectorAuditResourcesObject& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

InspectorAuditResourcesObject* JSInspectorAuditResourcesObject::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSInspectorAuditResourcesObject*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
