/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSInspectorFrontendHost.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSEvent.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

template<> InspectorFrontendHost::ContextMenuItem convertDictionary<InspectorFrontendHost::ContextMenuItem>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    InspectorFrontendHost::ContextMenuItem result;
    JSValue checkedValue;
    if (isNullOrUndefined)
        checkedValue = jsUndefined();
    else {
        checkedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "checked"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!checkedValue.isUndefined()) {
        result.checked = convert<IDLBoolean>(lexicalGlobalObject, checkedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue enabledValue;
    if (isNullOrUndefined)
        enabledValue = jsUndefined();
    else {
        enabledValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "enabled"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!enabledValue.isUndefined()) {
        result.enabled = convert<IDLBoolean>(lexicalGlobalObject, enabledValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue idValue;
    if (isNullOrUndefined)
        idValue = jsUndefined();
    else {
        idValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "id"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!idValue.isUndefined()) {
        result.id = convert<IDLLong>(lexicalGlobalObject, idValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue labelValue;
    if (isNullOrUndefined)
        labelValue = jsUndefined();
    else {
        labelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "label"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!labelValue.isUndefined()) {
        result.label = convert<IDLDOMString>(lexicalGlobalObject, labelValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue subItemsValue;
    if (isNullOrUndefined)
        subItemsValue = jsUndefined();
    else {
        subItemsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "subItems"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!subItemsValue.isUndefined()) {
        result.subItems = convert<IDLSequence<IDLDictionary<InspectorFrontendHost::ContextMenuItem>>>(lexicalGlobalObject, subItemsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue typeValue;
    if (isNullOrUndefined)
        typeValue = jsUndefined();
    else {
        typeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "type"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!typeValue.isUndefined()) {
        result.type = convert<IDLDOMString>(lexicalGlobalObject, typeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

template<> InspectorFrontendHost::DebuggableInfo convertDictionary<InspectorFrontendHost::DebuggableInfo>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    InspectorFrontendHost::DebuggableInfo result;
    JSValue debuggableTypeValue;
    if (isNullOrUndefined)
        debuggableTypeValue = jsUndefined();
    else {
        debuggableTypeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "debuggableType"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!debuggableTypeValue.isUndefined()) {
        result.debuggableType = convert<IDLDOMString>(lexicalGlobalObject, debuggableTypeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue targetBuildVersionValue;
    if (isNullOrUndefined)
        targetBuildVersionValue = jsUndefined();
    else {
        targetBuildVersionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "targetBuildVersion"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!targetBuildVersionValue.isUndefined()) {
        result.targetBuildVersion = convert<IDLDOMString>(lexicalGlobalObject, targetBuildVersionValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue targetIsSimulatorValue;
    if (isNullOrUndefined)
        targetIsSimulatorValue = jsUndefined();
    else {
        targetIsSimulatorValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "targetIsSimulator"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!targetIsSimulatorValue.isUndefined()) {
        result.targetIsSimulator = convert<IDLBoolean>(lexicalGlobalObject, targetIsSimulatorValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue targetPlatformNameValue;
    if (isNullOrUndefined)
        targetPlatformNameValue = jsUndefined();
    else {
        targetPlatformNameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "targetPlatformName"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!targetPlatformNameValue.isUndefined()) {
        result.targetPlatformName = convert<IDLDOMString>(lexicalGlobalObject, targetPlatformNameValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue targetProductVersionValue;
    if (isNullOrUndefined)
        targetProductVersionValue = jsUndefined();
    else {
        targetProductVersionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "targetProductVersion"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!targetProductVersionValue.isUndefined()) {
        result.targetProductVersion = convert<IDLDOMString>(lexicalGlobalObject, targetProductVersionValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const InspectorFrontendHost::DebuggableInfo& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLDOMString::isNullValue(dictionary.debuggableType)) {
        auto debuggableTypeValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.debuggableType));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "debuggableType"), debuggableTypeValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.targetBuildVersion)) {
        auto targetBuildVersionValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.targetBuildVersion));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "targetBuildVersion"), targetBuildVersionValue);
    }
    if (!IDLBoolean::isNullValue(dictionary.targetIsSimulator)) {
        auto targetIsSimulatorValue = toJS<IDLBoolean>(IDLBoolean::extractValueFromNullable(dictionary.targetIsSimulator));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "targetIsSimulator"), targetIsSimulatorValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.targetPlatformName)) {
        auto targetPlatformNameValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.targetPlatformName));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "targetPlatformName"), targetPlatformNameValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.targetProductVersion)) {
        auto targetProductVersionValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.targetProductVersion));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "targetProductVersion"), targetProductVersionValue);
    }
    return result;
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionLoaded(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionCloseWindow(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionReopen(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionReset(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionBringToFront(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionInspectedURLChanged(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionShowCertificate(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionSetZoomFactor(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionZoomFactor(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionUserInterfaceLayoutDirection(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionRequestSetDockSide(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionSetAttachedWindowHeight(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionSetAttachedWindowWidth(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionSetSheetRect(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionStartWindowDrag(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionMoveWindowBy(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionCopyText(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionKillText(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionOpenInNewTab(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionCanSave(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionSave(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionAppend(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionClose(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionShowContextMenu(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionDispatchEventAsContextMenuEvent(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionSendMessageToBackend(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionUnbufferedLog(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionIsUnderTest(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionIsExperimentalBuild(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionBeep(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionInspectInspector(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionIsBeingInspected(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsInspectorFrontendHostSupportsShowCertificate(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsInspectorFrontendHostIsRemote(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsInspectorFrontendHostLocalizedStringsURL(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsInspectorFrontendHostBackendCommandsURL(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsInspectorFrontendHostInspectionLevel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsInspectorFrontendHostDebuggableInfo(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsInspectorFrontendHostPort(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsInspectorFrontendHostPlatform(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsInspectorFrontendHostSupportsDiagnosticLogging(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSInspectorFrontendHostPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSInspectorFrontendHostPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSInspectorFrontendHostPrototype* ptr = new (NotNull, JSC::allocateCell<JSInspectorFrontendHostPrototype>(vm.heap)) JSInspectorFrontendHostPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSInspectorFrontendHostPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSInspectorFrontendHostPrototype, JSInspectorFrontendHostPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSInspectorFrontendHostPrototypeTableValues[] =
{
    { "supportsShowCertificate", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInspectorFrontendHostSupportsShowCertificate), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "isRemote", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInspectorFrontendHostIsRemote), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "localizedStringsURL", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInspectorFrontendHostLocalizedStringsURL), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "backendCommandsURL", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInspectorFrontendHostBackendCommandsURL), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "inspectionLevel", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInspectorFrontendHostInspectionLevel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "debuggableInfo", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInspectorFrontendHostDebuggableInfo), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "port", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInspectorFrontendHostPort), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "platform", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInspectorFrontendHostPlatform), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "supportsDiagnosticLogging", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInspectorFrontendHostSupportsDiagnosticLogging), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "loaded", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorFrontendHostPrototypeFunctionLoaded), (intptr_t) (0) } },
    { "closeWindow", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorFrontendHostPrototypeFunctionCloseWindow), (intptr_t) (0) } },
    { "reopen", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorFrontendHostPrototypeFunctionReopen), (intptr_t) (0) } },
    { "reset", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorFrontendHostPrototypeFunctionReset), (intptr_t) (0) } },
    { "bringToFront", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorFrontendHostPrototypeFunctionBringToFront), (intptr_t) (0) } },
    { "inspectedURLChanged", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorFrontendHostPrototypeFunctionInspectedURLChanged), (intptr_t) (1) } },
    { "showCertificate", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorFrontendHostPrototypeFunctionShowCertificate), (intptr_t) (1) } },
    { "setZoomFactor", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorFrontendHostPrototypeFunctionSetZoomFactor), (intptr_t) (1) } },
    { "zoomFactor", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorFrontendHostPrototypeFunctionZoomFactor), (intptr_t) (0) } },
    { "userInterfaceLayoutDirection", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorFrontendHostPrototypeFunctionUserInterfaceLayoutDirection), (intptr_t) (0) } },
    { "requestSetDockSide", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorFrontendHostPrototypeFunctionRequestSetDockSide), (intptr_t) (1) } },
    { "setAttachedWindowHeight", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorFrontendHostPrototypeFunctionSetAttachedWindowHeight), (intptr_t) (1) } },
    { "setAttachedWindowWidth", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorFrontendHostPrototypeFunctionSetAttachedWindowWidth), (intptr_t) (1) } },
    { "setSheetRect", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorFrontendHostPrototypeFunctionSetSheetRect), (intptr_t) (4) } },
    { "startWindowDrag", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorFrontendHostPrototypeFunctionStartWindowDrag), (intptr_t) (0) } },
    { "moveWindowBy", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorFrontendHostPrototypeFunctionMoveWindowBy), (intptr_t) (2) } },
    { "copyText", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorFrontendHostPrototypeFunctionCopyText), (intptr_t) (1) } },
    { "killText", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorFrontendHostPrototypeFunctionKillText), (intptr_t) (3) } },
    { "openInNewTab", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorFrontendHostPrototypeFunctionOpenInNewTab), (intptr_t) (1) } },
    { "canSave", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorFrontendHostPrototypeFunctionCanSave), (intptr_t) (0) } },
    { "save", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorFrontendHostPrototypeFunctionSave), (intptr_t) (4) } },
    { "append", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorFrontendHostPrototypeFunctionAppend), (intptr_t) (2) } },
    { "close", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorFrontendHostPrototypeFunctionClose), (intptr_t) (1) } },
    { "showContextMenu", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorFrontendHostPrototypeFunctionShowContextMenu), (intptr_t) (2) } },
    { "dispatchEventAsContextMenuEvent", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorFrontendHostPrototypeFunctionDispatchEventAsContextMenuEvent), (intptr_t) (1) } },
    { "sendMessageToBackend", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorFrontendHostPrototypeFunctionSendMessageToBackend), (intptr_t) (1) } },
    { "unbufferedLog", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorFrontendHostPrototypeFunctionUnbufferedLog), (intptr_t) (1) } },
    { "isUnderTest", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorFrontendHostPrototypeFunctionIsUnderTest), (intptr_t) (0) } },
    { "isExperimentalBuild", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorFrontendHostPrototypeFunctionIsExperimentalBuild), (intptr_t) (0) } },
    { "beep", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorFrontendHostPrototypeFunctionBeep), (intptr_t) (0) } },
    { "inspectInspector", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorFrontendHostPrototypeFunctionInspectInspector), (intptr_t) (0) } },
    { "isBeingInspected", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInspectorFrontendHostPrototypeFunctionIsBeingInspected), (intptr_t) (0) } },
};

const ClassInfo JSInspectorFrontendHostPrototype::s_info = { "InspectorFrontendHostPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSInspectorFrontendHostPrototype) };

void JSInspectorFrontendHostPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSInspectorFrontendHost::info(), JSInspectorFrontendHostPrototypeTableValues, *this);
}

const ClassInfo JSInspectorFrontendHost::s_info = { "InspectorFrontendHost", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSInspectorFrontendHost) };

JSInspectorFrontendHost::JSInspectorFrontendHost(Structure* structure, JSDOMGlobalObject& globalObject, Ref<InspectorFrontendHost>&& impl)
    : JSDOMWrapper<InspectorFrontendHost>(structure, globalObject, WTFMove(impl))
{
}

void JSInspectorFrontendHost::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, InspectorFrontendHost>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSInspectorFrontendHost::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSInspectorFrontendHostPrototype::create(vm, &globalObject, JSInspectorFrontendHostPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSInspectorFrontendHost::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSInspectorFrontendHost>(vm, globalObject);
}

void JSInspectorFrontendHost::destroy(JSC::JSCell* cell)
{
    JSInspectorFrontendHost* thisObject = static_cast<JSInspectorFrontendHost*>(cell);
    thisObject->JSInspectorFrontendHost::~JSInspectorFrontendHost();
}

template<> inline JSInspectorFrontendHost* IDLAttribute<JSInspectorFrontendHost>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSInspectorFrontendHost*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSInspectorFrontendHost* IDLOperation<JSInspectorFrontendHost>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSInspectorFrontendHost*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

static inline JSValue jsInspectorFrontendHostSupportsShowCertificateGetter(JSGlobalObject& lexicalGlobalObject, JSInspectorFrontendHost& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.supportsShowCertificate());
    return result;
}

EncodedJSValue jsInspectorFrontendHostSupportsShowCertificate(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSInspectorFrontendHost>::get<jsInspectorFrontendHostSupportsShowCertificateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "supportsShowCertificate");
}

static inline JSValue jsInspectorFrontendHostIsRemoteGetter(JSGlobalObject& lexicalGlobalObject, JSInspectorFrontendHost& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.isRemote());
    return result;
}

EncodedJSValue jsInspectorFrontendHostIsRemote(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSInspectorFrontendHost>::get<jsInspectorFrontendHostIsRemoteGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "isRemote");
}

static inline JSValue jsInspectorFrontendHostLocalizedStringsURLGetter(JSGlobalObject& lexicalGlobalObject, JSInspectorFrontendHost& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.localizedStringsURL());
    return result;
}

EncodedJSValue jsInspectorFrontendHostLocalizedStringsURL(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSInspectorFrontendHost>::get<jsInspectorFrontendHostLocalizedStringsURLGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "localizedStringsURL");
}

static inline JSValue jsInspectorFrontendHostBackendCommandsURLGetter(JSGlobalObject& lexicalGlobalObject, JSInspectorFrontendHost& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.backendCommandsURL());
    return result;
}

EncodedJSValue jsInspectorFrontendHostBackendCommandsURL(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSInspectorFrontendHost>::get<jsInspectorFrontendHostBackendCommandsURLGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "backendCommandsURL");
}

static inline JSValue jsInspectorFrontendHostInspectionLevelGetter(JSGlobalObject& lexicalGlobalObject, JSInspectorFrontendHost& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.inspectionLevel());
    return result;
}

EncodedJSValue jsInspectorFrontendHostInspectionLevel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSInspectorFrontendHost>::get<jsInspectorFrontendHostInspectionLevelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "inspectionLevel");
}

static inline JSValue jsInspectorFrontendHostDebuggableInfoGetter(JSGlobalObject& lexicalGlobalObject, JSInspectorFrontendHost& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDictionary<InspectorFrontendHost::DebuggableInfo>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.debuggableInfo());
    return result;
}

EncodedJSValue jsInspectorFrontendHostDebuggableInfo(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSInspectorFrontendHost>::get<jsInspectorFrontendHostDebuggableInfoGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "debuggableInfo");
}

static inline JSValue jsInspectorFrontendHostPortGetter(JSGlobalObject& lexicalGlobalObject, JSInspectorFrontendHost& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.port());
    return result;
}

EncodedJSValue jsInspectorFrontendHostPort(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSInspectorFrontendHost>::get<jsInspectorFrontendHostPortGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "port");
}

static inline JSValue jsInspectorFrontendHostPlatformGetter(JSGlobalObject& lexicalGlobalObject, JSInspectorFrontendHost& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.platform());
    return result;
}

EncodedJSValue jsInspectorFrontendHostPlatform(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSInspectorFrontendHost>::get<jsInspectorFrontendHostPlatformGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "platform");
}

static inline JSValue jsInspectorFrontendHostSupportsDiagnosticLoggingGetter(JSGlobalObject& lexicalGlobalObject, JSInspectorFrontendHost& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.supportsDiagnosticLogging());
    return result;
}

EncodedJSValue jsInspectorFrontendHostSupportsDiagnosticLogging(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSInspectorFrontendHost>::get<jsInspectorFrontendHostSupportsDiagnosticLoggingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "supportsDiagnosticLogging");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunctionLoadedBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.loaded();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionLoaded(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunctionLoadedBody>(*lexicalGlobalObject, *callFrame, "loaded");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunctionCloseWindowBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.closeWindow();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionCloseWindow(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunctionCloseWindowBody>(*lexicalGlobalObject, *callFrame, "closeWindow");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunctionReopenBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.reopen();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionReopen(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunctionReopenBody>(*lexicalGlobalObject, *callFrame, "reopen");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunctionResetBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.reset();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionReset(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunctionResetBody>(*lexicalGlobalObject, *callFrame, "reset");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunctionBringToFrontBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.bringToFront();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionBringToFront(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunctionBringToFrontBody>(*lexicalGlobalObject, *callFrame, "bringToFront");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunctionInspectedURLChangedBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto newURL = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.inspectedURLChanged(WTFMove(newURL));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionInspectedURLChanged(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunctionInspectedURLChangedBody>(*lexicalGlobalObject, *callFrame, "inspectedURLChanged");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunctionShowCertificateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto serializedCertificate = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.showCertificate(WTFMove(serializedCertificate))));
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionShowCertificate(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunctionShowCertificateBody>(*lexicalGlobalObject, *callFrame, "showCertificate");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunctionSetZoomFactorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto zoom = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setZoomFactor(WTFMove(zoom));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionSetZoomFactor(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunctionSetZoomFactorBody>(*lexicalGlobalObject, *callFrame, "setZoomFactor");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunctionZoomFactorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLFloat>(impl.zoomFactor()));
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionZoomFactor(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunctionZoomFactorBody>(*lexicalGlobalObject, *callFrame, "zoomFactor");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunctionUserInterfaceLayoutDirectionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.userInterfaceLayoutDirection()));
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionUserInterfaceLayoutDirection(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunctionUserInterfaceLayoutDirectionBody>(*lexicalGlobalObject, *callFrame, "userInterfaceLayoutDirection");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunctionRequestSetDockSideBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto side = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.requestSetDockSide(WTFMove(side));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionRequestSetDockSide(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunctionRequestSetDockSideBody>(*lexicalGlobalObject, *callFrame, "requestSetDockSide");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunctionSetAttachedWindowHeightBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto height = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setAttachedWindowHeight(WTFMove(height));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionSetAttachedWindowHeight(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunctionSetAttachedWindowHeightBody>(*lexicalGlobalObject, *callFrame, "setAttachedWindowHeight");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunctionSetAttachedWindowWidthBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto width = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setAttachedWindowWidth(WTFMove(width));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionSetAttachedWindowWidth(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunctionSetAttachedWindowWidthBody>(*lexicalGlobalObject, *callFrame, "setAttachedWindowWidth");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunctionSetSheetRectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setSheetRect(WTFMove(x), WTFMove(y), WTFMove(width), WTFMove(height));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionSetSheetRect(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunctionSetSheetRectBody>(*lexicalGlobalObject, *callFrame, "setSheetRect");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunctionStartWindowDragBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.startWindowDrag();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionStartWindowDrag(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunctionStartWindowDragBody>(*lexicalGlobalObject, *callFrame, "startWindowDrag");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunctionMoveWindowByBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.moveWindowBy(WTFMove(x), WTFMove(y));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionMoveWindowBy(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunctionMoveWindowByBody>(*lexicalGlobalObject, *callFrame, "moveWindowBy");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunctionCopyTextBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto text = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.copyText(WTFMove(text));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionCopyText(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunctionCopyTextBody>(*lexicalGlobalObject, *callFrame, "copyText");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunctionKillTextBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto text = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto shouldPrependToKillRing = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto shouldStartNewSequence = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.killText(WTFMove(text), WTFMove(shouldPrependToKillRing), WTFMove(shouldStartNewSequence));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionKillText(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunctionKillTextBody>(*lexicalGlobalObject, *callFrame, "killText");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunctionOpenInNewTabBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto url = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.openInNewTab(WTFMove(url));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionOpenInNewTab(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunctionOpenInNewTabBody>(*lexicalGlobalObject, *callFrame, "openInNewTab");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunctionCanSaveBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLBoolean>(impl.canSave()));
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionCanSave(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunctionCanSaveBody>(*lexicalGlobalObject, *callFrame, "canSave");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunctionSaveBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto url = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto content = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto base64Encoded = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto forceSaveAs = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.save(WTFMove(url), WTFMove(content), WTFMove(base64Encoded), WTFMove(forceSaveAs));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionSave(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunctionSaveBody>(*lexicalGlobalObject, *callFrame, "save");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunctionAppendBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto url = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto content = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.append(WTFMove(url), WTFMove(content));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionAppend(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunctionAppendBody>(*lexicalGlobalObject, *callFrame, "append");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunctionCloseBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto url = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.close(WTFMove(url));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionClose(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunctionCloseBody>(*lexicalGlobalObject, *callFrame, "close");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunctionShowContextMenuBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto event = convert<IDLInterface<Event>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "event", "InspectorFrontendHost", "showContextMenu", "Event"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto items = convert<IDLSequence<IDLDictionary<InspectorFrontendHost::ContextMenuItem>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.showContextMenu(*event, WTFMove(items));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionShowContextMenu(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunctionShowContextMenuBody>(*lexicalGlobalObject, *callFrame, "showContextMenu");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunctionDispatchEventAsContextMenuEventBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto event = convert<IDLInterface<Event>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "event", "InspectorFrontendHost", "dispatchEventAsContextMenuEvent", "Event"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.dispatchEventAsContextMenuEvent(*event);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionDispatchEventAsContextMenuEvent(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunctionDispatchEventAsContextMenuEventBody>(*lexicalGlobalObject, *callFrame, "dispatchEventAsContextMenuEvent");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunctionSendMessageToBackendBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto message = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.sendMessageToBackend(WTFMove(message));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionSendMessageToBackend(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunctionSendMessageToBackendBody>(*lexicalGlobalObject, *callFrame, "sendMessageToBackend");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunctionUnbufferedLogBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto message = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.unbufferedLog(WTFMove(message));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionUnbufferedLog(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunctionUnbufferedLogBody>(*lexicalGlobalObject, *callFrame, "unbufferedLog");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunctionIsUnderTestBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLBoolean>(impl.isUnderTest()));
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionIsUnderTest(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunctionIsUnderTestBody>(*lexicalGlobalObject, *callFrame, "isUnderTest");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunctionIsExperimentalBuildBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLBoolean>(impl.isExperimentalBuild()));
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionIsExperimentalBuild(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunctionIsExperimentalBuildBody>(*lexicalGlobalObject, *callFrame, "isExperimentalBuild");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunctionBeepBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.beep();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionBeep(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunctionBeepBody>(*lexicalGlobalObject, *callFrame, "beep");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunctionInspectInspectorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.inspectInspector();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionInspectInspector(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunctionInspectInspectorBody>(*lexicalGlobalObject, *callFrame, "inspectInspector");
}

static inline JSC::EncodedJSValue jsInspectorFrontendHostPrototypeFunctionIsBeingInspectedBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInspectorFrontendHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLBoolean>(impl.isBeingInspected()));
}

EncodedJSValue JSC_HOST_CALL jsInspectorFrontendHostPrototypeFunctionIsBeingInspected(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInspectorFrontendHost>::call<jsInspectorFrontendHostPrototypeFunctionIsBeingInspectedBody>(*lexicalGlobalObject, *callFrame, "isBeingInspected");
}

void JSInspectorFrontendHost::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSInspectorFrontendHost*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSInspectorFrontendHostOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSInspectorFrontendHostOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsInspectorFrontendHost = static_cast<JSInspectorFrontendHost*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsInspectorFrontendHost->wrapped(), jsInspectorFrontendHost);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<InspectorFrontendHost>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to InspectorFrontendHost.
    static_assert(!std::is_polymorphic<InspectorFrontendHost>::value, "InspectorFrontendHost is polymorphic but the IDL claims it is not");
    return createWrapper<InspectorFrontendHost>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, InspectorFrontendHost& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

InspectorFrontendHost* JSInspectorFrontendHost::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSInspectorFrontendHost*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
