/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#include "InternalSettings.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMWrapper.h"
#include "JSInternalSettingsGenerated.h"

namespace WebCore {

class WEBCORE_TESTSUPPORT_EXPORT JSInternalSettings : public JSInternalSettingsGenerated {
public:
    using Base = JSInternalSettingsGenerated;
    using DOMWrapped = InternalSettings;
    static JSInternalSettings* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<InternalSettings>&& impl)
    {
        JSInternalSettings* ptr = new (NotNull, JSC::allocateCell<JSInternalSettings>(globalObject->vm().heap)) JSInternalSettings(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::VM&, JSDOMGlobalObject&);
    static JSC::JSObject* prototype(JSC::VM&, JSDOMGlobalObject&);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);
    InternalSettings& wrapped() const
    {
        return static_cast<InternalSettings&>(Base::wrapped());
    }
protected:
    JSInternalSettings(JSC::Structure*, JSDOMGlobalObject&, Ref<InternalSettings>&&);

    void finishCreation(JSC::VM&);
};

WEBCORE_TESTSUPPORT_EXPORT JSC::JSValue toJS(JSC::JSGlobalObject*, JSDOMGlobalObject*, InternalSettings&);
inline JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, InternalSettings* impl) { return impl ? toJS(lexicalGlobalObject, globalObject, *impl) : JSC::jsNull(); }
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject*, Ref<InternalSettings>&&);
inline JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RefPtr<InternalSettings>&& impl) { return impl ? toJSNewlyCreated(lexicalGlobalObject, globalObject, impl.releaseNonNull()) : JSC::jsNull(); }

template<> struct JSDOMWrapperConverterTraits<InternalSettings> {
    using WrapperClass = JSInternalSettings;
    using ToWrappedReturnType = InternalSettings*;
};
String convertEnumerationToString(InternalSettings::ForcedAccessibilityValue);
template<> JSC::JSString* convertEnumerationToJS(JSC::JSGlobalObject&, InternalSettings::ForcedAccessibilityValue);

template<> Optional<InternalSettings::ForcedAccessibilityValue> parseEnumeration<InternalSettings::ForcedAccessibilityValue>(JSC::JSGlobalObject&, JSC::JSValue);
template<> const char* expectedEnumerationValues<InternalSettings::ForcedAccessibilityValue>();

String convertEnumerationToString(InternalSettings::FrameFlatteningValue);
template<> JSC::JSString* convertEnumerationToJS(JSC::JSGlobalObject&, InternalSettings::FrameFlatteningValue);

template<> Optional<InternalSettings::FrameFlatteningValue> parseEnumeration<InternalSettings::FrameFlatteningValue>(JSC::JSGlobalObject&, JSC::JSValue);
template<> const char* expectedEnumerationValues<InternalSettings::FrameFlatteningValue>();

String convertEnumerationToString(InternalSettings::FontLoadTimingOverride);
template<> JSC::JSString* convertEnumerationToJS(JSC::JSGlobalObject&, InternalSettings::FontLoadTimingOverride);

template<> Optional<InternalSettings::FontLoadTimingOverride> parseEnumeration<InternalSettings::FontLoadTimingOverride>(JSC::JSGlobalObject&, JSC::JSValue);
template<> const char* expectedEnumerationValues<InternalSettings::FontLoadTimingOverride>();


} // namespace WebCore
