/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSInternals.h"

#include "ActiveDOMObject.h"
#include "Document.h"
#include "JSCSSStyleDeclaration.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertEventListener.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertSerializedScriptValue.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMRect.h"
#include "JSDOMRectList.h"
#include "JSDOMRectReadOnly.h"
#include "JSDOMURL.h"
#include "JSDOMWindow.h"
#include "JSDOMWrapperCache.h"
#include "JSDocument.h"
#include "JSElement.h"
#include "JSEventListener.h"
#include "JSFetchResponse.h"
#include "JSFile.h"
#include "JSGCObservation.h"
#include "JSHTMLImageElement.h"
#include "JSHTMLInputElement.h"
#include "JSHTMLLinkElement.h"
#include "JSHTMLSelectElement.h"
#include "JSInternalSettings.h"
#include "JSInternalsMapLike.h"
#include "JSInternalsSetLike.h"
#include "JSMallocStatistics.h"
#include "JSMemoryInfo.h"
#include "JSMockPageOverlay.h"
#include "JSNode.h"
#include "JSNodeList.h"
#include "JSRange.h"
#include "JSSVGSVGElement.h"
#include "JSStringCallback.h"
#include "JSStyleSheet.h"
#include "JSTypeConversions.h"
#include "JSVoidCallback.h"
#include "JSWindowProxy.h"
#include "JSXMLHttpRequest.h"
#include "ScriptExecutionContext.h"
#include "SerializedScriptValue.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>

#if ENABLE(APPLE_PAY)
#include "JSMockPaymentCoordinator.h"
#endif

#if ENABLE(CONTENT_FILTERING)
#include "JSMockContentFilterSettings.h"
#endif

#if ENABLE(ENCRYPTED_MEDIA)
#include "JSMockCDMFactory.h"
#endif

#if ENABLE(MEDIA_SESSION)
#include "JSMediaSession.h"
#endif

#if ENABLE(MEDIA_SESSION) || ENABLE(VIDEO)
#include "JSHTMLMediaElement.h"
#endif

#if ENABLE(MEDIA_SOURCE)
#include "JSSourceBuffer.h"
#endif

#if ENABLE(MEDIA_STREAM)
#include "JSMediaStream.h"
#include "JSMediaStreamTrack.h"
#endif

#if ENABLE(PICTURE_IN_PICTURE_API)
#include "JSHTMLVideoElement.h"
#endif

#if ENABLE(SERVICE_WORKER)
#include "JSServiceWorker.h"
#endif

#if ENABLE(VIDEO)
#include "JSTimeRanges.h"
#endif

#if ENABLE(VIDEO_TRACK)
#include "JSTextTrackCueGeneric.h"
#endif

#if ENABLE(WEBGL)
#include "JSWebGLRenderingContext.h"
#endif

#if ENABLE(WEB_AUDIO)
#include "JSAudioContext.h"
#endif

#if ENABLE(WEB_AUTHN)
#include "JSMockWebAuthenticationConfiguration.h"
#endif

#if ENABLE(WEB_RTC)
#include "JSRTCPeerConnection.h"
#endif


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(Internals::PageOverlayType enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("view"),
        MAKE_STATIC_STRING_IMPL("document"),
    };
    static_assert(static_cast<size_t>(Internals::PageOverlayType::View) == 0, "Internals::PageOverlayType::View is not 0 as expected");
    static_assert(static_cast<size_t>(Internals::PageOverlayType::Document) == 1, "Internals::PageOverlayType::Document is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, Internals::PageOverlayType enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<Internals::PageOverlayType> parseEnumeration<Internals::PageOverlayType>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "view")
        return Internals::PageOverlayType::View;
    if (stringValue == "document")
        return Internals::PageOverlayType::Document;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<Internals::PageOverlayType>()
{
    return "\"view\", \"document\"";
}

String convertEnumerationToString(Internals::CachePolicy enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("UseProtocolCachePolicy"),
        MAKE_STATIC_STRING_IMPL("ReloadIgnoringCacheData"),
        MAKE_STATIC_STRING_IMPL("ReturnCacheDataElseLoad"),
        MAKE_STATIC_STRING_IMPL("ReturnCacheDataDontLoad"),
    };
    static_assert(static_cast<size_t>(Internals::CachePolicy::UseProtocolCachePolicy) == 0, "Internals::CachePolicy::UseProtocolCachePolicy is not 0 as expected");
    static_assert(static_cast<size_t>(Internals::CachePolicy::ReloadIgnoringCacheData) == 1, "Internals::CachePolicy::ReloadIgnoringCacheData is not 1 as expected");
    static_assert(static_cast<size_t>(Internals::CachePolicy::ReturnCacheDataElseLoad) == 2, "Internals::CachePolicy::ReturnCacheDataElseLoad is not 2 as expected");
    static_assert(static_cast<size_t>(Internals::CachePolicy::ReturnCacheDataDontLoad) == 3, "Internals::CachePolicy::ReturnCacheDataDontLoad is not 3 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, Internals::CachePolicy enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<Internals::CachePolicy> parseEnumeration<Internals::CachePolicy>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "UseProtocolCachePolicy")
        return Internals::CachePolicy::UseProtocolCachePolicy;
    if (stringValue == "ReloadIgnoringCacheData")
        return Internals::CachePolicy::ReloadIgnoringCacheData;
    if (stringValue == "ReturnCacheDataElseLoad")
        return Internals::CachePolicy::ReturnCacheDataElseLoad;
    if (stringValue == "ReturnCacheDataDontLoad")
        return Internals::CachePolicy::ReturnCacheDataDontLoad;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<Internals::CachePolicy>()
{
    return "\"UseProtocolCachePolicy\", \"ReloadIgnoringCacheData\", \"ReturnCacheDataElseLoad\", \"ReturnCacheDataDontLoad\"";
}

String convertEnumerationToString(Internals::ResourceLoadPriority enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("ResourceLoadPriorityVeryLow"),
        MAKE_STATIC_STRING_IMPL("ResourceLoadPriorityLow"),
        MAKE_STATIC_STRING_IMPL("ResourceLoadPriorityMedium"),
        MAKE_STATIC_STRING_IMPL("ResourceLoadPriorityHigh"),
        MAKE_STATIC_STRING_IMPL("ResourceLoadPriorityVeryHigh"),
    };
    static_assert(static_cast<size_t>(Internals::ResourceLoadPriority::ResourceLoadPriorityVeryLow) == 0, "Internals::ResourceLoadPriority::ResourceLoadPriorityVeryLow is not 0 as expected");
    static_assert(static_cast<size_t>(Internals::ResourceLoadPriority::ResourceLoadPriorityLow) == 1, "Internals::ResourceLoadPriority::ResourceLoadPriorityLow is not 1 as expected");
    static_assert(static_cast<size_t>(Internals::ResourceLoadPriority::ResourceLoadPriorityMedium) == 2, "Internals::ResourceLoadPriority::ResourceLoadPriorityMedium is not 2 as expected");
    static_assert(static_cast<size_t>(Internals::ResourceLoadPriority::ResourceLoadPriorityHigh) == 3, "Internals::ResourceLoadPriority::ResourceLoadPriorityHigh is not 3 as expected");
    static_assert(static_cast<size_t>(Internals::ResourceLoadPriority::ResourceLoadPriorityVeryHigh) == 4, "Internals::ResourceLoadPriority::ResourceLoadPriorityVeryHigh is not 4 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, Internals::ResourceLoadPriority enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<Internals::ResourceLoadPriority> parseEnumeration<Internals::ResourceLoadPriority>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "ResourceLoadPriorityVeryLow")
        return Internals::ResourceLoadPriority::ResourceLoadPriorityVeryLow;
    if (stringValue == "ResourceLoadPriorityLow")
        return Internals::ResourceLoadPriority::ResourceLoadPriorityLow;
    if (stringValue == "ResourceLoadPriorityMedium")
        return Internals::ResourceLoadPriority::ResourceLoadPriorityMedium;
    if (stringValue == "ResourceLoadPriorityHigh")
        return Internals::ResourceLoadPriority::ResourceLoadPriorityHigh;
    if (stringValue == "ResourceLoadPriorityVeryHigh")
        return Internals::ResourceLoadPriority::ResourceLoadPriorityVeryHigh;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<Internals::ResourceLoadPriority>()
{
    return "\"ResourceLoadPriorityVeryLow\", \"ResourceLoadPriorityLow\", \"ResourceLoadPriorityMedium\", \"ResourceLoadPriorityHigh\", \"ResourceLoadPriorityVeryHigh\"";
}

#if ENABLE(MEDIA_SESSION)

String convertEnumerationToString(Internals::MediaSessionInterruptingCategory enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("content"),
        MAKE_STATIC_STRING_IMPL("transient"),
        MAKE_STATIC_STRING_IMPL("transient-solo"),
    };
    static_assert(static_cast<size_t>(Internals::MediaSessionInterruptingCategory::Content) == 0, "Internals::MediaSessionInterruptingCategory::Content is not 0 as expected");
    static_assert(static_cast<size_t>(Internals::MediaSessionInterruptingCategory::Transient) == 1, "Internals::MediaSessionInterruptingCategory::Transient is not 1 as expected");
    static_assert(static_cast<size_t>(Internals::MediaSessionInterruptingCategory::TransientSolo) == 2, "Internals::MediaSessionInterruptingCategory::TransientSolo is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, Internals::MediaSessionInterruptingCategory enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<Internals::MediaSessionInterruptingCategory> parseEnumeration<Internals::MediaSessionInterruptingCategory>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "content")
        return Internals::MediaSessionInterruptingCategory::Content;
    if (stringValue == "transient")
        return Internals::MediaSessionInterruptingCategory::Transient;
    if (stringValue == "transient-solo")
        return Internals::MediaSessionInterruptingCategory::TransientSolo;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<Internals::MediaSessionInterruptingCategory>()
{
    return "\"content\", \"transient\", \"transient-solo\"";
}

#endif

#if ENABLE(MEDIA_SESSION)

String convertEnumerationToString(Internals::MediaControlEvent enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("play-pause"),
        MAKE_STATIC_STRING_IMPL("next-track"),
        MAKE_STATIC_STRING_IMPL("previous-track"),
    };
    static_assert(static_cast<size_t>(Internals::MediaControlEvent::PlayPause) == 0, "Internals::MediaControlEvent::PlayPause is not 0 as expected");
    static_assert(static_cast<size_t>(Internals::MediaControlEvent::NextTrack) == 1, "Internals::MediaControlEvent::NextTrack is not 1 as expected");
    static_assert(static_cast<size_t>(Internals::MediaControlEvent::PreviousTrack) == 2, "Internals::MediaControlEvent::PreviousTrack is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, Internals::MediaControlEvent enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<Internals::MediaControlEvent> parseEnumeration<Internals::MediaControlEvent>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "play-pause")
        return Internals::MediaControlEvent::PlayPause;
    if (stringValue == "next-track")
        return Internals::MediaControlEvent::NextTrack;
    if (stringValue == "previous-track")
        return Internals::MediaControlEvent::PreviousTrack;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<Internals::MediaControlEvent>()
{
    return "\"play-pause\", \"next-track\", \"previous-track\"";
}

#endif

String convertEnumerationToString(Internals::AutoFillButtonType enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("None"),
        MAKE_STATIC_STRING_IMPL("Contacts"),
        MAKE_STATIC_STRING_IMPL("Credentials"),
        MAKE_STATIC_STRING_IMPL("StrongPassword"),
        MAKE_STATIC_STRING_IMPL("CreditCard"),
    };
    static_assert(static_cast<size_t>(Internals::AutoFillButtonType::None) == 0, "Internals::AutoFillButtonType::None is not 0 as expected");
    static_assert(static_cast<size_t>(Internals::AutoFillButtonType::Contacts) == 1, "Internals::AutoFillButtonType::Contacts is not 1 as expected");
    static_assert(static_cast<size_t>(Internals::AutoFillButtonType::Credentials) == 2, "Internals::AutoFillButtonType::Credentials is not 2 as expected");
    static_assert(static_cast<size_t>(Internals::AutoFillButtonType::StrongPassword) == 3, "Internals::AutoFillButtonType::StrongPassword is not 3 as expected");
    static_assert(static_cast<size_t>(Internals::AutoFillButtonType::CreditCard) == 4, "Internals::AutoFillButtonType::CreditCard is not 4 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, Internals::AutoFillButtonType enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<Internals::AutoFillButtonType> parseEnumeration<Internals::AutoFillButtonType>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "None")
        return Internals::AutoFillButtonType::None;
    if (stringValue == "Contacts")
        return Internals::AutoFillButtonType::Contacts;
    if (stringValue == "Credentials")
        return Internals::AutoFillButtonType::Credentials;
    if (stringValue == "StrongPassword")
        return Internals::AutoFillButtonType::StrongPassword;
    if (stringValue == "CreditCard")
        return Internals::AutoFillButtonType::CreditCard;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<Internals::AutoFillButtonType>()
{
    return "\"None\", \"Contacts\", \"Credentials\", \"StrongPassword\", \"CreditCard\"";
}

String convertEnumerationToString(Internals::UserInterfaceLayoutDirection enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("LTR"),
        MAKE_STATIC_STRING_IMPL("RTL"),
    };
    static_assert(static_cast<size_t>(Internals::UserInterfaceLayoutDirection::LTR) == 0, "Internals::UserInterfaceLayoutDirection::LTR is not 0 as expected");
    static_assert(static_cast<size_t>(Internals::UserInterfaceLayoutDirection::RTL) == 1, "Internals::UserInterfaceLayoutDirection::RTL is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, Internals::UserInterfaceLayoutDirection enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<Internals::UserInterfaceLayoutDirection> parseEnumeration<Internals::UserInterfaceLayoutDirection>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "LTR")
        return Internals::UserInterfaceLayoutDirection::LTR;
    if (stringValue == "RTL")
        return Internals::UserInterfaceLayoutDirection::RTL;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<Internals::UserInterfaceLayoutDirection>()
{
    return "\"LTR\", \"RTL\"";
}

String convertEnumerationToString(Internals::BaseWritingDirection enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("Natural"),
        MAKE_STATIC_STRING_IMPL("Ltr"),
        MAKE_STATIC_STRING_IMPL("Rtl"),
    };
    static_assert(static_cast<size_t>(Internals::BaseWritingDirection::Natural) == 0, "Internals::BaseWritingDirection::Natural is not 0 as expected");
    static_assert(static_cast<size_t>(Internals::BaseWritingDirection::Ltr) == 1, "Internals::BaseWritingDirection::Ltr is not 1 as expected");
    static_assert(static_cast<size_t>(Internals::BaseWritingDirection::Rtl) == 2, "Internals::BaseWritingDirection::Rtl is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, Internals::BaseWritingDirection enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<Internals::BaseWritingDirection> parseEnumeration<Internals::BaseWritingDirection>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "Natural")
        return Internals::BaseWritingDirection::Natural;
    if (stringValue == "Ltr")
        return Internals::BaseWritingDirection::Ltr;
    if (stringValue == "Rtl")
        return Internals::BaseWritingDirection::Rtl;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<Internals::BaseWritingDirection>()
{
    return "\"Natural\", \"Ltr\", \"Rtl\"";
}

String convertEnumerationToString(Internals::EventThrottlingBehavior enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("responsive"),
        MAKE_STATIC_STRING_IMPL("unresponsive"),
    };
    static_assert(static_cast<size_t>(Internals::EventThrottlingBehavior::Responsive) == 0, "Internals::EventThrottlingBehavior::Responsive is not 0 as expected");
    static_assert(static_cast<size_t>(Internals::EventThrottlingBehavior::Unresponsive) == 1, "Internals::EventThrottlingBehavior::Unresponsive is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, Internals::EventThrottlingBehavior enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<Internals::EventThrottlingBehavior> parseEnumeration<Internals::EventThrottlingBehavior>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "responsive")
        return Internals::EventThrottlingBehavior::Responsive;
    if (stringValue == "unresponsive")
        return Internals::EventThrottlingBehavior::Unresponsive;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<Internals::EventThrottlingBehavior>()
{
    return "\"responsive\", \"unresponsive\"";
}

String convertEnumerationToString(Internals::CompositingPolicy enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("normal"),
        MAKE_STATIC_STRING_IMPL("conservative"),
    };
    static_assert(static_cast<size_t>(Internals::CompositingPolicy::Normal) == 0, "Internals::CompositingPolicy::Normal is not 0 as expected");
    static_assert(static_cast<size_t>(Internals::CompositingPolicy::Conservative) == 1, "Internals::CompositingPolicy::Conservative is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, Internals::CompositingPolicy enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<Internals::CompositingPolicy> parseEnumeration<Internals::CompositingPolicy>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "normal")
        return Internals::CompositingPolicy::Normal;
    if (stringValue == "conservative")
        return Internals::CompositingPolicy::Conservative;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<Internals::CompositingPolicy>()
{
    return "\"normal\", \"conservative\"";
}

#if ENABLE(VIDEO)

String convertEnumerationToString(Internals::PlaybackControlsPurpose enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("ControlsManager"),
        MAKE_STATIC_STRING_IMPL("NowPlaying"),
    };
    static_assert(static_cast<size_t>(Internals::PlaybackControlsPurpose::ControlsManager) == 0, "Internals::PlaybackControlsPurpose::ControlsManager is not 0 as expected");
    static_assert(static_cast<size_t>(Internals::PlaybackControlsPurpose::NowPlaying) == 1, "Internals::PlaybackControlsPurpose::NowPlaying is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, Internals::PlaybackControlsPurpose enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<Internals::PlaybackControlsPurpose> parseEnumeration<Internals::PlaybackControlsPurpose>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "ControlsManager")
        return Internals::PlaybackControlsPurpose::ControlsManager;
    if (stringValue == "NowPlaying")
        return Internals::PlaybackControlsPurpose::NowPlaying;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<Internals::PlaybackControlsPurpose>()
{
    return "\"ControlsManager\", \"NowPlaying\"";
}

#endif

#if ENABLE(VIDEO)

String convertEnumerationToString(Internals::MediaSessionState enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("Idle"),
        MAKE_STATIC_STRING_IMPL("Autoplaying"),
        MAKE_STATIC_STRING_IMPL("Playing"),
        MAKE_STATIC_STRING_IMPL("Paused"),
        MAKE_STATIC_STRING_IMPL("Interrupted"),
    };
    static_assert(static_cast<size_t>(Internals::MediaSessionState::Idle) == 0, "Internals::MediaSessionState::Idle is not 0 as expected");
    static_assert(static_cast<size_t>(Internals::MediaSessionState::Autoplaying) == 1, "Internals::MediaSessionState::Autoplaying is not 1 as expected");
    static_assert(static_cast<size_t>(Internals::MediaSessionState::Playing) == 2, "Internals::MediaSessionState::Playing is not 2 as expected");
    static_assert(static_cast<size_t>(Internals::MediaSessionState::Paused) == 3, "Internals::MediaSessionState::Paused is not 3 as expected");
    static_assert(static_cast<size_t>(Internals::MediaSessionState::Interrupted) == 4, "Internals::MediaSessionState::Interrupted is not 4 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, Internals::MediaSessionState enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<Internals::MediaSessionState> parseEnumeration<Internals::MediaSessionState>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "Idle")
        return Internals::MediaSessionState::Idle;
    if (stringValue == "Autoplaying")
        return Internals::MediaSessionState::Autoplaying;
    if (stringValue == "Playing")
        return Internals::MediaSessionState::Playing;
    if (stringValue == "Paused")
        return Internals::MediaSessionState::Paused;
    if (stringValue == "Interrupted")
        return Internals::MediaSessionState::Interrupted;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<Internals::MediaSessionState>()
{
    return "\"Idle\", \"Autoplaying\", \"Playing\", \"Paused\", \"Interrupted\"";
}

#endif

#if ENABLE(VIDEO)

template<> Internals::NowPlayingState convertDictionary<Internals::NowPlayingState>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    Internals::NowPlayingState result;
    JSValue durationValue;
    if (isNullOrUndefined)
        durationValue = jsUndefined();
    else {
        durationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "duration"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!durationValue.isUndefined()) {
        result.duration = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, durationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue elapsedTimeValue;
    if (isNullOrUndefined)
        elapsedTimeValue = jsUndefined();
    else {
        elapsedTimeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "elapsedTime"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!elapsedTimeValue.isUndefined()) {
        result.elapsedTime = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, elapsedTimeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue hasActiveSessionValue;
    if (isNullOrUndefined)
        hasActiveSessionValue = jsUndefined();
    else {
        hasActiveSessionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "hasActiveSession"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!hasActiveSessionValue.isUndefined()) {
        result.hasActiveSession = convert<IDLBoolean>(lexicalGlobalObject, hasActiveSessionValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue registeredAsNowPlayingApplicationValue;
    if (isNullOrUndefined)
        registeredAsNowPlayingApplicationValue = jsUndefined();
    else {
        registeredAsNowPlayingApplicationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "registeredAsNowPlayingApplication"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!registeredAsNowPlayingApplicationValue.isUndefined()) {
        result.registeredAsNowPlayingApplication = convert<IDLBoolean>(lexicalGlobalObject, registeredAsNowPlayingApplicationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue titleValue;
    if (isNullOrUndefined)
        titleValue = jsUndefined();
    else {
        titleValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "title"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!titleValue.isUndefined()) {
        result.title = convert<IDLDOMString>(lexicalGlobalObject, titleValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue uniqueIdentifierValue;
    if (isNullOrUndefined)
        uniqueIdentifierValue = jsUndefined();
    else {
        uniqueIdentifierValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "uniqueIdentifier"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!uniqueIdentifierValue.isUndefined()) {
        result.uniqueIdentifier = convert<IDLUnsignedLongLong>(lexicalGlobalObject, uniqueIdentifierValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const Internals::NowPlayingState& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLUnrestrictedDouble::isNullValue(dictionary.duration)) {
        auto durationValue = toJS<IDLUnrestrictedDouble>(IDLUnrestrictedDouble::extractValueFromNullable(dictionary.duration));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "duration"), durationValue);
    }
    if (!IDLUnrestrictedDouble::isNullValue(dictionary.elapsedTime)) {
        auto elapsedTimeValue = toJS<IDLUnrestrictedDouble>(IDLUnrestrictedDouble::extractValueFromNullable(dictionary.elapsedTime));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "elapsedTime"), elapsedTimeValue);
    }
    if (!IDLBoolean::isNullValue(dictionary.hasActiveSession)) {
        auto hasActiveSessionValue = toJS<IDLBoolean>(IDLBoolean::extractValueFromNullable(dictionary.hasActiveSession));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "hasActiveSession"), hasActiveSessionValue);
    }
    if (!IDLBoolean::isNullValue(dictionary.registeredAsNowPlayingApplication)) {
        auto registeredAsNowPlayingApplicationValue = toJS<IDLBoolean>(IDLBoolean::extractValueFromNullable(dictionary.registeredAsNowPlayingApplication));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "registeredAsNowPlayingApplication"), registeredAsNowPlayingApplicationValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.title)) {
        auto titleValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.title));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "title"), titleValue);
    }
    if (!IDLUnsignedLongLong::isNullValue(dictionary.uniqueIdentifier)) {
        auto uniqueIdentifierValue = toJS<IDLUnsignedLongLong>(IDLUnsignedLongLong::extractValueFromNullable(dictionary.uniqueIdentifier));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "uniqueIdentifier"), uniqueIdentifierValue);
    }
    return result;
}

#endif

template<> Internals::FullscreenInsets convertDictionary<Internals::FullscreenInsets>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    Internals::FullscreenInsets result;
    JSValue bottomValue;
    if (isNullOrUndefined)
        bottomValue = jsUndefined();
    else {
        bottomValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bottom"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bottomValue.isUndefined()) {
        result.bottom = convert<IDLDouble>(lexicalGlobalObject, bottomValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue leftValue;
    if (isNullOrUndefined)
        leftValue = jsUndefined();
    else {
        leftValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "left"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!leftValue.isUndefined()) {
        result.left = convert<IDLDouble>(lexicalGlobalObject, leftValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue rightValue;
    if (isNullOrUndefined)
        rightValue = jsUndefined();
    else {
        rightValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "right"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!rightValue.isUndefined()) {
        result.right = convert<IDLDouble>(lexicalGlobalObject, rightValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue topValue;
    if (isNullOrUndefined)
        topValue = jsUndefined();
    else {
        topValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "top"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!topValue.isUndefined()) {
        result.top = convert<IDLDouble>(lexicalGlobalObject, topValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const Internals::FullscreenInsets& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLDouble::isNullValue(dictionary.bottom)) {
        auto bottomValue = toJS<IDLDouble>(IDLDouble::extractValueFromNullable(dictionary.bottom));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "bottom"), bottomValue);
    }
    if (!IDLDouble::isNullValue(dictionary.left)) {
        auto leftValue = toJS<IDLDouble>(IDLDouble::extractValueFromNullable(dictionary.left));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "left"), leftValue);
    }
    if (!IDLDouble::isNullValue(dictionary.right)) {
        auto rightValue = toJS<IDLDouble>(IDLDouble::extractValueFromNullable(dictionary.right));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "right"), rightValue);
    }
    if (!IDLDouble::isNullValue(dictionary.top)) {
        auto topValue = toJS<IDLDouble>(IDLDouble::extractValueFromNullable(dictionary.top));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "top"), topValue);
    }
    return result;
}

template<> Internals::HEVCParameterSet convertDictionary<Internals::HEVCParameterSet>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    Internals::HEVCParameterSet result;
    JSValue codecNameValue;
    if (isNullOrUndefined)
        codecNameValue = jsUndefined();
    else {
        codecNameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "codecName"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!codecNameValue.isUndefined()) {
        result.codecName = convert<IDLDOMString>(lexicalGlobalObject, codecNameValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue constraintFlagsValue;
    if (isNullOrUndefined)
        constraintFlagsValue = jsUndefined();
    else {
        constraintFlagsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "constraintFlags"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!constraintFlagsValue.isUndefined()) {
        result.constraintFlags = convert<IDLSequence<IDLUnsignedShort>>(lexicalGlobalObject, constraintFlagsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue generalLevelIDCValue;
    if (isNullOrUndefined)
        generalLevelIDCValue = jsUndefined();
    else {
        generalLevelIDCValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "generalLevelIDC"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!generalLevelIDCValue.isUndefined()) {
        result.generalLevelIDC = convert<IDLUnsignedShort>(lexicalGlobalObject, generalLevelIDCValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue generalProfileCompatibilityFlagsValue;
    if (isNullOrUndefined)
        generalProfileCompatibilityFlagsValue = jsUndefined();
    else {
        generalProfileCompatibilityFlagsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "generalProfileCompatibilityFlags"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!generalProfileCompatibilityFlagsValue.isUndefined()) {
        result.generalProfileCompatibilityFlags = convert<IDLUnsignedLong>(lexicalGlobalObject, generalProfileCompatibilityFlagsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue generalProfileIDCValue;
    if (isNullOrUndefined)
        generalProfileIDCValue = jsUndefined();
    else {
        generalProfileIDCValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "generalProfileIDC"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!generalProfileIDCValue.isUndefined()) {
        result.generalProfileIDC = convert<IDLUnsignedShort>(lexicalGlobalObject, generalProfileIDCValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue generalProfileSpaceValue;
    if (isNullOrUndefined)
        generalProfileSpaceValue = jsUndefined();
    else {
        generalProfileSpaceValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "generalProfileSpace"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!generalProfileSpaceValue.isUndefined()) {
        result.generalProfileSpace = convert<IDLUnsignedShort>(lexicalGlobalObject, generalProfileSpaceValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue generalTierFlagValue;
    if (isNullOrUndefined)
        generalTierFlagValue = jsUndefined();
    else {
        generalTierFlagValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "generalTierFlag"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!generalTierFlagValue.isUndefined()) {
        result.generalTierFlag = convert<IDLBoolean>(lexicalGlobalObject, generalTierFlagValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const Internals::HEVCParameterSet& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLDOMString::isNullValue(dictionary.codecName)) {
        auto codecNameValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.codecName));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "codecName"), codecNameValue);
    }
    if (!IDLSequence<IDLUnsignedShort>::isNullValue(dictionary.constraintFlags)) {
        auto constraintFlagsValue = toJS<IDLSequence<IDLUnsignedShort>>(lexicalGlobalObject, globalObject, IDLSequence<IDLUnsignedShort>::extractValueFromNullable(dictionary.constraintFlags));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "constraintFlags"), constraintFlagsValue);
    }
    if (!IDLUnsignedShort::isNullValue(dictionary.generalLevelIDC)) {
        auto generalLevelIDCValue = toJS<IDLUnsignedShort>(IDLUnsignedShort::extractValueFromNullable(dictionary.generalLevelIDC));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "generalLevelIDC"), generalLevelIDCValue);
    }
    if (!IDLUnsignedLong::isNullValue(dictionary.generalProfileCompatibilityFlags)) {
        auto generalProfileCompatibilityFlagsValue = toJS<IDLUnsignedLong>(IDLUnsignedLong::extractValueFromNullable(dictionary.generalProfileCompatibilityFlags));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "generalProfileCompatibilityFlags"), generalProfileCompatibilityFlagsValue);
    }
    if (!IDLUnsignedShort::isNullValue(dictionary.generalProfileIDC)) {
        auto generalProfileIDCValue = toJS<IDLUnsignedShort>(IDLUnsignedShort::extractValueFromNullable(dictionary.generalProfileIDC));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "generalProfileIDC"), generalProfileIDCValue);
    }
    if (!IDLUnsignedShort::isNullValue(dictionary.generalProfileSpace)) {
        auto generalProfileSpaceValue = toJS<IDLUnsignedShort>(IDLUnsignedShort::extractValueFromNullable(dictionary.generalProfileSpace));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "generalProfileSpace"), generalProfileSpaceValue);
    }
    if (!IDLBoolean::isNullValue(dictionary.generalTierFlag)) {
        auto generalTierFlagValue = toJS<IDLBoolean>(IDLBoolean::extractValueFromNullable(dictionary.generalTierFlag));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "generalTierFlag"), generalTierFlagValue);
    }
    return result;
}

template<> Internals::DoViParameterSet convertDictionary<Internals::DoViParameterSet>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    Internals::DoViParameterSet result;
    JSValue bitstreamLevelIDValue;
    if (isNullOrUndefined)
        bitstreamLevelIDValue = jsUndefined();
    else {
        bitstreamLevelIDValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bitstreamLevelID"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bitstreamLevelIDValue.isUndefined()) {
        result.bitstreamLevelID = convert<IDLUnsignedShort>(lexicalGlobalObject, bitstreamLevelIDValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue bitstreamProfileIDValue;
    if (isNullOrUndefined)
        bitstreamProfileIDValue = jsUndefined();
    else {
        bitstreamProfileIDValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bitstreamProfileID"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bitstreamProfileIDValue.isUndefined()) {
        result.bitstreamProfileID = convert<IDLUnsignedShort>(lexicalGlobalObject, bitstreamProfileIDValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue codecNameValue;
    if (isNullOrUndefined)
        codecNameValue = jsUndefined();
    else {
        codecNameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "codecName"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!codecNameValue.isUndefined()) {
        result.codecName = convert<IDLDOMString>(lexicalGlobalObject, codecNameValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const Internals::DoViParameterSet& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLUnsignedShort::isNullValue(dictionary.bitstreamLevelID)) {
        auto bitstreamLevelIDValue = toJS<IDLUnsignedShort>(IDLUnsignedShort::extractValueFromNullable(dictionary.bitstreamLevelID));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "bitstreamLevelID"), bitstreamLevelIDValue);
    }
    if (!IDLUnsignedShort::isNullValue(dictionary.bitstreamProfileID)) {
        auto bitstreamProfileIDValue = toJS<IDLUnsignedShort>(IDLUnsignedShort::extractValueFromNullable(dictionary.bitstreamProfileID));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "bitstreamProfileID"), bitstreamProfileIDValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.codecName)) {
        auto codecNameValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.codecName));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "codecName"), codecNameValue);
    }
    return result;
}

template<> Internals::AcceleratedAnimation convertDictionary<Internals::AcceleratedAnimation>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    Internals::AcceleratedAnimation result;
    JSValue propertyValue;
    if (isNullOrUndefined)
        propertyValue = jsUndefined();
    else {
        propertyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "property"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!propertyValue.isUndefined()) {
        result.property = convert<IDLDOMString>(lexicalGlobalObject, propertyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue speedValue;
    if (isNullOrUndefined)
        speedValue = jsUndefined();
    else {
        speedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "speed"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!speedValue.isUndefined()) {
        result.speed = convert<IDLDouble>(lexicalGlobalObject, speedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const Internals::AcceleratedAnimation& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLDOMString::isNullValue(dictionary.property)) {
        auto propertyValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.property));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "property"), propertyValue);
    }
    if (!IDLDouble::isNullValue(dictionary.speed)) {
        auto speedValue = toJS<IDLDouble>(IDLDouble::extractValueFromNullable(dictionary.speed));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "speed"), speedValue);
    }
    return result;
}

template<> Internals::CookieData convertDictionary<Internals::CookieData>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    Internals::CookieData result;
    JSValue domainValue;
    if (isNullOrUndefined)
        domainValue = jsUndefined();
    else {
        domainValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "domain"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!domainValue.isUndefined()) {
        result.domain = convert<IDLDOMString>(lexicalGlobalObject, domainValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue expiresValue;
    if (isNullOrUndefined)
        expiresValue = jsUndefined();
    else {
        expiresValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "expires"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!expiresValue.isUndefined()) {
        result.expires = convert<IDLDouble>(lexicalGlobalObject, expiresValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue isHttpOnlyValue;
    if (isNullOrUndefined)
        isHttpOnlyValue = jsUndefined();
    else {
        isHttpOnlyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "isHttpOnly"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!isHttpOnlyValue.isUndefined()) {
        result.isHttpOnly = convert<IDLBoolean>(lexicalGlobalObject, isHttpOnlyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue isSameSiteLaxValue;
    if (isNullOrUndefined)
        isSameSiteLaxValue = jsUndefined();
    else {
        isSameSiteLaxValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "isSameSiteLax"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!isSameSiteLaxValue.isUndefined()) {
        result.isSameSiteLax = convert<IDLBoolean>(lexicalGlobalObject, isSameSiteLaxValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue isSameSiteStrictValue;
    if (isNullOrUndefined)
        isSameSiteStrictValue = jsUndefined();
    else {
        isSameSiteStrictValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "isSameSiteStrict"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!isSameSiteStrictValue.isUndefined()) {
        result.isSameSiteStrict = convert<IDLBoolean>(lexicalGlobalObject, isSameSiteStrictValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue isSecureValue;
    if (isNullOrUndefined)
        isSecureValue = jsUndefined();
    else {
        isSecureValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "isSecure"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!isSecureValue.isUndefined()) {
        result.isSecure = convert<IDLBoolean>(lexicalGlobalObject, isSecureValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue isSessionValue;
    if (isNullOrUndefined)
        isSessionValue = jsUndefined();
    else {
        isSessionValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "isSession"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!isSessionValue.isUndefined()) {
        result.isSession = convert<IDLBoolean>(lexicalGlobalObject, isSessionValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue nameValue;
    if (isNullOrUndefined)
        nameValue = jsUndefined();
    else {
        nameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "name"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!nameValue.isUndefined()) {
        result.name = convert<IDLDOMString>(lexicalGlobalObject, nameValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue valueValue;
    if (isNullOrUndefined)
        valueValue = jsUndefined();
    else {
        valueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "value"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!valueValue.isUndefined()) {
        result.value = convert<IDLDOMString>(lexicalGlobalObject, valueValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const Internals::CookieData& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLDOMString::isNullValue(dictionary.domain)) {
        auto domainValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.domain));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "domain"), domainValue);
    }
    if (!IDLDouble::isNullValue(dictionary.expires)) {
        auto expiresValue = toJS<IDLDouble>(IDLDouble::extractValueFromNullable(dictionary.expires));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "expires"), expiresValue);
    }
    if (!IDLBoolean::isNullValue(dictionary.isHttpOnly)) {
        auto isHttpOnlyValue = toJS<IDLBoolean>(IDLBoolean::extractValueFromNullable(dictionary.isHttpOnly));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "isHttpOnly"), isHttpOnlyValue);
    }
    if (!IDLBoolean::isNullValue(dictionary.isSameSiteLax)) {
        auto isSameSiteLaxValue = toJS<IDLBoolean>(IDLBoolean::extractValueFromNullable(dictionary.isSameSiteLax));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "isSameSiteLax"), isSameSiteLaxValue);
    }
    if (!IDLBoolean::isNullValue(dictionary.isSameSiteStrict)) {
        auto isSameSiteStrictValue = toJS<IDLBoolean>(IDLBoolean::extractValueFromNullable(dictionary.isSameSiteStrict));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "isSameSiteStrict"), isSameSiteStrictValue);
    }
    if (!IDLBoolean::isNullValue(dictionary.isSecure)) {
        auto isSecureValue = toJS<IDLBoolean>(IDLBoolean::extractValueFromNullable(dictionary.isSecure));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "isSecure"), isSecureValue);
    }
    if (!IDLBoolean::isNullValue(dictionary.isSession)) {
        auto isSessionValue = toJS<IDLBoolean>(IDLBoolean::extractValueFromNullable(dictionary.isSession));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "isSession"), isSessionValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.name)) {
        auto nameValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.name));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "name"), nameValue);
    }
    if (!IDLDOMString::isNullValue(dictionary.value)) {
        auto valueValue = toJS<IDLDOMString>(lexicalGlobalObject, IDLDOMString::extractValueFromNullable(dictionary.value));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "value"), valueValue);
    }
    return result;
}

template<> Internals::TextIndicatorInfo convertDictionary<Internals::TextIndicatorInfo>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    Internals::TextIndicatorInfo result;
    JSValue textBoundingRectInRootViewCoordinatesValue;
    if (isNullOrUndefined)
        textBoundingRectInRootViewCoordinatesValue = jsUndefined();
    else {
        textBoundingRectInRootViewCoordinatesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "textBoundingRectInRootViewCoordinates"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!textBoundingRectInRootViewCoordinatesValue.isUndefined()) {
        result.textBoundingRectInRootViewCoordinates = convert<IDLInterface<DOMRectReadOnly>>(lexicalGlobalObject, textBoundingRectInRootViewCoordinatesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue textRectsInBoundingRectCoordinatesValue;
    if (isNullOrUndefined)
        textRectsInBoundingRectCoordinatesValue = jsUndefined();
    else {
        textRectsInBoundingRectCoordinatesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "textRectsInBoundingRectCoordinates"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!textRectsInBoundingRectCoordinatesValue.isUndefined()) {
        result.textRectsInBoundingRectCoordinates = convert<IDLInterface<DOMRectList>>(lexicalGlobalObject, textRectsInBoundingRectCoordinatesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const Internals::TextIndicatorInfo& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLInterface<DOMRectReadOnly>::isNullValue(dictionary.textBoundingRectInRootViewCoordinates)) {
        auto textBoundingRectInRootViewCoordinatesValue = toJS<IDLInterface<DOMRectReadOnly>>(lexicalGlobalObject, globalObject, IDLInterface<DOMRectReadOnly>::extractValueFromNullable(dictionary.textBoundingRectInRootViewCoordinates));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "textBoundingRectInRootViewCoordinates"), textBoundingRectInRootViewCoordinatesValue);
    }
    if (!IDLInterface<DOMRectList>::isNullValue(dictionary.textRectsInBoundingRectCoordinates)) {
        auto textRectsInBoundingRectCoordinatesValue = toJS<IDLInterface<DOMRectList>>(lexicalGlobalObject, globalObject, IDLInterface<DOMRectList>::extractValueFromNullable(dictionary.textRectsInBoundingRectCoordinates));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "textRectsInBoundingRectCoordinates"), textRectsInBoundingRectCoordinatesValue);
    }
    return result;
}

template<> Internals::TextIndicatorOptions convertDictionary<Internals::TextIndicatorOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    Internals::TextIndicatorOptions result;
    JSValue computeEstimatedBackgroundColorValue;
    if (isNullOrUndefined)
        computeEstimatedBackgroundColorValue = jsUndefined();
    else {
        computeEstimatedBackgroundColorValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "computeEstimatedBackgroundColor"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!computeEstimatedBackgroundColorValue.isUndefined()) {
        result.computeEstimatedBackgroundColor = convert<IDLBoolean>(lexicalGlobalObject, computeEstimatedBackgroundColorValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.computeEstimatedBackgroundColor = false;
    JSValue respectTextColorValue;
    if (isNullOrUndefined)
        respectTextColorValue = jsUndefined();
    else {
        respectTextColorValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "respectTextColor"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!respectTextColorValue.isUndefined()) {
        result.respectTextColor = convert<IDLBoolean>(lexicalGlobalObject, respectTextColorValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.respectTextColor = false;
    JSValue useBoundingRectAndPaintAllContentForComplexRangesValue;
    if (isNullOrUndefined)
        useBoundingRectAndPaintAllContentForComplexRangesValue = jsUndefined();
    else {
        useBoundingRectAndPaintAllContentForComplexRangesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "useBoundingRectAndPaintAllContentForComplexRanges"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!useBoundingRectAndPaintAllContentForComplexRangesValue.isUndefined()) {
        result.useBoundingRectAndPaintAllContentForComplexRanges = convert<IDLBoolean>(lexicalGlobalObject, useBoundingRectAndPaintAllContentForComplexRangesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.useBoundingRectAndPaintAllContentForComplexRanges = false;
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const Internals::TextIndicatorOptions& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto computeEstimatedBackgroundColorValue = toJS<IDLBoolean>(dictionary.computeEstimatedBackgroundColor);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "computeEstimatedBackgroundColor"), computeEstimatedBackgroundColorValue);
    auto respectTextColorValue = toJS<IDLBoolean>(dictionary.respectTextColor);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "respectTextColor"), respectTextColorValue);
    auto useBoundingRectAndPaintAllContentForComplexRangesValue = toJS<IDLBoolean>(dictionary.useBoundingRectAndPaintAllContentForComplexRanges);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "useBoundingRectAndPaintAllContentForComplexRanges"), useBoundingRectAndPaintAllContentForComplexRangesValue);
    return result;
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionAddress(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNodeNeedsStyleRecalc(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionStyleChangeType(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionDescription(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionHasPausedImageAnimations(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsPaintingFrequently(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIncrementFrequentPaintCounter(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionElementRenderTreeAsText(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsPreloaded(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsLoadingFromMemoryCache(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionFetchResponseSource(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionXhrResponseSource(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsSharingStyleSheetContents(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsStyleSheetLoadingSubresources(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionClearMemoryCache(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPruneMemoryCacheToSize(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionDestroyDecodedDataForAllImages(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMemoryCacheSize(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetOverrideCachePolicy(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetOverrideResourceLoadPriority(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetStrictRawResourceValidationPolicyDisabled(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionClearBackForwardCache(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionBackForwardCacheSize(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPreventDocumentFromEnteringBackForwardCache(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionComputedStyleIncludingVisitedInfo(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionEnsureUserAgentShadowRoot(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionShadowRoot(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionDeferredStyleRulesCount(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionDeferredGroupRulesCount(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionDeferredKeyframesRulesCount(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionShadowRootType(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionShadowPseudoId(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetShadowPseudoId(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionTreeScopeRootNode(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionParentTreeScope(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionLastSpatialNavigationCandidateCount(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNumberOfActiveAnimations(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSuspendAnimations(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionResumeAnimations(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionAnimationsAreSuspended(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPauseAnimationAtTimeOnElement(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPauseAnimationAtTimeOnPseudoElement(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPauseTransitionAtTimeOnElement(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPauseTransitionAtTimeOnPseudoElement(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionAcceleratedAnimationsForElement(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNumberOfAnimationTimelineInvalidations(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPseudoElement(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionVisiblePlaceholder(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSelectColorInColorChooser(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionFormControlStateOfPreviousHistoryItem(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetFormControlStateOfPreviousHistoryItem(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionAbsoluteCaretBounds(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsCaretBlinkingSuspended(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionBoundingBox(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionInspectorHighlightRects(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMarkerCountForNode(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMarkerRangeForNode(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMarkerDescriptionForNode(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionDumpMarkerRects(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionAddTextMatchMarker(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetMarkedTextMatchesAreHighlighted(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionInvalidateFontCache(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetFontSmoothingEnabled(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetScrollViewPosition(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionUnconstrainedScrollTo(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionLayoutViewportRect(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionVisualViewportRect(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetViewIsTransparent(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionViewBaseBackgroundColor(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetViewBaseBackgroundColor(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetPagination(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetPaginationLineGridEnabled(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionConfigurationForViewport(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionWasLastChangeUserEdit(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionElementShouldAutoComplete(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetAutofilled(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetAutoFilledAndViewable(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetShowAutoFillButton(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionAutoFillButtonType(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionLastAutoFillButtonType(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetCanShowPlaceholder(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionRangeOfString(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionCountMatchesForText(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionCountFindMatches(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionAutofillFieldName(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionInvalidateControlTints(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionScrollElementToRect(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionRangeFromLocationAndLength(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionLocationFromRange(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionLengthFromRange(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionRangeAsText(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionRangeAsTextUsingBackwardsTextIterator(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSubrange(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionRangeForDictionaryLookupAtLocation(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionRangeOfStringNearLocation(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetDelegatesScrolling(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionLastSpellCheckRequestSequence(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionLastSpellCheckProcessedSequence(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionUserPreferredLanguages(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetUserPreferredLanguages(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionUserPreferredAudioCharacteristics(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetUserPreferredAudioCharacteristic(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionWheelEventHandlerCount(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionTouchEventHandlerCount(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionTouchEventRectsForEvent(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPassiveTouchEventListenerRects(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNodesFromRect(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionParserMetaData(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionUpdateEditorUINowIfScheduled(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionHasSpellingMarker(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionHasGrammarMarker(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionHasAutocorrectedMarker(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetContinuousSpellCheckingEnabled(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetAutomaticQuoteSubstitutionEnabled(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetAutomaticLinkDetectionEnabled(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetAutomaticDashSubstitutionEnabled(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetAutomaticTextReplacementEnabled(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetAutomaticSpellingCorrectionEnabled(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionHandleAcceptedCandidate(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionChangeSelectionListType(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsOverwriteModeEnabled(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionToggleOverwriteModeEnabled(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNumberOfScrollableAreas(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsPageBoxVisible(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionImageFrameIndex(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionImageFrameCount(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionImageFrameDurationAtIndex(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetImageFrameDecodingDuration(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionResetImageAnimation(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsImageAnimating(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionImagePendingDecodePromisesCountForTesting(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetClearDecoderAfterAsyncFrameRequestForTesting(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionImageDecodeCount(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPdfDocumentCachingCount(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetLargeImageAsyncDecodingEnabledForTesting(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetForceUpdateImageDataEnabledForTesting(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetGridMaxTracksLimit(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSVGAnimationsInterval(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionTestProcessIncomingSyncMessagesWhenWaitingForSyncReply(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionLayerTreeAsText(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionLayerIDForElement(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionScrollbarOverlayStyle(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionScrollbarUsingDarkAppearance(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionScrollingStateTreeAsText(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMainThreadScrollingReasons(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNonFastScrollableRects(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionRepaintRectsAsText(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetElementUsesDisplayListDrawing(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetElementTracksDisplayListReplay(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionDisplayListForElement(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionReplayDisplayListForElement(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionGarbageCollectDocumentResources(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionInsertAuthorCSS(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionInsertUserCSS(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionBeginSimulatedMemoryPressure(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionEndSimulatedMemoryPressure(JSC::JSGlobalObject*, JSC::CallFrame*);
#if ENABLE(INDEXED_DATABASE)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNumberOfIDBTransactions(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNumberOfLiveNodes(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNumberOfLiveDocuments(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionReferencingNodeCount(JSC::JSGlobalObject*, JSC::CallFrame*);
#if ENABLE(INTERSECTION_OBSERVER)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNumberOfIntersectionObservers(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionOpenDummyInspectorFrontend(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionCloseDummyInspectorFrontend(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetInspectorIsUnderTest(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionCounterValue(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPageNumber(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionShortcutIconURLs(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNumberOfPages(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPageProperty(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPageSizeAndMarginsInPixels(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetPageScaleFactor(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPageScaleFactor(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetPageZoomFactor(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetTextZoomFactor(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetUseFixedLayout(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetFixedLayoutSize(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetPrinting(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetViewExposedRect(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetHeaderHeight(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetFooterHeight(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetTopContentInset(JSC::JSGlobalObject*, JSC::CallFrame*);
#if ENABLE(FULLSCREEN_API)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionWebkitWillEnterFullScreenForElement(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(FULLSCREEN_API)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionWebkitDidEnterFullScreenForElement(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(FULLSCREEN_API)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionWebkitWillExitFullScreenForElement(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(FULLSCREEN_API)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionWebkitDidExitFullScreenForElement(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetFullscreenInsets(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetFullscreenAutoHideDuration(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetFullscreenControlsHidden(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetApplicationCacheOriginQuota(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionRegisterURLSchemeAsBypassingContentSecurityPolicy(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionRemoveURLSchemeRegisteredAsBypassingContentSecurityPolicy(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionRegisterDefaultPortForProtocol(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMallocStatistics(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionTypeConversions(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMemoryInfo(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionGetReferencedFilePaths(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionStartTrackingRepaints(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionStopTrackingRepaints(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionStartTrackingLayerFlushes(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionLayerFlushCount(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsTimerThrottled(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsRequestAnimationFrameThrottled(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionAreTimersThrottled(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetLowPowerModeEnabled(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionStartTrackingStyleRecalcs(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionStyleRecalcCount(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionStartTrackingCompositingUpdates(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionCompositingUpdateCount(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionUpdateLayoutIgnorePendingStylesheetsAndRunPostLayoutTasks(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionGetCurrentCursorInfo(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMarkerTextForListItem(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionToolTipFromElement(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionDeserializeBuffer(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSerializeObject(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsFromCurrentWorld(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionEvaluateInWorldIgnoringException(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetUsesOverlayScrollbars(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetUsesMockScrollAnimator(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionForceReload(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionReloadExpiredOnly(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionEnableAutoSizeMode(JSC::JSGlobalObject*, JSC::CallFrame*);
#if ENABLE(VIDEO)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMediaResponseSources(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(VIDEO)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMediaResponseContentRanges(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(VIDEO)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSimulateAudioInterruption(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(VIDEO)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMediaElementHasCharacteristic(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(VIDEO)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionBeginSimulatedHDCPError(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(VIDEO)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionEndSimulatedHDCPError(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(VIDEO)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionElementShouldBufferData(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(VIDEO)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionElementBufferingPolicy(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(VIDEO)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPrivatePlayerVolume(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionInitializeMockCDM(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(ENCRYPTED_MEDIA)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionRegisterMockCDM(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionEnableMockMediaCapabilities(JSC::JSGlobalObject*, JSC::CallFrame*);
#if ENABLE(SPEECH_SYNTHESIS)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionEnableMockSpeechSynthesizer(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionGetImageSourceURL(JSC::JSGlobalObject*, JSC::CallFrame*);
#if ENABLE(VIDEO_TRACK)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionCaptionsStyleSheetOverride(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(VIDEO_TRACK)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetCaptionsStyleSheetOverride(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(VIDEO_TRACK)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetPrimaryAudioTrackLanguageOverride(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(VIDEO_TRACK)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetCaptionDisplayMode(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(VIDEO_TRACK)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionCreateGenericCue(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(VIDEO)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionCreateTimeRanges(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(VIDEO)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionClosestTimeToTimeRanges(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsSelectPopupVisible(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsPluginUnavailabilityIndicatorObscured(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionUnavailablePluginReplacementText(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsPluginSnapshotted(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPluginIsBelowSizeThreshold(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSelectionBounds(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetSelectionWithoutValidation(JSC::JSGlobalObject*, JSC::CallFrame*);
#if ENABLE(MEDIA_SOURCE)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionInitializeMockMediaSource(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(MEDIA_SOURCE)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionBufferedSamplesForTrackID(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(MEDIA_SOURCE)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionEnqueuedSamplesForTrackID(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(MEDIA_SOURCE)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetShouldGenerateTimestamps(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(MEDIA_SOURCE)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMinimumUpcomingPresentationTimeForTrackID(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(MEDIA_SOURCE)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetMaximumQueueDepthForTrackID(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(VIDEO)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionBeginMediaSessionInterruption(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(VIDEO)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionEndMediaSessionInterruption(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(MEDIA_SESSION)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSendMediaSessionStartOfInterruptionNotification(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(MEDIA_SESSION)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSendMediaSessionEndOfInterruptionNotification(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(MEDIA_SESSION)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMediaSessionCurrentState(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(MEDIA_SESSION)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMediaElementPlayerVolume(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(MEDIA_SESSION)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSendMediaControlEvent(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(VIDEO)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionApplicationWillBecomeInactive(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(VIDEO)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionApplicationDidBecomeActive(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(VIDEO)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionApplicationWillEnterForeground(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(VIDEO)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionApplicationDidEnterBackground(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(VIDEO)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetMediaSessionRestrictions(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(VIDEO)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMediaSessionRestrictions(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(VIDEO)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetMediaElementRestrictions(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEB_AUDIO)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetAudioContextRestrictions(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(VIDEO)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPostRemoteControlCommand(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetMockMediaPlaybackTargetPickerEnabled(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetMockMediaPlaybackTargetPickerState(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMockMediaPlaybackTargetPickerDismissPopup(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(MEDIA_STREAM)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetCustomPrivateRecorderCreator(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEB_AUDIO)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionUseMockAudioDestinationCocoa(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEB_RTC)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionEmulateRTCPeerConnectionPlatformEvent(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEB_RTC)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionUseMockRTCPeerConnectionFactory(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEB_RTC)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetICECandidateFiltering(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEB_RTC)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetEnumeratingAllNetworkInterfacesEnabled(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEB_RTC)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionStopPeerConnection(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEB_RTC)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionClearPeerConnectionFactory(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEB_RTC)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetEnableWebRTCEncryption(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEB_RTC)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetUseDTLS10(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEB_RTC)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetUseGPUProcessForWebRTC(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(VIDEO)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSimulateSystemSleep(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(VIDEO)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSimulateSystemWake(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(VIDEO)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionElementIsBlockingDisplaySleep(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionInstallMockPageOverlay(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPageOverlayLayerTreeAsText(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetPageMuted(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPageMediaState(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetPageDefersLoading(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPageDefersLoading(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionCreateFile(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionQueueMicroTask(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionTestPreloaderSettingViewport(JSC::JSGlobalObject*, JSC::CallFrame*);
#if ENABLE(CSS_SCROLL_SNAP)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionScrollSnapOffsets(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(CSS_SCROLL_SNAP)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetPlatformMomentumScrollingPredictionEnabled(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPathStringWithShrinkWrappedRects(JSC::JSGlobalObject*, JSC::CallFrame*);
#if ENABLE(VIDEO)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionGetCurrentMediaControlsStatusForElement(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionUserVisibleString(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetShowAllPlugins(JSC::JSGlobalObject*, JSC::CallFrame*);
#if ENABLE(STREAMS_API)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionCloneArrayBuffer(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(STREAMS_API)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsReadableStreamDisturbed(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionResourceLoadStatisticsForURL(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetResourceLoadStatisticsEnabled(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetCanShowModalDialogOverride(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionComposedTreeAsText(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsProcessingUserGesture(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionLastHandledUserGestureTimestamp(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionWithUserGesture(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionUserIsInteracting(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionObserveGC(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetUserInterfaceLayoutDirection(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetBaseWritingDirection(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionUserPrefersReducedMotion(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionReportBacktrace(JSC::JSGlobalObject*, JSC::CallFrame*);
#if ENABLE(POINTER_LOCK)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPageHasPendingPointerLock(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(POINTER_LOCK)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPageHasPointerLock(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionAccessKeyModifiers(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetQuickLookPassword(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetAsRunningUserScripts(JSC::JSGlobalObject*, JSC::CallFrame*);
#if ENABLE(APPLE_PAY)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetApplePayIsActive(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionDisableTileSizeUpdateDelay(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetSpeculativeTilingDelayDisabledForTesting(JSC::JSGlobalObject*, JSC::CallFrame*);
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSimulateWebGLContextChanged(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionFailNextGPUStatusCheck(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEBGL)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionHasLowAndHighPowerGPUs(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetPageVisibility(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetPageIsFocusedAndActive(JSC::JSGlobalObject*, JSC::CallFrame*);
#if ENABLE(WEB_RTC)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetH264HardwareEncoderAllowed(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(WEB_RTC)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionApplyRotationForOutgoingVideoSources(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(MEDIA_STREAM)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetMockAudioTrackChannelNumber(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(MEDIA_STREAM)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetShouldInterruptAudioOnPageVisibilityChange(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(MEDIA_STREAM)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetCameraMediaStreamTrackOrientation(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(MEDIA_STREAM)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionObserveMediaStreamTrack(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(MEDIA_STREAM)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionGrabNextMediaStreamTrackFrame(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(MEDIA_STREAM)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionDelayMediaStreamTrackSamples(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(MEDIA_STREAM)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetMediaStreamTrackMuted(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(MEDIA_STREAM)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionRemoveMediaStreamTrack(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(MEDIA_STREAM)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSimulateMediaStreamTrackCaptureSourceFailure(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(MEDIA_STREAM)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetMediaStreamTrackIdentifier(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(MEDIA_STREAM)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetMediaStreamSourceInterrupted(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(MEDIA_STREAM)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsMockRealtimeMediaSourceCenterEnabled(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionDocumentIdentifier(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsDocumentAlive(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionElementIdentifier(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionFrameIdentifier(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPageIdentifier(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsAnyWorkletGlobalScopeAlive(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionServiceWorkerClientIdentifier(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionStoreRegistrationsOnDisk(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionClearCacheStorageMemoryRepresentation(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionCacheStorageEngineRepresentation(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetResponseSizeWithPadding(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionResponseSizeWithPadding(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionUpdateQuotaBasedOnSpaceUsage(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetConsoleMessageListener(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionAudioSessionCategory(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPreferredAudioBufferSize(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionAudioSessionActive(JSC::JSGlobalObject*, JSC::CallFrame*);
#if ENABLE(SERVICE_WORKER)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionHasServiceWorkerRegistration(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(SERVICE_WORKER)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionTerminateServiceWorker(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(SERVICE_WORKER)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsServiceWorkerRunning(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsSystemPreviewLink(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsSystemPreviewImage(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionUsingAppleInternalSDK(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPostTask(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionQueueTask(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionQueueTaskToQueueMicrotask(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionHasSameEventLoopAs(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionWindowLocationHost(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMarkContextAsInsecure(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetMaxCanvasPixelMemory(JSC::JSGlobalObject*, JSC::CallFrame*);
#if ENABLE(VIDEO)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionBestMediaElementForShowingPlaybackControlsManager(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(VIDEO)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMediaSessionState(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionOngoingLoadsDescriptions(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetCaptureExtraNetworkLoadMetricsEnabled(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionReloadWithoutContentExtensions(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetUseSystemAppearance(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPluginCount(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNotifyResourceLoadObserver(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPrimaryScreenDisplayID(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionCapsLockIsOn(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSupportsVCPEncoder(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionParseHEVCCodecParameters(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionParseDoViCodecParameters(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionGetCookies(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetAlwaysAllowLocalWebarchive(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionProcessWillSuspend(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionProcessDidResume(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionTestDictionaryLogging(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetXHRMaximumIntervalForUserGestureForwarding(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetTransientActivationDuration(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetIsPlayingToAutomotiveHeadUnit(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionTextIndicatorForRange(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionAddPrefetchLoadEventListener(JSC::JSGlobalObject*, JSC::CallFrame*);
#if ENABLE(WEB_AUTHN)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetMockWebAuthenticationConfiguration(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetPictureInPictureAPITestEnabled(JSC::JSGlobalObject*, JSC::CallFrame*);
#endif
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionCreateInternalsMapLike(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionCreateInternalsSetLike(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionHighlightPseudoElementColor(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionHasSandboxMachLookupAccessToGlobalName(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionHasSandboxMachLookupAccessToXPCServiceName(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSystemColorForCSSValue(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionFocusRingColor(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSystemHasBattery(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMediaMIMETypeForExtension(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsInternalsAnimationsInterval(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsInternalsSentenceRetroCorrectionEnabled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsInternalsSettings(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsInternalsWorkerThreadCount(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsInternalsAreSVGAnimationsPaused(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsInternalsIsUnderMemoryPressure(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#if ENABLE(FULLSCREEN_API)
JSC::EncodedJSValue jsInternalsIsAnimatingFullScreen(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
JSC::EncodedJSValue jsInternalsRequestAnimationFrameInterval(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsInternalsScriptedAnimationsAreSuspended(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsInternalsEventThrottlingBehaviorOverride(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSInternalsEventThrottlingBehaviorOverride(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsInternalsLastStyleUpdateSize(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsInternalsCompositingPolicyOverride(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSInternalsCompositingPolicyOverride(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsInternalsLayoutCount(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#if ENABLE(CONTENT_FILTERING)
JSC::EncodedJSValue jsInternalsMockContentFilterSettings(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(MEDIA_STREAM)
JSC::EncodedJSValue jsInternalsTrackAudioSampleCount(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(MEDIA_STREAM)
JSC::EncodedJSValue jsInternalsTrackVideoSampleCount(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
JSC::EncodedJSValue jsInternalsProcessIdentifier(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsInternalsSupportsAudioSession(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#if ENABLE(APPLE_PAY)
JSC::EncodedJSValue jsInternalsMockPaymentCoordinator(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif
#if ENABLE(VIDEO)
JSC::EncodedJSValue jsInternalsNowPlayingState(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
#endif

class JSInternalsPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSInternalsPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSInternalsPrototype* ptr = new (NotNull, JSC::allocateCell<JSInternalsPrototype>(vm.heap)) JSInternalsPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSInternalsPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSInternalsPrototype, JSInternalsPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSInternalsPrototypeTableValues[] =
{
    { "animationsInterval", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInternalsAnimationsInterval), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "sentenceRetroCorrectionEnabled", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInternalsSentenceRetroCorrectionEnabled), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "settings", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInternalsSettings), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "workerThreadCount", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInternalsWorkerThreadCount), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "areSVGAnimationsPaused", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInternalsAreSVGAnimationsPaused), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "isUnderMemoryPressure", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInternalsIsUnderMemoryPressure), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#if ENABLE(FULLSCREEN_API)
    { "isAnimatingFullScreen", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInternalsIsAnimatingFullScreen), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "requestAnimationFrameInterval", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInternalsRequestAnimationFrameInterval), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "scriptedAnimationsAreSuspended", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInternalsScriptedAnimationsAreSuspended), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "eventThrottlingBehaviorOverride", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInternalsEventThrottlingBehaviorOverride), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSInternalsEventThrottlingBehaviorOverride) } },
    { "lastStyleUpdateSize", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInternalsLastStyleUpdateSize), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "compositingPolicyOverride", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInternalsCompositingPolicyOverride), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSInternalsCompositingPolicyOverride) } },
    { "layoutCount", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInternalsLayoutCount), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#if ENABLE(CONTENT_FILTERING)
    { "mockContentFilterSettings", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInternalsMockContentFilterSettings), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_STREAM)
    { "trackAudioSampleCount", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInternalsTrackAudioSampleCount), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_STREAM)
    { "trackVideoSampleCount", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInternalsTrackVideoSampleCount), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "processIdentifier", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInternalsProcessIdentifier), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "supportsAudioSession", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInternalsSupportsAudioSession), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#if ENABLE(APPLE_PAY)
    { "mockPaymentCoordinator", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInternalsMockPaymentCoordinator), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO)
    { "nowPlayingState", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsInternalsNowPlayingState), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "address", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionAddress), (intptr_t) (1) } },
    { "nodeNeedsStyleRecalc", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionNodeNeedsStyleRecalc), (intptr_t) (1) } },
    { "styleChangeType", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionStyleChangeType), (intptr_t) (1) } },
    { "description", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionDescription), (intptr_t) (1) } },
    { "hasPausedImageAnimations", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionHasPausedImageAnimations), (intptr_t) (1) } },
    { "isPaintingFrequently", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionIsPaintingFrequently), (intptr_t) (1) } },
    { "incrementFrequentPaintCounter", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionIncrementFrequentPaintCounter), (intptr_t) (1) } },
    { "elementRenderTreeAsText", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionElementRenderTreeAsText), (intptr_t) (1) } },
    { "isPreloaded", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionIsPreloaded), (intptr_t) (1) } },
    { "isLoadingFromMemoryCache", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionIsLoadingFromMemoryCache), (intptr_t) (1) } },
    { "fetchResponseSource", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionFetchResponseSource), (intptr_t) (1) } },
    { "xhrResponseSource", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionXhrResponseSource), (intptr_t) (1) } },
    { "isSharingStyleSheetContents", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionIsSharingStyleSheetContents), (intptr_t) (2) } },
    { "isStyleSheetLoadingSubresources", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionIsStyleSheetLoadingSubresources), (intptr_t) (1) } },
    { "clearMemoryCache", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionClearMemoryCache), (intptr_t) (0) } },
    { "pruneMemoryCacheToSize", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionPruneMemoryCacheToSize), (intptr_t) (1) } },
    { "destroyDecodedDataForAllImages", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionDestroyDecodedDataForAllImages), (intptr_t) (0) } },
    { "memoryCacheSize", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionMemoryCacheSize), (intptr_t) (0) } },
    { "setOverrideCachePolicy", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetOverrideCachePolicy), (intptr_t) (1) } },
    { "setOverrideResourceLoadPriority", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetOverrideResourceLoadPriority), (intptr_t) (1) } },
    { "setStrictRawResourceValidationPolicyDisabled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetStrictRawResourceValidationPolicyDisabled), (intptr_t) (1) } },
    { "clearBackForwardCache", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionClearBackForwardCache), (intptr_t) (0) } },
    { "backForwardCacheSize", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionBackForwardCacheSize), (intptr_t) (0) } },
    { "preventDocumentFromEnteringBackForwardCache", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionPreventDocumentFromEnteringBackForwardCache), (intptr_t) (0) } },
    { "computedStyleIncludingVisitedInfo", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionComputedStyleIncludingVisitedInfo), (intptr_t) (1) } },
    { "ensureUserAgentShadowRoot", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionEnsureUserAgentShadowRoot), (intptr_t) (1) } },
    { "shadowRoot", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionShadowRoot), (intptr_t) (1) } },
    { "deferredStyleRulesCount", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionDeferredStyleRulesCount), (intptr_t) (1) } },
    { "deferredGroupRulesCount", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionDeferredGroupRulesCount), (intptr_t) (1) } },
    { "deferredKeyframesRulesCount", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionDeferredKeyframesRulesCount), (intptr_t) (1) } },
    { "shadowRootType", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionShadowRootType), (intptr_t) (1) } },
    { "shadowPseudoId", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionShadowPseudoId), (intptr_t) (1) } },
    { "setShadowPseudoId", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetShadowPseudoId), (intptr_t) (2) } },
    { "treeScopeRootNode", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionTreeScopeRootNode), (intptr_t) (1) } },
    { "parentTreeScope", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionParentTreeScope), (intptr_t) (1) } },
    { "lastSpatialNavigationCandidateCount", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionLastSpatialNavigationCandidateCount), (intptr_t) (0) } },
    { "numberOfActiveAnimations", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionNumberOfActiveAnimations), (intptr_t) (0) } },
    { "suspendAnimations", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSuspendAnimations), (intptr_t) (0) } },
    { "resumeAnimations", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionResumeAnimations), (intptr_t) (0) } },
    { "animationsAreSuspended", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionAnimationsAreSuspended), (intptr_t) (0) } },
    { "pauseAnimationAtTimeOnElement", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionPauseAnimationAtTimeOnElement), (intptr_t) (3) } },
    { "pauseAnimationAtTimeOnPseudoElement", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionPauseAnimationAtTimeOnPseudoElement), (intptr_t) (4) } },
    { "pauseTransitionAtTimeOnElement", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionPauseTransitionAtTimeOnElement), (intptr_t) (3) } },
    { "pauseTransitionAtTimeOnPseudoElement", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionPauseTransitionAtTimeOnPseudoElement), (intptr_t) (4) } },
    { "acceleratedAnimationsForElement", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionAcceleratedAnimationsForElement), (intptr_t) (1) } },
    { "numberOfAnimationTimelineInvalidations", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionNumberOfAnimationTimelineInvalidations), (intptr_t) (0) } },
    { "pseudoElement", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionPseudoElement), (intptr_t) (2) } },
    { "visiblePlaceholder", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionVisiblePlaceholder), (intptr_t) (1) } },
    { "selectColorInColorChooser", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSelectColorInColorChooser), (intptr_t) (2) } },
    { "formControlStateOfPreviousHistoryItem", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionFormControlStateOfPreviousHistoryItem), (intptr_t) (0) } },
    { "setFormControlStateOfPreviousHistoryItem", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetFormControlStateOfPreviousHistoryItem), (intptr_t) (1) } },
    { "absoluteCaretBounds", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionAbsoluteCaretBounds), (intptr_t) (0) } },
    { "isCaretBlinkingSuspended", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionIsCaretBlinkingSuspended), (intptr_t) (0) } },
    { "boundingBox", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionBoundingBox), (intptr_t) (1) } },
    { "inspectorHighlightRects", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionInspectorHighlightRects), (intptr_t) (0) } },
    { "markerCountForNode", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionMarkerCountForNode), (intptr_t) (2) } },
    { "markerRangeForNode", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionMarkerRangeForNode), (intptr_t) (3) } },
    { "markerDescriptionForNode", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionMarkerDescriptionForNode), (intptr_t) (3) } },
    { "dumpMarkerRects", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionDumpMarkerRects), (intptr_t) (1) } },
    { "addTextMatchMarker", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionAddTextMatchMarker), (intptr_t) (2) } },
    { "setMarkedTextMatchesAreHighlighted", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetMarkedTextMatchesAreHighlighted), (intptr_t) (1) } },
    { "invalidateFontCache", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionInvalidateFontCache), (intptr_t) (0) } },
    { "setFontSmoothingEnabled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetFontSmoothingEnabled), (intptr_t) (1) } },
    { "setScrollViewPosition", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetScrollViewPosition), (intptr_t) (2) } },
    { "unconstrainedScrollTo", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionUnconstrainedScrollTo), (intptr_t) (3) } },
    { "layoutViewportRect", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionLayoutViewportRect), (intptr_t) (0) } },
    { "visualViewportRect", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionVisualViewportRect), (intptr_t) (0) } },
    { "setViewIsTransparent", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetViewIsTransparent), (intptr_t) (1) } },
    { "viewBaseBackgroundColor", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionViewBaseBackgroundColor), (intptr_t) (0) } },
    { "setViewBaseBackgroundColor", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetViewBaseBackgroundColor), (intptr_t) (1) } },
    { "setPagination", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetPagination), (intptr_t) (2) } },
    { "setPaginationLineGridEnabled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetPaginationLineGridEnabled), (intptr_t) (1) } },
    { "configurationForViewport", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionConfigurationForViewport), (intptr_t) (5) } },
    { "wasLastChangeUserEdit", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionWasLastChangeUserEdit), (intptr_t) (1) } },
    { "elementShouldAutoComplete", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionElementShouldAutoComplete), (intptr_t) (1) } },
    { "setAutofilled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetAutofilled), (intptr_t) (2) } },
    { "setAutoFilledAndViewable", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetAutoFilledAndViewable), (intptr_t) (2) } },
    { "setShowAutoFillButton", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetShowAutoFillButton), (intptr_t) (2) } },
    { "autoFillButtonType", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionAutoFillButtonType), (intptr_t) (1) } },
    { "lastAutoFillButtonType", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionLastAutoFillButtonType), (intptr_t) (1) } },
    { "setCanShowPlaceholder", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetCanShowPlaceholder), (intptr_t) (2) } },
    { "rangeOfString", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionRangeOfString), (intptr_t) (3) } },
    { "countMatchesForText", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionCountMatchesForText), (intptr_t) (3) } },
    { "countFindMatches", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionCountFindMatches), (intptr_t) (2) } },
    { "autofillFieldName", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionAutofillFieldName), (intptr_t) (1) } },
    { "invalidateControlTints", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionInvalidateControlTints), (intptr_t) (0) } },
    { "scrollElementToRect", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionScrollElementToRect), (intptr_t) (5) } },
    { "rangeFromLocationAndLength", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionRangeFromLocationAndLength), (intptr_t) (3) } },
    { "locationFromRange", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionLocationFromRange), (intptr_t) (2) } },
    { "lengthFromRange", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionLengthFromRange), (intptr_t) (2) } },
    { "rangeAsText", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionRangeAsText), (intptr_t) (1) } },
    { "rangeAsTextUsingBackwardsTextIterator", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionRangeAsTextUsingBackwardsTextIterator), (intptr_t) (1) } },
    { "subrange", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSubrange), (intptr_t) (3) } },
    { "rangeForDictionaryLookupAtLocation", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionRangeForDictionaryLookupAtLocation), (intptr_t) (2) } },
    { "rangeOfStringNearLocation", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionRangeOfStringNearLocation), (intptr_t) (3) } },
    { "setDelegatesScrolling", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetDelegatesScrolling), (intptr_t) (1) } },
    { "lastSpellCheckRequestSequence", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionLastSpellCheckRequestSequence), (intptr_t) (0) } },
    { "lastSpellCheckProcessedSequence", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionLastSpellCheckProcessedSequence), (intptr_t) (0) } },
    { "userPreferredLanguages", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionUserPreferredLanguages), (intptr_t) (0) } },
    { "setUserPreferredLanguages", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetUserPreferredLanguages), (intptr_t) (1) } },
    { "userPreferredAudioCharacteristics", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionUserPreferredAudioCharacteristics), (intptr_t) (0) } },
    { "setUserPreferredAudioCharacteristic", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetUserPreferredAudioCharacteristic), (intptr_t) (1) } },
    { "wheelEventHandlerCount", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionWheelEventHandlerCount), (intptr_t) (0) } },
    { "touchEventHandlerCount", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionTouchEventHandlerCount), (intptr_t) (0) } },
    { "touchEventRectsForEvent", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionTouchEventRectsForEvent), (intptr_t) (1) } },
    { "passiveTouchEventListenerRects", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionPassiveTouchEventListenerRects), (intptr_t) (0) } },
    { "nodesFromRect", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionNodesFromRect), (intptr_t) (10) } },
    { "parserMetaData", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionParserMetaData), (intptr_t) (0) } },
    { "updateEditorUINowIfScheduled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionUpdateEditorUINowIfScheduled), (intptr_t) (0) } },
    { "hasSpellingMarker", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionHasSpellingMarker), (intptr_t) (2) } },
    { "hasGrammarMarker", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionHasGrammarMarker), (intptr_t) (2) } },
    { "hasAutocorrectedMarker", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionHasAutocorrectedMarker), (intptr_t) (2) } },
    { "setContinuousSpellCheckingEnabled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetContinuousSpellCheckingEnabled), (intptr_t) (1) } },
    { "setAutomaticQuoteSubstitutionEnabled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetAutomaticQuoteSubstitutionEnabled), (intptr_t) (1) } },
    { "setAutomaticLinkDetectionEnabled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetAutomaticLinkDetectionEnabled), (intptr_t) (1) } },
    { "setAutomaticDashSubstitutionEnabled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetAutomaticDashSubstitutionEnabled), (intptr_t) (1) } },
    { "setAutomaticTextReplacementEnabled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetAutomaticTextReplacementEnabled), (intptr_t) (1) } },
    { "setAutomaticSpellingCorrectionEnabled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetAutomaticSpellingCorrectionEnabled), (intptr_t) (1) } },
    { "handleAcceptedCandidate", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionHandleAcceptedCandidate), (intptr_t) (3) } },
    { "changeSelectionListType", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionChangeSelectionListType), (intptr_t) (0) } },
    { "isOverwriteModeEnabled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionIsOverwriteModeEnabled), (intptr_t) (0) } },
    { "toggleOverwriteModeEnabled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionToggleOverwriteModeEnabled), (intptr_t) (0) } },
    { "numberOfScrollableAreas", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionNumberOfScrollableAreas), (intptr_t) (0) } },
    { "isPageBoxVisible", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionIsPageBoxVisible), (intptr_t) (1) } },
    { "imageFrameIndex", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionImageFrameIndex), (intptr_t) (1) } },
    { "imageFrameCount", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionImageFrameCount), (intptr_t) (1) } },
    { "imageFrameDurationAtIndex", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionImageFrameDurationAtIndex), (intptr_t) (2) } },
    { "setImageFrameDecodingDuration", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetImageFrameDecodingDuration), (intptr_t) (2) } },
    { "resetImageAnimation", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionResetImageAnimation), (intptr_t) (1) } },
    { "isImageAnimating", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionIsImageAnimating), (intptr_t) (1) } },
    { "imagePendingDecodePromisesCountForTesting", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionImagePendingDecodePromisesCountForTesting), (intptr_t) (1) } },
    { "setClearDecoderAfterAsyncFrameRequestForTesting", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetClearDecoderAfterAsyncFrameRequestForTesting), (intptr_t) (2) } },
    { "imageDecodeCount", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionImageDecodeCount), (intptr_t) (1) } },
    { "pdfDocumentCachingCount", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionPdfDocumentCachingCount), (intptr_t) (1) } },
    { "setLargeImageAsyncDecodingEnabledForTesting", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetLargeImageAsyncDecodingEnabledForTesting), (intptr_t) (2) } },
    { "setForceUpdateImageDataEnabledForTesting", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetForceUpdateImageDataEnabledForTesting), (intptr_t) (2) } },
    { "setGridMaxTracksLimit", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetGridMaxTracksLimit), (intptr_t) (1) } },
    { "svgAnimationsInterval", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSVGAnimationsInterval), (intptr_t) (1) } },
    { "testProcessIncomingSyncMessagesWhenWaitingForSyncReply", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionTestProcessIncomingSyncMessagesWhenWaitingForSyncReply), (intptr_t) (0) } },
    { "layerTreeAsText", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionLayerTreeAsText), (intptr_t) (1) } },
    { "layerIDForElement", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionLayerIDForElement), (intptr_t) (1) } },
    { "scrollbarOverlayStyle", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionScrollbarOverlayStyle), (intptr_t) (0) } },
    { "scrollbarUsingDarkAppearance", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionScrollbarUsingDarkAppearance), (intptr_t) (0) } },
    { "scrollingStateTreeAsText", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionScrollingStateTreeAsText), (intptr_t) (0) } },
    { "mainThreadScrollingReasons", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionMainThreadScrollingReasons), (intptr_t) (0) } },
    { "nonFastScrollableRects", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionNonFastScrollableRects), (intptr_t) (0) } },
    { "repaintRectsAsText", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionRepaintRectsAsText), (intptr_t) (0) } },
    { "setElementUsesDisplayListDrawing", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetElementUsesDisplayListDrawing), (intptr_t) (2) } },
    { "setElementTracksDisplayListReplay", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetElementTracksDisplayListReplay), (intptr_t) (2) } },
    { "displayListForElement", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionDisplayListForElement), (intptr_t) (1) } },
    { "replayDisplayListForElement", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionReplayDisplayListForElement), (intptr_t) (1) } },
    { "garbageCollectDocumentResources", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionGarbageCollectDocumentResources), (intptr_t) (0) } },
    { "insertAuthorCSS", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionInsertAuthorCSS), (intptr_t) (1) } },
    { "insertUserCSS", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionInsertUserCSS), (intptr_t) (1) } },
    { "beginSimulatedMemoryPressure", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionBeginSimulatedMemoryPressure), (intptr_t) (0) } },
    { "endSimulatedMemoryPressure", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionEndSimulatedMemoryPressure), (intptr_t) (0) } },
#if ENABLE(INDEXED_DATABASE)
    { "numberOfIDBTransactions", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionNumberOfIDBTransactions), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "numberOfLiveNodes", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionNumberOfLiveNodes), (intptr_t) (0) } },
    { "numberOfLiveDocuments", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionNumberOfLiveDocuments), (intptr_t) (0) } },
    { "referencingNodeCount", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionReferencingNodeCount), (intptr_t) (1) } },
#if ENABLE(INTERSECTION_OBSERVER)
    { "numberOfIntersectionObservers", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionNumberOfIntersectionObservers), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "openDummyInspectorFrontend", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionOpenDummyInspectorFrontend), (intptr_t) (1) } },
    { "closeDummyInspectorFrontend", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionCloseDummyInspectorFrontend), (intptr_t) (0) } },
    { "setInspectorIsUnderTest", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetInspectorIsUnderTest), (intptr_t) (1) } },
    { "counterValue", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionCounterValue), (intptr_t) (1) } },
    { "pageNumber", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionPageNumber), (intptr_t) (1) } },
    { "shortcutIconURLs", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionShortcutIconURLs), (intptr_t) (0) } },
    { "numberOfPages", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionNumberOfPages), (intptr_t) (0) } },
    { "pageProperty", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionPageProperty), (intptr_t) (2) } },
    { "pageSizeAndMarginsInPixels", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionPageSizeAndMarginsInPixels), (intptr_t) (7) } },
    { "setPageScaleFactor", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetPageScaleFactor), (intptr_t) (3) } },
    { "pageScaleFactor", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionPageScaleFactor), (intptr_t) (0) } },
    { "setPageZoomFactor", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetPageZoomFactor), (intptr_t) (1) } },
    { "setTextZoomFactor", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetTextZoomFactor), (intptr_t) (1) } },
    { "setUseFixedLayout", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetUseFixedLayout), (intptr_t) (1) } },
    { "setFixedLayoutSize", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetFixedLayoutSize), (intptr_t) (2) } },
    { "setPrinting", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetPrinting), (intptr_t) (2) } },
    { "setViewExposedRect", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetViewExposedRect), (intptr_t) (4) } },
    { "setHeaderHeight", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetHeaderHeight), (intptr_t) (1) } },
    { "setFooterHeight", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetFooterHeight), (intptr_t) (1) } },
    { "setTopContentInset", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetTopContentInset), (intptr_t) (1) } },
#if ENABLE(FULLSCREEN_API)
    { "webkitWillEnterFullScreenForElement", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionWebkitWillEnterFullScreenForElement), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(FULLSCREEN_API)
    { "webkitDidEnterFullScreenForElement", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionWebkitDidEnterFullScreenForElement), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(FULLSCREEN_API)
    { "webkitWillExitFullScreenForElement", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionWebkitWillExitFullScreenForElement), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(FULLSCREEN_API)
    { "webkitDidExitFullScreenForElement", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionWebkitDidExitFullScreenForElement), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "setFullscreenInsets", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetFullscreenInsets), (intptr_t) (1) } },
    { "setFullscreenAutoHideDuration", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetFullscreenAutoHideDuration), (intptr_t) (1) } },
    { "setFullscreenControlsHidden", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetFullscreenControlsHidden), (intptr_t) (1) } },
    { "setApplicationCacheOriginQuota", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetApplicationCacheOriginQuota), (intptr_t) (1) } },
    { "registerURLSchemeAsBypassingContentSecurityPolicy", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionRegisterURLSchemeAsBypassingContentSecurityPolicy), (intptr_t) (1) } },
    { "removeURLSchemeRegisteredAsBypassingContentSecurityPolicy", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionRemoveURLSchemeRegisteredAsBypassingContentSecurityPolicy), (intptr_t) (1) } },
    { "registerDefaultPortForProtocol", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionRegisterDefaultPortForProtocol), (intptr_t) (2) } },
    { "mallocStatistics", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionMallocStatistics), (intptr_t) (0) } },
    { "typeConversions", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionTypeConversions), (intptr_t) (0) } },
    { "memoryInfo", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionMemoryInfo), (intptr_t) (0) } },
    { "getReferencedFilePaths", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionGetReferencedFilePaths), (intptr_t) (0) } },
    { "startTrackingRepaints", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionStartTrackingRepaints), (intptr_t) (0) } },
    { "stopTrackingRepaints", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionStopTrackingRepaints), (intptr_t) (0) } },
    { "startTrackingLayerFlushes", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionStartTrackingLayerFlushes), (intptr_t) (0) } },
    { "layerFlushCount", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionLayerFlushCount), (intptr_t) (0) } },
    { "isTimerThrottled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionIsTimerThrottled), (intptr_t) (1) } },
    { "isRequestAnimationFrameThrottled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionIsRequestAnimationFrameThrottled), (intptr_t) (0) } },
    { "areTimersThrottled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionAreTimersThrottled), (intptr_t) (0) } },
    { "setLowPowerModeEnabled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetLowPowerModeEnabled), (intptr_t) (1) } },
    { "startTrackingStyleRecalcs", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionStartTrackingStyleRecalcs), (intptr_t) (0) } },
    { "styleRecalcCount", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionStyleRecalcCount), (intptr_t) (0) } },
    { "startTrackingCompositingUpdates", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionStartTrackingCompositingUpdates), (intptr_t) (0) } },
    { "compositingUpdateCount", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionCompositingUpdateCount), (intptr_t) (0) } },
    { "updateLayoutIgnorePendingStylesheetsAndRunPostLayoutTasks", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionUpdateLayoutIgnorePendingStylesheetsAndRunPostLayoutTasks), (intptr_t) (0) } },
    { "getCurrentCursorInfo", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionGetCurrentCursorInfo), (intptr_t) (0) } },
    { "markerTextForListItem", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionMarkerTextForListItem), (intptr_t) (1) } },
    { "toolTipFromElement", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionToolTipFromElement), (intptr_t) (1) } },
    { "deserializeBuffer", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionDeserializeBuffer), (intptr_t) (1) } },
    { "serializeObject", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSerializeObject), (intptr_t) (1) } },
    { "isFromCurrentWorld", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionIsFromCurrentWorld), (intptr_t) (1) } },
    { "evaluateInWorldIgnoringException", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionEvaluateInWorldIgnoringException), (intptr_t) (2) } },
    { "setUsesOverlayScrollbars", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetUsesOverlayScrollbars), (intptr_t) (1) } },
    { "setUsesMockScrollAnimator", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetUsesMockScrollAnimator), (intptr_t) (1) } },
    { "forceReload", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionForceReload), (intptr_t) (1) } },
    { "reloadExpiredOnly", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionReloadExpiredOnly), (intptr_t) (0) } },
    { "enableAutoSizeMode", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionEnableAutoSizeMode), (intptr_t) (3) } },
#if ENABLE(VIDEO)
    { "mediaResponseSources", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionMediaResponseSources), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO)
    { "mediaResponseContentRanges", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionMediaResponseContentRanges), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO)
    { "simulateAudioInterruption", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSimulateAudioInterruption), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO)
    { "mediaElementHasCharacteristic", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionMediaElementHasCharacteristic), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO)
    { "beginSimulatedHDCPError", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionBeginSimulatedHDCPError), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO)
    { "endSimulatedHDCPError", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionEndSimulatedHDCPError), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO)
    { "elementShouldBufferData", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionElementShouldBufferData), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO)
    { "elementBufferingPolicy", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionElementBufferingPolicy), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO)
    { "privatePlayerVolume", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionPrivatePlayerVolume), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
    { "initializeMockCDM", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionInitializeMockCDM), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(ENCRYPTED_MEDIA)
    { "registerMockCDM", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionRegisterMockCDM), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "enableMockMediaCapabilities", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionEnableMockMediaCapabilities), (intptr_t) (0) } },
#if ENABLE(SPEECH_SYNTHESIS)
    { "enableMockSpeechSynthesizer", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionEnableMockSpeechSynthesizer), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "getImageSourceURL", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionGetImageSourceURL), (intptr_t) (1) } },
#if ENABLE(VIDEO_TRACK)
    { "captionsStyleSheetOverride", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionCaptionsStyleSheetOverride), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO_TRACK)
    { "setCaptionsStyleSheetOverride", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetCaptionsStyleSheetOverride), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO_TRACK)
    { "setPrimaryAudioTrackLanguageOverride", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetPrimaryAudioTrackLanguageOverride), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO_TRACK)
    { "setCaptionDisplayMode", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetCaptionDisplayMode), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO_TRACK)
    { "createGenericCue", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionCreateGenericCue), (intptr_t) (3) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO)
    { "createTimeRanges", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionCreateTimeRanges), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO)
    { "closestTimeToTimeRanges", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionClosestTimeToTimeRanges), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "isSelectPopupVisible", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionIsSelectPopupVisible), (intptr_t) (1) } },
    { "isPluginUnavailabilityIndicatorObscured", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionIsPluginUnavailabilityIndicatorObscured), (intptr_t) (1) } },
    { "unavailablePluginReplacementText", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionUnavailablePluginReplacementText), (intptr_t) (1) } },
    { "isPluginSnapshotted", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionIsPluginSnapshotted), (intptr_t) (1) } },
    { "pluginIsBelowSizeThreshold", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionPluginIsBelowSizeThreshold), (intptr_t) (1) } },
    { "selectionBounds", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSelectionBounds), (intptr_t) (0) } },
    { "setSelectionWithoutValidation", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetSelectionWithoutValidation), (intptr_t) (4) } },
#if ENABLE(MEDIA_SOURCE)
    { "initializeMockMediaSource", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionInitializeMockMediaSource), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_SOURCE)
    { "bufferedSamplesForTrackID", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionBufferedSamplesForTrackID), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_SOURCE)
    { "enqueuedSamplesForTrackID", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionEnqueuedSamplesForTrackID), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_SOURCE)
    { "setShouldGenerateTimestamps", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetShouldGenerateTimestamps), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_SOURCE)
    { "minimumUpcomingPresentationTimeForTrackID", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionMinimumUpcomingPresentationTimeForTrackID), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_SOURCE)
    { "setMaximumQueueDepthForTrackID", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetMaximumQueueDepthForTrackID), (intptr_t) (3) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO)
    { "beginMediaSessionInterruption", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionBeginMediaSessionInterruption), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO)
    { "endMediaSessionInterruption", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionEndMediaSessionInterruption), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_SESSION)
    { "sendMediaSessionStartOfInterruptionNotification", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSendMediaSessionStartOfInterruptionNotification), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_SESSION)
    { "sendMediaSessionEndOfInterruptionNotification", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSendMediaSessionEndOfInterruptionNotification), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_SESSION)
    { "mediaSessionCurrentState", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionMediaSessionCurrentState), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_SESSION)
    { "mediaElementPlayerVolume", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionMediaElementPlayerVolume), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_SESSION)
    { "sendMediaControlEvent", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSendMediaControlEvent), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO)
    { "applicationWillBecomeInactive", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionApplicationWillBecomeInactive), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO)
    { "applicationDidBecomeActive", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionApplicationDidBecomeActive), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO)
    { "applicationWillEnterForeground", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionApplicationWillEnterForeground), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO)
    { "applicationDidEnterBackground", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionApplicationDidEnterBackground), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO)
    { "setMediaSessionRestrictions", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetMediaSessionRestrictions), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO)
    { "mediaSessionRestrictions", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionMediaSessionRestrictions), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO)
    { "setMediaElementRestrictions", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetMediaElementRestrictions), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEB_AUDIO)
    { "setAudioContextRestrictions", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetAudioContextRestrictions), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO)
    { "postRemoteControlCommand", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionPostRemoteControlCommand), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
    { "setMockMediaPlaybackTargetPickerEnabled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetMockMediaPlaybackTargetPickerEnabled), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
    { "setMockMediaPlaybackTargetPickerState", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetMockMediaPlaybackTargetPickerState), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WIRELESS_PLAYBACK_TARGET)
    { "mockMediaPlaybackTargetPickerDismissPopup", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionMockMediaPlaybackTargetPickerDismissPopup), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_STREAM)
    { "setCustomPrivateRecorderCreator", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetCustomPrivateRecorderCreator), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEB_AUDIO)
    { "useMockAudioDestinationCocoa", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionUseMockAudioDestinationCocoa), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEB_RTC)
    { "emulateRTCPeerConnectionPlatformEvent", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionEmulateRTCPeerConnectionPlatformEvent), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEB_RTC)
    { "useMockRTCPeerConnectionFactory", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionUseMockRTCPeerConnectionFactory), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEB_RTC)
    { "setICECandidateFiltering", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetICECandidateFiltering), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEB_RTC)
    { "setEnumeratingAllNetworkInterfacesEnabled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetEnumeratingAllNetworkInterfacesEnabled), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEB_RTC)
    { "stopPeerConnection", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionStopPeerConnection), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEB_RTC)
    { "clearPeerConnectionFactory", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionClearPeerConnectionFactory), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEB_RTC)
    { "setEnableWebRTCEncryption", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetEnableWebRTCEncryption), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEB_RTC)
    { "setUseDTLS10", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetUseDTLS10), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEB_RTC)
    { "setUseGPUProcessForWebRTC", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetUseGPUProcessForWebRTC), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO)
    { "simulateSystemSleep", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSimulateSystemSleep), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO)
    { "simulateSystemWake", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSimulateSystemWake), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO)
    { "elementIsBlockingDisplaySleep", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionElementIsBlockingDisplaySleep), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "installMockPageOverlay", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionInstallMockPageOverlay), (intptr_t) (1) } },
    { "pageOverlayLayerTreeAsText", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionPageOverlayLayerTreeAsText), (intptr_t) (0) } },
    { "setPageMuted", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetPageMuted), (intptr_t) (1) } },
    { "pageMediaState", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionPageMediaState), (intptr_t) (0) } },
    { "setPageDefersLoading", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetPageDefersLoading), (intptr_t) (1) } },
    { "pageDefersLoading", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionPageDefersLoading), (intptr_t) (0) } },
    { "createFile", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionCreateFile), (intptr_t) (1) } },
    { "queueMicroTask", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionQueueMicroTask), (intptr_t) (1) } },
    { "testPreloaderSettingViewport", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionTestPreloaderSettingViewport), (intptr_t) (0) } },
#if ENABLE(CSS_SCROLL_SNAP)
    { "scrollSnapOffsets", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionScrollSnapOffsets), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(CSS_SCROLL_SNAP)
    { "setPlatformMomentumScrollingPredictionEnabled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetPlatformMomentumScrollingPredictionEnabled), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "pathStringWithShrinkWrappedRects", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionPathStringWithShrinkWrappedRects), (intptr_t) (2) } },
#if ENABLE(VIDEO)
    { "getCurrentMediaControlsStatusForElement", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionGetCurrentMediaControlsStatusForElement), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "userVisibleString", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionUserVisibleString), (intptr_t) (1) } },
    { "setShowAllPlugins", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetShowAllPlugins), (intptr_t) (1) } },
#if ENABLE(STREAMS_API)
    { "cloneArrayBuffer", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionCloneArrayBuffer), (intptr_t) (3) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(STREAMS_API)
    { "isReadableStreamDisturbed", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionIsReadableStreamDisturbed), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "resourceLoadStatisticsForURL", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionResourceLoadStatisticsForURL), (intptr_t) (1) } },
    { "setResourceLoadStatisticsEnabled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetResourceLoadStatisticsEnabled), (intptr_t) (1) } },
    { "setCanShowModalDialogOverride", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetCanShowModalDialogOverride), (intptr_t) (1) } },
    { "composedTreeAsText", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionComposedTreeAsText), (intptr_t) (1) } },
    { "isProcessingUserGesture", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionIsProcessingUserGesture), (intptr_t) (0) } },
    { "lastHandledUserGestureTimestamp", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionLastHandledUserGestureTimestamp), (intptr_t) (0) } },
    { "withUserGesture", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionWithUserGesture), (intptr_t) (1) } },
    { "userIsInteracting", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionUserIsInteracting), (intptr_t) (0) } },
    { "observeGC", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionObserveGC), (intptr_t) (1) } },
    { "setUserInterfaceLayoutDirection", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetUserInterfaceLayoutDirection), (intptr_t) (1) } },
    { "setBaseWritingDirection", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetBaseWritingDirection), (intptr_t) (1) } },
    { "userPrefersReducedMotion", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionUserPrefersReducedMotion), (intptr_t) (0) } },
    { "reportBacktrace", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionReportBacktrace), (intptr_t) (0) } },
#if ENABLE(POINTER_LOCK)
    { "pageHasPendingPointerLock", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionPageHasPendingPointerLock), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(POINTER_LOCK)
    { "pageHasPointerLock", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionPageHasPointerLock), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "accessKeyModifiers", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionAccessKeyModifiers), (intptr_t) (0) } },
    { "setQuickLookPassword", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetQuickLookPassword), (intptr_t) (1) } },
    { "setAsRunningUserScripts", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetAsRunningUserScripts), (intptr_t) (0) } },
#if ENABLE(APPLE_PAY)
    { "setApplePayIsActive", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetApplePayIsActive), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "disableTileSizeUpdateDelay", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionDisableTileSizeUpdateDelay), (intptr_t) (0) } },
    { "setSpeculativeTilingDelayDisabledForTesting", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetSpeculativeTilingDelayDisabledForTesting), (intptr_t) (1) } },
#if ENABLE(WEBGL)
    { "simulateWebGLContextChanged", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSimulateWebGLContextChanged), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "failNextGPUStatusCheck", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionFailNextGPUStatusCheck), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEBGL)
    { "hasLowAndHighPowerGPUs", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionHasLowAndHighPowerGPUs), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "setPageVisibility", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetPageVisibility), (intptr_t) (1) } },
    { "setPageIsFocusedAndActive", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetPageIsFocusedAndActive), (intptr_t) (1) } },
#if ENABLE(WEB_RTC)
    { "setH264HardwareEncoderAllowed", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetH264HardwareEncoderAllowed), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(WEB_RTC)
    { "applyRotationForOutgoingVideoSources", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionApplyRotationForOutgoingVideoSources), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_STREAM)
    { "setMockAudioTrackChannelNumber", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetMockAudioTrackChannelNumber), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_STREAM)
    { "setShouldInterruptAudioOnPageVisibilityChange", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetShouldInterruptAudioOnPageVisibilityChange), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_STREAM)
    { "setCameraMediaStreamTrackOrientation", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetCameraMediaStreamTrackOrientation), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_STREAM)
    { "observeMediaStreamTrack", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionObserveMediaStreamTrack), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_STREAM)
    { "grabNextMediaStreamTrackFrame", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionGrabNextMediaStreamTrackFrame), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_STREAM)
    { "delayMediaStreamTrackSamples", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionDelayMediaStreamTrackSamples), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_STREAM)
    { "setMediaStreamTrackMuted", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetMediaStreamTrackMuted), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_STREAM)
    { "removeMediaStreamTrack", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionRemoveMediaStreamTrack), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_STREAM)
    { "simulateMediaStreamTrackCaptureSourceFailure", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSimulateMediaStreamTrackCaptureSourceFailure), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_STREAM)
    { "setMediaStreamTrackIdentifier", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetMediaStreamTrackIdentifier), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_STREAM)
    { "setMediaStreamSourceInterrupted", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetMediaStreamSourceInterrupted), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(MEDIA_STREAM)
    { "isMockRealtimeMediaSourceCenterEnabled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionIsMockRealtimeMediaSourceCenterEnabled), (intptr_t) (0) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "documentIdentifier", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionDocumentIdentifier), (intptr_t) (1) } },
    { "isDocumentAlive", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionIsDocumentAlive), (intptr_t) (1) } },
    { "elementIdentifier", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionElementIdentifier), (intptr_t) (1) } },
    { "frameIdentifier", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionFrameIdentifier), (intptr_t) (1) } },
    { "pageIdentifier", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionPageIdentifier), (intptr_t) (1) } },
    { "isAnyWorkletGlobalScopeAlive", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionIsAnyWorkletGlobalScopeAlive), (intptr_t) (0) } },
    { "serviceWorkerClientIdentifier", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionServiceWorkerClientIdentifier), (intptr_t) (1) } },
    { "storeRegistrationsOnDisk", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionStoreRegistrationsOnDisk), (intptr_t) (0) } },
    { "clearCacheStorageMemoryRepresentation", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionClearCacheStorageMemoryRepresentation), (intptr_t) (0) } },
    { "cacheStorageEngineRepresentation", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionCacheStorageEngineRepresentation), (intptr_t) (0) } },
    { "setResponseSizeWithPadding", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetResponseSizeWithPadding), (intptr_t) (2) } },
    { "responseSizeWithPadding", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionResponseSizeWithPadding), (intptr_t) (1) } },
    { "updateQuotaBasedOnSpaceUsage", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionUpdateQuotaBasedOnSpaceUsage), (intptr_t) (0) } },
    { "setConsoleMessageListener", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetConsoleMessageListener), (intptr_t) (1) } },
    { "audioSessionCategory", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionAudioSessionCategory), (intptr_t) (0) } },
    { "preferredAudioBufferSize", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionPreferredAudioBufferSize), (intptr_t) (0) } },
    { "audioSessionActive", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionAudioSessionActive), (intptr_t) (0) } },
#if ENABLE(SERVICE_WORKER)
    { "hasServiceWorkerRegistration", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionHasServiceWorkerRegistration), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(SERVICE_WORKER)
    { "terminateServiceWorker", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionTerminateServiceWorker), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(SERVICE_WORKER)
    { "isServiceWorkerRunning", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionIsServiceWorkerRunning), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "isSystemPreviewLink", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionIsSystemPreviewLink), (intptr_t) (1) } },
    { "isSystemPreviewImage", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionIsSystemPreviewImage), (intptr_t) (1) } },
    { "usingAppleInternalSDK", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionUsingAppleInternalSDK), (intptr_t) (0) } },
    { "postTask", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionPostTask), (intptr_t) (1) } },
    { "queueTask", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionQueueTask), (intptr_t) (2) } },
    { "queueTaskToQueueMicrotask", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionQueueTaskToQueueMicrotask), (intptr_t) (2) } },
    { "hasSameEventLoopAs", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionHasSameEventLoopAs), (intptr_t) (1) } },
    { "windowLocationHost", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionWindowLocationHost), (intptr_t) (1) } },
    { "markContextAsInsecure", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionMarkContextAsInsecure), (intptr_t) (0) } },
    { "setMaxCanvasPixelMemory", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetMaxCanvasPixelMemory), (intptr_t) (1) } },
#if ENABLE(VIDEO)
    { "bestMediaElementForShowingPlaybackControlsManager", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionBestMediaElementForShowingPlaybackControlsManager), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(VIDEO)
    { "mediaSessionState", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionMediaSessionState), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "ongoingLoadsDescriptions", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionOngoingLoadsDescriptions), (intptr_t) (0) } },
    { "setCaptureExtraNetworkLoadMetricsEnabled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetCaptureExtraNetworkLoadMetricsEnabled), (intptr_t) (1) } },
    { "reloadWithoutContentExtensions", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionReloadWithoutContentExtensions), (intptr_t) (0) } },
    { "setUseSystemAppearance", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetUseSystemAppearance), (intptr_t) (1) } },
    { "pluginCount", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionPluginCount), (intptr_t) (0) } },
    { "notifyResourceLoadObserver", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionNotifyResourceLoadObserver), (intptr_t) (0) } },
    { "primaryScreenDisplayID", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionPrimaryScreenDisplayID), (intptr_t) (0) } },
    { "capsLockIsOn", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionCapsLockIsOn), (intptr_t) (0) } },
    { "supportsVCPEncoder", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSupportsVCPEncoder), (intptr_t) (0) } },
    { "parseHEVCCodecParameters", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionParseHEVCCodecParameters), (intptr_t) (1) } },
    { "parseDoViCodecParameters", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionParseDoViCodecParameters), (intptr_t) (1) } },
    { "getCookies", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionGetCookies), (intptr_t) (0) } },
    { "setAlwaysAllowLocalWebarchive", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetAlwaysAllowLocalWebarchive), (intptr_t) (1) } },
    { "processWillSuspend", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionProcessWillSuspend), (intptr_t) (0) } },
    { "processDidResume", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionProcessDidResume), (intptr_t) (0) } },
    { "testDictionaryLogging", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionTestDictionaryLogging), (intptr_t) (0) } },
    { "setXHRMaximumIntervalForUserGestureForwarding", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetXHRMaximumIntervalForUserGestureForwarding), (intptr_t) (2) } },
    { "setTransientActivationDuration", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetTransientActivationDuration), (intptr_t) (1) } },
    { "setIsPlayingToAutomotiveHeadUnit", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetIsPlayingToAutomotiveHeadUnit), (intptr_t) (1) } },
    { "textIndicatorForRange", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionTextIndicatorForRange), (intptr_t) (2) } },
    { "addPrefetchLoadEventListener", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionAddPrefetchLoadEventListener), (intptr_t) (2) } },
#if ENABLE(WEB_AUTHN)
    { "setMockWebAuthenticationConfiguration", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetMockWebAuthenticationConfiguration), (intptr_t) (1) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
#if ENABLE(PICTURE_IN_PICTURE_API)
    { "setPictureInPictureAPITestEnabled", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSetPictureInPictureAPITestEnabled), (intptr_t) (2) } },
#else
    { 0, 0, NoIntrinsic, { 0, 0 } },
#endif
    { "createInternalsMapLike", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionCreateInternalsMapLike), (intptr_t) (0) } },
    { "createInternalsSetLike", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionCreateInternalsSetLike), (intptr_t) (0) } },
    { "highlightPseudoElementColor", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionHighlightPseudoElementColor), (intptr_t) (2) } },
    { "hasSandboxMachLookupAccessToGlobalName", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionHasSandboxMachLookupAccessToGlobalName), (intptr_t) (2) } },
    { "hasSandboxMachLookupAccessToXPCServiceName", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionHasSandboxMachLookupAccessToXPCServiceName), (intptr_t) (2) } },
    { "systemColorForCSSValue", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSystemColorForCSSValue), (intptr_t) (3) } },
    { "focusRingColor", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionFocusRingColor), (intptr_t) (0) } },
    { "systemHasBattery", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionSystemHasBattery), (intptr_t) (0) } },
    { "mediaMIMETypeForExtension", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsInternalsPrototypeFunctionMediaMIMETypeForExtension), (intptr_t) (1) } },
    { "LAYER_TREE_INCLUDES_VISIBLE_RECTS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
    { "LAYER_TREE_INCLUDES_TILE_CACHES", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(2) } },
    { "LAYER_TREE_INCLUDES_REPAINT_RECTS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(4) } },
    { "LAYER_TREE_INCLUDES_PAINTING_PHASES", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(8) } },
    { "LAYER_TREE_INCLUDES_CONTENT_LAYERS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(16) } },
    { "LAYER_TREE_INCLUDES_ACCELERATES_DRAWING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(32) } },
    { "LAYER_TREE_INCLUDES_CLIPPING", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(64) } },
    { "LAYER_TREE_INCLUDES_BACKING_STORE_ATTACHED", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(128) } },
    { "LAYER_TREE_INCLUDES_ROOT_LAYER_PROPERTIES", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(256) } },
    { "LAYER_TREE_INCLUDES_EVENT_REGION", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(512) } },
    { "LAYER_TREE_INCLUDES_DEEP_COLOR", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1024) } },
    { "DISPLAY_LIST_INCLUDES_PLATFORM_OPERATIONS", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(1) } },
};

const ClassInfo JSInternalsPrototype::s_info = { "InternalsPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSInternalsPrototype) };

void JSInternalsPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSInternals::info(), JSInternalsPrototypeTableValues, *this);
}

const ClassInfo JSInternals::s_info = { "Internals", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSInternals) };

JSInternals::JSInternals(Structure* structure, JSDOMGlobalObject& globalObject, Ref<Internals>&& impl)
    : JSDOMWrapper<Internals>(structure, globalObject, WTFMove(impl))
{
}

void JSInternals::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, Internals>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSInternals::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSInternalsPrototype::create(vm, &globalObject, JSInternalsPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSInternals::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSInternals>(vm, globalObject);
}

void JSInternals::destroy(JSC::JSCell* cell)
{
    JSInternals* thisObject = static_cast<JSInternals*>(cell);
    thisObject->JSInternals::~JSInternals();
}

template<> inline JSInternals* IDLAttribute<JSInternals>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSInternals*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSInternals* IDLOperation<JSInternals>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSInternals*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

static inline JSValue jsInternalsAnimationsIntervalGetter(JSGlobalObject& lexicalGlobalObject, JSInternals& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.animationsInterval());
    return result;
}

EncodedJSValue jsInternalsAnimationsInterval(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSInternals>::get<jsInternalsAnimationsIntervalGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "animationsInterval");
}

static inline JSValue jsInternalsSentenceRetroCorrectionEnabledGetter(JSGlobalObject& lexicalGlobalObject, JSInternals& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.sentenceRetroCorrectionEnabled());
    return result;
}

EncodedJSValue jsInternalsSentenceRetroCorrectionEnabled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSInternals>::get<jsInternalsSentenceRetroCorrectionEnabledGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "sentenceRetroCorrectionEnabled");
}

static inline JSValue jsInternalsSettingsGetter(JSGlobalObject& lexicalGlobalObject, JSInternals& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<InternalSettings>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.settings());
    return result;
}

EncodedJSValue jsInternalsSettings(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSInternals>::get<jsInternalsSettingsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "settings");
}

static inline JSValue jsInternalsWorkerThreadCountGetter(JSGlobalObject& lexicalGlobalObject, JSInternals& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.workerThreadCount());
    return result;
}

EncodedJSValue jsInternalsWorkerThreadCount(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSInternals>::get<jsInternalsWorkerThreadCountGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "workerThreadCount");
}

static inline JSValue jsInternalsAreSVGAnimationsPausedGetter(JSGlobalObject& lexicalGlobalObject, JSInternals& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.areSVGAnimationsPaused());
    return result;
}

EncodedJSValue jsInternalsAreSVGAnimationsPaused(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSInternals>::get<jsInternalsAreSVGAnimationsPausedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "areSVGAnimationsPaused");
}

static inline JSValue jsInternalsIsUnderMemoryPressureGetter(JSGlobalObject& lexicalGlobalObject, JSInternals& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.isUnderMemoryPressure());
    return result;
}

EncodedJSValue jsInternalsIsUnderMemoryPressure(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSInternals>::get<jsInternalsIsUnderMemoryPressureGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "isUnderMemoryPressure");
}

#if ENABLE(FULLSCREEN_API)
static inline JSValue jsInternalsIsAnimatingFullScreenGetter(JSGlobalObject& lexicalGlobalObject, JSInternals& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.isAnimatingFullScreen());
    return result;
}

EncodedJSValue jsInternalsIsAnimatingFullScreen(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSInternals>::get<jsInternalsIsAnimatingFullScreenGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "isAnimatingFullScreen");
}

#endif

static inline JSValue jsInternalsRequestAnimationFrameIntervalGetter(JSGlobalObject& lexicalGlobalObject, JSInternals& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.requestAnimationFrameInterval());
    return result;
}

EncodedJSValue jsInternalsRequestAnimationFrameInterval(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSInternals>::get<jsInternalsRequestAnimationFrameIntervalGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "requestAnimationFrameInterval");
}

static inline JSValue jsInternalsScriptedAnimationsAreSuspendedGetter(JSGlobalObject& lexicalGlobalObject, JSInternals& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.scriptedAnimationsAreSuspended());
    return result;
}

EncodedJSValue jsInternalsScriptedAnimationsAreSuspended(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSInternals>::get<jsInternalsScriptedAnimationsAreSuspendedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "scriptedAnimationsAreSuspended");
}

static inline JSValue jsInternalsEventThrottlingBehaviorOverrideGetter(JSGlobalObject& lexicalGlobalObject, JSInternals& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLEnumeration<Internals::EventThrottlingBehavior>>>(lexicalGlobalObject, throwScope, impl.eventThrottlingBehaviorOverride());
    return result;
}

EncodedJSValue jsInternalsEventThrottlingBehaviorOverride(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSInternals>::get<jsInternalsEventThrottlingBehaviorOverrideGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "eventThrottlingBehaviorOverride");
}

static inline bool setJSInternalsEventThrottlingBehaviorOverrideSetter(JSGlobalObject& lexicalGlobalObject, JSInternals& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<Internals::EventThrottlingBehavior>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    auto nativeValue = optionalNativeValue.value();
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setEventThrottlingBehaviorOverride(WTFMove(nativeValue));
    });
    return true;
}

bool setJSInternalsEventThrottlingBehaviorOverride(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSInternals>::set<setJSInternalsEventThrottlingBehaviorOverrideSetter>(*lexicalGlobalObject, thisValue, encodedValue, "eventThrottlingBehaviorOverride");
}

static inline JSValue jsInternalsLastStyleUpdateSizeGetter(JSGlobalObject& lexicalGlobalObject, JSInternals& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.lastStyleUpdateSize());
    return result;
}

EncodedJSValue jsInternalsLastStyleUpdateSize(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSInternals>::get<jsInternalsLastStyleUpdateSizeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "lastStyleUpdateSize");
}

static inline JSValue jsInternalsCompositingPolicyOverrideGetter(JSGlobalObject& lexicalGlobalObject, JSInternals& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLEnumeration<Internals::CompositingPolicy>>>(lexicalGlobalObject, throwScope, impl.compositingPolicyOverride());
    return result;
}

EncodedJSValue jsInternalsCompositingPolicyOverride(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSInternals>::get<jsInternalsCompositingPolicyOverrideGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "compositingPolicyOverride");
}

static inline bool setJSInternalsCompositingPolicyOverrideSetter(JSGlobalObject& lexicalGlobalObject, JSInternals& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<Internals::CompositingPolicy>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    auto nativeValue = optionalNativeValue.value();
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setCompositingPolicyOverride(WTFMove(nativeValue));
    });
    return true;
}

bool setJSInternalsCompositingPolicyOverride(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSInternals>::set<setJSInternalsCompositingPolicyOverrideSetter>(*lexicalGlobalObject, thisValue, encodedValue, "compositingPolicyOverride");
}

static inline JSValue jsInternalsLayoutCountGetter(JSGlobalObject& lexicalGlobalObject, JSInternals& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.layoutCount());
    return result;
}

EncodedJSValue jsInternalsLayoutCount(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSInternals>::get<jsInternalsLayoutCountGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "layoutCount");
}

#if ENABLE(CONTENT_FILTERING)
static inline JSValue jsInternalsMockContentFilterSettingsGetter(JSGlobalObject& lexicalGlobalObject, JSInternals& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<MockContentFilterSettings>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.mockContentFilterSettings());
    return result;
}

EncodedJSValue jsInternalsMockContentFilterSettings(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSInternals>::get<jsInternalsMockContentFilterSettingsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "mockContentFilterSettings");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline JSValue jsInternalsTrackAudioSampleCountGetter(JSGlobalObject& lexicalGlobalObject, JSInternals& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.trackAudioSampleCount());
    return result;
}

EncodedJSValue jsInternalsTrackAudioSampleCount(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSInternals>::get<jsInternalsTrackAudioSampleCountGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "trackAudioSampleCount");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline JSValue jsInternalsTrackVideoSampleCountGetter(JSGlobalObject& lexicalGlobalObject, JSInternals& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.trackVideoSampleCount());
    return result;
}

EncodedJSValue jsInternalsTrackVideoSampleCount(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSInternals>::get<jsInternalsTrackVideoSampleCountGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "trackVideoSampleCount");
}

#endif

static inline JSValue jsInternalsProcessIdentifierGetter(JSGlobalObject& lexicalGlobalObject, JSInternals& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.processIdentifier());
    return result;
}

EncodedJSValue jsInternalsProcessIdentifier(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSInternals>::get<jsInternalsProcessIdentifierGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "processIdentifier");
}

static inline JSValue jsInternalsSupportsAudioSessionGetter(JSGlobalObject& lexicalGlobalObject, JSInternals& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.supportsAudioSession());
    return result;
}

EncodedJSValue jsInternalsSupportsAudioSession(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSInternals>::get<jsInternalsSupportsAudioSessionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "supportsAudioSession");
}

#if ENABLE(APPLE_PAY)
static inline JSValue jsInternalsMockPaymentCoordinatorGetter(JSGlobalObject& lexicalGlobalObject, JSInternals& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto* context = jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return jsUndefined();
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<MockPaymentCoordinator>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.mockPaymentCoordinator(document));
    return result;
}

EncodedJSValue jsInternalsMockPaymentCoordinator(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSInternals>::get<jsInternalsMockPaymentCoordinatorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "mockPaymentCoordinator");
}

#endif

#if ENABLE(VIDEO)
static inline JSValue jsInternalsNowPlayingStateGetter(JSGlobalObject& lexicalGlobalObject, JSInternals& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDictionary<Internals::NowPlayingState>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.nowPlayingState());
    return result;
}

EncodedJSValue jsInternalsNowPlayingState(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSInternals>::get<jsInternalsNowPlayingStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "nowPlayingState");
}

#endif

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionAddressBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto node = convert<IDLInterface<Node>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "Internals", "address", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.address(*node)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionAddress(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionAddressBody>(*lexicalGlobalObject, *callFrame, "address");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionNodeNeedsStyleRecalcBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto node = convert<IDLInterface<Node>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "Internals", "nodeNeedsStyleRecalc", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.nodeNeedsStyleRecalc(*node)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNodeNeedsStyleRecalc(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionNodeNeedsStyleRecalcBody>(*lexicalGlobalObject, *callFrame, "nodeNeedsStyleRecalc");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionStyleChangeTypeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto node = convert<IDLInterface<Node>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "Internals", "styleChangeType", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.styleChangeType(*node)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionStyleChangeType(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionStyleChangeTypeBody>(*lexicalGlobalObject, *callFrame, "styleChangeType");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionDescriptionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto value = convert<IDLAny>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.description(WTFMove(value))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionDescription(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionDescriptionBody>(*lexicalGlobalObject, *callFrame, "description");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionHasPausedImageAnimationsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "hasPausedImageAnimations", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.hasPausedImageAnimations(*element)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionHasPausedImageAnimations(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionHasPausedImageAnimationsBody>(*lexicalGlobalObject, *callFrame, "hasPausedImageAnimations");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionIsPaintingFrequentlyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "isPaintingFrequently", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.isPaintingFrequently(*element)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsPaintingFrequently(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionIsPaintingFrequentlyBody>(*lexicalGlobalObject, *callFrame, "isPaintingFrequently");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionIncrementFrequentPaintCounterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "incrementFrequentPaintCounter", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.incrementFrequentPaintCounter(*element);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIncrementFrequentPaintCounter(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionIncrementFrequentPaintCounterBody>(*lexicalGlobalObject, *callFrame, "incrementFrequentPaintCounter");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionElementRenderTreeAsTextBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "elementRenderTreeAsText", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.elementRenderTreeAsText(*element)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionElementRenderTreeAsText(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionElementRenderTreeAsTextBody>(*lexicalGlobalObject, *callFrame, "elementRenderTreeAsText");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionIsPreloadedBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto url = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.isPreloaded(WTFMove(url))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsPreloaded(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionIsPreloadedBody>(*lexicalGlobalObject, *callFrame, "isPreloaded");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionIsLoadingFromMemoryCacheBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto url = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.isLoadingFromMemoryCache(WTFMove(url))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsLoadingFromMemoryCache(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionIsLoadingFromMemoryCacheBody>(*lexicalGlobalObject, *callFrame, "isLoadingFromMemoryCache");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionFetchResponseSourceBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto response = convert<IDLInterface<FetchResponse>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "response", "Internals", "fetchResponseSource", "FetchResponse"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.fetchResponseSource(*response)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionFetchResponseSource(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionFetchResponseSourceBody>(*lexicalGlobalObject, *callFrame, "fetchResponseSource");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionXhrResponseSourceBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto xhr = convert<IDLInterface<XMLHttpRequest>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "xhr", "Internals", "xhrResponseSource", "XMLHttpRequest"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.xhrResponseSource(*xhr)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionXhrResponseSource(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionXhrResponseSourceBody>(*lexicalGlobalObject, *callFrame, "xhrResponseSource");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionIsSharingStyleSheetContentsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto a = convert<IDLInterface<HTMLLinkElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "a", "Internals", "isSharingStyleSheetContents", "HTMLLinkElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto b = convert<IDLInterface<HTMLLinkElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "b", "Internals", "isSharingStyleSheetContents", "HTMLLinkElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.isSharingStyleSheetContents(*a, *b)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsSharingStyleSheetContents(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionIsSharingStyleSheetContentsBody>(*lexicalGlobalObject, *callFrame, "isSharingStyleSheetContents");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionIsStyleSheetLoadingSubresourcesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto link = convert<IDLInterface<HTMLLinkElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "link", "Internals", "isStyleSheetLoadingSubresources", "HTMLLinkElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.isStyleSheetLoadingSubresources(*link)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsStyleSheetLoadingSubresources(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionIsStyleSheetLoadingSubresourcesBody>(*lexicalGlobalObject, *callFrame, "isStyleSheetLoadingSubresources");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionClearMemoryCacheBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.clearMemoryCache();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionClearMemoryCache(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionClearMemoryCacheBody>(*lexicalGlobalObject, *callFrame, "clearMemoryCache");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionPruneMemoryCacheToSizeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto size = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.pruneMemoryCacheToSize(WTFMove(size));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPruneMemoryCacheToSize(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionPruneMemoryCacheToSizeBody>(*lexicalGlobalObject, *callFrame, "pruneMemoryCacheToSize");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionDestroyDecodedDataForAllImagesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.destroyDecodedDataForAllImages();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionDestroyDecodedDataForAllImages(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionDestroyDecodedDataForAllImagesBody>(*lexicalGlobalObject, *callFrame, "destroyDecodedDataForAllImages");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionMemoryCacheSizeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLLong>(impl.memoryCacheSize()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMemoryCacheSize(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionMemoryCacheSizeBody>(*lexicalGlobalObject, *callFrame, "memoryCacheSize");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetOverrideCachePolicyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto policy = convert<IDLEnumeration<Internals::CachePolicy>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 0, "policy", "Internals", "setOverrideCachePolicy", expectedEnumerationValues<Internals::CachePolicy>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setOverrideCachePolicy(WTFMove(policy));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetOverrideCachePolicy(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetOverrideCachePolicyBody>(*lexicalGlobalObject, *callFrame, "setOverrideCachePolicy");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetOverrideResourceLoadPriorityBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto priority = convert<IDLEnumeration<Internals::ResourceLoadPriority>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 0, "priority", "Internals", "setOverrideResourceLoadPriority", expectedEnumerationValues<Internals::ResourceLoadPriority>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setOverrideResourceLoadPriority(WTFMove(priority));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetOverrideResourceLoadPriority(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetOverrideResourceLoadPriorityBody>(*lexicalGlobalObject, *callFrame, "setOverrideResourceLoadPriority");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetStrictRawResourceValidationPolicyDisabledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto disabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setStrictRawResourceValidationPolicyDisabled(WTFMove(disabled));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetStrictRawResourceValidationPolicyDisabled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetStrictRawResourceValidationPolicyDisabledBody>(*lexicalGlobalObject, *callFrame, "setStrictRawResourceValidationPolicyDisabled");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionClearBackForwardCacheBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.clearBackForwardCache();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionClearBackForwardCache(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionClearBackForwardCacheBody>(*lexicalGlobalObject, *callFrame, "clearBackForwardCache");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionBackForwardCacheSizeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLUnsignedLong>(impl.backForwardCacheSize()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionBackForwardCacheSize(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionBackForwardCacheSizeBody>(*lexicalGlobalObject, *callFrame, "backForwardCacheSize");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionPreventDocumentFromEnteringBackForwardCacheBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.preventDocumentFromEnteringBackForwardCache();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPreventDocumentFromEnteringBackForwardCache(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionPreventDocumentFromEnteringBackForwardCacheBody>(*lexicalGlobalObject, *callFrame, "preventDocumentFromEnteringBackForwardCache");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionComputedStyleIncludingVisitedInfoBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "computedStyleIncludingVisitedInfo", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<CSSStyleDeclaration>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.computedStyleIncludingVisitedInfo(*element)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionComputedStyleIncludingVisitedInfo(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionComputedStyleIncludingVisitedInfoBody>(*lexicalGlobalObject, *callFrame, "computedStyleIncludingVisitedInfo");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionEnsureUserAgentShadowRootBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto host = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "host", "Internals", "ensureUserAgentShadowRoot", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<Node>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.ensureUserAgentShadowRoot(*host)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionEnsureUserAgentShadowRoot(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionEnsureUserAgentShadowRootBody>(*lexicalGlobalObject, *callFrame, "ensureUserAgentShadowRoot");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionShadowRootBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto host = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "host", "Internals", "shadowRoot", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<Node>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.shadowRoot(*host)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionShadowRoot(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionShadowRootBody>(*lexicalGlobalObject, *callFrame, "shadowRoot");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionDeferredStyleRulesCountBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto sheet = convert<IDLInterface<StyleSheet>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "sheet", "Internals", "deferredStyleRulesCount", "StyleSheet"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLLong>(impl.deferredStyleRulesCount(*sheet)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionDeferredStyleRulesCount(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionDeferredStyleRulesCountBody>(*lexicalGlobalObject, *callFrame, "deferredStyleRulesCount");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionDeferredGroupRulesCountBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto sheet = convert<IDLInterface<StyleSheet>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "sheet", "Internals", "deferredGroupRulesCount", "StyleSheet"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLLong>(impl.deferredGroupRulesCount(*sheet)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionDeferredGroupRulesCount(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionDeferredGroupRulesCountBody>(*lexicalGlobalObject, *callFrame, "deferredGroupRulesCount");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionDeferredKeyframesRulesCountBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto sheet = convert<IDLInterface<StyleSheet>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "sheet", "Internals", "deferredKeyframesRulesCount", "StyleSheet"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLLong>(impl.deferredKeyframesRulesCount(*sheet)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionDeferredKeyframesRulesCount(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionDeferredKeyframesRulesCountBody>(*lexicalGlobalObject, *callFrame, "deferredKeyframesRulesCount");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionShadowRootTypeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto root = convert<IDLInterface<Node>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "root", "Internals", "shadowRootType", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.shadowRootType(*root)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionShadowRootType(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionShadowRootTypeBody>(*lexicalGlobalObject, *callFrame, "shadowRootType");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionShadowPseudoIdBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "shadowPseudoId", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.shadowPseudoId(*element)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionShadowPseudoId(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionShadowPseudoIdBody>(*lexicalGlobalObject, *callFrame, "shadowPseudoId");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetShadowPseudoIdBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "setShadowPseudoId", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto id = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setShadowPseudoId(*element, WTFMove(id));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetShadowPseudoId(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetShadowPseudoIdBody>(*lexicalGlobalObject, *callFrame, "setShadowPseudoId");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionTreeScopeRootNodeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto node = convert<IDLInterface<Node>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "Internals", "treeScopeRootNode", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<Node>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.treeScopeRootNode(*node)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionTreeScopeRootNode(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionTreeScopeRootNodeBody>(*lexicalGlobalObject, *callFrame, "treeScopeRootNode");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionParentTreeScopeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto node = convert<IDLInterface<Node>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "Internals", "parentTreeScope", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<Node>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.parentTreeScope(*node)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionParentTreeScope(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionParentTreeScopeBody>(*lexicalGlobalObject, *callFrame, "parentTreeScope");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionLastSpatialNavigationCandidateCountBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLUnsignedLong>(*lexicalGlobalObject, throwScope, impl.lastSpatialNavigationCandidateCount()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionLastSpatialNavigationCandidateCount(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionLastSpatialNavigationCandidateCountBody>(*lexicalGlobalObject, *callFrame, "lastSpatialNavigationCandidateCount");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionNumberOfActiveAnimationsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLUnsignedLong>(impl.numberOfActiveAnimations()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNumberOfActiveAnimations(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionNumberOfActiveAnimationsBody>(*lexicalGlobalObject, *callFrame, "numberOfActiveAnimations");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSuspendAnimationsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    propagateException(*lexicalGlobalObject, throwScope, impl.suspendAnimations());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSuspendAnimations(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSuspendAnimationsBody>(*lexicalGlobalObject, *callFrame, "suspendAnimations");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionResumeAnimationsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    propagateException(*lexicalGlobalObject, throwScope, impl.resumeAnimations());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionResumeAnimations(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionResumeAnimationsBody>(*lexicalGlobalObject, *callFrame, "resumeAnimations");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionAnimationsAreSuspendedBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.animationsAreSuspended()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionAnimationsAreSuspended(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionAnimationsAreSuspendedBody>(*lexicalGlobalObject, *callFrame, "animationsAreSuspended");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionPauseAnimationAtTimeOnElementBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto animationName = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pauseTime = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(2), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 2, "element", "Internals", "pauseAnimationAtTimeOnElement", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.pauseAnimationAtTimeOnElement(WTFMove(animationName), WTFMove(pauseTime), *element)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPauseAnimationAtTimeOnElement(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionPauseAnimationAtTimeOnElementBody>(*lexicalGlobalObject, *callFrame, "pauseAnimationAtTimeOnElement");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionPauseAnimationAtTimeOnPseudoElementBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto animationName = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pauseTime = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(2), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 2, "element", "Internals", "pauseAnimationAtTimeOnPseudoElement", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pseudoId = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.pauseAnimationAtTimeOnPseudoElement(WTFMove(animationName), WTFMove(pauseTime), *element, WTFMove(pseudoId))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPauseAnimationAtTimeOnPseudoElement(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionPauseAnimationAtTimeOnPseudoElementBody>(*lexicalGlobalObject, *callFrame, "pauseAnimationAtTimeOnPseudoElement");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionPauseTransitionAtTimeOnElementBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto propertyName = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pauseTime = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(2), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 2, "element", "Internals", "pauseTransitionAtTimeOnElement", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.pauseTransitionAtTimeOnElement(WTFMove(propertyName), WTFMove(pauseTime), *element)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPauseTransitionAtTimeOnElement(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionPauseTransitionAtTimeOnElementBody>(*lexicalGlobalObject, *callFrame, "pauseTransitionAtTimeOnElement");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionPauseTransitionAtTimeOnPseudoElementBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto property = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pauseTime = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(2), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 2, "element", "Internals", "pauseTransitionAtTimeOnPseudoElement", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pseudoId = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.pauseTransitionAtTimeOnPseudoElement(WTFMove(property), WTFMove(pauseTime), *element, WTFMove(pseudoId))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPauseTransitionAtTimeOnPseudoElement(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionPauseTransitionAtTimeOnPseudoElementBody>(*lexicalGlobalObject, *callFrame, "pauseTransitionAtTimeOnPseudoElement");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionAcceleratedAnimationsForElementBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "acceleratedAnimationsForElement", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLSequence<IDLDictionary<Internals::AcceleratedAnimation>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.acceleratedAnimationsForElement(*element)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionAcceleratedAnimationsForElement(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionAcceleratedAnimationsForElementBody>(*lexicalGlobalObject, *callFrame, "acceleratedAnimationsForElement");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionNumberOfAnimationTimelineInvalidationsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLUnsignedLong>(impl.numberOfAnimationTimelineInvalidations()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNumberOfAnimationTimelineInvalidations(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionNumberOfAnimationTimelineInvalidationsBody>(*lexicalGlobalObject, *callFrame, "numberOfAnimationTimelineInvalidations");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionPseudoElementBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "pseudoElement", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pseudoId = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLInterface<Element>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.pseudoElement(*element, WTFMove(pseudoId))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPseudoElement(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionPseudoElementBody>(*lexicalGlobalObject, *callFrame, "pseudoElement");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionVisiblePlaceholderBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "visiblePlaceholder", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.visiblePlaceholder(*element)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionVisiblePlaceholder(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionVisiblePlaceholderBody>(*lexicalGlobalObject, *callFrame, "visiblePlaceholder");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSelectColorInColorChooserBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<HTMLInputElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "selectColorInColorChooser", "HTMLInputElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto colorValue = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.selectColorInColorChooser(*element, WTFMove(colorValue));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSelectColorInColorChooser(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSelectColorInColorChooserBody>(*lexicalGlobalObject, *callFrame, "selectColorInColorChooser");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionFormControlStateOfPreviousHistoryItemBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLSequence<IDLDOMString>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.formControlStateOfPreviousHistoryItem()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionFormControlStateOfPreviousHistoryItem(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionFormControlStateOfPreviousHistoryItemBody>(*lexicalGlobalObject, *callFrame, "formControlStateOfPreviousHistoryItem");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetFormControlStateOfPreviousHistoryItemBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto values = convert<IDLSequence<IDLDOMString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setFormControlStateOfPreviousHistoryItem(WTFMove(values)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetFormControlStateOfPreviousHistoryItem(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetFormControlStateOfPreviousHistoryItemBody>(*lexicalGlobalObject, *callFrame, "setFormControlStateOfPreviousHistoryItem");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionAbsoluteCaretBoundsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<DOMRect>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.absoluteCaretBounds()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionAbsoluteCaretBounds(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionAbsoluteCaretBoundsBody>(*lexicalGlobalObject, *callFrame, "absoluteCaretBounds");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionIsCaretBlinkingSuspendedBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.isCaretBlinkingSuspended()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsCaretBlinkingSuspended(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionIsCaretBlinkingSuspendedBody>(*lexicalGlobalObject, *callFrame, "isCaretBlinkingSuspended");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionBoundingBoxBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "boundingBox", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<DOMRect>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.boundingBox(*element)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionBoundingBox(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionBoundingBoxBody>(*lexicalGlobalObject, *callFrame, "boundingBox");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionInspectorHighlightRectsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<DOMRectList>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.inspectorHighlightRects()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionInspectorHighlightRects(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionInspectorHighlightRectsBody>(*lexicalGlobalObject, *callFrame, "inspectorHighlightRects");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionMarkerCountForNodeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto node = convert<IDLInterface<Node>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "Internals", "markerCountForNode", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto markerType = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLUnsignedLong>(*lexicalGlobalObject, throwScope, impl.markerCountForNode(*node, WTFMove(markerType))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMarkerCountForNode(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionMarkerCountForNodeBody>(*lexicalGlobalObject, *callFrame, "markerCountForNode");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionMarkerRangeForNodeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto node = convert<IDLInterface<Node>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "Internals", "markerRangeForNode", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto markerType = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLInterface<Range>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.markerRangeForNode(*node, WTFMove(markerType), WTFMove(index))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMarkerRangeForNode(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionMarkerRangeForNodeBody>(*lexicalGlobalObject, *callFrame, "markerRangeForNode");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionMarkerDescriptionForNodeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto node = convert<IDLInterface<Node>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "Internals", "markerDescriptionForNode", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto markerType = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.markerDescriptionForNode(*node, WTFMove(markerType), WTFMove(index))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMarkerDescriptionForNode(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionMarkerDescriptionForNodeBody>(*lexicalGlobalObject, *callFrame, "markerDescriptionForNode");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionDumpMarkerRectsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto markerType = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.dumpMarkerRects(WTFMove(markerType))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionDumpMarkerRects(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionDumpMarkerRectsBody>(*lexicalGlobalObject, *callFrame, "dumpMarkerRects");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionAddTextMatchMarkerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto range = convert<IDLInterface<Range>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "range", "Internals", "addTextMatchMarker", "Range"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto isActive = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.addTextMatchMarker(*range, WTFMove(isActive));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionAddTextMatchMarker(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionAddTextMatchMarkerBody>(*lexicalGlobalObject, *callFrame, "addTextMatchMarker");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetMarkedTextMatchesAreHighlightedBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto flag = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setMarkedTextMatchesAreHighlighted(WTFMove(flag)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetMarkedTextMatchesAreHighlighted(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetMarkedTextMatchesAreHighlightedBody>(*lexicalGlobalObject, *callFrame, "setMarkedTextMatchesAreHighlighted");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionInvalidateFontCacheBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.invalidateFontCache();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionInvalidateFontCache(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionInvalidateFontCacheBody>(*lexicalGlobalObject, *callFrame, "invalidateFontCache");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetFontSmoothingEnabledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setFontSmoothingEnabled(WTFMove(enabled));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetFontSmoothingEnabled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetFontSmoothingEnabledBody>(*lexicalGlobalObject, *callFrame, "setFontSmoothingEnabled");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetScrollViewPositionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setScrollViewPosition(WTFMove(x), WTFMove(y)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetScrollViewPosition(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetScrollViewPositionBody>(*lexicalGlobalObject, *callFrame, "setScrollViewPosition");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionUnconstrainedScrollToBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "unconstrainedScrollTo", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.unconstrainedScrollTo(*element, WTFMove(x), WTFMove(y)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionUnconstrainedScrollTo(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionUnconstrainedScrollToBody>(*lexicalGlobalObject, *callFrame, "unconstrainedScrollTo");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionLayoutViewportRectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<DOMRect>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.layoutViewportRect()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionLayoutViewportRect(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionLayoutViewportRectBody>(*lexicalGlobalObject, *callFrame, "layoutViewportRect");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionVisualViewportRectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<DOMRect>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.visualViewportRect()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionVisualViewportRect(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionVisualViewportRectBody>(*lexicalGlobalObject, *callFrame, "visualViewportRect");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetViewIsTransparentBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto trnasparent = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setViewIsTransparent(WTFMove(trnasparent)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetViewIsTransparent(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetViewIsTransparentBody>(*lexicalGlobalObject, *callFrame, "setViewIsTransparent");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionViewBaseBackgroundColorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.viewBaseBackgroundColor()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionViewBaseBackgroundColor(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionViewBaseBackgroundColorBody>(*lexicalGlobalObject, *callFrame, "viewBaseBackgroundColor");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetViewBaseBackgroundColorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto colorValue = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setViewBaseBackgroundColor(WTFMove(colorValue)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetViewBaseBackgroundColor(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetViewBaseBackgroundColorBody>(*lexicalGlobalObject, *callFrame, "setViewBaseBackgroundColor");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetPaginationBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto mode = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto gap = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pageLength = convert<IDLLong>(*lexicalGlobalObject, callFrame->argument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setPagination(WTFMove(mode), WTFMove(gap), WTFMove(pageLength)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetPagination(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetPaginationBody>(*lexicalGlobalObject, *callFrame, "setPagination");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetPaginationLineGridEnabledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setPaginationLineGridEnabled(WTFMove(enabled)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetPaginationLineGridEnabled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetPaginationLineGridEnabledBody>(*lexicalGlobalObject, *callFrame, "setPaginationLineGridEnabled");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionConfigurationForViewportBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 5))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto devicePixelRatio = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto deviceWidth = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto deviceHeight = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto availableWidth = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto availableHeight = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.configurationForViewport(WTFMove(devicePixelRatio), WTFMove(deviceWidth), WTFMove(deviceHeight), WTFMove(availableWidth), WTFMove(availableHeight))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionConfigurationForViewport(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionConfigurationForViewportBody>(*lexicalGlobalObject, *callFrame, "configurationForViewport");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionWasLastChangeUserEditBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto textField = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "textField", "Internals", "wasLastChangeUserEdit", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.wasLastChangeUserEdit(*textField)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionWasLastChangeUserEdit(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionWasLastChangeUserEditBody>(*lexicalGlobalObject, *callFrame, "wasLastChangeUserEdit");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionElementShouldAutoCompleteBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto inputElement = convert<IDLInterface<HTMLInputElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "inputElement", "Internals", "elementShouldAutoComplete", "HTMLInputElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.elementShouldAutoComplete(*inputElement)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionElementShouldAutoComplete(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionElementShouldAutoCompleteBody>(*lexicalGlobalObject, *callFrame, "elementShouldAutoComplete");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetAutofilledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto inputElement = convert<IDLInterface<HTMLInputElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "inputElement", "Internals", "setAutofilled", "HTMLInputElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setAutofilled(*inputElement, WTFMove(enabled));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetAutofilled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetAutofilledBody>(*lexicalGlobalObject, *callFrame, "setAutofilled");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetAutoFilledAndViewableBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto inputElement = convert<IDLInterface<HTMLInputElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "inputElement", "Internals", "setAutoFilledAndViewable", "HTMLInputElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setAutoFilledAndViewable(*inputElement, WTFMove(enabled));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetAutoFilledAndViewable(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetAutoFilledAndViewableBody>(*lexicalGlobalObject, *callFrame, "setAutoFilledAndViewable");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetShowAutoFillButtonBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto inputElement = convert<IDLInterface<HTMLInputElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "inputElement", "Internals", "setShowAutoFillButton", "HTMLInputElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto autoFillButtonType = convert<IDLEnumeration<Internals::AutoFillButtonType>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 1, "autoFillButtonType", "Internals", "setShowAutoFillButton", expectedEnumerationValues<Internals::AutoFillButtonType>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setShowAutoFillButton(*inputElement, WTFMove(autoFillButtonType));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetShowAutoFillButton(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetShowAutoFillButtonBody>(*lexicalGlobalObject, *callFrame, "setShowAutoFillButton");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionAutoFillButtonTypeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto inputElement = convert<IDLInterface<HTMLInputElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "inputElement", "Internals", "autoFillButtonType", "HTMLInputElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLEnumeration<Internals::AutoFillButtonType>>(*lexicalGlobalObject, impl.autoFillButtonType(*inputElement)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionAutoFillButtonType(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionAutoFillButtonTypeBody>(*lexicalGlobalObject, *callFrame, "autoFillButtonType");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionLastAutoFillButtonTypeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto inputElement = convert<IDLInterface<HTMLInputElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "inputElement", "Internals", "lastAutoFillButtonType", "HTMLInputElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLEnumeration<Internals::AutoFillButtonType>>(*lexicalGlobalObject, impl.lastAutoFillButtonType(*inputElement)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionLastAutoFillButtonType(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionLastAutoFillButtonTypeBody>(*lexicalGlobalObject, *callFrame, "lastAutoFillButtonType");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetCanShowPlaceholderBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "setCanShowPlaceholder", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto canShowPlaceholder = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setCanShowPlaceholder(*element, WTFMove(canShowPlaceholder));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetCanShowPlaceholder(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetCanShowPlaceholderBody>(*lexicalGlobalObject, *callFrame, "setCanShowPlaceholder");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionRangeOfStringBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto text = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto referenceRange = convert<IDLNullable<IDLInterface<Range>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "referenceRange", "Internals", "rangeOfString", "Range"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto findOptions = convert<IDLSequence<IDLDOMString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLInterface<Range>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.rangeOfString(WTFMove(text), WTFMove(referenceRange), WTFMove(findOptions))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionRangeOfString(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionRangeOfStringBody>(*lexicalGlobalObject, *callFrame, "rangeOfString");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionCountMatchesForTextBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto text = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto findOptions = convert<IDLSequence<IDLDOMString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto markMatches = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLUnsignedLong>(*lexicalGlobalObject, throwScope, impl.countMatchesForText(WTFMove(text), WTFMove(findOptions), WTFMove(markMatches))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionCountMatchesForText(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionCountMatchesForTextBody>(*lexicalGlobalObject, *callFrame, "countMatchesForText");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionCountFindMatchesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto text = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto findOptions = convert<IDLSequence<IDLDOMString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLUnsignedLong>(*lexicalGlobalObject, throwScope, impl.countFindMatches(WTFMove(text), WTFMove(findOptions))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionCountFindMatches(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionCountFindMatchesBody>(*lexicalGlobalObject, *callFrame, "countFindMatches");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionAutofillFieldNameBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto formControlElement = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "formControlElement", "Internals", "autofillFieldName", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.autofillFieldName(*formControlElement)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionAutofillFieldName(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionAutofillFieldNameBody>(*lexicalGlobalObject, *callFrame, "autofillFieldName");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionInvalidateControlTintsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    propagateException(*lexicalGlobalObject, throwScope, impl.invalidateControlTints());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionInvalidateControlTints(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionInvalidateControlTintsBody>(*lexicalGlobalObject, *callFrame, "invalidateControlTints");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionScrollElementToRectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 5))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "scrollElementToRect", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto w = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto h = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.scrollElementToRect(*element, WTFMove(x), WTFMove(y), WTFMove(w), WTFMove(h)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionScrollElementToRect(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionScrollElementToRectBody>(*lexicalGlobalObject, *callFrame, "scrollElementToRect");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionRangeFromLocationAndLengthBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto scope = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "scope", "Internals", "rangeFromLocationAndLength", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto rangeLocation = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto rangeLength = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLInterface<Range>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.rangeFromLocationAndLength(*scope, WTFMove(rangeLocation), WTFMove(rangeLength))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionRangeFromLocationAndLength(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionRangeFromLocationAndLengthBody>(*lexicalGlobalObject, *callFrame, "rangeFromLocationAndLength");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionLocationFromRangeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto scope = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "scope", "Internals", "locationFromRange", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto range = convert<IDLInterface<Range>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "range", "Internals", "locationFromRange", "Range"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLUnsignedLong>(impl.locationFromRange(*scope, *range)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionLocationFromRange(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionLocationFromRangeBody>(*lexicalGlobalObject, *callFrame, "locationFromRange");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionLengthFromRangeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto scope = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "scope", "Internals", "lengthFromRange", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto range = convert<IDLInterface<Range>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "range", "Internals", "lengthFromRange", "Range"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLUnsignedLong>(impl.lengthFromRange(*scope, *range)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionLengthFromRange(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionLengthFromRangeBody>(*lexicalGlobalObject, *callFrame, "lengthFromRange");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionRangeAsTextBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto range = convert<IDLInterface<Range>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "range", "Internals", "rangeAsText", "Range"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.rangeAsText(*range)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionRangeAsText(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionRangeAsTextBody>(*lexicalGlobalObject, *callFrame, "rangeAsText");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionRangeAsTextUsingBackwardsTextIteratorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto range = convert<IDLInterface<Range>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "range", "Internals", "rangeAsTextUsingBackwardsTextIterator", "Range"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.rangeAsTextUsingBackwardsTextIterator(*range)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionRangeAsTextUsingBackwardsTextIterator(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionRangeAsTextUsingBackwardsTextIteratorBody>(*lexicalGlobalObject, *callFrame, "rangeAsTextUsingBackwardsTextIterator");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSubrangeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto range = convert<IDLInterface<Range>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "range", "Internals", "subrange", "Range"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto rangeLocation = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto rangeLength = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<Range>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.subrange(*range, WTFMove(rangeLocation), WTFMove(rangeLength))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSubrange(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSubrangeBody>(*lexicalGlobalObject, *callFrame, "subrange");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionRangeForDictionaryLookupAtLocationBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLInterface<Range>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.rangeForDictionaryLookupAtLocation(WTFMove(x), WTFMove(y))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionRangeForDictionaryLookupAtLocation(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionRangeForDictionaryLookupAtLocationBody>(*lexicalGlobalObject, *callFrame, "rangeForDictionaryLookupAtLocation");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionRangeOfStringNearLocationBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto range = convert<IDLInterface<Range>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "range", "Internals", "rangeOfStringNearLocation", "Range"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto text = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto targetOffset = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLInterface<Range>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.rangeOfStringNearLocation(*range, WTFMove(text), WTFMove(targetOffset))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionRangeOfStringNearLocation(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionRangeOfStringNearLocationBody>(*lexicalGlobalObject, *callFrame, "rangeOfStringNearLocation");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetDelegatesScrollingBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setDelegatesScrolling(WTFMove(enabled)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetDelegatesScrolling(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetDelegatesScrollingBody>(*lexicalGlobalObject, *callFrame, "setDelegatesScrolling");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionLastSpellCheckRequestSequenceBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLLong>(*lexicalGlobalObject, throwScope, impl.lastSpellCheckRequestSequence()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionLastSpellCheckRequestSequence(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionLastSpellCheckRequestSequenceBody>(*lexicalGlobalObject, *callFrame, "lastSpellCheckRequestSequence");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionLastSpellCheckProcessedSequenceBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLLong>(*lexicalGlobalObject, throwScope, impl.lastSpellCheckProcessedSequence()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionLastSpellCheckProcessedSequence(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionLastSpellCheckProcessedSequenceBody>(*lexicalGlobalObject, *callFrame, "lastSpellCheckProcessedSequence");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionUserPreferredLanguagesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLSequence<IDLDOMString>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.userPreferredLanguages()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionUserPreferredLanguages(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionUserPreferredLanguagesBody>(*lexicalGlobalObject, *callFrame, "userPreferredLanguages");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetUserPreferredLanguagesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto languages = convert<IDLSequence<IDLDOMString>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setUserPreferredLanguages(WTFMove(languages));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetUserPreferredLanguages(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetUserPreferredLanguagesBody>(*lexicalGlobalObject, *callFrame, "setUserPreferredLanguages");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionUserPreferredAudioCharacteristicsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLSequence<IDLDOMString>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.userPreferredAudioCharacteristics()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionUserPreferredAudioCharacteristics(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionUserPreferredAudioCharacteristicsBody>(*lexicalGlobalObject, *callFrame, "userPreferredAudioCharacteristics");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetUserPreferredAudioCharacteristicBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto characteristic = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setUserPreferredAudioCharacteristic(WTFMove(characteristic));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetUserPreferredAudioCharacteristic(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetUserPreferredAudioCharacteristicBody>(*lexicalGlobalObject, *callFrame, "setUserPreferredAudioCharacteristic");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionWheelEventHandlerCountBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLUnsignedLong>(*lexicalGlobalObject, throwScope, impl.wheelEventHandlerCount()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionWheelEventHandlerCount(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionWheelEventHandlerCountBody>(*lexicalGlobalObject, *callFrame, "wheelEventHandlerCount");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionTouchEventHandlerCountBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLUnsignedLong>(*lexicalGlobalObject, throwScope, impl.touchEventHandlerCount()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionTouchEventHandlerCount(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionTouchEventHandlerCountBody>(*lexicalGlobalObject, *callFrame, "touchEventHandlerCount");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionTouchEventRectsForEventBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto eventName = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<DOMRectList>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.touchEventRectsForEvent(WTFMove(eventName))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionTouchEventRectsForEvent(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionTouchEventRectsForEventBody>(*lexicalGlobalObject, *callFrame, "touchEventRectsForEvent");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionPassiveTouchEventListenerRectsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<DOMRectList>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.passiveTouchEventListenerRects()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPassiveTouchEventListenerRects(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionPassiveTouchEventListenerRectsBody>(*lexicalGlobalObject, *callFrame, "passiveTouchEventListenerRects");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionNodesFromRectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 10))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto document = convert<IDLInterface<Document>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "document", "Internals", "nodesFromRect", "Document"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto topPadding = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto rightPadding = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto bottomPadding = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto leftPadding = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto ignoreClipping = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(7));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto allowShadowContent = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(8));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto allowChildFrameContent = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(9));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLInterface<NodeList>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.nodesFromRect(*document, WTFMove(x), WTFMove(y), WTFMove(topPadding), WTFMove(rightPadding), WTFMove(bottomPadding), WTFMove(leftPadding), WTFMove(ignoreClipping), WTFMove(allowShadowContent), WTFMove(allowChildFrameContent))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNodesFromRect(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionNodesFromRectBody>(*lexicalGlobalObject, *callFrame, "nodesFromRect");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionParserMetaDataBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto func = convert<IDLAny>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.parserMetaData(WTFMove(func))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionParserMetaData(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionParserMetaDataBody>(*lexicalGlobalObject, *callFrame, "parserMetaData");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionUpdateEditorUINowIfScheduledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.updateEditorUINowIfScheduled();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionUpdateEditorUINowIfScheduled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionUpdateEditorUINowIfScheduledBody>(*lexicalGlobalObject, *callFrame, "updateEditorUINowIfScheduled");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionHasSpellingMarkerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto from = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto length = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.hasSpellingMarker(WTFMove(from), WTFMove(length))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionHasSpellingMarker(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionHasSpellingMarkerBody>(*lexicalGlobalObject, *callFrame, "hasSpellingMarker");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionHasGrammarMarkerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto from = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto length = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.hasGrammarMarker(WTFMove(from), WTFMove(length))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionHasGrammarMarker(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionHasGrammarMarkerBody>(*lexicalGlobalObject, *callFrame, "hasGrammarMarker");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionHasAutocorrectedMarkerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto from = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto length = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.hasAutocorrectedMarker(WTFMove(from), WTFMove(length))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionHasAutocorrectedMarker(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionHasAutocorrectedMarkerBody>(*lexicalGlobalObject, *callFrame, "hasAutocorrectedMarker");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetContinuousSpellCheckingEnabledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setContinuousSpellCheckingEnabled(WTFMove(enabled));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetContinuousSpellCheckingEnabled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetContinuousSpellCheckingEnabledBody>(*lexicalGlobalObject, *callFrame, "setContinuousSpellCheckingEnabled");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetAutomaticQuoteSubstitutionEnabledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setAutomaticQuoteSubstitutionEnabled(WTFMove(enabled));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetAutomaticQuoteSubstitutionEnabled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetAutomaticQuoteSubstitutionEnabledBody>(*lexicalGlobalObject, *callFrame, "setAutomaticQuoteSubstitutionEnabled");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetAutomaticLinkDetectionEnabledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setAutomaticLinkDetectionEnabled(WTFMove(enabled));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetAutomaticLinkDetectionEnabled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetAutomaticLinkDetectionEnabledBody>(*lexicalGlobalObject, *callFrame, "setAutomaticLinkDetectionEnabled");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetAutomaticDashSubstitutionEnabledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setAutomaticDashSubstitutionEnabled(WTFMove(enabled));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetAutomaticDashSubstitutionEnabled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetAutomaticDashSubstitutionEnabledBody>(*lexicalGlobalObject, *callFrame, "setAutomaticDashSubstitutionEnabled");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetAutomaticTextReplacementEnabledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setAutomaticTextReplacementEnabled(WTFMove(enabled));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetAutomaticTextReplacementEnabled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetAutomaticTextReplacementEnabledBody>(*lexicalGlobalObject, *callFrame, "setAutomaticTextReplacementEnabled");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetAutomaticSpellingCorrectionEnabledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setAutomaticSpellingCorrectionEnabled(WTFMove(enabled));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetAutomaticSpellingCorrectionEnabled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetAutomaticSpellingCorrectionEnabledBody>(*lexicalGlobalObject, *callFrame, "setAutomaticSpellingCorrectionEnabled");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionHandleAcceptedCandidateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto candidate = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto location = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto length = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.handleAcceptedCandidate(WTFMove(candidate), WTFMove(location), WTFMove(length));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionHandleAcceptedCandidate(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionHandleAcceptedCandidateBody>(*lexicalGlobalObject, *callFrame, "handleAcceptedCandidate");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionChangeSelectionListTypeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.changeSelectionListType();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionChangeSelectionListType(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionChangeSelectionListTypeBody>(*lexicalGlobalObject, *callFrame, "changeSelectionListType");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionIsOverwriteModeEnabledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLBoolean>(impl.isOverwriteModeEnabled()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsOverwriteModeEnabled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionIsOverwriteModeEnabledBody>(*lexicalGlobalObject, *callFrame, "isOverwriteModeEnabled");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionToggleOverwriteModeEnabledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.toggleOverwriteModeEnabled();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionToggleOverwriteModeEnabled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionToggleOverwriteModeEnabledBody>(*lexicalGlobalObject, *callFrame, "toggleOverwriteModeEnabled");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionNumberOfScrollableAreasBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLUnsignedLong>(impl.numberOfScrollableAreas()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNumberOfScrollableAreas(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionNumberOfScrollableAreasBody>(*lexicalGlobalObject, *callFrame, "numberOfScrollableAreas");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionIsPageBoxVisibleBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto pageNumber = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.isPageBoxVisible(WTFMove(pageNumber))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsPageBoxVisible(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionIsPageBoxVisibleBody>(*lexicalGlobalObject, *callFrame, "isPageBoxVisible");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionImageFrameIndexBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<HTMLImageElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "imageFrameIndex", "HTMLImageElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLUnsignedLong>(impl.imageFrameIndex(*element)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionImageFrameIndex(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionImageFrameIndexBody>(*lexicalGlobalObject, *callFrame, "imageFrameIndex");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionImageFrameCountBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<HTMLImageElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "imageFrameCount", "HTMLImageElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLUnsignedLong>(impl.imageFrameCount(*element)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionImageFrameCount(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionImageFrameCountBody>(*lexicalGlobalObject, *callFrame, "imageFrameCount");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionImageFrameDurationAtIndexBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<HTMLImageElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "imageFrameDurationAtIndex", "HTMLImageElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto index = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLFloat>(impl.imageFrameDurationAtIndex(*element, WTFMove(index))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionImageFrameDurationAtIndex(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionImageFrameDurationAtIndexBody>(*lexicalGlobalObject, *callFrame, "imageFrameDurationAtIndex");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetImageFrameDecodingDurationBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<HTMLImageElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "setImageFrameDecodingDuration", "HTMLImageElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto duration = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setImageFrameDecodingDuration(*element, WTFMove(duration));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetImageFrameDecodingDuration(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetImageFrameDecodingDurationBody>(*lexicalGlobalObject, *callFrame, "setImageFrameDecodingDuration");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionResetImageAnimationBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<HTMLImageElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "resetImageAnimation", "HTMLImageElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.resetImageAnimation(*element);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionResetImageAnimation(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionResetImageAnimationBody>(*lexicalGlobalObject, *callFrame, "resetImageAnimation");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionIsImageAnimatingBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<HTMLImageElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "isImageAnimating", "HTMLImageElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.isImageAnimating(*element)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsImageAnimating(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionIsImageAnimatingBody>(*lexicalGlobalObject, *callFrame, "isImageAnimating");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionImagePendingDecodePromisesCountForTestingBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<HTMLImageElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "imagePendingDecodePromisesCountForTesting", "HTMLImageElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLUnsignedLong>(impl.imagePendingDecodePromisesCountForTesting(*element)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionImagePendingDecodePromisesCountForTesting(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionImagePendingDecodePromisesCountForTestingBody>(*lexicalGlobalObject, *callFrame, "imagePendingDecodePromisesCountForTesting");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetClearDecoderAfterAsyncFrameRequestForTestingBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<HTMLImageElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "setClearDecoderAfterAsyncFrameRequestForTesting", "HTMLImageElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setClearDecoderAfterAsyncFrameRequestForTesting(*element, WTFMove(enabled));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetClearDecoderAfterAsyncFrameRequestForTesting(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetClearDecoderAfterAsyncFrameRequestForTestingBody>(*lexicalGlobalObject, *callFrame, "setClearDecoderAfterAsyncFrameRequestForTesting");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionImageDecodeCountBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<HTMLImageElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "imageDecodeCount", "HTMLImageElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLUnsignedLong>(impl.imageDecodeCount(*element)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionImageDecodeCount(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionImageDecodeCountBody>(*lexicalGlobalObject, *callFrame, "imageDecodeCount");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionPdfDocumentCachingCountBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<HTMLImageElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "pdfDocumentCachingCount", "HTMLImageElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLUnsignedLong>(impl.pdfDocumentCachingCount(*element)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPdfDocumentCachingCount(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionPdfDocumentCachingCountBody>(*lexicalGlobalObject, *callFrame, "pdfDocumentCachingCount");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetLargeImageAsyncDecodingEnabledForTestingBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<HTMLImageElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "setLargeImageAsyncDecodingEnabledForTesting", "HTMLImageElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setLargeImageAsyncDecodingEnabledForTesting(*element, WTFMove(enabled));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetLargeImageAsyncDecodingEnabledForTesting(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetLargeImageAsyncDecodingEnabledForTestingBody>(*lexicalGlobalObject, *callFrame, "setLargeImageAsyncDecodingEnabledForTesting");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetForceUpdateImageDataEnabledForTestingBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<HTMLImageElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "setForceUpdateImageDataEnabledForTesting", "HTMLImageElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setForceUpdateImageDataEnabledForTesting(*element, WTFMove(enabled));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetForceUpdateImageDataEnabledForTesting(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetForceUpdateImageDataEnabledForTestingBody>(*lexicalGlobalObject, *callFrame, "setForceUpdateImageDataEnabledForTesting");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetGridMaxTracksLimitBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto maxTracksLimit = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setGridMaxTracksLimit(WTFMove(maxTracksLimit));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetGridMaxTracksLimit(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetGridMaxTracksLimitBody>(*lexicalGlobalObject, *callFrame, "setGridMaxTracksLimit");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSVGAnimationsIntervalBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<SVGSVGElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "svgAnimationsInterval", "SVGSVGElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDouble>(*lexicalGlobalObject, throwScope, impl.svgAnimationsInterval(*element)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSVGAnimationsInterval(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSVGAnimationsIntervalBody>(*lexicalGlobalObject, *callFrame, "svgAnimationsInterval");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionTestProcessIncomingSyncMessagesWhenWaitingForSyncReplyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLBoolean>(impl.testProcessIncomingSyncMessagesWhenWaitingForSyncReply()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionTestProcessIncomingSyncMessagesWhenWaitingForSyncReply(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionTestProcessIncomingSyncMessagesWhenWaitingForSyncReplyBody>(*lexicalGlobalObject, *callFrame, "testProcessIncomingSyncMessagesWhenWaitingForSyncReply");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionLayerTreeAsTextBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto document = convert<IDLInterface<Document>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "document", "Internals", "layerTreeAsText", "Document"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto flags = convert<IDLUnsignedShort>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.layerTreeAsText(*document, WTFMove(flags))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionLayerTreeAsText(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionLayerTreeAsTextBody>(*lexicalGlobalObject, *callFrame, "layerTreeAsText");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionLayerIDForElementBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "layerIDForElement", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLUnsignedLongLong>(*lexicalGlobalObject, throwScope, impl.layerIDForElement(*element)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionLayerIDForElement(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionLayerIDForElementBody>(*lexicalGlobalObject, *callFrame, "layerIDForElement");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionScrollbarOverlayStyleBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto node = convert<IDLNullable<IDLInterface<Node>>>(*lexicalGlobalObject, callFrame->argument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "Internals", "scrollbarOverlayStyle", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.scrollbarOverlayStyle(WTFMove(node))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionScrollbarOverlayStyle(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionScrollbarOverlayStyleBody>(*lexicalGlobalObject, *callFrame, "scrollbarOverlayStyle");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionScrollbarUsingDarkAppearanceBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto node = convert<IDLNullable<IDLInterface<Node>>>(*lexicalGlobalObject, callFrame->argument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "Internals", "scrollbarUsingDarkAppearance", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.scrollbarUsingDarkAppearance(WTFMove(node))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionScrollbarUsingDarkAppearance(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionScrollbarUsingDarkAppearanceBody>(*lexicalGlobalObject, *callFrame, "scrollbarUsingDarkAppearance");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionScrollingStateTreeAsTextBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.scrollingStateTreeAsText()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionScrollingStateTreeAsText(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionScrollingStateTreeAsTextBody>(*lexicalGlobalObject, *callFrame, "scrollingStateTreeAsText");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionMainThreadScrollingReasonsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.mainThreadScrollingReasons()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMainThreadScrollingReasons(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionMainThreadScrollingReasonsBody>(*lexicalGlobalObject, *callFrame, "mainThreadScrollingReasons");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionNonFastScrollableRectsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<DOMRectList>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.nonFastScrollableRects()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNonFastScrollableRects(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionNonFastScrollableRectsBody>(*lexicalGlobalObject, *callFrame, "nonFastScrollableRects");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionRepaintRectsAsTextBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.repaintRectsAsText()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionRepaintRectsAsText(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionRepaintRectsAsTextBody>(*lexicalGlobalObject, *callFrame, "repaintRectsAsText");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetElementUsesDisplayListDrawingBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "setElementUsesDisplayListDrawing", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto usesDisplayListDrawing = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setElementUsesDisplayListDrawing(*element, WTFMove(usesDisplayListDrawing)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetElementUsesDisplayListDrawing(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetElementUsesDisplayListDrawingBody>(*lexicalGlobalObject, *callFrame, "setElementUsesDisplayListDrawing");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetElementTracksDisplayListReplayBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "setElementTracksDisplayListReplay", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto trackReplay = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setElementTracksDisplayListReplay(*element, WTFMove(trackReplay)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetElementTracksDisplayListReplay(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetElementTracksDisplayListReplayBody>(*lexicalGlobalObject, *callFrame, "setElementTracksDisplayListReplay");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionDisplayListForElementBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "displayListForElement", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto flags = convert<IDLUnsignedShort>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.displayListForElement(*element, WTFMove(flags))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionDisplayListForElement(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionDisplayListForElementBody>(*lexicalGlobalObject, *callFrame, "displayListForElement");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionReplayDisplayListForElementBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "replayDisplayListForElement", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto flags = convert<IDLUnsignedShort>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.replayDisplayListForElement(*element, WTFMove(flags))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionReplayDisplayListForElement(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionReplayDisplayListForElementBody>(*lexicalGlobalObject, *callFrame, "replayDisplayListForElement");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionGarbageCollectDocumentResourcesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    propagateException(*lexicalGlobalObject, throwScope, impl.garbageCollectDocumentResources());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionGarbageCollectDocumentResources(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionGarbageCollectDocumentResourcesBody>(*lexicalGlobalObject, *callFrame, "garbageCollectDocumentResources");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionInsertAuthorCSSBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto css = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.insertAuthorCSS(WTFMove(css)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionInsertAuthorCSS(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionInsertAuthorCSSBody>(*lexicalGlobalObject, *callFrame, "insertAuthorCSS");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionInsertUserCSSBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto css = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.insertUserCSS(WTFMove(css)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionInsertUserCSS(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionInsertUserCSSBody>(*lexicalGlobalObject, *callFrame, "insertUserCSS");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionBeginSimulatedMemoryPressureBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.beginSimulatedMemoryPressure();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionBeginSimulatedMemoryPressure(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionBeginSimulatedMemoryPressureBody>(*lexicalGlobalObject, *callFrame, "beginSimulatedMemoryPressure");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionEndSimulatedMemoryPressureBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.endSimulatedMemoryPressure();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionEndSimulatedMemoryPressure(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionEndSimulatedMemoryPressureBody>(*lexicalGlobalObject, *callFrame, "endSimulatedMemoryPressure");
}

#if ENABLE(INDEXED_DATABASE)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionNumberOfIDBTransactionsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLUnsignedLong>(impl.numberOfIDBTransactions()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNumberOfIDBTransactions(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionNumberOfIDBTransactionsBody>(*lexicalGlobalObject, *callFrame, "numberOfIDBTransactions");
}

#endif

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionNumberOfLiveNodesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLUnsignedLong>(impl.numberOfLiveNodes()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNumberOfLiveNodes(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionNumberOfLiveNodesBody>(*lexicalGlobalObject, *callFrame, "numberOfLiveNodes");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionNumberOfLiveDocumentsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLUnsignedLong>(impl.numberOfLiveDocuments()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNumberOfLiveDocuments(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionNumberOfLiveDocumentsBody>(*lexicalGlobalObject, *callFrame, "numberOfLiveDocuments");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionReferencingNodeCountBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto document = convert<IDLInterface<Document>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "document", "Internals", "referencingNodeCount", "Document"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLUnsignedLong>(impl.referencingNodeCount(*document)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionReferencingNodeCount(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionReferencingNodeCountBody>(*lexicalGlobalObject, *callFrame, "referencingNodeCount");
}

#if ENABLE(INTERSECTION_OBSERVER)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionNumberOfIntersectionObserversBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto document = convert<IDLInterface<Document>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "document", "Internals", "numberOfIntersectionObservers", "Document"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLUnsignedLong>(impl.numberOfIntersectionObservers(*document)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNumberOfIntersectionObservers(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionNumberOfIntersectionObserversBody>(*lexicalGlobalObject, *callFrame, "numberOfIntersectionObservers");
}

#endif

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionOpenDummyInspectorFrontendBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto url = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLInterface<WindowProxy>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.openDummyInspectorFrontend(WTFMove(url))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionOpenDummyInspectorFrontend(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionOpenDummyInspectorFrontendBody>(*lexicalGlobalObject, *callFrame, "openDummyInspectorFrontend");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionCloseDummyInspectorFrontendBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.closeDummyInspectorFrontend();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionCloseDummyInspectorFrontend(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionCloseDummyInspectorFrontendBody>(*lexicalGlobalObject, *callFrame, "closeDummyInspectorFrontend");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetInspectorIsUnderTestBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto isUnderTest = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setInspectorIsUnderTest(WTFMove(isUnderTest)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetInspectorIsUnderTest(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetInspectorIsUnderTestBody>(*lexicalGlobalObject, *callFrame, "setInspectorIsUnderTest");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionCounterValueBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "counterValue", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.counterValue(*element)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionCounterValue(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionCounterValueBody>(*lexicalGlobalObject, *callFrame, "counterValue");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionPageNumberBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "pageNumber", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pageWidth = callFrame->argument(1).isUndefined() ? 800 : convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pageHeight = callFrame->argument(2).isUndefined() ? 600 : convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLLong>(impl.pageNumber(*element, WTFMove(pageWidth), WTFMove(pageHeight))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPageNumber(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionPageNumberBody>(*lexicalGlobalObject, *callFrame, "pageNumber");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionShortcutIconURLsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLSequence<IDLDOMString>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.shortcutIconURLs()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionShortcutIconURLs(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionShortcutIconURLsBody>(*lexicalGlobalObject, *callFrame, "shortcutIconURLs");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionNumberOfPagesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto pageWidthInPixels = callFrame->argument(0).isUndefined() ? 800 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pageHeightInPixels = callFrame->argument(1).isUndefined() ? 600 : convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLLong>(impl.numberOfPages(WTFMove(pageWidthInPixels), WTFMove(pageHeightInPixels))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNumberOfPages(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionNumberOfPagesBody>(*lexicalGlobalObject, *callFrame, "numberOfPages");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionPagePropertyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto propertyName = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto pageNumber = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.pageProperty(WTFMove(propertyName), WTFMove(pageNumber))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPageProperty(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionPagePropertyBody>(*lexicalGlobalObject, *callFrame, "pageProperty");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionPageSizeAndMarginsInPixelsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 7))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto pageIndex = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto marginTop = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto marginRight = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto marginBottom = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto marginLeft = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.pageSizeAndMarginsInPixels(WTFMove(pageIndex), WTFMove(width), WTFMove(height), WTFMove(marginTop), WTFMove(marginRight), WTFMove(marginBottom), WTFMove(marginLeft))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPageSizeAndMarginsInPixels(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionPageSizeAndMarginsInPixelsBody>(*lexicalGlobalObject, *callFrame, "pageSizeAndMarginsInPixels");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetPageScaleFactorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto scaleFactor = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto x = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setPageScaleFactor(WTFMove(scaleFactor), WTFMove(x), WTFMove(y)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetPageScaleFactor(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetPageScaleFactorBody>(*lexicalGlobalObject, *callFrame, "setPageScaleFactor");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionPageScaleFactorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLFloat>(*lexicalGlobalObject, throwScope, impl.pageScaleFactor()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPageScaleFactor(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionPageScaleFactorBody>(*lexicalGlobalObject, *callFrame, "pageScaleFactor");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetPageZoomFactorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto zoomFactor = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setPageZoomFactor(WTFMove(zoomFactor)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetPageZoomFactor(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetPageZoomFactorBody>(*lexicalGlobalObject, *callFrame, "setPageZoomFactor");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetTextZoomFactorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto zoomFactor = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setTextZoomFactor(WTFMove(zoomFactor)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetTextZoomFactor(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetTextZoomFactorBody>(*lexicalGlobalObject, *callFrame, "setTextZoomFactor");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetUseFixedLayoutBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto useFixedLayout = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setUseFixedLayout(WTFMove(useFixedLayout)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetUseFixedLayout(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetUseFixedLayoutBody>(*lexicalGlobalObject, *callFrame, "setUseFixedLayout");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetFixedLayoutSizeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setFixedLayoutSize(WTFMove(width), WTFMove(height)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetFixedLayoutSize(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetFixedLayoutSizeBody>(*lexicalGlobalObject, *callFrame, "setFixedLayoutSize");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetPrintingBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setPrinting(WTFMove(width), WTFMove(height));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetPrinting(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetPrintingBody>(*lexicalGlobalObject, *callFrame, "setPrinting");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetViewExposedRectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto x = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto y = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setViewExposedRect(WTFMove(x), WTFMove(y), WTFMove(width), WTFMove(height)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetViewExposedRect(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetViewExposedRectBody>(*lexicalGlobalObject, *callFrame, "setViewExposedRect");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetHeaderHeightBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto height = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setHeaderHeight(WTFMove(height));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetHeaderHeight(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetHeaderHeightBody>(*lexicalGlobalObject, *callFrame, "setHeaderHeight");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetFooterHeightBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto height = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setFooterHeight(WTFMove(height));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetFooterHeight(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetFooterHeightBody>(*lexicalGlobalObject, *callFrame, "setFooterHeight");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetTopContentInsetBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto contentInset = convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setTopContentInset(WTFMove(contentInset));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetTopContentInset(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetTopContentInsetBody>(*lexicalGlobalObject, *callFrame, "setTopContentInset");
}

#if ENABLE(FULLSCREEN_API)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionWebkitWillEnterFullScreenForElementBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "webkitWillEnterFullScreenForElement", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.webkitWillEnterFullScreenForElement(*element);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionWebkitWillEnterFullScreenForElement(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionWebkitWillEnterFullScreenForElementBody>(*lexicalGlobalObject, *callFrame, "webkitWillEnterFullScreenForElement");
}

#endif

#if ENABLE(FULLSCREEN_API)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionWebkitDidEnterFullScreenForElementBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "webkitDidEnterFullScreenForElement", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.webkitDidEnterFullScreenForElement(*element);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionWebkitDidEnterFullScreenForElement(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionWebkitDidEnterFullScreenForElementBody>(*lexicalGlobalObject, *callFrame, "webkitDidEnterFullScreenForElement");
}

#endif

#if ENABLE(FULLSCREEN_API)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionWebkitWillExitFullScreenForElementBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "webkitWillExitFullScreenForElement", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.webkitWillExitFullScreenForElement(*element);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionWebkitWillExitFullScreenForElement(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionWebkitWillExitFullScreenForElementBody>(*lexicalGlobalObject, *callFrame, "webkitWillExitFullScreenForElement");
}

#endif

#if ENABLE(FULLSCREEN_API)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionWebkitDidExitFullScreenForElementBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "webkitDidExitFullScreenForElement", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.webkitDidExitFullScreenForElement(*element);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionWebkitDidExitFullScreenForElement(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionWebkitDidExitFullScreenForElementBody>(*lexicalGlobalObject, *callFrame, "webkitDidExitFullScreenForElement");
}

#endif

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetFullscreenInsetsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto insets = convert<IDLDictionary<Internals::FullscreenInsets>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setFullscreenInsets(WTFMove(insets));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetFullscreenInsets(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetFullscreenInsetsBody>(*lexicalGlobalObject, *callFrame, "setFullscreenInsets");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetFullscreenAutoHideDurationBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto duration = convert<IDLDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setFullscreenAutoHideDuration(WTFMove(duration));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetFullscreenAutoHideDuration(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetFullscreenAutoHideDurationBody>(*lexicalGlobalObject, *callFrame, "setFullscreenAutoHideDuration");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetFullscreenControlsHiddenBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto hidden = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setFullscreenControlsHidden(WTFMove(hidden));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetFullscreenControlsHidden(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetFullscreenControlsHiddenBody>(*lexicalGlobalObject, *callFrame, "setFullscreenControlsHidden");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetApplicationCacheOriginQuotaBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto quota = convert<IDLUnsignedLongLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setApplicationCacheOriginQuota(WTFMove(quota));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetApplicationCacheOriginQuota(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetApplicationCacheOriginQuotaBody>(*lexicalGlobalObject, *callFrame, "setApplicationCacheOriginQuota");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionRegisterURLSchemeAsBypassingContentSecurityPolicyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto scheme = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.registerURLSchemeAsBypassingContentSecurityPolicy(WTFMove(scheme));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionRegisterURLSchemeAsBypassingContentSecurityPolicy(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionRegisterURLSchemeAsBypassingContentSecurityPolicyBody>(*lexicalGlobalObject, *callFrame, "registerURLSchemeAsBypassingContentSecurityPolicy");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionRemoveURLSchemeRegisteredAsBypassingContentSecurityPolicyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto scheme = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.removeURLSchemeRegisteredAsBypassingContentSecurityPolicy(WTFMove(scheme));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionRemoveURLSchemeRegisteredAsBypassingContentSecurityPolicy(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionRemoveURLSchemeRegisteredAsBypassingContentSecurityPolicyBody>(*lexicalGlobalObject, *callFrame, "removeURLSchemeRegisteredAsBypassingContentSecurityPolicy");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionRegisterDefaultPortForProtocolBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto port = convert<IDLUnsignedShort>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto scheme = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.registerDefaultPortForProtocol(WTFMove(port), WTFMove(scheme));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionRegisterDefaultPortForProtocol(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionRegisterDefaultPortForProtocolBody>(*lexicalGlobalObject, *callFrame, "registerDefaultPortForProtocol");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionMallocStatisticsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<MallocStatistics>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.mallocStatistics()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMallocStatistics(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionMallocStatisticsBody>(*lexicalGlobalObject, *callFrame, "mallocStatistics");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionTypeConversionsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<TypeConversions>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.typeConversions()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionTypeConversions(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionTypeConversionsBody>(*lexicalGlobalObject, *callFrame, "typeConversions");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionMemoryInfoBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<MemoryInfo>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.memoryInfo()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMemoryInfo(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionMemoryInfoBody>(*lexicalGlobalObject, *callFrame, "memoryInfo");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionGetReferencedFilePathsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLSequence<IDLDOMString>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getReferencedFilePaths()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionGetReferencedFilePaths(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionGetReferencedFilePathsBody>(*lexicalGlobalObject, *callFrame, "getReferencedFilePaths");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionStartTrackingRepaintsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    propagateException(*lexicalGlobalObject, throwScope, impl.startTrackingRepaints());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionStartTrackingRepaints(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionStartTrackingRepaintsBody>(*lexicalGlobalObject, *callFrame, "startTrackingRepaints");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionStopTrackingRepaintsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    propagateException(*lexicalGlobalObject, throwScope, impl.stopTrackingRepaints());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionStopTrackingRepaints(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionStopTrackingRepaintsBody>(*lexicalGlobalObject, *callFrame, "stopTrackingRepaints");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionStartTrackingLayerFlushesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    propagateException(*lexicalGlobalObject, throwScope, impl.startTrackingLayerFlushes());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionStartTrackingLayerFlushes(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionStartTrackingLayerFlushesBody>(*lexicalGlobalObject, *callFrame, "startTrackingLayerFlushes");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionLayerFlushCountBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLUnsignedLong>(*lexicalGlobalObject, throwScope, impl.layerFlushCount()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionLayerFlushCount(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionLayerFlushCountBody>(*lexicalGlobalObject, *callFrame, "layerFlushCount");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionIsTimerThrottledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto timerHandle = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.isTimerThrottled(WTFMove(timerHandle))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsTimerThrottled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionIsTimerThrottledBody>(*lexicalGlobalObject, *callFrame, "isTimerThrottled");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionIsRequestAnimationFrameThrottledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLBoolean>(impl.isRequestAnimationFrameThrottled()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsRequestAnimationFrameThrottled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionIsRequestAnimationFrameThrottledBody>(*lexicalGlobalObject, *callFrame, "isRequestAnimationFrameThrottled");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionAreTimersThrottledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLBoolean>(impl.areTimersThrottled()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionAreTimersThrottled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionAreTimersThrottledBody>(*lexicalGlobalObject, *callFrame, "areTimersThrottled");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetLowPowerModeEnabledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setLowPowerModeEnabled(WTFMove(enabled)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetLowPowerModeEnabled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetLowPowerModeEnabledBody>(*lexicalGlobalObject, *callFrame, "setLowPowerModeEnabled");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionStartTrackingStyleRecalcsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    propagateException(*lexicalGlobalObject, throwScope, impl.startTrackingStyleRecalcs());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionStartTrackingStyleRecalcs(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionStartTrackingStyleRecalcsBody>(*lexicalGlobalObject, *callFrame, "startTrackingStyleRecalcs");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionStyleRecalcCountBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLUnsignedLong>(*lexicalGlobalObject, throwScope, impl.styleRecalcCount()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionStyleRecalcCount(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionStyleRecalcCountBody>(*lexicalGlobalObject, *callFrame, "styleRecalcCount");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionStartTrackingCompositingUpdatesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    propagateException(*lexicalGlobalObject, throwScope, impl.startTrackingCompositingUpdates());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionStartTrackingCompositingUpdates(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionStartTrackingCompositingUpdatesBody>(*lexicalGlobalObject, *callFrame, "startTrackingCompositingUpdates");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionCompositingUpdateCountBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLUnsignedLong>(*lexicalGlobalObject, throwScope, impl.compositingUpdateCount()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionCompositingUpdateCount(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionCompositingUpdateCountBody>(*lexicalGlobalObject, *callFrame, "compositingUpdateCount");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionUpdateLayoutIgnorePendingStylesheetsAndRunPostLayoutTasksBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto node = convert<IDLNullable<IDLInterface<Node>>>(*lexicalGlobalObject, callFrame->argument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "Internals", "updateLayoutIgnorePendingStylesheetsAndRunPostLayoutTasks", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.updateLayoutIgnorePendingStylesheetsAndRunPostLayoutTasks(WTFMove(node)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionUpdateLayoutIgnorePendingStylesheetsAndRunPostLayoutTasks(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionUpdateLayoutIgnorePendingStylesheetsAndRunPostLayoutTasksBody>(*lexicalGlobalObject, *callFrame, "updateLayoutIgnorePendingStylesheetsAndRunPostLayoutTasks");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionGetCurrentCursorInfoBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.getCurrentCursorInfo()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionGetCurrentCursorInfo(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionGetCurrentCursorInfoBody>(*lexicalGlobalObject, *callFrame, "getCurrentCursorInfo");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionMarkerTextForListItemBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "markerTextForListItem", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.markerTextForListItem(*element)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMarkerTextForListItem(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionMarkerTextForListItemBody>(*lexicalGlobalObject, *callFrame, "markerTextForListItem");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionToolTipFromElementBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "toolTipFromElement", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.toolTipFromElement(*element)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionToolTipFromElement(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionToolTipFromElementBody>(*lexicalGlobalObject, *callFrame, "toolTipFromElement");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionDeserializeBufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto buffer = convert<IDLArrayBuffer>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "buffer", "Internals", "deserializeBuffer", "ArrayBuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLSerializedScriptValue<SerializedScriptValue>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.deserializeBuffer(*buffer)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionDeserializeBuffer(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionDeserializeBufferBody>(*lexicalGlobalObject, *callFrame, "deserializeBuffer");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSerializeObjectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto object = convert<IDLSerializedScriptValue<SerializedScriptValue>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLArrayBuffer>(*lexicalGlobalObject, *castedThis->globalObject(), impl.serializeObject(WTFMove(object))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSerializeObject(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSerializeObjectBody>(*lexicalGlobalObject, *callFrame, "serializeObject");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionIsFromCurrentWorldBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto obj = convert<IDLAny>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.isFromCurrentWorld(WTFMove(obj))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsFromCurrentWorld(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionIsFromCurrentWorldBody>(*lexicalGlobalObject, *callFrame, "isFromCurrentWorld");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionEvaluateInWorldIgnoringExceptionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto name = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto source = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLAny>(impl.evaluateInWorldIgnoringException(WTFMove(name), WTFMove(source))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionEvaluateInWorldIgnoringException(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionEvaluateInWorldIgnoringExceptionBody>(*lexicalGlobalObject, *callFrame, "evaluateInWorldIgnoringException");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetUsesOverlayScrollbarsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setUsesOverlayScrollbars(WTFMove(enabled));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetUsesOverlayScrollbars(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetUsesOverlayScrollbarsBody>(*lexicalGlobalObject, *callFrame, "setUsesOverlayScrollbars");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetUsesMockScrollAnimatorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setUsesMockScrollAnimator(WTFMove(enabled));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetUsesMockScrollAnimator(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetUsesMockScrollAnimatorBody>(*lexicalGlobalObject, *callFrame, "setUsesMockScrollAnimator");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionForceReloadBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto endToEnd = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.forceReload(WTFMove(endToEnd));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionForceReload(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionForceReloadBody>(*lexicalGlobalObject, *callFrame, "forceReload");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionReloadExpiredOnlyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.reloadExpiredOnly();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionReloadExpiredOnly(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionReloadExpiredOnlyBody>(*lexicalGlobalObject, *callFrame, "reloadExpiredOnly");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionEnableAutoSizeModeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto width = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto height = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.enableAutoSizeMode(WTFMove(enabled), WTFMove(width), WTFMove(height));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionEnableAutoSizeMode(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionEnableAutoSizeModeBody>(*lexicalGlobalObject, *callFrame, "enableAutoSizeMode");
}

#if ENABLE(VIDEO)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionMediaResponseSourcesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto media = convert<IDLInterface<HTMLMediaElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "media", "Internals", "mediaResponseSources", "HTMLMediaElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLSequence<IDLDOMString>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.mediaResponseSources(*media)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMediaResponseSources(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionMediaResponseSourcesBody>(*lexicalGlobalObject, *callFrame, "mediaResponseSources");
}

#endif

#if ENABLE(VIDEO)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionMediaResponseContentRangesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto media = convert<IDLInterface<HTMLMediaElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "media", "Internals", "mediaResponseContentRanges", "HTMLMediaElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLSequence<IDLDOMString>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.mediaResponseContentRanges(*media)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMediaResponseContentRanges(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionMediaResponseContentRangesBody>(*lexicalGlobalObject, *callFrame, "mediaResponseContentRanges");
}

#endif

#if ENABLE(VIDEO)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSimulateAudioInterruptionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<HTMLMediaElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "simulateAudioInterruption", "HTMLMediaElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.simulateAudioInterruption(*element);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSimulateAudioInterruption(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSimulateAudioInterruptionBody>(*lexicalGlobalObject, *callFrame, "simulateAudioInterruption");
}

#endif

#if ENABLE(VIDEO)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionMediaElementHasCharacteristicBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<HTMLMediaElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "mediaElementHasCharacteristic", "HTMLMediaElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto characteristic = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.mediaElementHasCharacteristic(*element, WTFMove(characteristic))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMediaElementHasCharacteristic(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionMediaElementHasCharacteristicBody>(*lexicalGlobalObject, *callFrame, "mediaElementHasCharacteristic");
}

#endif

#if ENABLE(VIDEO)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionBeginSimulatedHDCPErrorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto media = convert<IDLInterface<HTMLMediaElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "media", "Internals", "beginSimulatedHDCPError", "HTMLMediaElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.beginSimulatedHDCPError(*media);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionBeginSimulatedHDCPError(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionBeginSimulatedHDCPErrorBody>(*lexicalGlobalObject, *callFrame, "beginSimulatedHDCPError");
}

#endif

#if ENABLE(VIDEO)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionEndSimulatedHDCPErrorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto media = convert<IDLInterface<HTMLMediaElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "media", "Internals", "endSimulatedHDCPError", "HTMLMediaElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.endSimulatedHDCPError(*media);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionEndSimulatedHDCPError(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionEndSimulatedHDCPErrorBody>(*lexicalGlobalObject, *callFrame, "endSimulatedHDCPError");
}

#endif

#if ENABLE(VIDEO)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionElementShouldBufferDataBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto media = convert<IDLInterface<HTMLMediaElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "media", "Internals", "elementShouldBufferData", "HTMLMediaElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.elementShouldBufferData(*media)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionElementShouldBufferData(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionElementShouldBufferDataBody>(*lexicalGlobalObject, *callFrame, "elementShouldBufferData");
}

#endif

#if ENABLE(VIDEO)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionElementBufferingPolicyBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto media = convert<IDLInterface<HTMLMediaElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "media", "Internals", "elementBufferingPolicy", "HTMLMediaElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.elementBufferingPolicy(*media)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionElementBufferingPolicy(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionElementBufferingPolicyBody>(*lexicalGlobalObject, *callFrame, "elementBufferingPolicy");
}

#endif

#if ENABLE(VIDEO)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionPrivatePlayerVolumeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto media = convert<IDLInterface<HTMLMediaElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "media", "Internals", "privatePlayerVolume", "HTMLMediaElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDouble>(impl.privatePlayerVolume(*media)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPrivatePlayerVolume(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionPrivatePlayerVolumeBody>(*lexicalGlobalObject, *callFrame, "privatePlayerVolume");
}

#endif

#if ENABLE(LEGACY_ENCRYPTED_MEDIA)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionInitializeMockCDMBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.initializeMockCDM();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionInitializeMockCDM(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionInitializeMockCDMBody>(*lexicalGlobalObject, *callFrame, "initializeMockCDM");
}

#endif

#if ENABLE(ENCRYPTED_MEDIA)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionRegisterMockCDMBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<MockCDMFactory>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.registerMockCDM()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionRegisterMockCDM(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionRegisterMockCDMBody>(*lexicalGlobalObject, *callFrame, "registerMockCDM");
}

#endif

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionEnableMockMediaCapabilitiesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.enableMockMediaCapabilities();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionEnableMockMediaCapabilities(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionEnableMockMediaCapabilitiesBody>(*lexicalGlobalObject, *callFrame, "enableMockMediaCapabilities");
}

#if ENABLE(SPEECH_SYNTHESIS)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionEnableMockSpeechSynthesizerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.enableMockSpeechSynthesizer();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionEnableMockSpeechSynthesizer(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionEnableMockSpeechSynthesizerBody>(*lexicalGlobalObject, *callFrame, "enableMockSpeechSynthesizer");
}

#endif

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionGetImageSourceURLBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "getImageSourceURL", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.getImageSourceURL(*element)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionGetImageSourceURL(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionGetImageSourceURLBody>(*lexicalGlobalObject, *callFrame, "getImageSourceURL");
}

#if ENABLE(VIDEO_TRACK)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionCaptionsStyleSheetOverrideBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.captionsStyleSheetOverride()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionCaptionsStyleSheetOverride(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionCaptionsStyleSheetOverrideBody>(*lexicalGlobalObject, *callFrame, "captionsStyleSheetOverride");
}

#endif

#if ENABLE(VIDEO_TRACK)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetCaptionsStyleSheetOverrideBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto override = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setCaptionsStyleSheetOverride(WTFMove(override)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetCaptionsStyleSheetOverride(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetCaptionsStyleSheetOverrideBody>(*lexicalGlobalObject, *callFrame, "setCaptionsStyleSheetOverride");
}

#endif

#if ENABLE(VIDEO_TRACK)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetPrimaryAudioTrackLanguageOverrideBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto language = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setPrimaryAudioTrackLanguageOverride(WTFMove(language)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetPrimaryAudioTrackLanguageOverride(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetPrimaryAudioTrackLanguageOverrideBody>(*lexicalGlobalObject, *callFrame, "setPrimaryAudioTrackLanguageOverride");
}

#endif

#if ENABLE(VIDEO_TRACK)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetCaptionDisplayModeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto mode = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setCaptionDisplayMode(WTFMove(mode)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetCaptionDisplayMode(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetCaptionDisplayModeBody>(*lexicalGlobalObject, *callFrame, "setCaptionDisplayMode");
}

#endif

#if ENABLE(VIDEO_TRACK)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionCreateGenericCueBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto startTime = convert<IDLDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto endTime = convert<IDLDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto text = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<TextTrackCueGeneric>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.createGenericCue(WTFMove(startTime), WTFMove(endTime), WTFMove(text))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionCreateGenericCue(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionCreateGenericCueBody>(*lexicalGlobalObject, *callFrame, "createGenericCue");
}

#endif

#if ENABLE(VIDEO)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionCreateTimeRangesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto startTimes = convert<IDLFloat32Array>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "startTimes", "Internals", "createTimeRanges", "Float32Array"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto endTimes = convert<IDLFloat32Array>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "endTimes", "Internals", "createTimeRanges", "Float32Array"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<TimeRanges>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.createTimeRanges(startTimes.releaseNonNull(), endTimes.releaseNonNull())));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionCreateTimeRanges(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionCreateTimeRangesBody>(*lexicalGlobalObject, *callFrame, "createTimeRanges");
}

#endif

#if ENABLE(VIDEO)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionClosestTimeToTimeRangesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto time = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto ranges = convert<IDLInterface<TimeRanges>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "ranges", "Internals", "closestTimeToTimeRanges", "TimeRanges"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLUnrestrictedDouble>(impl.closestTimeToTimeRanges(WTFMove(time), *ranges)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionClosestTimeToTimeRanges(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionClosestTimeToTimeRangesBody>(*lexicalGlobalObject, *callFrame, "closestTimeToTimeRanges");
}

#endif

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionIsSelectPopupVisibleBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<HTMLSelectElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "isSelectPopupVisible", "HTMLSelectElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.isSelectPopupVisible(*element)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsSelectPopupVisible(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionIsSelectPopupVisibleBody>(*lexicalGlobalObject, *callFrame, "isSelectPopupVisible");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionIsPluginUnavailabilityIndicatorObscuredBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "isPluginUnavailabilityIndicatorObscured", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.isPluginUnavailabilityIndicatorObscured(*element)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsPluginUnavailabilityIndicatorObscured(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionIsPluginUnavailabilityIndicatorObscuredBody>(*lexicalGlobalObject, *callFrame, "isPluginUnavailabilityIndicatorObscured");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionUnavailablePluginReplacementTextBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "unavailablePluginReplacementText", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.unavailablePluginReplacementText(*element)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionUnavailablePluginReplacementText(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionUnavailablePluginReplacementTextBody>(*lexicalGlobalObject, *callFrame, "unavailablePluginReplacementText");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionIsPluginSnapshottedBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "isPluginSnapshotted", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.isPluginSnapshotted(*element)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsPluginSnapshotted(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionIsPluginSnapshottedBody>(*lexicalGlobalObject, *callFrame, "isPluginSnapshotted");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionPluginIsBelowSizeThresholdBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "pluginIsBelowSizeThreshold", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.pluginIsBelowSizeThreshold(*element)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPluginIsBelowSizeThreshold(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionPluginIsBelowSizeThresholdBody>(*lexicalGlobalObject, *callFrame, "pluginIsBelowSizeThreshold");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSelectionBoundsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<DOMRect>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.selectionBounds()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSelectionBounds(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSelectionBoundsBody>(*lexicalGlobalObject, *callFrame, "selectionBounds");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetSelectionWithoutValidationBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 4))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto baseNode = convert<IDLInterface<Node>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "baseNode", "Internals", "setSelectionWithoutValidation", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto baseOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto extentNode = convert<IDLNullable<IDLInterface<Node>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(2), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 2, "extentNode", "Internals", "setSelectionWithoutValidation", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto extentOffset = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(3));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setSelectionWithoutValidation(*baseNode, WTFMove(baseOffset), WTFMove(extentNode), WTFMove(extentOffset));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetSelectionWithoutValidation(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetSelectionWithoutValidationBody>(*lexicalGlobalObject, *callFrame, "setSelectionWithoutValidation");
}

#if ENABLE(MEDIA_SOURCE)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionInitializeMockMediaSourceBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.initializeMockMediaSource();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionInitializeMockMediaSource(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionInitializeMockMediaSourceBody>(*lexicalGlobalObject, *callFrame, "initializeMockMediaSource");
}

#endif

#if ENABLE(MEDIA_SOURCE)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionBufferedSamplesForTrackIDBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto buffer = convert<IDLInterface<SourceBuffer>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "buffer", "Internals", "bufferedSamplesForTrackID", "SourceBuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto trackID = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLSequence<IDLDOMString>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.bufferedSamplesForTrackID(*buffer, WTFMove(trackID))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionBufferedSamplesForTrackID(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionBufferedSamplesForTrackIDBody>(*lexicalGlobalObject, *callFrame, "bufferedSamplesForTrackID");
}

#endif

#if ENABLE(MEDIA_SOURCE)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionEnqueuedSamplesForTrackIDBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto buffer = convert<IDLInterface<SourceBuffer>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "buffer", "Internals", "enqueuedSamplesForTrackID", "SourceBuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto trackID = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLSequence<IDLDOMString>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.enqueuedSamplesForTrackID(*buffer, WTFMove(trackID))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionEnqueuedSamplesForTrackID(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionEnqueuedSamplesForTrackIDBody>(*lexicalGlobalObject, *callFrame, "enqueuedSamplesForTrackID");
}

#endif

#if ENABLE(MEDIA_SOURCE)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetShouldGenerateTimestampsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto buffer = convert<IDLInterface<SourceBuffer>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "buffer", "Internals", "setShouldGenerateTimestamps", "SourceBuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto flag = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setShouldGenerateTimestamps(*buffer, WTFMove(flag));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetShouldGenerateTimestamps(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetShouldGenerateTimestampsBody>(*lexicalGlobalObject, *callFrame, "setShouldGenerateTimestamps");
}

#endif

#if ENABLE(MEDIA_SOURCE)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionMinimumUpcomingPresentationTimeForTrackIDBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto buffer = convert<IDLInterface<SourceBuffer>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "buffer", "Internals", "minimumUpcomingPresentationTimeForTrackID", "SourceBuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto trackID = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDouble>(impl.minimumUpcomingPresentationTimeForTrackID(*buffer, WTFMove(trackID))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMinimumUpcomingPresentationTimeForTrackID(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionMinimumUpcomingPresentationTimeForTrackIDBody>(*lexicalGlobalObject, *callFrame, "minimumUpcomingPresentationTimeForTrackID");
}

#endif

#if ENABLE(MEDIA_SOURCE)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetMaximumQueueDepthForTrackIDBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto buffer = convert<IDLInterface<SourceBuffer>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "buffer", "Internals", "setMaximumQueueDepthForTrackID", "SourceBuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto trackID = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto maxQueueDepth = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setMaximumQueueDepthForTrackID(*buffer, WTFMove(trackID), WTFMove(maxQueueDepth));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetMaximumQueueDepthForTrackID(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetMaximumQueueDepthForTrackIDBody>(*lexicalGlobalObject, *callFrame, "setMaximumQueueDepthForTrackID");
}

#endif

#if ENABLE(VIDEO)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionBeginMediaSessionInterruptionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto interruptionType = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.beginMediaSessionInterruption(WTFMove(interruptionType)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionBeginMediaSessionInterruption(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionBeginMediaSessionInterruptionBody>(*lexicalGlobalObject, *callFrame, "beginMediaSessionInterruption");
}

#endif

#if ENABLE(VIDEO)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionEndMediaSessionInterruptionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto flags = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.endMediaSessionInterruption(WTFMove(flags));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionEndMediaSessionInterruption(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionEndMediaSessionInterruptionBody>(*lexicalGlobalObject, *callFrame, "endMediaSessionInterruption");
}

#endif

#if ENABLE(MEDIA_SESSION)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSendMediaSessionStartOfInterruptionNotificationBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto category = convert<IDLEnumeration<Internals::MediaSessionInterruptingCategory>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 0, "category", "Internals", "sendMediaSessionStartOfInterruptionNotification", expectedEnumerationValues<Internals::MediaSessionInterruptingCategory>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.sendMediaSessionStartOfInterruptionNotification(WTFMove(category));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSendMediaSessionStartOfInterruptionNotification(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSendMediaSessionStartOfInterruptionNotificationBody>(*lexicalGlobalObject, *callFrame, "sendMediaSessionStartOfInterruptionNotification");
}

#endif

#if ENABLE(MEDIA_SESSION)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSendMediaSessionEndOfInterruptionNotificationBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto category = convert<IDLEnumeration<Internals::MediaSessionInterruptingCategory>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 0, "category", "Internals", "sendMediaSessionEndOfInterruptionNotification", expectedEnumerationValues<Internals::MediaSessionInterruptingCategory>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.sendMediaSessionEndOfInterruptionNotification(WTFMove(category));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSendMediaSessionEndOfInterruptionNotification(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSendMediaSessionEndOfInterruptionNotificationBody>(*lexicalGlobalObject, *callFrame, "sendMediaSessionEndOfInterruptionNotification");
}

#endif

#if ENABLE(MEDIA_SESSION)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionMediaSessionCurrentStateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto session = convert<IDLInterface<MediaSession>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "session", "Internals", "mediaSessionCurrentState", "MediaSession"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.mediaSessionCurrentState(*session)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMediaSessionCurrentState(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionMediaSessionCurrentStateBody>(*lexicalGlobalObject, *callFrame, "mediaSessionCurrentState");
}

#endif

#if ENABLE(MEDIA_SESSION)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionMediaElementPlayerVolumeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<HTMLMediaElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "mediaElementPlayerVolume", "HTMLMediaElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDouble>(impl.mediaElementPlayerVolume(*element)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMediaElementPlayerVolume(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionMediaElementPlayerVolumeBody>(*lexicalGlobalObject, *callFrame, "mediaElementPlayerVolume");
}

#endif

#if ENABLE(MEDIA_SESSION)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSendMediaControlEventBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto event = convert<IDLEnumeration<Internals::MediaControlEvent>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 0, "event", "Internals", "sendMediaControlEvent", expectedEnumerationValues<Internals::MediaControlEvent>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.sendMediaControlEvent(WTFMove(event));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSendMediaControlEvent(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSendMediaControlEventBody>(*lexicalGlobalObject, *callFrame, "sendMediaControlEvent");
}

#endif

#if ENABLE(VIDEO)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionApplicationWillBecomeInactiveBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.applicationWillBecomeInactive();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionApplicationWillBecomeInactive(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionApplicationWillBecomeInactiveBody>(*lexicalGlobalObject, *callFrame, "applicationWillBecomeInactive");
}

#endif

#if ENABLE(VIDEO)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionApplicationDidBecomeActiveBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.applicationDidBecomeActive();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionApplicationDidBecomeActive(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionApplicationDidBecomeActiveBody>(*lexicalGlobalObject, *callFrame, "applicationDidBecomeActive");
}

#endif

#if ENABLE(VIDEO)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionApplicationWillEnterForegroundBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto suspendedUnderLock = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.applicationWillEnterForeground(WTFMove(suspendedUnderLock));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionApplicationWillEnterForeground(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionApplicationWillEnterForegroundBody>(*lexicalGlobalObject, *callFrame, "applicationWillEnterForeground");
}

#endif

#if ENABLE(VIDEO)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionApplicationDidEnterBackgroundBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto suspendedUnderLock = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.applicationDidEnterBackground(WTFMove(suspendedUnderLock));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionApplicationDidEnterBackground(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionApplicationDidEnterBackgroundBody>(*lexicalGlobalObject, *callFrame, "applicationDidEnterBackground");
}

#endif

#if ENABLE(VIDEO)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetMediaSessionRestrictionsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto mediaType = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto restrictions = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setMediaSessionRestrictions(WTFMove(mediaType), WTFMove(restrictions)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetMediaSessionRestrictions(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetMediaSessionRestrictionsBody>(*lexicalGlobalObject, *callFrame, "setMediaSessionRestrictions");
}

#endif

#if ENABLE(VIDEO)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionMediaSessionRestrictionsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto mediaType = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.mediaSessionRestrictions(WTFMove(mediaType))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMediaSessionRestrictions(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionMediaSessionRestrictionsBody>(*lexicalGlobalObject, *callFrame, "mediaSessionRestrictions");
}

#endif

#if ENABLE(VIDEO)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetMediaElementRestrictionsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<HTMLMediaElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "setMediaElementRestrictions", "HTMLMediaElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto restrictions = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setMediaElementRestrictions(*element, WTFMove(restrictions));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetMediaElementRestrictions(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetMediaElementRestrictionsBody>(*lexicalGlobalObject, *callFrame, "setMediaElementRestrictions");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetAudioContextRestrictionsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto context = convert<IDLInterface<AudioContext>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "context", "Internals", "setAudioContextRestrictions", "AudioContext"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto restrictions = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setAudioContextRestrictions(*context, WTFMove(restrictions));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetAudioContextRestrictions(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetAudioContextRestrictionsBody>(*lexicalGlobalObject, *callFrame, "setAudioContextRestrictions");
}

#endif

#if ENABLE(VIDEO)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionPostRemoteControlCommandBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto command = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto argument = callFrame->argument(1).isUndefined() ? 0 : convert<IDLUnrestrictedFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.postRemoteControlCommand(WTFMove(command), WTFMove(argument)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPostRemoteControlCommand(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionPostRemoteControlCommandBody>(*lexicalGlobalObject, *callFrame, "postRemoteControlCommand");
}

#endif

#if ENABLE(WIRELESS_PLAYBACK_TARGET)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetMockMediaPlaybackTargetPickerEnabledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setMockMediaPlaybackTargetPickerEnabled(WTFMove(enabled));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetMockMediaPlaybackTargetPickerEnabled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetMockMediaPlaybackTargetPickerEnabledBody>(*lexicalGlobalObject, *callFrame, "setMockMediaPlaybackTargetPickerEnabled");
}

#endif

#if ENABLE(WIRELESS_PLAYBACK_TARGET)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetMockMediaPlaybackTargetPickerStateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto deviceName = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto deviceState = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setMockMediaPlaybackTargetPickerState(WTFMove(deviceName), WTFMove(deviceState)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetMockMediaPlaybackTargetPickerState(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetMockMediaPlaybackTargetPickerStateBody>(*lexicalGlobalObject, *callFrame, "setMockMediaPlaybackTargetPickerState");
}

#endif

#if ENABLE(WIRELESS_PLAYBACK_TARGET)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionMockMediaPlaybackTargetPickerDismissPopupBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.mockMediaPlaybackTargetPickerDismissPopup();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMockMediaPlaybackTargetPickerDismissPopup(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionMockMediaPlaybackTargetPickerDismissPopupBody>(*lexicalGlobalObject, *callFrame, "mockMediaPlaybackTargetPickerDismissPopup");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetCustomPrivateRecorderCreatorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.setCustomPrivateRecorderCreator();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetCustomPrivateRecorderCreator(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetCustomPrivateRecorderCreatorBody>(*lexicalGlobalObject, *callFrame, "setCustomPrivateRecorderCreator");
}

#endif

#if ENABLE(WEB_AUDIO)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionUseMockAudioDestinationCocoaBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.useMockAudioDestinationCocoa();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionUseMockAudioDestinationCocoa(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionUseMockAudioDestinationCocoaBody>(*lexicalGlobalObject, *callFrame, "useMockAudioDestinationCocoa");
}

#endif

#if ENABLE(WEB_RTC)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionEmulateRTCPeerConnectionPlatformEventBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto connection = convert<IDLInterface<RTCPeerConnection>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "connection", "Internals", "emulateRTCPeerConnectionPlatformEvent", "RTCPeerConnection"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto action = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.emulateRTCPeerConnectionPlatformEvent(*connection, WTFMove(action));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionEmulateRTCPeerConnectionPlatformEvent(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionEmulateRTCPeerConnectionPlatformEventBody>(*lexicalGlobalObject, *callFrame, "emulateRTCPeerConnectionPlatformEvent");
}

#endif

#if ENABLE(WEB_RTC)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionUseMockRTCPeerConnectionFactoryBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto testCase = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.useMockRTCPeerConnectionFactory(WTFMove(testCase));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionUseMockRTCPeerConnectionFactory(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionUseMockRTCPeerConnectionFactoryBody>(*lexicalGlobalObject, *callFrame, "useMockRTCPeerConnectionFactory");
}

#endif

#if ENABLE(WEB_RTC)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetICECandidateFilteringBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setICECandidateFiltering(WTFMove(enabled));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetICECandidateFiltering(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetICECandidateFilteringBody>(*lexicalGlobalObject, *callFrame, "setICECandidateFiltering");
}

#endif

#if ENABLE(WEB_RTC)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetEnumeratingAllNetworkInterfacesEnabledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setEnumeratingAllNetworkInterfacesEnabled(WTFMove(enabled));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetEnumeratingAllNetworkInterfacesEnabled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetEnumeratingAllNetworkInterfacesEnabledBody>(*lexicalGlobalObject, *callFrame, "setEnumeratingAllNetworkInterfacesEnabled");
}

#endif

#if ENABLE(WEB_RTC)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionStopPeerConnectionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto connection = convert<IDLInterface<RTCPeerConnection>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "connection", "Internals", "stopPeerConnection", "RTCPeerConnection"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.stopPeerConnection(*connection);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionStopPeerConnection(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionStopPeerConnectionBody>(*lexicalGlobalObject, *callFrame, "stopPeerConnection");
}

#endif

#if ENABLE(WEB_RTC)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionClearPeerConnectionFactoryBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.clearPeerConnectionFactory();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionClearPeerConnectionFactory(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionClearPeerConnectionFactoryBody>(*lexicalGlobalObject, *callFrame, "clearPeerConnectionFactory");
}

#endif

#if ENABLE(WEB_RTC)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetEnableWebRTCEncryptionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setEnableWebRTCEncryption(WTFMove(enabled));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetEnableWebRTCEncryption(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetEnableWebRTCEncryptionBody>(*lexicalGlobalObject, *callFrame, "setEnableWebRTCEncryption");
}

#endif

#if ENABLE(WEB_RTC)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetUseDTLS10Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto use = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setUseDTLS10(WTFMove(use));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetUseDTLS10(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetUseDTLS10Body>(*lexicalGlobalObject, *callFrame, "setUseDTLS10");
}

#endif

#if ENABLE(WEB_RTC)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetUseGPUProcessForWebRTCBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto use = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setUseGPUProcessForWebRTC(WTFMove(use));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetUseGPUProcessForWebRTC(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetUseGPUProcessForWebRTCBody>(*lexicalGlobalObject, *callFrame, "setUseGPUProcessForWebRTC");
}

#endif

#if ENABLE(VIDEO)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSimulateSystemSleepBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.simulateSystemSleep();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSimulateSystemSleep(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSimulateSystemSleepBody>(*lexicalGlobalObject, *callFrame, "simulateSystemSleep");
}

#endif

#if ENABLE(VIDEO)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSimulateSystemWakeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.simulateSystemWake();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSimulateSystemWake(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSimulateSystemWakeBody>(*lexicalGlobalObject, *callFrame, "simulateSystemWake");
}

#endif

#if ENABLE(VIDEO)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionElementIsBlockingDisplaySleepBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<HTMLMediaElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "elementIsBlockingDisplaySleep", "HTMLMediaElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.elementIsBlockingDisplaySleep(*element)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionElementIsBlockingDisplaySleep(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionElementIsBlockingDisplaySleepBody>(*lexicalGlobalObject, *callFrame, "elementIsBlockingDisplaySleep");
}

#endif

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionInstallMockPageOverlayBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto type = convert<IDLEnumeration<Internals::PageOverlayType>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 0, "type", "Internals", "installMockPageOverlay", expectedEnumerationValues<Internals::PageOverlayType>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<MockPageOverlay>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.installMockPageOverlay(WTFMove(type))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionInstallMockPageOverlay(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionInstallMockPageOverlayBody>(*lexicalGlobalObject, *callFrame, "installMockPageOverlay");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionPageOverlayLayerTreeAsTextBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto flags = convert<IDLUnsignedShort>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.pageOverlayLayerTreeAsText(WTFMove(flags))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPageOverlayLayerTreeAsText(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionPageOverlayLayerTreeAsTextBody>(*lexicalGlobalObject, *callFrame, "pageOverlayLayerTreeAsText");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetPageMutedBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto mutedState = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setPageMuted(WTFMove(mutedState));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetPageMuted(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetPageMutedBody>(*lexicalGlobalObject, *callFrame, "setPageMuted");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionPageMediaStateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.pageMediaState()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPageMediaState(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionPageMediaStateBody>(*lexicalGlobalObject, *callFrame, "pageMediaState");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetPageDefersLoadingBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto defersLoading = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setPageDefersLoading(WTFMove(defersLoading));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetPageDefersLoading(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetPageDefersLoadingBody>(*lexicalGlobalObject, *callFrame, "setPageDefersLoading");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionPageDefersLoadingBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.pageDefersLoading()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPageDefersLoading(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionPageDefersLoadingBody>(*lexicalGlobalObject, *callFrame, "pageDefersLoading");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionCreateFileBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto url = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLInterface<File>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.createFile(WTFMove(url))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionCreateFile(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionCreateFileBody>(*lexicalGlobalObject, *callFrame, "createFile");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionQueueMicroTaskBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto testNumber = convert<IDLLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.queueMicroTask(WTFMove(testNumber));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionQueueMicroTask(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionQueueMicroTaskBody>(*lexicalGlobalObject, *callFrame, "queueMicroTask");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionTestPreloaderSettingViewportBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLBoolean>(impl.testPreloaderSettingViewport()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionTestPreloaderSettingViewport(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionTestPreloaderSettingViewportBody>(*lexicalGlobalObject, *callFrame, "testPreloaderSettingViewport");
}

#if ENABLE(CSS_SCROLL_SNAP)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionScrollSnapOffsetsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "scrollSnapOffsets", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.scrollSnapOffsets(*element)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionScrollSnapOffsets(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionScrollSnapOffsetsBody>(*lexicalGlobalObject, *callFrame, "scrollSnapOffsets");
}

#endif

#if ENABLE(CSS_SCROLL_SNAP)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetPlatformMomentumScrollingPredictionEnabledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setPlatformMomentumScrollingPredictionEnabled(WTFMove(enabled));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetPlatformMomentumScrollingPredictionEnabled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetPlatformMomentumScrollingPredictionEnabledBody>(*lexicalGlobalObject, *callFrame, "setPlatformMomentumScrollingPredictionEnabled");
}

#endif

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionPathStringWithShrinkWrappedRectsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto rectComponents = convert<IDLSequence<IDLDouble>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto radius = convert<IDLDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, throwScope, impl.pathStringWithShrinkWrappedRects(WTFMove(rectComponents), WTFMove(radius))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPathStringWithShrinkWrappedRects(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionPathStringWithShrinkWrappedRectsBody>(*lexicalGlobalObject, *callFrame, "pathStringWithShrinkWrappedRects");
}

#if ENABLE(VIDEO)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionGetCurrentMediaControlsStatusForElementBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<HTMLMediaElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "getCurrentMediaControlsStatusForElement", "HTMLMediaElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.getCurrentMediaControlsStatusForElement(*element)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionGetCurrentMediaControlsStatusForElement(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionGetCurrentMediaControlsStatusForElementBody>(*lexicalGlobalObject, *callFrame, "getCurrentMediaControlsStatusForElement");
}

#endif

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionUserVisibleStringBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto url = convert<IDLInterface<DOMURL>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "url", "Internals", "userVisibleString", "DOMURL"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.userVisibleString(*url)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionUserVisibleString(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionUserVisibleStringBody>(*lexicalGlobalObject, *callFrame, "userVisibleString");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetShowAllPluginsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto showAll = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setShowAllPlugins(WTFMove(showAll));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetShowAllPlugins(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetShowAllPluginsBody>(*lexicalGlobalObject, *callFrame, "setShowAllPlugins");
}

#if ENABLE(STREAMS_API)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionCloneArrayBufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto buffer = convert<IDLAny>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto srcByteOffset = convert<IDLAny>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto byteLength = convert<IDLAny>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLAny>(impl.cloneArrayBuffer(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(buffer), WTFMove(srcByteOffset), WTFMove(byteLength))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionCloneArrayBuffer(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionCloneArrayBufferBody>(*lexicalGlobalObject, *callFrame, "cloneArrayBuffer");
}

#endif

#if ENABLE(STREAMS_API)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionIsReadableStreamDisturbedBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto stream = convert<IDLAny>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.isReadableStreamDisturbed(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(stream))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsReadableStreamDisturbed(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionIsReadableStreamDisturbedBody>(*lexicalGlobalObject, *callFrame, "isReadableStreamDisturbed");
}

#endif

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionResourceLoadStatisticsForURLBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto url = convert<IDLInterface<DOMURL>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "url", "Internals", "resourceLoadStatisticsForURL", "DOMURL"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.resourceLoadStatisticsForURL(*url)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionResourceLoadStatisticsForURL(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionResourceLoadStatisticsForURLBody>(*lexicalGlobalObject, *callFrame, "resourceLoadStatisticsForURL");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetResourceLoadStatisticsEnabledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto enable = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setResourceLoadStatisticsEnabled(WTFMove(enable));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetResourceLoadStatisticsEnabled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetResourceLoadStatisticsEnabledBody>(*lexicalGlobalObject, *callFrame, "setResourceLoadStatisticsEnabled");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetCanShowModalDialogOverrideBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto allow = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setCanShowModalDialogOverride(WTFMove(allow)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetCanShowModalDialogOverride(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetCanShowModalDialogOverrideBody>(*lexicalGlobalObject, *callFrame, "setCanShowModalDialogOverride");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionComposedTreeAsTextBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto parent = convert<IDLInterface<Node>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "parent", "Internals", "composedTreeAsText", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.composedTreeAsText(*parent)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionComposedTreeAsText(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionComposedTreeAsTextBody>(*lexicalGlobalObject, *callFrame, "composedTreeAsText");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionIsProcessingUserGestureBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLBoolean>(impl.isProcessingUserGesture()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsProcessingUserGesture(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionIsProcessingUserGestureBody>(*lexicalGlobalObject, *callFrame, "isProcessingUserGesture");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionLastHandledUserGestureTimestampBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLDouble>(impl.lastHandledUserGestureTimestamp()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionLastHandledUserGestureTimestamp(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionLastHandledUserGestureTimestampBody>(*lexicalGlobalObject, *callFrame, "lastHandledUserGestureTimestamp");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionWithUserGestureBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto callback = convert<IDLCallbackFunction<JSVoidCallback>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 0, "callback", "Internals", "withUserGesture"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.withUserGesture(callback.releaseNonNull());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionWithUserGesture(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionWithUserGestureBody>(*lexicalGlobalObject, *callFrame, "withUserGesture");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionUserIsInteractingBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLBoolean>(impl.userIsInteracting()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionUserIsInteracting(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionUserIsInteractingBody>(*lexicalGlobalObject, *callFrame, "userIsInteracting");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionObserveGCBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto observed = convert<IDLAny>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLInterface<GCObservation>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.observeGC(WTFMove(observed))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionObserveGC(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionObserveGCBody>(*lexicalGlobalObject, *callFrame, "observeGC");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetUserInterfaceLayoutDirectionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto userInterfaceLayoutDirection = convert<IDLEnumeration<Internals::UserInterfaceLayoutDirection>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 0, "userInterfaceLayoutDirection", "Internals", "setUserInterfaceLayoutDirection", expectedEnumerationValues<Internals::UserInterfaceLayoutDirection>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setUserInterfaceLayoutDirection(WTFMove(userInterfaceLayoutDirection));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetUserInterfaceLayoutDirection(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetUserInterfaceLayoutDirectionBody>(*lexicalGlobalObject, *callFrame, "setUserInterfaceLayoutDirection");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetBaseWritingDirectionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto direction = convert<IDLEnumeration<Internals::BaseWritingDirection>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 0, "direction", "Internals", "setBaseWritingDirection", expectedEnumerationValues<Internals::BaseWritingDirection>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setBaseWritingDirection(WTFMove(direction));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetBaseWritingDirection(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetBaseWritingDirectionBody>(*lexicalGlobalObject, *callFrame, "setBaseWritingDirection");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionUserPrefersReducedMotionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLBoolean>(impl.userPrefersReducedMotion()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionUserPrefersReducedMotion(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionUserPrefersReducedMotionBody>(*lexicalGlobalObject, *callFrame, "userPrefersReducedMotion");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionReportBacktraceBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.reportBacktrace();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionReportBacktrace(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionReportBacktraceBody>(*lexicalGlobalObject, *callFrame, "reportBacktrace");
}

#if ENABLE(POINTER_LOCK)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionPageHasPendingPointerLockBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLBoolean>(impl.pageHasPendingPointerLock()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPageHasPendingPointerLock(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionPageHasPendingPointerLockBody>(*lexicalGlobalObject, *callFrame, "pageHasPendingPointerLock");
}

#endif

#if ENABLE(POINTER_LOCK)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionPageHasPointerLockBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLBoolean>(impl.pageHasPointerLock()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPageHasPointerLock(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionPageHasPointerLockBody>(*lexicalGlobalObject, *callFrame, "pageHasPointerLock");
}

#endif

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionAccessKeyModifiersBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLSequence<IDLDOMString>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.accessKeyModifiers()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionAccessKeyModifiers(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionAccessKeyModifiersBody>(*lexicalGlobalObject, *callFrame, "accessKeyModifiers");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetQuickLookPasswordBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto password = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setQuickLookPassword(WTFMove(password));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetQuickLookPassword(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetQuickLookPasswordBody>(*lexicalGlobalObject, *callFrame, "setQuickLookPassword");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetAsRunningUserScriptsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    impl.setAsRunningUserScripts(document);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetAsRunningUserScripts(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetAsRunningUserScriptsBody>(*lexicalGlobalObject, *callFrame, "setAsRunningUserScripts");
}

#if ENABLE(APPLE_PAY)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetApplePayIsActiveBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    impl.setApplePayIsActive(document);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetApplePayIsActive(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetApplePayIsActiveBody>(*lexicalGlobalObject, *callFrame, "setApplePayIsActive");
}

#endif

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionDisableTileSizeUpdateDelayBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.disableTileSizeUpdateDelay();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionDisableTileSizeUpdateDelay(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionDisableTileSizeUpdateDelayBody>(*lexicalGlobalObject, *callFrame, "disableTileSizeUpdateDelay");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetSpeculativeTilingDelayDisabledForTestingBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto disabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setSpeculativeTilingDelayDisabledForTesting(WTFMove(disabled));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetSpeculativeTilingDelayDisabledForTesting(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetSpeculativeTilingDelayDisabledForTestingBody>(*lexicalGlobalObject, *callFrame, "setSpeculativeTilingDelayDisabledForTesting");
}

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSimulateWebGLContextChangedBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto context = convert<IDLInterface<WebGLRenderingContext>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "context", "Internals", "simulateWebGLContextChanged", "WebGLRenderingContext"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.simulateWebGLContextChanged(*context);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSimulateWebGLContextChanged(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSimulateWebGLContextChangedBody>(*lexicalGlobalObject, *callFrame, "simulateWebGLContextChanged");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionFailNextGPUStatusCheckBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto context = convert<IDLInterface<WebGLRenderingContext>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "context", "Internals", "failNextGPUStatusCheck", "WebGLRenderingContext"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.failNextGPUStatusCheck(*context);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionFailNextGPUStatusCheck(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionFailNextGPUStatusCheckBody>(*lexicalGlobalObject, *callFrame, "failNextGPUStatusCheck");
}

#endif

#if ENABLE(WEBGL)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionHasLowAndHighPowerGPUsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLBoolean>(impl.hasLowAndHighPowerGPUs()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionHasLowAndHighPowerGPUs(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionHasLowAndHighPowerGPUsBody>(*lexicalGlobalObject, *callFrame, "hasLowAndHighPowerGPUs");
}

#endif

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetPageVisibilityBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto isVisible = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setPageVisibility(WTFMove(isVisible));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetPageVisibility(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetPageVisibilityBody>(*lexicalGlobalObject, *callFrame, "setPageVisibility");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetPageIsFocusedAndActiveBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto isFocused = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setPageIsFocusedAndActive(WTFMove(isFocused));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetPageIsFocusedAndActive(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetPageIsFocusedAndActiveBody>(*lexicalGlobalObject, *callFrame, "setPageIsFocusedAndActive");
}

#if ENABLE(WEB_RTC)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetH264HardwareEncoderAllowedBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto allowed = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setH264HardwareEncoderAllowed(WTFMove(allowed));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetH264HardwareEncoderAllowed(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetH264HardwareEncoderAllowedBody>(*lexicalGlobalObject, *callFrame, "setH264HardwareEncoderAllowed");
}

#endif

#if ENABLE(WEB_RTC)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionApplyRotationForOutgoingVideoSourcesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto connection = convert<IDLInterface<RTCPeerConnection>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "connection", "Internals", "applyRotationForOutgoingVideoSources", "RTCPeerConnection"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.applyRotationForOutgoingVideoSources(*connection);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionApplyRotationForOutgoingVideoSources(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionApplyRotationForOutgoingVideoSourcesBody>(*lexicalGlobalObject, *callFrame, "applyRotationForOutgoingVideoSources");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetMockAudioTrackChannelNumberBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto track = convert<IDLInterface<MediaStreamTrack>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "track", "Internals", "setMockAudioTrackChannelNumber", "MediaStreamTrack"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto count = convert<IDLUnsignedShort>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setMockAudioTrackChannelNumber(*track, WTFMove(count));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetMockAudioTrackChannelNumber(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetMockAudioTrackChannelNumberBody>(*lexicalGlobalObject, *callFrame, "setMockAudioTrackChannelNumber");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetShouldInterruptAudioOnPageVisibilityChangeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto shouldInterrupt = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setShouldInterruptAudioOnPageVisibilityChange(WTFMove(shouldInterrupt));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetShouldInterruptAudioOnPageVisibilityChange(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetShouldInterruptAudioOnPageVisibilityChangeBody>(*lexicalGlobalObject, *callFrame, "setShouldInterruptAudioOnPageVisibilityChange");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetCameraMediaStreamTrackOrientationBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto track = convert<IDLInterface<MediaStreamTrack>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "track", "Internals", "setCameraMediaStreamTrackOrientation", "MediaStreamTrack"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto orientation = convert<IDLShort>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setCameraMediaStreamTrackOrientation(*track, WTFMove(orientation));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetCameraMediaStreamTrackOrientation(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetCameraMediaStreamTrackOrientationBody>(*lexicalGlobalObject, *callFrame, "setCameraMediaStreamTrackOrientation");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionObserveMediaStreamTrackBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto track = convert<IDLInterface<MediaStreamTrack>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "track", "Internals", "observeMediaStreamTrack", "MediaStreamTrack"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.observeMediaStreamTrack(*track);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionObserveMediaStreamTrack(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionObserveMediaStreamTrackBody>(*lexicalGlobalObject, *callFrame, "observeMediaStreamTrack");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionGrabNextMediaStreamTrackFrameBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSInternals>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.grabNextMediaStreamTrackFrame(WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionGrabNextMediaStreamTrackFrame(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSInternals>::call<jsInternalsPrototypeFunctionGrabNextMediaStreamTrackFrameBody>(*lexicalGlobalObject, *callFrame, "grabNextMediaStreamTrackFrame");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionDelayMediaStreamTrackSamplesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto track = convert<IDLInterface<MediaStreamTrack>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "track", "Internals", "delayMediaStreamTrackSamples", "MediaStreamTrack"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto delay = convert<IDLFloat>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.delayMediaStreamTrackSamples(*track, WTFMove(delay));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionDelayMediaStreamTrackSamples(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionDelayMediaStreamTrackSamplesBody>(*lexicalGlobalObject, *callFrame, "delayMediaStreamTrackSamples");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetMediaStreamTrackMutedBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto track = convert<IDLInterface<MediaStreamTrack>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "track", "Internals", "setMediaStreamTrackMuted", "MediaStreamTrack"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto muted = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setMediaStreamTrackMuted(*track, WTFMove(muted));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetMediaStreamTrackMuted(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetMediaStreamTrackMutedBody>(*lexicalGlobalObject, *callFrame, "setMediaStreamTrackMuted");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionRemoveMediaStreamTrackBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto stream = convert<IDLInterface<MediaStream>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "stream", "Internals", "removeMediaStreamTrack", "MediaStream"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto track = convert<IDLInterface<MediaStreamTrack>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "track", "Internals", "removeMediaStreamTrack", "MediaStreamTrack"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.removeMediaStreamTrack(*stream, *track);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionRemoveMediaStreamTrack(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionRemoveMediaStreamTrackBody>(*lexicalGlobalObject, *callFrame, "removeMediaStreamTrack");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSimulateMediaStreamTrackCaptureSourceFailureBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto track = convert<IDLInterface<MediaStreamTrack>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "track", "Internals", "simulateMediaStreamTrackCaptureSourceFailure", "MediaStreamTrack"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.simulateMediaStreamTrackCaptureSourceFailure(*track);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSimulateMediaStreamTrackCaptureSourceFailure(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSimulateMediaStreamTrackCaptureSourceFailureBody>(*lexicalGlobalObject, *callFrame, "simulateMediaStreamTrackCaptureSourceFailure");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetMediaStreamTrackIdentifierBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto track = convert<IDLInterface<MediaStreamTrack>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "track", "Internals", "setMediaStreamTrackIdentifier", "MediaStreamTrack"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto identifier = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setMediaStreamTrackIdentifier(*track, WTFMove(identifier));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetMediaStreamTrackIdentifier(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetMediaStreamTrackIdentifierBody>(*lexicalGlobalObject, *callFrame, "setMediaStreamTrackIdentifier");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetMediaStreamSourceInterruptedBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto track = convert<IDLInterface<MediaStreamTrack>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "track", "Internals", "setMediaStreamSourceInterrupted", "MediaStreamTrack"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto interrupted = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setMediaStreamSourceInterrupted(*track, WTFMove(interrupted));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetMediaStreamSourceInterrupted(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetMediaStreamSourceInterruptedBody>(*lexicalGlobalObject, *callFrame, "setMediaStreamSourceInterrupted");
}

#endif

#if ENABLE(MEDIA_STREAM)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionIsMockRealtimeMediaSourceCenterEnabledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLBoolean>(impl.isMockRealtimeMediaSourceCenterEnabled()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsMockRealtimeMediaSourceCenterEnabled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionIsMockRealtimeMediaSourceCenterEnabledBody>(*lexicalGlobalObject, *callFrame, "isMockRealtimeMediaSourceCenterEnabled");
}

#endif

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionDocumentIdentifierBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto document = convert<IDLInterface<Document>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "document", "Internals", "documentIdentifier", "Document"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLUnsignedLongLong>(impl.documentIdentifier(*document)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionDocumentIdentifier(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionDocumentIdentifierBody>(*lexicalGlobalObject, *callFrame, "documentIdentifier");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionIsDocumentAliveBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto documentIdentifier = convert<IDLUnsignedLongLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.isDocumentAlive(WTFMove(documentIdentifier))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsDocumentAlive(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionIsDocumentAliveBody>(*lexicalGlobalObject, *callFrame, "isDocumentAlive");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionElementIdentifierBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "elementIdentifier", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLUnsignedLongLong>(impl.elementIdentifier(*element)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionElementIdentifier(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionElementIdentifierBody>(*lexicalGlobalObject, *callFrame, "elementIdentifier");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionFrameIdentifierBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto document = convert<IDLInterface<Document>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "document", "Internals", "frameIdentifier", "Document"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLUnsignedLongLong>(impl.frameIdentifier(*document)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionFrameIdentifier(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionFrameIdentifierBody>(*lexicalGlobalObject, *callFrame, "frameIdentifier");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionPageIdentifierBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto document = convert<IDLInterface<Document>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "document", "Internals", "pageIdentifier", "Document"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLUnsignedLongLong>(impl.pageIdentifier(*document)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPageIdentifier(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionPageIdentifierBody>(*lexicalGlobalObject, *callFrame, "pageIdentifier");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionIsAnyWorkletGlobalScopeAliveBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLBoolean>(impl.isAnyWorkletGlobalScopeAlive()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsAnyWorkletGlobalScopeAlive(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionIsAnyWorkletGlobalScopeAliveBody>(*lexicalGlobalObject, *callFrame, "isAnyWorkletGlobalScopeAlive");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionServiceWorkerClientIdentifierBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto document = convert<IDLInterface<Document>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "document", "Internals", "serviceWorkerClientIdentifier", "Document"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.serviceWorkerClientIdentifier(*document)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionServiceWorkerClientIdentifier(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionServiceWorkerClientIdentifierBody>(*lexicalGlobalObject, *callFrame, "serviceWorkerClientIdentifier");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionStoreRegistrationsOnDiskBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSInternals>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.storeRegistrationsOnDisk(WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionStoreRegistrationsOnDisk(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSInternals>::call<jsInternalsPrototypeFunctionStoreRegistrationsOnDiskBody>(*lexicalGlobalObject, *callFrame, "storeRegistrationsOnDisk");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionClearCacheStorageMemoryRepresentationBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSInternals>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.clearCacheStorageMemoryRepresentation(WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionClearCacheStorageMemoryRepresentation(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSInternals>::call<jsInternalsPrototypeFunctionClearCacheStorageMemoryRepresentationBody>(*lexicalGlobalObject, *callFrame, "clearCacheStorageMemoryRepresentation");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionCacheStorageEngineRepresentationBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSInternals>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.cacheStorageEngineRepresentation(WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionCacheStorageEngineRepresentation(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSInternals>::call<jsInternalsPrototypeFunctionCacheStorageEngineRepresentationBody>(*lexicalGlobalObject, *callFrame, "cacheStorageEngineRepresentation");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetResponseSizeWithPaddingBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto response = convert<IDLInterface<FetchResponse>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "response", "Internals", "setResponseSizeWithPadding", "FetchResponse"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto size = convert<IDLUnsignedLongLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setResponseSizeWithPadding(*response, WTFMove(size));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetResponseSizeWithPadding(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetResponseSizeWithPaddingBody>(*lexicalGlobalObject, *callFrame, "setResponseSizeWithPadding");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionResponseSizeWithPaddingBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto response = convert<IDLInterface<FetchResponse>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "response", "Internals", "responseSizeWithPadding", "FetchResponse"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLUnsignedLongLong>(impl.responseSizeWithPadding(*response)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionResponseSizeWithPadding(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionResponseSizeWithPaddingBody>(*lexicalGlobalObject, *callFrame, "responseSizeWithPadding");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionUpdateQuotaBasedOnSpaceUsageBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.updateQuotaBasedOnSpaceUsage();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionUpdateQuotaBasedOnSpaceUsage(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionUpdateQuotaBasedOnSpaceUsageBody>(*lexicalGlobalObject, *callFrame, "updateQuotaBasedOnSpaceUsage");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetConsoleMessageListenerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto callback = convert<IDLCallbackFunction<JSStringCallback>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 0, "callback", "Internals", "setConsoleMessageListener"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setConsoleMessageListener(callback.releaseNonNull());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetConsoleMessageListener(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetConsoleMessageListenerBody>(*lexicalGlobalObject, *callFrame, "setConsoleMessageListener");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionAudioSessionCategoryBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.audioSessionCategory()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionAudioSessionCategory(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionAudioSessionCategoryBody>(*lexicalGlobalObject, *callFrame, "audioSessionCategory");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionPreferredAudioBufferSizeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLDouble>(impl.preferredAudioBufferSize()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPreferredAudioBufferSize(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionPreferredAudioBufferSizeBody>(*lexicalGlobalObject, *callFrame, "preferredAudioBufferSize");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionAudioSessionActiveBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLBoolean>(impl.audioSessionActive()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionAudioSessionActive(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionAudioSessionActiveBody>(*lexicalGlobalObject, *callFrame, "audioSessionActive");
}

#if ENABLE(SERVICE_WORKER)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionHasServiceWorkerRegistrationBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSInternals>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto scopeURL = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.hasServiceWorkerRegistration(WTFMove(scopeURL), WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionHasServiceWorkerRegistration(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSInternals>::call<jsInternalsPrototypeFunctionHasServiceWorkerRegistrationBody>(*lexicalGlobalObject, *callFrame, "hasServiceWorkerRegistration");
}

#endif

#if ENABLE(SERVICE_WORKER)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionTerminateServiceWorkerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto worker = convert<IDLInterface<ServiceWorker>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "worker", "Internals", "terminateServiceWorker", "ServiceWorker"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.terminateServiceWorker(*worker);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionTerminateServiceWorker(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionTerminateServiceWorkerBody>(*lexicalGlobalObject, *callFrame, "terminateServiceWorker");
}

#endif

#if ENABLE(SERVICE_WORKER)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionIsServiceWorkerRunningBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSInternals>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto worker = convert<IDLInterface<ServiceWorker>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "worker", "Internals", "isServiceWorkerRunning", "ServiceWorker"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.isServiceWorkerRunning(*worker, WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsServiceWorkerRunning(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSInternals>::call<jsInternalsPrototypeFunctionIsServiceWorkerRunningBody>(*lexicalGlobalObject, *callFrame, "isServiceWorkerRunning");
}

#endif

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionIsSystemPreviewLinkBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "isSystemPreviewLink", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.isSystemPreviewLink(*element)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsSystemPreviewLink(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionIsSystemPreviewLinkBody>(*lexicalGlobalObject, *callFrame, "isSystemPreviewLink");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionIsSystemPreviewImageBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "isSystemPreviewImage", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.isSystemPreviewImage(*element)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionIsSystemPreviewImage(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionIsSystemPreviewImageBody>(*lexicalGlobalObject, *callFrame, "isSystemPreviewImage");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionUsingAppleInternalSDKBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLBoolean>(impl.usingAppleInternalSDK()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionUsingAppleInternalSDK(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionUsingAppleInternalSDKBody>(*lexicalGlobalObject, *callFrame, "usingAppleInternalSDK");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionPostTaskBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto callback = convert<IDLCallbackFunction<JSVoidCallback>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 0, "callback", "Internals", "postTask"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.postTask(callback.releaseNonNull());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPostTask(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionPostTaskBody>(*lexicalGlobalObject, *callFrame, "postTask");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionQueueTaskBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    auto source = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto callback = convert<IDLCallbackFunction<JSVoidCallback>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 1, "callback", "Internals", "queueTask"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.queueTask(*context, WTFMove(source), callback.releaseNonNull()));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionQueueTask(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionQueueTaskBody>(*lexicalGlobalObject, *callFrame, "queueTask");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionQueueTaskToQueueMicrotaskBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    auto source = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto callback = convert<IDLCallbackFunction<JSVoidCallback>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 1, "callback", "Internals", "queueTaskToQueueMicrotask"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.queueTaskToQueueMicrotask(document, WTFMove(source), callback.releaseNonNull());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionQueueTaskToQueueMicrotask(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionQueueTaskToQueueMicrotaskBody>(*lexicalGlobalObject, *callFrame, "queueTaskToQueueMicrotask");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionHasSameEventLoopAsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto windowProxy = convert<IDLInterface<WindowProxy>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "windowProxy", "Internals", "hasSameEventLoopAs", "WindowProxy"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.hasSameEventLoopAs(*windowProxy)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionHasSameEventLoopAs(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionHasSameEventLoopAsBody>(*lexicalGlobalObject, *callFrame, "hasSameEventLoopAs");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionWindowLocationHostBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto window = convert<IDLInterface<DOMWindow>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "window", "Internals", "windowLocationHost", "DOMWindow"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.windowLocationHost(*window)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionWindowLocationHost(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionWindowLocationHostBody>(*lexicalGlobalObject, *callFrame, "windowLocationHost");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionMarkContextAsInsecureBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.markContextAsInsecure();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMarkContextAsInsecure(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionMarkContextAsInsecureBody>(*lexicalGlobalObject, *callFrame, "markContextAsInsecure");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetMaxCanvasPixelMemoryBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto size = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setMaxCanvasPixelMemory(WTFMove(size));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetMaxCanvasPixelMemory(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetMaxCanvasPixelMemoryBody>(*lexicalGlobalObject, *callFrame, "setMaxCanvasPixelMemory");
}

#if ENABLE(VIDEO)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionBestMediaElementForShowingPlaybackControlsManagerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto purpose = convert<IDLEnumeration<Internals::PlaybackControlsPurpose>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 0, "purpose", "Internals", "bestMediaElementForShowingPlaybackControlsManager", expectedEnumerationValues<Internals::PlaybackControlsPurpose>()); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<HTMLMediaElement>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.bestMediaElementForShowingPlaybackControlsManager(WTFMove(purpose))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionBestMediaElementForShowingPlaybackControlsManager(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionBestMediaElementForShowingPlaybackControlsManagerBody>(*lexicalGlobalObject, *callFrame, "bestMediaElementForShowingPlaybackControlsManager");
}

#endif

#if ENABLE(VIDEO)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionMediaSessionStateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto element = convert<IDLInterface<HTMLMediaElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "element", "Internals", "mediaSessionState", "HTMLMediaElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLEnumeration<Internals::MediaSessionState>>(*lexicalGlobalObject, impl.mediaSessionState(*element)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMediaSessionState(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionMediaSessionStateBody>(*lexicalGlobalObject, *callFrame, "mediaSessionState");
}

#endif

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionOngoingLoadsDescriptionsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.ongoingLoadsDescriptions()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionOngoingLoadsDescriptions(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionOngoingLoadsDescriptionsBody>(*lexicalGlobalObject, *callFrame, "ongoingLoadsDescriptions");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetCaptureExtraNetworkLoadMetricsEnabledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto value = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setCaptureExtraNetworkLoadMetricsEnabled(WTFMove(value));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetCaptureExtraNetworkLoadMetricsEnabled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetCaptureExtraNetworkLoadMetricsEnabledBody>(*lexicalGlobalObject, *callFrame, "setCaptureExtraNetworkLoadMetricsEnabled");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionReloadWithoutContentExtensionsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.reloadWithoutContentExtensions();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionReloadWithoutContentExtensions(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionReloadWithoutContentExtensionsBody>(*lexicalGlobalObject, *callFrame, "reloadWithoutContentExtensions");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetUseSystemAppearanceBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto value = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setUseSystemAppearance(WTFMove(value));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetUseSystemAppearance(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetUseSystemAppearanceBody>(*lexicalGlobalObject, *callFrame, "setUseSystemAppearance");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionPluginCountBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLUnsignedLong>(impl.pluginCount()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPluginCount(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionPluginCountBody>(*lexicalGlobalObject, *callFrame, "pluginCount");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionNotifyResourceLoadObserverBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.notifyResourceLoadObserver();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionNotifyResourceLoadObserver(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionNotifyResourceLoadObserverBody>(*lexicalGlobalObject, *callFrame, "notifyResourceLoadObserver");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionPrimaryScreenDisplayIDBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLUnsignedLong>(impl.primaryScreenDisplayID()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionPrimaryScreenDisplayID(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionPrimaryScreenDisplayIDBody>(*lexicalGlobalObject, *callFrame, "primaryScreenDisplayID");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionCapsLockIsOnBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLBoolean>(impl.capsLockIsOn()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionCapsLockIsOn(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionCapsLockIsOnBody>(*lexicalGlobalObject, *callFrame, "capsLockIsOn");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSupportsVCPEncoderBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLBoolean>(impl.supportsVCPEncoder()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSupportsVCPEncoder(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSupportsVCPEncoderBody>(*lexicalGlobalObject, *callFrame, "supportsVCPEncoder");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionParseHEVCCodecParametersBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto codecParameters = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLDictionary<Internals::HEVCParameterSet>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.parseHEVCCodecParameters(WTFMove(codecParameters))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionParseHEVCCodecParameters(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionParseHEVCCodecParametersBody>(*lexicalGlobalObject, *callFrame, "parseHEVCCodecParameters");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionParseDoViCodecParametersBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto codecParameters = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLNullable<IDLDictionary<Internals::DoViParameterSet>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.parseDoViCodecParameters(WTFMove(codecParameters))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionParseDoViCodecParameters(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionParseDoViCodecParametersBody>(*lexicalGlobalObject, *callFrame, "parseDoViCodecParameters");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionGetCookiesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLSequence<IDLDictionary<Internals::CookieData>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getCookies()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionGetCookies(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionGetCookiesBody>(*lexicalGlobalObject, *callFrame, "getCookies");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetAlwaysAllowLocalWebarchiveBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto alwaysAllowLocalWebarchive = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setAlwaysAllowLocalWebarchive(WTFMove(alwaysAllowLocalWebarchive));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetAlwaysAllowLocalWebarchive(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetAlwaysAllowLocalWebarchiveBody>(*lexicalGlobalObject, *callFrame, "setAlwaysAllowLocalWebarchive");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionProcessWillSuspendBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.processWillSuspend();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionProcessWillSuspend(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionProcessWillSuspendBody>(*lexicalGlobalObject, *callFrame, "processWillSuspend");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionProcessDidResumeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.processDidResume();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionProcessDidResume(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionProcessDidResumeBody>(*lexicalGlobalObject, *callFrame, "processDidResume");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionTestDictionaryLoggingBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.testDictionaryLogging();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionTestDictionaryLogging(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionTestDictionaryLoggingBody>(*lexicalGlobalObject, *callFrame, "testDictionaryLogging");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetXHRMaximumIntervalForUserGestureForwardingBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto xhr = convert<IDLInterface<XMLHttpRequest>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "xhr", "Internals", "setXHRMaximumIntervalForUserGestureForwarding", "XMLHttpRequest"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto interval = convert<IDLDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setXHRMaximumIntervalForUserGestureForwarding(*xhr, WTFMove(interval));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetXHRMaximumIntervalForUserGestureForwarding(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetXHRMaximumIntervalForUserGestureForwardingBody>(*lexicalGlobalObject, *callFrame, "setXHRMaximumIntervalForUserGestureForwarding");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetTransientActivationDurationBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto seconds = convert<IDLDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setTransientActivationDuration(WTFMove(seconds));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetTransientActivationDuration(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetTransientActivationDurationBody>(*lexicalGlobalObject, *callFrame, "setTransientActivationDuration");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetIsPlayingToAutomotiveHeadUnitBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto value = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setIsPlayingToAutomotiveHeadUnit(WTFMove(value));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetIsPlayingToAutomotiveHeadUnit(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetIsPlayingToAutomotiveHeadUnitBody>(*lexicalGlobalObject, *callFrame, "setIsPlayingToAutomotiveHeadUnit");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionTextIndicatorForRangeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto range = convert<IDLInterface<Range>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "range", "Internals", "textIndicatorForRange", "Range"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto options = convert<IDLDictionary<Internals::TextIndicatorOptions>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDictionary<Internals::TextIndicatorInfo>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.textIndicatorForRange(*range, WTFMove(options))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionTextIndicatorForRange(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionTextIndicatorForRangeBody>(*lexicalGlobalObject, *callFrame, "textIndicatorForRange");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionAddPrefetchLoadEventListenerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto link = convert<IDLInterface<HTMLLinkElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "link", "Internals", "addPrefetchLoadEventListener", "HTMLLinkElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto callback = convert<IDLNullable<IDLEventListener<JSEventListener>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), *castedThis);
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.addPrefetchLoadEventListener(*link, WTFMove(callback));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionAddPrefetchLoadEventListener(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionAddPrefetchLoadEventListenerBody>(*lexicalGlobalObject, *callFrame, "addPrefetchLoadEventListener");
}

#if ENABLE(WEB_AUTHN)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetMockWebAuthenticationConfigurationBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto configuration = convert<IDLDictionary<MockWebAuthenticationConfiguration>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setMockWebAuthenticationConfiguration(WTFMove(configuration));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetMockWebAuthenticationConfiguration(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetMockWebAuthenticationConfigurationBody>(*lexicalGlobalObject, *callFrame, "setMockWebAuthenticationConfiguration");
}

#endif

#if ENABLE(PICTURE_IN_PICTURE_API)
static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSetPictureInPictureAPITestEnabledBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto videoElement = convert<IDLInterface<HTMLVideoElement>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "videoElement", "Internals", "setPictureInPictureAPITestEnabled", "HTMLVideoElement"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto enabled = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setPictureInPictureAPITestEnabled(*videoElement, WTFMove(enabled));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSetPictureInPictureAPITestEnabled(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSetPictureInPictureAPITestEnabledBody>(*lexicalGlobalObject, *callFrame, "setPictureInPictureAPITestEnabled");
}

#endif

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionCreateInternalsMapLikeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<InternalsMapLike>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.createInternalsMapLike()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionCreateInternalsMapLike(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionCreateInternalsMapLikeBody>(*lexicalGlobalObject, *callFrame, "createInternalsMapLike");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionCreateInternalsSetLikeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<InternalsSetLike>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.createInternalsSetLike()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionCreateInternalsSetLike(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionCreateInternalsSetLikeBody>(*lexicalGlobalObject, *callFrame, "createInternalsSetLike");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionHighlightPseudoElementColorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto highlightName = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto element = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "element", "Internals", "highlightPseudoElementColor", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.highlightPseudoElementColor(WTFMove(highlightName), *element)));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionHighlightPseudoElementColor(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionHighlightPseudoElementColorBody>(*lexicalGlobalObject, *callFrame, "highlightPseudoElementColor");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionHasSandboxMachLookupAccessToGlobalNameBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto process = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto service = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.hasSandboxMachLookupAccessToGlobalName(WTFMove(process), WTFMove(service))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionHasSandboxMachLookupAccessToGlobalName(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionHasSandboxMachLookupAccessToGlobalNameBody>(*lexicalGlobalObject, *callFrame, "hasSandboxMachLookupAccessToGlobalName");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionHasSandboxMachLookupAccessToXPCServiceNameBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto process = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto service = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.hasSandboxMachLookupAccessToXPCServiceName(WTFMove(process), WTFMove(service))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionHasSandboxMachLookupAccessToXPCServiceName(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionHasSandboxMachLookupAccessToXPCServiceNameBody>(*lexicalGlobalObject, *callFrame, "hasSandboxMachLookupAccessToXPCServiceName");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSystemColorForCSSValueBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 3))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto cssValue = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto useDarkModeAppearance = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto useElevatedUserInterfaceLevel = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.systemColorForCSSValue(WTFMove(cssValue), WTFMove(useDarkModeAppearance), WTFMove(useElevatedUserInterfaceLevel))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSystemColorForCSSValue(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSystemColorForCSSValueBody>(*lexicalGlobalObject, *callFrame, "systemColorForCSSValue");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionFocusRingColorBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.focusRingColor()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionFocusRingColor(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionFocusRingColorBody>(*lexicalGlobalObject, *callFrame, "focusRingColor");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionSystemHasBatteryBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLBoolean>(impl.systemHasBattery()));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionSystemHasBattery(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionSystemHasBatteryBody>(*lexicalGlobalObject, *callFrame, "systemHasBattery");
}

static inline JSC::EncodedJSValue jsInternalsPrototypeFunctionMediaMIMETypeForExtensionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSInternals>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto extension = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.mediaMIMETypeForExtension(WTFMove(extension))));
}

EncodedJSValue JSC_HOST_CALL jsInternalsPrototypeFunctionMediaMIMETypeForExtension(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSInternals>::call<jsInternalsPrototypeFunctionMediaMIMETypeForExtensionBody>(*lexicalGlobalObject, *callFrame, "mediaMIMETypeForExtension");
}

void JSInternals::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSInternals*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSInternalsOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSInternalsOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsInternals = static_cast<JSInternals*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsInternals->wrapped(), jsInternals);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7Internals@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore9InternalsE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<Internals>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7Internals@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore9InternalsE[2];
#endif

    // If this fails Internals does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<Internals>::value, "Internals is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // Internals has subclasses. If Internals has subclasses that get passed
    // to toJS() we currently require Internals you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<Internals>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, Internals& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

Internals* JSInternals::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSInternals*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
