/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#include "Internals.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMWrapper.h"
#include <wtf/NeverDestroyed.h>

namespace WebCore {

class WEBCORE_TESTSUPPORT_EXPORT JSInternals : public JSDOMWrapper<Internals> {
public:
    using Base = JSDOMWrapper<Internals>;
    static JSInternals* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<Internals>&& impl)
    {
        JSInternals* ptr = new (NotNull, JSC::allocateCell<JSInternals>(globalObject->vm().heap)) JSInternals(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::VM&, JSDOMGlobalObject&);
    static JSC::JSObject* prototype(JSC::VM&, JSDOMGlobalObject&);
    static Internals* toWrapped(JSC::VM&, JSC::JSValue);
    static void destroy(JSC::JSCell*);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);
protected:
    JSInternals(JSC::Structure*, JSDOMGlobalObject&, Ref<Internals>&&);

    void finishCreation(JSC::VM&);
};

class JSInternalsOwner : public JSC::WeakHandleOwner {
public:
    virtual bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::SlotVisitor&, const char**);
    virtual void finalize(JSC::Handle<JSC::Unknown>, void* context);
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld&, Internals*)
{
    static NeverDestroyed<JSInternalsOwner> owner;
    return &owner.get();
}

inline void* wrapperKey(Internals* wrappableObject)
{
    return wrappableObject;
}

WEBCORE_TESTSUPPORT_EXPORT JSC::JSValue toJS(JSC::JSGlobalObject*, JSDOMGlobalObject*, Internals&);
inline JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, Internals* impl) { return impl ? toJS(lexicalGlobalObject, globalObject, *impl) : JSC::jsNull(); }
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject*, Ref<Internals>&&);
inline JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RefPtr<Internals>&& impl) { return impl ? toJSNewlyCreated(lexicalGlobalObject, globalObject, impl.releaseNonNull()) : JSC::jsNull(); }

template<> struct JSDOMWrapperConverterTraits<Internals> {
    using WrapperClass = JSInternals;
    using ToWrappedReturnType = Internals*;
};
String convertEnumerationToString(Internals::PageOverlayType);
template<> JSC::JSString* convertEnumerationToJS(JSC::JSGlobalObject&, Internals::PageOverlayType);

template<> Optional<Internals::PageOverlayType> parseEnumeration<Internals::PageOverlayType>(JSC::JSGlobalObject&, JSC::JSValue);
template<> const char* expectedEnumerationValues<Internals::PageOverlayType>();

String convertEnumerationToString(Internals::CachePolicy);
template<> JSC::JSString* convertEnumerationToJS(JSC::JSGlobalObject&, Internals::CachePolicy);

template<> Optional<Internals::CachePolicy> parseEnumeration<Internals::CachePolicy>(JSC::JSGlobalObject&, JSC::JSValue);
template<> const char* expectedEnumerationValues<Internals::CachePolicy>();

String convertEnumerationToString(Internals::ResourceLoadPriority);
template<> JSC::JSString* convertEnumerationToJS(JSC::JSGlobalObject&, Internals::ResourceLoadPriority);

template<> Optional<Internals::ResourceLoadPriority> parseEnumeration<Internals::ResourceLoadPriority>(JSC::JSGlobalObject&, JSC::JSValue);
template<> const char* expectedEnumerationValues<Internals::ResourceLoadPriority>();

#if ENABLE(MEDIA_SESSION)

String convertEnumerationToString(Internals::MediaSessionInterruptingCategory);
template<> JSC::JSString* convertEnumerationToJS(JSC::JSGlobalObject&, Internals::MediaSessionInterruptingCategory);

template<> Optional<Internals::MediaSessionInterruptingCategory> parseEnumeration<Internals::MediaSessionInterruptingCategory>(JSC::JSGlobalObject&, JSC::JSValue);
template<> const char* expectedEnumerationValues<Internals::MediaSessionInterruptingCategory>();

#endif

#if ENABLE(MEDIA_SESSION)

String convertEnumerationToString(Internals::MediaControlEvent);
template<> JSC::JSString* convertEnumerationToJS(JSC::JSGlobalObject&, Internals::MediaControlEvent);

template<> Optional<Internals::MediaControlEvent> parseEnumeration<Internals::MediaControlEvent>(JSC::JSGlobalObject&, JSC::JSValue);
template<> const char* expectedEnumerationValues<Internals::MediaControlEvent>();

#endif

String convertEnumerationToString(Internals::AutoFillButtonType);
template<> JSC::JSString* convertEnumerationToJS(JSC::JSGlobalObject&, Internals::AutoFillButtonType);

template<> Optional<Internals::AutoFillButtonType> parseEnumeration<Internals::AutoFillButtonType>(JSC::JSGlobalObject&, JSC::JSValue);
template<> const char* expectedEnumerationValues<Internals::AutoFillButtonType>();

String convertEnumerationToString(Internals::UserInterfaceLayoutDirection);
template<> JSC::JSString* convertEnumerationToJS(JSC::JSGlobalObject&, Internals::UserInterfaceLayoutDirection);

template<> Optional<Internals::UserInterfaceLayoutDirection> parseEnumeration<Internals::UserInterfaceLayoutDirection>(JSC::JSGlobalObject&, JSC::JSValue);
template<> const char* expectedEnumerationValues<Internals::UserInterfaceLayoutDirection>();

String convertEnumerationToString(Internals::BaseWritingDirection);
template<> JSC::JSString* convertEnumerationToJS(JSC::JSGlobalObject&, Internals::BaseWritingDirection);

template<> Optional<Internals::BaseWritingDirection> parseEnumeration<Internals::BaseWritingDirection>(JSC::JSGlobalObject&, JSC::JSValue);
template<> const char* expectedEnumerationValues<Internals::BaseWritingDirection>();

String convertEnumerationToString(Internals::EventThrottlingBehavior);
template<> JSC::JSString* convertEnumerationToJS(JSC::JSGlobalObject&, Internals::EventThrottlingBehavior);

template<> Optional<Internals::EventThrottlingBehavior> parseEnumeration<Internals::EventThrottlingBehavior>(JSC::JSGlobalObject&, JSC::JSValue);
template<> const char* expectedEnumerationValues<Internals::EventThrottlingBehavior>();

String convertEnumerationToString(Internals::CompositingPolicy);
template<> JSC::JSString* convertEnumerationToJS(JSC::JSGlobalObject&, Internals::CompositingPolicy);

template<> Optional<Internals::CompositingPolicy> parseEnumeration<Internals::CompositingPolicy>(JSC::JSGlobalObject&, JSC::JSValue);
template<> const char* expectedEnumerationValues<Internals::CompositingPolicy>();

#if ENABLE(VIDEO)

String convertEnumerationToString(Internals::PlaybackControlsPurpose);
template<> JSC::JSString* convertEnumerationToJS(JSC::JSGlobalObject&, Internals::PlaybackControlsPurpose);

template<> Optional<Internals::PlaybackControlsPurpose> parseEnumeration<Internals::PlaybackControlsPurpose>(JSC::JSGlobalObject&, JSC::JSValue);
template<> const char* expectedEnumerationValues<Internals::PlaybackControlsPurpose>();

#endif

#if ENABLE(VIDEO)

String convertEnumerationToString(Internals::MediaSessionState);
template<> JSC::JSString* convertEnumerationToJS(JSC::JSGlobalObject&, Internals::MediaSessionState);

template<> Optional<Internals::MediaSessionState> parseEnumeration<Internals::MediaSessionState>(JSC::JSGlobalObject&, JSC::JSValue);
template<> const char* expectedEnumerationValues<Internals::MediaSessionState>();

#endif

#if ENABLE(VIDEO)

template<> WEBCORE_TESTSUPPORT_EXPORT Internals::NowPlayingState convertDictionary<Internals::NowPlayingState>(JSC::JSGlobalObject&, JSC::JSValue);

WEBCORE_TESTSUPPORT_EXPORT JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject&, JSDOMGlobalObject&, const Internals::NowPlayingState&);

#endif

template<> WEBCORE_TESTSUPPORT_EXPORT Internals::FullscreenInsets convertDictionary<Internals::FullscreenInsets>(JSC::JSGlobalObject&, JSC::JSValue);

WEBCORE_TESTSUPPORT_EXPORT JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject&, JSDOMGlobalObject&, const Internals::FullscreenInsets&);

template<> WEBCORE_TESTSUPPORT_EXPORT Internals::HEVCParameterSet convertDictionary<Internals::HEVCParameterSet>(JSC::JSGlobalObject&, JSC::JSValue);

WEBCORE_TESTSUPPORT_EXPORT JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject&, JSDOMGlobalObject&, const Internals::HEVCParameterSet&);

template<> WEBCORE_TESTSUPPORT_EXPORT Internals::DoViParameterSet convertDictionary<Internals::DoViParameterSet>(JSC::JSGlobalObject&, JSC::JSValue);

WEBCORE_TESTSUPPORT_EXPORT JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject&, JSDOMGlobalObject&, const Internals::DoViParameterSet&);

template<> WEBCORE_TESTSUPPORT_EXPORT Internals::AcceleratedAnimation convertDictionary<Internals::AcceleratedAnimation>(JSC::JSGlobalObject&, JSC::JSValue);

WEBCORE_TESTSUPPORT_EXPORT JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject&, JSDOMGlobalObject&, const Internals::AcceleratedAnimation&);

template<> WEBCORE_TESTSUPPORT_EXPORT Internals::CookieData convertDictionary<Internals::CookieData>(JSC::JSGlobalObject&, JSC::JSValue);

WEBCORE_TESTSUPPORT_EXPORT JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject&, JSDOMGlobalObject&, const Internals::CookieData&);

template<> WEBCORE_TESTSUPPORT_EXPORT Internals::TextIndicatorInfo convertDictionary<Internals::TextIndicatorInfo>(JSC::JSGlobalObject&, JSC::JSValue);

WEBCORE_TESTSUPPORT_EXPORT JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject&, JSDOMGlobalObject&, const Internals::TextIndicatorInfo&);

template<> WEBCORE_TESTSUPPORT_EXPORT Internals::TextIndicatorOptions convertDictionary<Internals::TextIndicatorOptions>(JSC::JSGlobalObject&, JSC::JSValue);

WEBCORE_TESTSUPPORT_EXPORT JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject&, JSDOMGlobalObject&, const Internals::TextIndicatorOptions&);


} // namespace WebCore
