/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(INTERSECTION_OBSERVER)

#include "JSIntersectionObserver.h"

#include "ActiveDOMObject.h"
#include "Document.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSElement.h"
#include "JSIntersectionObserverEntry.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>

#if ENABLE(INTERSECTION_OBSERVER)
#include "JSDOMConvertCallbacks.h"
#include "JSIntersectionObserverCallback.h"
#endif


namespace WebCore {
using namespace JSC;

#if ENABLE(INTERSECTION_OBSERVER)

template<> IntersectionObserver::Init convertDictionary<IntersectionObserver::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    IntersectionObserver::Init result;
    JSValue rootValue;
    if (isNullOrUndefined)
        rootValue = jsUndefined();
    else {
        rootValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "root"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!rootValue.isUndefined()) {
        result.root = convert<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, rootValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.root = nullptr;
    JSValue rootMarginValue;
    if (isNullOrUndefined)
        rootMarginValue = jsUndefined();
    else {
        rootMarginValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "rootMargin"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!rootMarginValue.isUndefined()) {
        result.rootMargin = convert<IDLDOMString>(lexicalGlobalObject, rootMarginValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.rootMargin = "0px"_s;
    JSValue thresholdValue;
    if (isNullOrUndefined)
        thresholdValue = jsUndefined();
    else {
        thresholdValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "threshold"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!thresholdValue.isUndefined()) {
        result.threshold = convert<IDLUnion<IDLDouble, IDLSequence<IDLDouble>>>(lexicalGlobalObject, thresholdValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.threshold = 0.0;
    return result;
}

#endif

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsIntersectionObserverPrototypeFunctionObserve(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsIntersectionObserverPrototypeFunctionUnobserve(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsIntersectionObserverPrototypeFunctionDisconnect(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsIntersectionObserverPrototypeFunctionTakeRecords(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsIntersectionObserverConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSIntersectionObserverConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsIntersectionObserverRoot(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsIntersectionObserverRootMargin(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsIntersectionObserverThresholds(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSIntersectionObserverPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSIntersectionObserverPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSIntersectionObserverPrototype* ptr = new (NotNull, JSC::allocateCell<JSIntersectionObserverPrototype>(vm.heap)) JSIntersectionObserverPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSIntersectionObserverPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSIntersectionObserverPrototype, JSIntersectionObserverPrototype::Base);

using JSIntersectionObserverConstructor = JSDOMConstructor<JSIntersectionObserver>;

template<> EncodedJSValue JSC_HOST_CALL JSIntersectionObserverConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSIntersectionObserverConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "IntersectionObserver");
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    auto callback = convert<IDLCallbackFunction<JSIntersectionObserverCallback>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 0, "callback", "IntersectionObserver", nullptr); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto options = convert<IDLDictionary<IntersectionObserver::Init>>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = IntersectionObserver::create(document, callback.releaseNonNull(), WTFMove(options));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<IntersectionObserver>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object)));
}

template<> JSValue JSIntersectionObserverConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSIntersectionObserverConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSIntersectionObserver::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("IntersectionObserver"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSIntersectionObserverConstructor::s_info = { "IntersectionObserver", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIntersectionObserverConstructor) };

/* Hash table for prototype */

static const HashTableValue JSIntersectionObserverPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIntersectionObserverConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSIntersectionObserverConstructor) } },
    { "root", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIntersectionObserverRoot), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "rootMargin", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIntersectionObserverRootMargin), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "thresholds", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIntersectionObserverThresholds), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "observe", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsIntersectionObserverPrototypeFunctionObserve), (intptr_t) (1) } },
    { "unobserve", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsIntersectionObserverPrototypeFunctionUnobserve), (intptr_t) (1) } },
    { "disconnect", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsIntersectionObserverPrototypeFunctionDisconnect), (intptr_t) (0) } },
    { "takeRecords", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsIntersectionObserverPrototypeFunctionTakeRecords), (intptr_t) (0) } },
};

const ClassInfo JSIntersectionObserverPrototype::s_info = { "IntersectionObserverPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIntersectionObserverPrototype) };

void JSIntersectionObserverPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSIntersectionObserver::info(), JSIntersectionObserverPrototypeTableValues, *this);
}

const ClassInfo JSIntersectionObserver::s_info = { "IntersectionObserver", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIntersectionObserver) };

JSIntersectionObserver::JSIntersectionObserver(Structure* structure, JSDOMGlobalObject& globalObject, Ref<IntersectionObserver>&& impl)
    : JSDOMWrapper<IntersectionObserver>(structure, globalObject, WTFMove(impl))
{
}

void JSIntersectionObserver::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(std::is_base_of<ActiveDOMObject, IntersectionObserver>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

}

JSObject* JSIntersectionObserver::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSIntersectionObserverPrototype::create(vm, &globalObject, JSIntersectionObserverPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSIntersectionObserver::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSIntersectionObserver>(vm, globalObject);
}

JSValue JSIntersectionObserver::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIntersectionObserverConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSIntersectionObserver::destroy(JSC::JSCell* cell)
{
    JSIntersectionObserver* thisObject = static_cast<JSIntersectionObserver*>(cell);
    thisObject->JSIntersectionObserver::~JSIntersectionObserver();
}

template<> inline JSIntersectionObserver* IDLAttribute<JSIntersectionObserver>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSIntersectionObserver*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSIntersectionObserver* IDLOperation<JSIntersectionObserver>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSIntersectionObserver*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsIntersectionObserverConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSIntersectionObserverPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSIntersectionObserver::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSIntersectionObserverConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSIntersectionObserverPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsIntersectionObserverRootGetter(JSGlobalObject& lexicalGlobalObject, JSIntersectionObserver& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.root());
    return result;
}

EncodedJSValue jsIntersectionObserverRoot(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIntersectionObserver>::get<jsIntersectionObserverRootGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "root");
}

static inline JSValue jsIntersectionObserverRootMarginGetter(JSGlobalObject& lexicalGlobalObject, JSIntersectionObserver& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.rootMargin());
    return result;
}

EncodedJSValue jsIntersectionObserverRootMargin(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIntersectionObserver>::get<jsIntersectionObserverRootMarginGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "rootMargin");
}

static inline JSValue jsIntersectionObserverThresholdsGetter(JSGlobalObject& lexicalGlobalObject, JSIntersectionObserver& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLSequence<IDLDouble>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.thresholds());
    return result;
}

EncodedJSValue jsIntersectionObserverThresholds(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIntersectionObserver>::get<jsIntersectionObserverThresholdsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "thresholds");
}

static inline JSC::EncodedJSValue jsIntersectionObserverPrototypeFunctionObserveBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIntersectionObserver>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "target", "IntersectionObserver", "observe", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.observe(*target);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsIntersectionObserverPrototypeFunctionObserve(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSIntersectionObserver>::call<jsIntersectionObserverPrototypeFunctionObserveBody>(*lexicalGlobalObject, *callFrame, "observe");
}

static inline JSC::EncodedJSValue jsIntersectionObserverPrototypeFunctionUnobserveBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIntersectionObserver>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLInterface<Element>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "target", "IntersectionObserver", "unobserve", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.unobserve(*target);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsIntersectionObserverPrototypeFunctionUnobserve(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSIntersectionObserver>::call<jsIntersectionObserverPrototypeFunctionUnobserveBody>(*lexicalGlobalObject, *callFrame, "unobserve");
}

static inline JSC::EncodedJSValue jsIntersectionObserverPrototypeFunctionDisconnectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIntersectionObserver>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.disconnect();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsIntersectionObserverPrototypeFunctionDisconnect(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSIntersectionObserver>::call<jsIntersectionObserverPrototypeFunctionDisconnectBody>(*lexicalGlobalObject, *callFrame, "disconnect");
}

static inline JSC::EncodedJSValue jsIntersectionObserverPrototypeFunctionTakeRecordsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSIntersectionObserver>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto implResult = impl.takeRecords();
    return JSValue::encode(toJS<IDLSequence<IDLInterface<IntersectionObserverEntry>>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(implResult.records)));
}

EncodedJSValue JSC_HOST_CALL jsIntersectionObserverPrototypeFunctionTakeRecords(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSIntersectionObserver>::call<jsIntersectionObserverPrototypeFunctionTakeRecordsBody>(*lexicalGlobalObject, *callFrame, "takeRecords");
}

void JSIntersectionObserver::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSIntersectionObserver*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSIntersectionObserverOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsIntersectionObserver = jsCast<JSIntersectionObserver*>(handle.slot()->asCell());
    if (jsIntersectionObserver->wrapped().hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSIntersectionObserverOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsIntersectionObserver = static_cast<JSIntersectionObserver*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsIntersectionObserver->wrapped(), jsIntersectionObserver);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7IntersectionObserver@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore20IntersectionObserverE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<IntersectionObserver>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7IntersectionObserver@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore20IntersectionObserverE[2];
#endif

    // If this fails IntersectionObserver does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<IntersectionObserver>::value, "IntersectionObserver is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // IntersectionObserver has subclasses. If IntersectionObserver has subclasses that get passed
    // to toJS() we currently require IntersectionObserver you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<IntersectionObserver>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, IntersectionObserver& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

IntersectionObserver* JSIntersectionObserver::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSIntersectionObserver*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(INTERSECTION_OBSERVER)
