/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(INTERSECTION_OBSERVER)

#include "JSIntersectionObserverEntry.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMRectInit.h"
#include "JSDOMRectReadOnly.h"
#include "JSDOMWrapperCache.h"
#include "JSElement.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(INTERSECTION_OBSERVER)

template<> IntersectionObserverEntry::Init convertDictionary<IntersectionObserverEntry::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    IntersectionObserverEntry::Init result;
    JSValue boundingClientRectValue;
    if (isNullOrUndefined)
        boundingClientRectValue = jsUndefined();
    else {
        boundingClientRectValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "boundingClientRect"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!boundingClientRectValue.isUndefined()) {
        result.boundingClientRect = convert<IDLDictionary<DOMRectInit>>(lexicalGlobalObject, boundingClientRectValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "boundingClientRect", "IntersectionObserverEntryInit", "DOMRectInit");
        return { };
    }
    JSValue intersectionRatioValue;
    if (isNullOrUndefined)
        intersectionRatioValue = jsUndefined();
    else {
        intersectionRatioValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "intersectionRatio"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!intersectionRatioValue.isUndefined()) {
        result.intersectionRatio = convert<IDLDouble>(lexicalGlobalObject, intersectionRatioValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "intersectionRatio", "IntersectionObserverEntryInit", "double");
        return { };
    }
    JSValue intersectionRectValue;
    if (isNullOrUndefined)
        intersectionRectValue = jsUndefined();
    else {
        intersectionRectValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "intersectionRect"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!intersectionRectValue.isUndefined()) {
        result.intersectionRect = convert<IDLDictionary<DOMRectInit>>(lexicalGlobalObject, intersectionRectValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "intersectionRect", "IntersectionObserverEntryInit", "DOMRectInit");
        return { };
    }
    JSValue isIntersectingValue;
    if (isNullOrUndefined)
        isIntersectingValue = jsUndefined();
    else {
        isIntersectingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "isIntersecting"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!isIntersectingValue.isUndefined()) {
        result.isIntersecting = convert<IDLBoolean>(lexicalGlobalObject, isIntersectingValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "isIntersecting", "IntersectionObserverEntryInit", "boolean");
        return { };
    }
    JSValue rootBoundsValue;
    if (isNullOrUndefined)
        rootBoundsValue = jsUndefined();
    else {
        rootBoundsValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "rootBounds"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!rootBoundsValue.isUndefined()) {
        result.rootBounds = convert<IDLNullable<IDLDictionary<DOMRectInit>>>(lexicalGlobalObject, rootBoundsValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "rootBounds", "IntersectionObserverEntryInit", "DOMRectInit");
        return { };
    }
    JSValue targetValue;
    if (isNullOrUndefined)
        targetValue = jsUndefined();
    else {
        targetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "target"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!targetValue.isUndefined()) {
        result.target = convert<IDLInterface<Element>>(lexicalGlobalObject, targetValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "target", "IntersectionObserverEntryInit", "Element");
        return { };
    }
    JSValue timeValue;
    if (isNullOrUndefined)
        timeValue = jsUndefined();
    else {
        timeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "time"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!timeValue.isUndefined()) {
        result.time = convert<IDLDouble>(lexicalGlobalObject, timeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "time", "IntersectionObserverEntryInit", "double");
        return { };
    }
    return result;
}

#endif

// Attributes

JSC::EncodedJSValue jsIntersectionObserverEntryConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSIntersectionObserverEntryConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsIntersectionObserverEntryTime(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsIntersectionObserverEntryRootBounds(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsIntersectionObserverEntryBoundingClientRect(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsIntersectionObserverEntryIntersectionRect(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsIntersectionObserverEntryIsIntersecting(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsIntersectionObserverEntryIntersectionRatio(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsIntersectionObserverEntryTarget(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSIntersectionObserverEntryPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSIntersectionObserverEntryPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSIntersectionObserverEntryPrototype* ptr = new (NotNull, JSC::allocateCell<JSIntersectionObserverEntryPrototype>(vm.heap)) JSIntersectionObserverEntryPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSIntersectionObserverEntryPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSIntersectionObserverEntryPrototype, JSIntersectionObserverEntryPrototype::Base);

using JSIntersectionObserverEntryConstructor = JSDOMConstructor<JSIntersectionObserverEntry>;

template<> EncodedJSValue JSC_HOST_CALL JSIntersectionObserverEntryConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSIntersectionObserverEntryConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto intersectionObserverEntryInit = convert<IDLDictionary<IntersectionObserverEntry::Init>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = IntersectionObserverEntry::create(WTFMove(intersectionObserverEntryInit));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<IntersectionObserverEntry>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSIntersectionObserverEntryConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSIntersectionObserverEntryConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSIntersectionObserverEntry::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("IntersectionObserverEntry"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSIntersectionObserverEntryConstructor::s_info = { "IntersectionObserverEntry", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIntersectionObserverEntryConstructor) };

/* Hash table for prototype */

static const HashTableValue JSIntersectionObserverEntryPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIntersectionObserverEntryConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSIntersectionObserverEntryConstructor) } },
    { "time", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIntersectionObserverEntryTime), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "rootBounds", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIntersectionObserverEntryRootBounds), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "boundingClientRect", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIntersectionObserverEntryBoundingClientRect), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "intersectionRect", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIntersectionObserverEntryIntersectionRect), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "isIntersecting", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIntersectionObserverEntryIsIntersecting), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "intersectionRatio", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIntersectionObserverEntryIntersectionRatio), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "target", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsIntersectionObserverEntryTarget), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSIntersectionObserverEntryPrototype::s_info = { "IntersectionObserverEntryPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIntersectionObserverEntryPrototype) };

void JSIntersectionObserverEntryPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSIntersectionObserverEntry::info(), JSIntersectionObserverEntryPrototypeTableValues, *this);
}

const ClassInfo JSIntersectionObserverEntry::s_info = { "IntersectionObserverEntry", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSIntersectionObserverEntry) };

JSIntersectionObserverEntry::JSIntersectionObserverEntry(Structure* structure, JSDOMGlobalObject& globalObject, Ref<IntersectionObserverEntry>&& impl)
    : JSDOMWrapper<IntersectionObserverEntry>(structure, globalObject, WTFMove(impl))
{
}

void JSIntersectionObserverEntry::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, IntersectionObserverEntry>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSIntersectionObserverEntry::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSIntersectionObserverEntryPrototype::create(vm, &globalObject, JSIntersectionObserverEntryPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSIntersectionObserverEntry::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSIntersectionObserverEntry>(vm, globalObject);
}

JSValue JSIntersectionObserverEntry::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSIntersectionObserverEntryConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSIntersectionObserverEntry::destroy(JSC::JSCell* cell)
{
    JSIntersectionObserverEntry* thisObject = static_cast<JSIntersectionObserverEntry*>(cell);
    thisObject->JSIntersectionObserverEntry::~JSIntersectionObserverEntry();
}

template<> inline JSIntersectionObserverEntry* IDLAttribute<JSIntersectionObserverEntry>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSIntersectionObserverEntry*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsIntersectionObserverEntryConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSIntersectionObserverEntryPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSIntersectionObserverEntry::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSIntersectionObserverEntryConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSIntersectionObserverEntryPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsIntersectionObserverEntryTimeGetter(JSGlobalObject& lexicalGlobalObject, JSIntersectionObserverEntry& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.time());
    return result;
}

EncodedJSValue jsIntersectionObserverEntryTime(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIntersectionObserverEntry>::get<jsIntersectionObserverEntryTimeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "time");
}

static inline JSValue jsIntersectionObserverEntryRootBoundsGetter(JSGlobalObject& lexicalGlobalObject, JSIntersectionObserverEntry& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<DOMRectReadOnly>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.rootBounds());
    return result;
}

EncodedJSValue jsIntersectionObserverEntryRootBounds(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIntersectionObserverEntry>::get<jsIntersectionObserverEntryRootBoundsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "rootBounds");
}

static inline JSValue jsIntersectionObserverEntryBoundingClientRectGetter(JSGlobalObject& lexicalGlobalObject, JSIntersectionObserverEntry& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<DOMRectReadOnly>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.boundingClientRect());
    return result;
}

EncodedJSValue jsIntersectionObserverEntryBoundingClientRect(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIntersectionObserverEntry>::get<jsIntersectionObserverEntryBoundingClientRectGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "boundingClientRect");
}

static inline JSValue jsIntersectionObserverEntryIntersectionRectGetter(JSGlobalObject& lexicalGlobalObject, JSIntersectionObserverEntry& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<DOMRectReadOnly>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.intersectionRect());
    return result;
}

EncodedJSValue jsIntersectionObserverEntryIntersectionRect(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIntersectionObserverEntry>::get<jsIntersectionObserverEntryIntersectionRectGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "intersectionRect");
}

static inline JSValue jsIntersectionObserverEntryIsIntersectingGetter(JSGlobalObject& lexicalGlobalObject, JSIntersectionObserverEntry& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.isIntersecting());
    return result;
}

EncodedJSValue jsIntersectionObserverEntryIsIntersecting(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIntersectionObserverEntry>::get<jsIntersectionObserverEntryIsIntersectingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "isIntersecting");
}

static inline JSValue jsIntersectionObserverEntryIntersectionRatioGetter(JSGlobalObject& lexicalGlobalObject, JSIntersectionObserverEntry& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.intersectionRatio());
    return result;
}

EncodedJSValue jsIntersectionObserverEntryIntersectionRatio(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIntersectionObserverEntry>::get<jsIntersectionObserverEntryIntersectionRatioGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "intersectionRatio");
}

static inline JSValue jsIntersectionObserverEntryTargetGetter(JSGlobalObject& lexicalGlobalObject, JSIntersectionObserverEntry& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<Element>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.target());
    return result;
}

EncodedJSValue jsIntersectionObserverEntryTarget(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSIntersectionObserverEntry>::get<jsIntersectionObserverEntryTargetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "target");
}

void JSIntersectionObserverEntry::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSIntersectionObserverEntry*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSIntersectionObserverEntry::visitOutputConstraints(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSIntersectionObserverEntry*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSIntersectionObserverEntry::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSIntersectionObserverEntry*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSIntersectionObserverEntryOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSIntersectionObserverEntryOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsIntersectionObserverEntry = static_cast<JSIntersectionObserverEntry*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsIntersectionObserverEntry->wrapped(), jsIntersectionObserverEntry);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<IntersectionObserverEntry>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to IntersectionObserverEntry.
    static_assert(!std::is_polymorphic<IntersectionObserverEntry>::value, "IntersectionObserverEntry is polymorphic but the IDL claims it is not");
    return createWrapper<IntersectionObserverEntry>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, IntersectionObserverEntry& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

IntersectionObserverEntry* JSIntersectionObserverEntry::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSIntersectionObserverEntry*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(INTERSECTION_OBSERVER)
