/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSKeyboardEvent.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSWindowProxy.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

template<> KeyboardEvent::Init convertDictionary<KeyboardEvent::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    KeyboardEvent::Init result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bubblesValue.isUndefined()) {
        result.bubbles = convert<IDLBoolean>(lexicalGlobalObject, bubblesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.bubbles = false;
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!cancelableValue.isUndefined()) {
        result.cancelable = convert<IDLBoolean>(lexicalGlobalObject, cancelableValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.cancelable = false;
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!composedValue.isUndefined()) {
        result.composed = convert<IDLBoolean>(lexicalGlobalObject, composedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.composed = false;
    JSValue detailValue;
    if (isNullOrUndefined)
        detailValue = jsUndefined();
    else {
        detailValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "detail"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!detailValue.isUndefined()) {
        result.detail = convert<IDLLong>(lexicalGlobalObject, detailValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.detail = 0;
    JSValue viewValue;
    if (isNullOrUndefined)
        viewValue = jsUndefined();
    else {
        viewValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "view"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!viewValue.isUndefined()) {
        result.view = convert<IDLNullable<IDLInterface<WindowProxy>>>(lexicalGlobalObject, viewValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.view = nullptr;
    JSValue altKeyValue;
    if (isNullOrUndefined)
        altKeyValue = jsUndefined();
    else {
        altKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "altKey"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!altKeyValue.isUndefined()) {
        result.altKey = convert<IDLBoolean>(lexicalGlobalObject, altKeyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.altKey = false;
    JSValue ctrlKeyValue;
    if (isNullOrUndefined)
        ctrlKeyValue = jsUndefined();
    else {
        ctrlKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "ctrlKey"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!ctrlKeyValue.isUndefined()) {
        result.ctrlKey = convert<IDLBoolean>(lexicalGlobalObject, ctrlKeyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.ctrlKey = false;
    JSValue metaKeyValue;
    if (isNullOrUndefined)
        metaKeyValue = jsUndefined();
    else {
        metaKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "metaKey"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!metaKeyValue.isUndefined()) {
        result.metaKey = convert<IDLBoolean>(lexicalGlobalObject, metaKeyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.metaKey = false;
    JSValue modifierAltGraphValue;
    if (isNullOrUndefined)
        modifierAltGraphValue = jsUndefined();
    else {
        modifierAltGraphValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "modifierAltGraph"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!modifierAltGraphValue.isUndefined()) {
        result.modifierAltGraph = convert<IDLBoolean>(lexicalGlobalObject, modifierAltGraphValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.modifierAltGraph = false;
    JSValue modifierCapsLockValue;
    if (isNullOrUndefined)
        modifierCapsLockValue = jsUndefined();
    else {
        modifierCapsLockValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "modifierCapsLock"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!modifierCapsLockValue.isUndefined()) {
        result.modifierCapsLock = convert<IDLBoolean>(lexicalGlobalObject, modifierCapsLockValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.modifierCapsLock = false;
    JSValue shiftKeyValue;
    if (isNullOrUndefined)
        shiftKeyValue = jsUndefined();
    else {
        shiftKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "shiftKey"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!shiftKeyValue.isUndefined()) {
        result.shiftKey = convert<IDLBoolean>(lexicalGlobalObject, shiftKeyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.shiftKey = false;
    JSValue charCodeValue;
    if (isNullOrUndefined)
        charCodeValue = jsUndefined();
    else {
        charCodeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "charCode"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!charCodeValue.isUndefined()) {
        result.charCode = convert<IDLUnsignedLong>(lexicalGlobalObject, charCodeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.charCode = 0;
    JSValue codeValue;
    if (isNullOrUndefined)
        codeValue = jsUndefined();
    else {
        codeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "code"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!codeValue.isUndefined()) {
        result.code = convert<IDLDOMString>(lexicalGlobalObject, codeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.code = emptyString();
    JSValue isComposingValue;
    if (isNullOrUndefined)
        isComposingValue = jsUndefined();
    else {
        isComposingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "isComposing"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!isComposingValue.isUndefined()) {
        result.isComposing = convert<IDLBoolean>(lexicalGlobalObject, isComposingValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.isComposing = false;
    JSValue keyValue;
    if (isNullOrUndefined)
        keyValue = jsUndefined();
    else {
        keyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "key"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!keyValue.isUndefined()) {
        result.key = convert<IDLDOMString>(lexicalGlobalObject, keyValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.key = emptyString();
    JSValue keyCodeValue;
    if (isNullOrUndefined)
        keyCodeValue = jsUndefined();
    else {
        keyCodeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "keyCode"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!keyCodeValue.isUndefined()) {
        result.keyCode = convert<IDLUnsignedLong>(lexicalGlobalObject, keyCodeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.keyCode = 0;
    JSValue keyIdentifierValue;
    if (isNullOrUndefined)
        keyIdentifierValue = jsUndefined();
    else {
        keyIdentifierValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "keyIdentifier"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!keyIdentifierValue.isUndefined()) {
        result.keyIdentifier = convert<IDLDOMString>(lexicalGlobalObject, keyIdentifierValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.keyIdentifier = emptyString();
    JSValue keyLocationValue;
    if (isNullOrUndefined)
        keyLocationValue = jsUndefined();
    else {
        keyLocationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "keyLocation"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!keyLocationValue.isUndefined()) {
        result.keyLocation = convert<IDLUnsignedLong>(lexicalGlobalObject, keyLocationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue locationValue;
    if (isNullOrUndefined)
        locationValue = jsUndefined();
    else {
        locationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "location"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!locationValue.isUndefined()) {
        result.location = convert<IDLUnsignedLong>(lexicalGlobalObject, locationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.location = 0;
    JSValue repeatValue;
    if (isNullOrUndefined)
        repeatValue = jsUndefined();
    else {
        repeatValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "repeat"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!repeatValue.isUndefined()) {
        result.repeat = convert<IDLBoolean>(lexicalGlobalObject, repeatValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.repeat = false;
    JSValue whichValue;
    if (isNullOrUndefined)
        whichValue = jsUndefined();
    else {
        whichValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "which"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!whichValue.isUndefined()) {
        result.which = convert<IDLUnsignedLong>(lexicalGlobalObject, whichValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.which = 0;
    return result;
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsKeyboardEventPrototypeFunctionGetModifierState(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsKeyboardEventPrototypeFunctionInitKeyboardEvent(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsKeyboardEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSKeyboardEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsKeyboardEventKey(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsKeyboardEventCode(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsKeyboardEventLocation(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsKeyboardEventCtrlKey(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsKeyboardEventShiftKey(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsKeyboardEventAltKey(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsKeyboardEventMetaKey(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsKeyboardEventRepeat(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsKeyboardEventIsComposing(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsKeyboardEventKeyIdentifier(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsKeyboardEventKeyLocation(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsKeyboardEventAltGraphKey(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsKeyboardEventCharCode(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsKeyboardEventKeyCode(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsKeyboardEventWhich(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSKeyboardEventPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSKeyboardEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSKeyboardEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSKeyboardEventPrototype>(vm.heap)) JSKeyboardEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSKeyboardEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSKeyboardEventPrototype, JSKeyboardEventPrototype::Base);

using JSKeyboardEventConstructor = JSDOMConstructor<JSKeyboardEvent>;

/* Hash table for constructor */

static const HashTableValue JSKeyboardEventConstructorTableValues[] =
{
    { "DOM_KEY_LOCATION_STANDARD", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x00) } },
    { "DOM_KEY_LOCATION_LEFT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x01) } },
    { "DOM_KEY_LOCATION_RIGHT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x02) } },
    { "DOM_KEY_LOCATION_NUMPAD", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x03) } },
};

static_assert(KeyboardEvent::DOM_KEY_LOCATION_STANDARD == 0x00, "DOM_KEY_LOCATION_STANDARD in KeyboardEvent does not match value from IDL");
static_assert(KeyboardEvent::DOM_KEY_LOCATION_LEFT == 0x01, "DOM_KEY_LOCATION_LEFT in KeyboardEvent does not match value from IDL");
static_assert(KeyboardEvent::DOM_KEY_LOCATION_RIGHT == 0x02, "DOM_KEY_LOCATION_RIGHT in KeyboardEvent does not match value from IDL");
static_assert(KeyboardEvent::DOM_KEY_LOCATION_NUMPAD == 0x03, "DOM_KEY_LOCATION_NUMPAD in KeyboardEvent does not match value from IDL");

template<> EncodedJSValue JSC_HOST_CALL JSKeyboardEventConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSKeyboardEventConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto type = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto eventInitDict = convert<IDLDictionary<KeyboardEvent::Init>>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = KeyboardEvent::create(WTFMove(type), WTFMove(eventInitDict));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<KeyboardEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSKeyboardEventConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSUIEvent::getConstructor(vm, &globalObject);
}

template<> void JSKeyboardEventConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSKeyboardEvent::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("KeyboardEvent"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSKeyboardEvent::info(), JSKeyboardEventConstructorTableValues, *this);
}

template<> const ClassInfo JSKeyboardEventConstructor::s_info = { "KeyboardEvent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSKeyboardEventConstructor) };

/* Hash table for prototype */

static const HashTableValue JSKeyboardEventPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSKeyboardEventConstructor) } },
    { "key", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventKey), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "code", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventCode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "location", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventLocation), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "ctrlKey", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventCtrlKey), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "shiftKey", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventShiftKey), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "altKey", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventAltKey), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "metaKey", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventMetaKey), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "repeat", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventRepeat), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "isComposing", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventIsComposing), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "keyIdentifier", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventKeyIdentifier), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "keyLocation", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventKeyLocation), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "altGraphKey", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventAltGraphKey), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "charCode", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventCharCode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "keyCode", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventKeyCode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "which", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyboardEventWhich), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "getModifierState", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsKeyboardEventPrototypeFunctionGetModifierState), (intptr_t) (1) } },
    { "initKeyboardEvent", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsKeyboardEventPrototypeFunctionInitKeyboardEvent), (intptr_t) (0) } },
    { "DOM_KEY_LOCATION_STANDARD", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x00) } },
    { "DOM_KEY_LOCATION_LEFT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x01) } },
    { "DOM_KEY_LOCATION_RIGHT", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x02) } },
    { "DOM_KEY_LOCATION_NUMPAD", JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::ConstantInteger, NoIntrinsic, { (long long)(0x03) } },
};

const ClassInfo JSKeyboardEventPrototype::s_info = { "KeyboardEventPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSKeyboardEventPrototype) };

void JSKeyboardEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSKeyboardEvent::info(), JSKeyboardEventPrototypeTableValues, *this);
}

const ClassInfo JSKeyboardEvent::s_info = { "KeyboardEvent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSKeyboardEvent) };

JSKeyboardEvent::JSKeyboardEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<KeyboardEvent>&& impl)
    : JSUIEvent(structure, globalObject, WTFMove(impl))
{
}

void JSKeyboardEvent::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, KeyboardEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSKeyboardEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSKeyboardEventPrototype::create(vm, &globalObject, JSKeyboardEventPrototype::createStructure(vm, &globalObject, JSUIEvent::prototype(vm, globalObject)));
}

JSObject* JSKeyboardEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSKeyboardEvent>(vm, globalObject);
}

JSValue JSKeyboardEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSKeyboardEventConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSKeyboardEvent* IDLAttribute<JSKeyboardEvent>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSKeyboardEvent*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSKeyboardEvent* IDLOperation<JSKeyboardEvent>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSKeyboardEvent*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsKeyboardEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSKeyboardEventPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSKeyboardEvent::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSKeyboardEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSKeyboardEventPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsKeyboardEventKeyGetter(JSGlobalObject& lexicalGlobalObject, JSKeyboardEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.key());
    return result;
}

EncodedJSValue jsKeyboardEventKey(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSKeyboardEvent>::get<jsKeyboardEventKeyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "key");
}

static inline JSValue jsKeyboardEventCodeGetter(JSGlobalObject& lexicalGlobalObject, JSKeyboardEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.code());
    return result;
}

EncodedJSValue jsKeyboardEventCode(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSKeyboardEvent>::get<jsKeyboardEventCodeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "code");
}

static inline JSValue jsKeyboardEventLocationGetter(JSGlobalObject& lexicalGlobalObject, JSKeyboardEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.location());
    return result;
}

EncodedJSValue jsKeyboardEventLocation(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSKeyboardEvent>::get<jsKeyboardEventLocationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "location");
}

static inline JSValue jsKeyboardEventCtrlKeyGetter(JSGlobalObject& lexicalGlobalObject, JSKeyboardEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.ctrlKey());
    return result;
}

EncodedJSValue jsKeyboardEventCtrlKey(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSKeyboardEvent>::get<jsKeyboardEventCtrlKeyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ctrlKey");
}

static inline JSValue jsKeyboardEventShiftKeyGetter(JSGlobalObject& lexicalGlobalObject, JSKeyboardEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.shiftKey());
    return result;
}

EncodedJSValue jsKeyboardEventShiftKey(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSKeyboardEvent>::get<jsKeyboardEventShiftKeyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "shiftKey");
}

static inline JSValue jsKeyboardEventAltKeyGetter(JSGlobalObject& lexicalGlobalObject, JSKeyboardEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.altKey());
    return result;
}

EncodedJSValue jsKeyboardEventAltKey(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSKeyboardEvent>::get<jsKeyboardEventAltKeyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "altKey");
}

static inline JSValue jsKeyboardEventMetaKeyGetter(JSGlobalObject& lexicalGlobalObject, JSKeyboardEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.metaKey());
    return result;
}

EncodedJSValue jsKeyboardEventMetaKey(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSKeyboardEvent>::get<jsKeyboardEventMetaKeyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "metaKey");
}

static inline JSValue jsKeyboardEventRepeatGetter(JSGlobalObject& lexicalGlobalObject, JSKeyboardEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.repeat());
    return result;
}

EncodedJSValue jsKeyboardEventRepeat(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSKeyboardEvent>::get<jsKeyboardEventRepeatGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "repeat");
}

static inline JSValue jsKeyboardEventIsComposingGetter(JSGlobalObject& lexicalGlobalObject, JSKeyboardEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.isComposing());
    return result;
}

EncodedJSValue jsKeyboardEventIsComposing(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSKeyboardEvent>::get<jsKeyboardEventIsComposingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "isComposing");
}

static inline JSValue jsKeyboardEventKeyIdentifierGetter(JSGlobalObject& lexicalGlobalObject, JSKeyboardEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.keyIdentifier());
    return result;
}

EncodedJSValue jsKeyboardEventKeyIdentifier(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSKeyboardEvent>::get<jsKeyboardEventKeyIdentifierGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "keyIdentifier");
}

static inline JSValue jsKeyboardEventKeyLocationGetter(JSGlobalObject& lexicalGlobalObject, JSKeyboardEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.location());
    return result;
}

EncodedJSValue jsKeyboardEventKeyLocation(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSKeyboardEvent>::get<jsKeyboardEventKeyLocationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "keyLocation");
}

static inline JSValue jsKeyboardEventAltGraphKeyGetter(JSGlobalObject& lexicalGlobalObject, JSKeyboardEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.altGraphKey());
    return result;
}

EncodedJSValue jsKeyboardEventAltGraphKey(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSKeyboardEvent>::get<jsKeyboardEventAltGraphKeyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "altGraphKey");
}

static inline JSValue jsKeyboardEventCharCodeGetter(JSGlobalObject& lexicalGlobalObject, JSKeyboardEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.charCode());
    return result;
}

EncodedJSValue jsKeyboardEventCharCode(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSKeyboardEvent>::get<jsKeyboardEventCharCodeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "charCode");
}

static inline JSValue jsKeyboardEventKeyCodeGetter(JSGlobalObject& lexicalGlobalObject, JSKeyboardEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.keyCode());
    return result;
}

EncodedJSValue jsKeyboardEventKeyCode(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSKeyboardEvent>::get<jsKeyboardEventKeyCodeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "keyCode");
}

static inline JSValue jsKeyboardEventWhichGetter(JSGlobalObject& lexicalGlobalObject, JSKeyboardEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.which());
    return result;
}

EncodedJSValue jsKeyboardEventWhich(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSKeyboardEvent>::get<jsKeyboardEventWhichGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "which");
}

static inline JSC::EncodedJSValue jsKeyboardEventPrototypeFunctionGetModifierStateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSKeyboardEvent>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto keyArg = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(impl.getModifierState(WTFMove(keyArg))));
}

EncodedJSValue JSC_HOST_CALL jsKeyboardEventPrototypeFunctionGetModifierState(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSKeyboardEvent>::call<jsKeyboardEventPrototypeFunctionGetModifierStateBody>(*lexicalGlobalObject, *callFrame, "getModifierState");
}

static inline JSC::EncodedJSValue jsKeyboardEventPrototypeFunctionInitKeyboardEventBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSKeyboardEvent>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto type = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto canBubble = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto cancelable = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->argument(2));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto view = convert<IDLNullable<IDLInterface<WindowProxy>>>(*lexicalGlobalObject, callFrame->argument(3), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 3, "view", "KeyboardEvent", "initKeyboardEvent", "WindowProxy"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto keyIdentifier = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->argument(4));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto location = convert<IDLUnsignedLong>(*lexicalGlobalObject, callFrame->argument(5));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto ctrlKey = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->argument(6));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto altKey = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->argument(7));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto shiftKey = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->argument(8));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto metaKey = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->argument(9));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto altGraphKey = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->argument(10));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.initKeyboardEvent(WTFMove(type), WTFMove(canBubble), WTFMove(cancelable), WTFMove(view), WTFMove(keyIdentifier), WTFMove(location), WTFMove(ctrlKey), WTFMove(altKey), WTFMove(shiftKey), WTFMove(metaKey), WTFMove(altGraphKey));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsKeyboardEventPrototypeFunctionInitKeyboardEvent(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSKeyboardEvent>::call<jsKeyboardEventPrototypeFunctionInitKeyboardEventBody>(*lexicalGlobalObject, *callFrame, "initKeyboardEvent");
}

void JSKeyboardEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSKeyboardEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7KeyboardEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore13KeyboardEventE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<KeyboardEvent>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7KeyboardEvent@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore13KeyboardEventE[2];
#endif

    // If this fails KeyboardEvent does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<KeyboardEvent>::value, "KeyboardEvent is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // KeyboardEvent has subclasses. If KeyboardEvent has subclasses that get passed
    // to toJS() we currently require KeyboardEvent you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<KeyboardEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, KeyboardEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
