/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSKeyframeEffect.h"

#include "ActiveDOMObject.h"
#include "JSCompositeOperation.h"
#include "JSCompositeOperationOrAuto.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertObject.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSElement.h"
#include "JSIterationCompositeOperation.h"
#include "JSKeyframeEffect.h"
#include "JSKeyframeEffectOptions.h"
#include "RuntimeEnabledFeatures.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>


namespace WebCore {
using namespace JSC;

template<> KeyframeEffect::BasePropertyIndexedKeyframe convertDictionary<KeyframeEffect::BasePropertyIndexedKeyframe>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    KeyframeEffect::BasePropertyIndexedKeyframe result;
    JSValue compositeValue;
    if (isNullOrUndefined)
        compositeValue = jsUndefined();
    else {
        compositeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composite"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!compositeValue.isUndefined()) {
        result.composite = convert<IDLUnion<IDLSequence<IDLEnumeration<CompositeOperationOrAuto>>, IDLEnumeration<CompositeOperationOrAuto>>>(lexicalGlobalObject, compositeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.composite = Converter<IDLUnion<IDLSequence<IDLEnumeration<CompositeOperationOrAuto>>, IDLEnumeration<CompositeOperationOrAuto>>>::ReturnType{ };
    JSValue easingValue;
    if (isNullOrUndefined)
        easingValue = jsUndefined();
    else {
        easingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "easing"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!easingValue.isUndefined()) {
        result.easing = convert<IDLUnion<IDLSequence<IDLDOMString>, IDLDOMString>>(lexicalGlobalObject, easingValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.easing = Converter<IDLUnion<IDLSequence<IDLDOMString>, IDLDOMString>>::ReturnType{ };
    JSValue offsetValue;
    if (isNullOrUndefined)
        offsetValue = jsUndefined();
    else {
        offsetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "offset"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!offsetValue.isUndefined()) {
        result.offset = convert<IDLUnion<IDLNull, IDLSequence<IDLNullable<IDLDouble>>, IDLDouble>>(lexicalGlobalObject, offsetValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.offset = Converter<IDLUnion<IDLNull, IDLSequence<IDLNullable<IDLDouble>>, IDLDouble>>::ReturnType{ };
    return result;
}

template<> KeyframeEffect::BaseKeyframe convertDictionary<KeyframeEffect::BaseKeyframe>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    KeyframeEffect::BaseKeyframe result;
    JSValue compositeValue;
    if (isNullOrUndefined)
        compositeValue = jsUndefined();
    else {
        compositeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composite"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!compositeValue.isUndefined()) {
        result.composite = convert<IDLEnumeration<CompositeOperationOrAuto>>(lexicalGlobalObject, compositeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.composite = CompositeOperationOrAuto::Auto;
    JSValue easingValue;
    if (isNullOrUndefined)
        easingValue = jsUndefined();
    else {
        easingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "easing"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!easingValue.isUndefined()) {
        result.easing = convert<IDLDOMString>(lexicalGlobalObject, easingValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.easing = "linear"_s;
    JSValue offsetValue;
    if (isNullOrUndefined)
        offsetValue = jsUndefined();
    else {
        offsetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "offset"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!offsetValue.isUndefined()) {
        result.offset = convert<IDLNullable<IDLDouble>>(lexicalGlobalObject, offsetValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.offset = WTF::nullopt;
    return result;
}

template<> KeyframeEffect::BaseComputedKeyframe convertDictionary<KeyframeEffect::BaseComputedKeyframe>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    KeyframeEffect::BaseComputedKeyframe result;
    JSValue compositeValue;
    if (isNullOrUndefined)
        compositeValue = jsUndefined();
    else {
        compositeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composite"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!compositeValue.isUndefined()) {
        result.composite = convert<IDLEnumeration<CompositeOperationOrAuto>>(lexicalGlobalObject, compositeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.composite = CompositeOperationOrAuto::Auto;
    JSValue computedOffsetValue;
    if (isNullOrUndefined)
        computedOffsetValue = jsUndefined();
    else {
        computedOffsetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "computedOffset"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!computedOffsetValue.isUndefined()) {
        result.computedOffset = convert<IDLDouble>(lexicalGlobalObject, computedOffsetValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue easingValue;
    if (isNullOrUndefined)
        easingValue = jsUndefined();
    else {
        easingValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "easing"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!easingValue.isUndefined()) {
        result.easing = convert<IDLDOMString>(lexicalGlobalObject, easingValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.easing = "linear"_s;
    JSValue offsetValue;
    if (isNullOrUndefined)
        offsetValue = jsUndefined();
    else {
        offsetValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "offset"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!offsetValue.isUndefined()) {
        result.offset = convert<IDLNullable<IDLDouble>>(lexicalGlobalObject, offsetValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.offset = WTF::nullopt;
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const KeyframeEffect::BaseComputedKeyframe& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto compositeValue = toJS<IDLEnumeration<CompositeOperationOrAuto>>(lexicalGlobalObject, dictionary.composite);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "composite"), compositeValue);
    if (!IDLDouble::isNullValue(dictionary.computedOffset)) {
        auto computedOffsetValue = toJS<IDLDouble>(IDLDouble::extractValueFromNullable(dictionary.computedOffset));
        result->putDirect(vm, JSC::Identifier::fromString(vm, "computedOffset"), computedOffsetValue);
    }
    auto easingValue = toJS<IDLDOMString>(lexicalGlobalObject, dictionary.easing);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "easing"), easingValue);
    auto offsetValue = toJS<IDLNullable<IDLDouble>>(dictionary.offset);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "offset"), offsetValue);
    return result;
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsKeyframeEffectPrototypeFunctionGetKeyframes(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsKeyframeEffectPrototypeFunctionSetKeyframes(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsKeyframeEffectConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSKeyframeEffectConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsKeyframeEffectTarget(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSKeyframeEffectTarget(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsKeyframeEffectIterationComposite(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSKeyframeEffectIterationComposite(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsKeyframeEffectComposite(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSKeyframeEffectComposite(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSKeyframeEffectPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSKeyframeEffectPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSKeyframeEffectPrototype* ptr = new (NotNull, JSC::allocateCell<JSKeyframeEffectPrototype>(vm.heap)) JSKeyframeEffectPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSKeyframeEffectPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSKeyframeEffectPrototype, JSKeyframeEffectPrototype::Base);

using JSKeyframeEffectConstructor = JSDOMConstructor<JSKeyframeEffect>;

static inline EncodedJSValue constructJSKeyframeEffect1(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSKeyframeEffectConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto target = convert<IDLNullable<IDLInterface<Element>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "target", "KeyframeEffect", nullptr, "Element"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto keyframes = convert<IDLNullable<IDLObject>>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto options = callFrame->argument(2).isUndefined() ? Optional<Converter<IDLUnion<IDLUnrestrictedDouble, IDLDictionary<KeyframeEffectOptions>>>::ReturnType>() : Optional<Converter<IDLUnion<IDLUnrestrictedDouble, IDLDictionary<KeyframeEffectOptions>>>::ReturnType>(convert<IDLUnion<IDLUnrestrictedDouble, IDLDictionary<KeyframeEffectOptions>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(2)));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = KeyframeEffect::create(*castedThis->globalObject(), WTFMove(target), WTFMove(keyframes), WTFMove(options));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<KeyframeEffect>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object)));
}

static inline EncodedJSValue constructJSKeyframeEffect2(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSKeyframeEffectConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto source = convert<IDLInterface<KeyframeEffect>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "source", "KeyframeEffect", nullptr, "KeyframeEffect"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = KeyframeEffect::create(*castedThis->globalObject(), *source);
    return JSValue::encode(toJSNewlyCreated<IDLInterface<KeyframeEffect>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object)));
}

template<> EncodedJSValue JSC_HOST_CALL JSKeyframeEffectConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    size_t argsCount = std::min<size_t>(3, callFrame->argumentCount());
    if (argsCount == 1) {
        return constructJSKeyframeEffect2(lexicalGlobalObject, callFrame);
    }
    if (argsCount == 2) {
        return constructJSKeyframeEffect1(lexicalGlobalObject, callFrame);
    }
    if (argsCount == 3) {
        return constructJSKeyframeEffect1(lexicalGlobalObject, callFrame);
    }
    return argsCount < 1 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

template<> JSValue JSKeyframeEffectConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSAnimationEffect::getConstructor(vm, &globalObject);
}

template<> void JSKeyframeEffectConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSKeyframeEffect::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("KeyframeEffect"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSKeyframeEffectConstructor::s_info = { "KeyframeEffect", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSKeyframeEffectConstructor) };

/* Hash table for prototype */

static const HashTableValue JSKeyframeEffectPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyframeEffectConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSKeyframeEffectConstructor) } },
    { "target", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyframeEffectTarget), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSKeyframeEffectTarget) } },
    { "iterationComposite", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyframeEffectIterationComposite), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSKeyframeEffectIterationComposite) } },
    { "composite", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsKeyframeEffectComposite), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSKeyframeEffectComposite) } },
    { "getKeyframes", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsKeyframeEffectPrototypeFunctionGetKeyframes), (intptr_t) (0) } },
    { "setKeyframes", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsKeyframeEffectPrototypeFunctionSetKeyframes), (intptr_t) (1) } },
};

const ClassInfo JSKeyframeEffectPrototype::s_info = { "KeyframeEffectPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSKeyframeEffectPrototype) };

void JSKeyframeEffectPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSKeyframeEffect::info(), JSKeyframeEffectPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!RuntimeEnabledFeatures::sharedFeatures().webAnimationsCompositeOperationsEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("iterationComposite"), strlen("iterationComposite"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().webAnimationsCompositeOperationsEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("composite"), strlen("composite"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
}

const ClassInfo JSKeyframeEffect::s_info = { "KeyframeEffect", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSKeyframeEffect) };

JSKeyframeEffect::JSKeyframeEffect(Structure* structure, JSDOMGlobalObject& globalObject, Ref<KeyframeEffect>&& impl)
    : JSAnimationEffect(structure, globalObject, WTFMove(impl))
{
}

void JSKeyframeEffect::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, KeyframeEffect>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSKeyframeEffect::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSKeyframeEffectPrototype::create(vm, &globalObject, JSKeyframeEffectPrototype::createStructure(vm, &globalObject, JSAnimationEffect::prototype(vm, globalObject)));
}

JSObject* JSKeyframeEffect::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSKeyframeEffect>(vm, globalObject);
}

JSValue JSKeyframeEffect::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSKeyframeEffectConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSKeyframeEffect* IDLAttribute<JSKeyframeEffect>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSKeyframeEffect*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSKeyframeEffect* IDLOperation<JSKeyframeEffect>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSKeyframeEffect*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsKeyframeEffectConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSKeyframeEffectPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSKeyframeEffect::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSKeyframeEffectConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSKeyframeEffectPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsKeyframeEffectTargetGetter(JSGlobalObject& lexicalGlobalObject, JSKeyframeEffect& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.target());
    return result;
}

EncodedJSValue jsKeyframeEffectTarget(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSKeyframeEffect>::get<jsKeyframeEffectTargetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "target");
}

static inline bool setJSKeyframeEffectTargetSetter(JSGlobalObject& lexicalGlobalObject, JSKeyframeEffect& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, value, [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwAttributeTypeError(lexicalGlobalObject, scope, "KeyframeEffect", "target", "Element"); });
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setTarget(WTFMove(nativeValue));
    });
    return true;
}

bool setJSKeyframeEffectTarget(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSKeyframeEffect>::set<setJSKeyframeEffectTargetSetter>(*lexicalGlobalObject, thisValue, encodedValue, "target");
}

static inline JSValue jsKeyframeEffectIterationCompositeGetter(JSGlobalObject& lexicalGlobalObject, JSKeyframeEffect& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<IterationCompositeOperation>>(lexicalGlobalObject, throwScope, impl.iterationComposite());
    return result;
}

EncodedJSValue jsKeyframeEffectIterationComposite(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSKeyframeEffect>::get<jsKeyframeEffectIterationCompositeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "iterationComposite");
}

static inline bool setJSKeyframeEffectIterationCompositeSetter(JSGlobalObject& lexicalGlobalObject, JSKeyframeEffect& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<IterationCompositeOperation>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    auto nativeValue = optionalNativeValue.value();
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setIterationComposite(WTFMove(nativeValue));
    });
    return true;
}

bool setJSKeyframeEffectIterationComposite(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSKeyframeEffect>::set<setJSKeyframeEffectIterationCompositeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "iterationComposite");
}

static inline JSValue jsKeyframeEffectCompositeGetter(JSGlobalObject& lexicalGlobalObject, JSKeyframeEffect& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<CompositeOperation>>(lexicalGlobalObject, throwScope, impl.composite());
    return result;
}

EncodedJSValue jsKeyframeEffectComposite(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSKeyframeEffect>::get<jsKeyframeEffectCompositeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "composite");
}

static inline bool setJSKeyframeEffectCompositeSetter(JSGlobalObject& lexicalGlobalObject, JSKeyframeEffect& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<CompositeOperation>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    auto nativeValue = optionalNativeValue.value();
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setComposite(WTFMove(nativeValue));
    });
    return true;
}

bool setJSKeyframeEffectComposite(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSKeyframeEffect>::set<setJSKeyframeEffectCompositeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "composite");
}

static inline JSC::EncodedJSValue jsKeyframeEffectPrototypeFunctionGetKeyframesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSKeyframeEffect>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLSequence<IDLObject>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getKeyframes(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject))));
}

EncodedJSValue JSC_HOST_CALL jsKeyframeEffectPrototypeFunctionGetKeyframes(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSKeyframeEffect>::call<jsKeyframeEffectPrototypeFunctionGetKeyframesBody>(*lexicalGlobalObject, *callFrame, "getKeyframes");
}

static inline JSC::EncodedJSValue jsKeyframeEffectPrototypeFunctionSetKeyframesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSKeyframeEffect>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto keyframes = convert<IDLNullable<IDLObject>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setKeyframes(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject), WTFMove(keyframes)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsKeyframeEffectPrototypeFunctionSetKeyframes(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSKeyframeEffect>::call<jsKeyframeEffectPrototypeFunctionSetKeyframesBody>(*lexicalGlobalObject, *callFrame, "setKeyframes");
}

void JSKeyframeEffect::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSKeyframeEffect*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7KeyframeEffect@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14KeyframeEffectE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<KeyframeEffect>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7KeyframeEffect@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore14KeyframeEffectE[2];
#endif

    // If this fails KeyframeEffect does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<KeyframeEffect>::value, "KeyframeEffect is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // KeyframeEffect has subclasses. If KeyframeEffect has subclasses that get passed
    // to toJS() we currently require KeyframeEffect you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<KeyframeEffect>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, KeyframeEffect& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

KeyframeEffect* JSKeyframeEffect::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSKeyframeEffect*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
