/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSLocation.h"

#include "ActiveDOMObject.h"
#include "DOMWindow.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMBindingSecurity.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMStringList.h"
#include "JSDOMWindowBase.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsLocationInstanceFunctionToString(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsLocationConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSLocationConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsLocationHref(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSLocationHref(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsLocationProtocol(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSLocationProtocol(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsLocationHost(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSLocationHost(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsLocationHostname(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSLocationHostname(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsLocationPort(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSLocationPort(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsLocationPathname(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSLocationPathname(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsLocationSearch(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSLocationSearch(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsLocationHash(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSLocationHash(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsLocationOrigin(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsLocationAncestorOrigins(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

using JSLocationConstructor = JSDOMConstructorNotConstructable<JSLocation>;

/* Hash table */

static const struct CompactHashIndex JSLocationTableIndex[35] = {
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 8, 34 },
    { -1, -1 },
    { -1, -1 },
    { 7, -1 },
    { 0, 32 },
    { 5, 33 },
    { -1, -1 },
    { 10, -1 },
    { -1, -1 },
    { 9, -1 },
    { -1, -1 },
    { -1, -1 },
    { 3, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 11, -1 },
    { -1, -1 },
    { 1, -1 },
    { -1, -1 },
    { 4, -1 },
    { 13, -1 },
    { -1, -1 },
    { -1, -1 },
    { -1, -1 },
    { 2, -1 },
    { 6, -1 },
    { 12, -1 },
};


static const HashTableValue JSLocationTableValues[] =
{
    { "href", static_cast<unsigned>(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsLocationHref), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSLocationHref) } },
    { "protocol", static_cast<unsigned>(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsLocationProtocol), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSLocationProtocol) } },
    { "host", static_cast<unsigned>(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsLocationHost), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSLocationHost) } },
    { "hostname", static_cast<unsigned>(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsLocationHostname), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSLocationHostname) } },
    { "port", static_cast<unsigned>(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsLocationPort), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSLocationPort) } },
    { "pathname", static_cast<unsigned>(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsLocationPathname), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSLocationPathname) } },
    { "search", static_cast<unsigned>(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsLocationSearch), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSLocationSearch) } },
    { "hash", static_cast<unsigned>(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsLocationHash), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSLocationHash) } },
    { "origin", static_cast<unsigned>(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsLocationOrigin), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "ancestorOrigins", static_cast<unsigned>(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsLocationAncestorOrigins), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "assign", static_cast<unsigned>(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsLocationInstanceFunctionAssign), (intptr_t) (1) } },
    { "replace", static_cast<unsigned>(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsLocationInstanceFunctionReplace), (intptr_t) (1) } },
    { "reload", static_cast<unsigned>(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsLocationInstanceFunctionReload), (intptr_t) (0) } },
    { "toString", static_cast<unsigned>(JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsLocationInstanceFunctionToString), (intptr_t) (0) } },
};

static const HashTable JSLocationTable = { 14, 31, true, JSLocation::info(), JSLocationTableValues, JSLocationTableIndex };
template<> JSValue JSLocationConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSLocationConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSLocation::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("Location"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSLocationConstructor::s_info = { "Location", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSLocationConstructor) };

/* Hash table for prototype */

static const HashTableValue JSLocationPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsLocationConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSLocationConstructor) } },
};

const ClassInfo JSLocationPrototype::s_info = { "LocationPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSLocationPrototype) };

void JSLocationPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSLocation::info(), JSLocationPrototypeTableValues, *this);
}

const ClassInfo JSLocation::s_info = { "Location", &Base::s_info, &JSLocationTable, nullptr, CREATE_METHOD_TABLE(JSLocation) };

JSLocation::JSLocation(Structure* structure, JSDOMGlobalObject& globalObject, Ref<Location>&& impl)
    : JSDOMWrapper<Location>(structure, globalObject, WTFMove(impl))
{
}

void JSLocation::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, Location>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

    putDirect(vm, vm.propertyNames->valueOf, globalObject()->objectProtoValueOfFunction(), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->toPrimitiveSymbol, jsUndefined(), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

JSObject* JSLocation::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSLocationPrototype::create(vm, &globalObject, JSLocationPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSLocation::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSLocation>(vm, globalObject);
}

JSValue JSLocation::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSLocationConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSLocation::destroy(JSC::JSCell* cell)
{
    JSLocation* thisObject = static_cast<JSLocation*>(cell);
    thisObject->JSLocation::~JSLocation();
}

template<> inline JSLocation* IDLAttribute<JSLocation>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSLocation*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSLocation* IDLOperation<JSLocation>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSLocation*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsLocationConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSLocationPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSLocation::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSLocationConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSLocationPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsLocationHrefGetter(JSGlobalObject& lexicalGlobalObject, JSLocation& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped().window(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.href());
    return result;
}

EncodedJSValue jsLocationHref(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSLocation>::get<jsLocationHrefGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "href");
}

static inline bool setJSLocationHrefSetter(JSGlobalObject& lexicalGlobalObject, JSLocation& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUSVString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setHref(activeDOMWindow(*jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)), firstDOMWindow(*jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)), WTFMove(nativeValue));
    });
    return true;
}

bool setJSLocationHref(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSLocation>::set<setJSLocationHrefSetter>(*lexicalGlobalObject, thisValue, encodedValue, "href");
}

static inline JSValue jsLocationProtocolGetter(JSGlobalObject& lexicalGlobalObject, JSLocation& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped().window(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.protocol());
    return result;
}

EncodedJSValue jsLocationProtocol(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSLocation>::get<jsLocationProtocolGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "protocol");
}

static inline bool setJSLocationProtocolSetter(JSGlobalObject& lexicalGlobalObject, JSLocation& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped().window(), ThrowSecurityError))
        return false;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUSVString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setProtocol(activeDOMWindow(*jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)), firstDOMWindow(*jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)), WTFMove(nativeValue));
    });
    return true;
}

bool setJSLocationProtocol(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSLocation>::set<setJSLocationProtocolSetter>(*lexicalGlobalObject, thisValue, encodedValue, "protocol");
}

static inline JSValue jsLocationHostGetter(JSGlobalObject& lexicalGlobalObject, JSLocation& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped().window(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.host());
    return result;
}

EncodedJSValue jsLocationHost(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSLocation>::get<jsLocationHostGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "host");
}

static inline bool setJSLocationHostSetter(JSGlobalObject& lexicalGlobalObject, JSLocation& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped().window(), ThrowSecurityError))
        return false;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUSVString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setHost(activeDOMWindow(*jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)), firstDOMWindow(*jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)), WTFMove(nativeValue));
    });
    return true;
}

bool setJSLocationHost(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSLocation>::set<setJSLocationHostSetter>(*lexicalGlobalObject, thisValue, encodedValue, "host");
}

static inline JSValue jsLocationHostnameGetter(JSGlobalObject& lexicalGlobalObject, JSLocation& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped().window(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.hostname());
    return result;
}

EncodedJSValue jsLocationHostname(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSLocation>::get<jsLocationHostnameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "hostname");
}

static inline bool setJSLocationHostnameSetter(JSGlobalObject& lexicalGlobalObject, JSLocation& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped().window(), ThrowSecurityError))
        return false;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUSVString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setHostname(activeDOMWindow(*jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)), firstDOMWindow(*jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)), WTFMove(nativeValue));
    });
    return true;
}

bool setJSLocationHostname(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSLocation>::set<setJSLocationHostnameSetter>(*lexicalGlobalObject, thisValue, encodedValue, "hostname");
}

static inline JSValue jsLocationPortGetter(JSGlobalObject& lexicalGlobalObject, JSLocation& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped().window(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.port());
    return result;
}

EncodedJSValue jsLocationPort(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSLocation>::get<jsLocationPortGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "port");
}

static inline bool setJSLocationPortSetter(JSGlobalObject& lexicalGlobalObject, JSLocation& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped().window(), ThrowSecurityError))
        return false;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUSVString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setPort(activeDOMWindow(*jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)), firstDOMWindow(*jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)), WTFMove(nativeValue));
    });
    return true;
}

bool setJSLocationPort(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSLocation>::set<setJSLocationPortSetter>(*lexicalGlobalObject, thisValue, encodedValue, "port");
}

static inline JSValue jsLocationPathnameGetter(JSGlobalObject& lexicalGlobalObject, JSLocation& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped().window(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.pathname());
    return result;
}

EncodedJSValue jsLocationPathname(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSLocation>::get<jsLocationPathnameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "pathname");
}

static inline bool setJSLocationPathnameSetter(JSGlobalObject& lexicalGlobalObject, JSLocation& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped().window(), ThrowSecurityError))
        return false;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUSVString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setPathname(activeDOMWindow(*jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)), firstDOMWindow(*jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)), WTFMove(nativeValue));
    });
    return true;
}

bool setJSLocationPathname(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSLocation>::set<setJSLocationPathnameSetter>(*lexicalGlobalObject, thisValue, encodedValue, "pathname");
}

static inline JSValue jsLocationSearchGetter(JSGlobalObject& lexicalGlobalObject, JSLocation& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped().window(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.search());
    return result;
}

EncodedJSValue jsLocationSearch(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSLocation>::get<jsLocationSearchGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "search");
}

static inline bool setJSLocationSearchSetter(JSGlobalObject& lexicalGlobalObject, JSLocation& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped().window(), ThrowSecurityError))
        return false;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUSVString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setSearch(activeDOMWindow(*jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)), firstDOMWindow(*jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)), WTFMove(nativeValue));
    });
    return true;
}

bool setJSLocationSearch(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSLocation>::set<setJSLocationSearchSetter>(*lexicalGlobalObject, thisValue, encodedValue, "search");
}

static inline JSValue jsLocationHashGetter(JSGlobalObject& lexicalGlobalObject, JSLocation& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped().window(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.hash());
    return result;
}

EncodedJSValue jsLocationHash(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSLocation>::get<jsLocationHashGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "hash");
}

static inline bool setJSLocationHashSetter(JSGlobalObject& lexicalGlobalObject, JSLocation& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped().window(), ThrowSecurityError))
        return false;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUSVString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setHash(activeDOMWindow(*jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)), firstDOMWindow(*jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject)), WTFMove(nativeValue));
    });
    return true;
}

bool setJSLocationHash(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSLocation>::set<setJSLocationHashSetter>(*lexicalGlobalObject, thisValue, encodedValue, "hash");
}

static inline JSValue jsLocationOriginGetter(JSGlobalObject& lexicalGlobalObject, JSLocation& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped().window(), ThrowSecurityError))
        return jsUndefined();
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.origin());
    return result;
}

EncodedJSValue jsLocationOrigin(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSLocation>::get<jsLocationOriginGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "origin");
}

static inline JSValue jsLocationAncestorOriginsGetter(JSGlobalObject& lexicalGlobalObject, JSLocation& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(&lexicalGlobalObject, thisObject.wrapped().window(), ThrowSecurityError))
        return jsUndefined();
    if (JSValue cachedValue = thisObject.m_ancestorOrigins.get())
        return cachedValue;
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<DOMStringList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.ancestorOrigins());
    thisObject.m_ancestorOrigins.set(JSC::getVM(&lexicalGlobalObject), &thisObject, result);
    return result;
}

EncodedJSValue jsLocationAncestorOrigins(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSLocation>::get<jsLocationAncestorOriginsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ancestorOrigins");
}

static inline JSC::EncodedJSValue jsLocationInstanceFunctionAssignBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSLocation>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(lexicalGlobalObject, castedThis->wrapped().window(), ThrowSecurityError))
        return JSValue::encode(jsUndefined());
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto url = convert<IDLUSVString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.assign(activeDOMWindow(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)), firstDOMWindow(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)), WTFMove(url)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsLocationInstanceFunctionAssign(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSLocation>::call<jsLocationInstanceFunctionAssignBody>(*lexicalGlobalObject, *callFrame, "assign");
}

static inline JSC::EncodedJSValue jsLocationInstanceFunctionReplaceBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSLocation>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto url = convert<IDLUSVString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.replace(activeDOMWindow(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)), firstDOMWindow(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)), WTFMove(url));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsLocationInstanceFunctionReplace(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSLocation>::call<jsLocationInstanceFunctionReplaceBody>(*lexicalGlobalObject, *callFrame, "replace");
}

static inline JSC::EncodedJSValue jsLocationInstanceFunctionReloadBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSLocation>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(lexicalGlobalObject, castedThis->wrapped().window(), ThrowSecurityError))
        return JSValue::encode(jsUndefined());
    auto& impl = castedThis->wrapped();
    impl.reload(activeDOMWindow(*jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsLocationInstanceFunctionReload(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSLocation>::call<jsLocationInstanceFunctionReloadBody>(*lexicalGlobalObject, *callFrame, "reload");
}

static inline JSC::EncodedJSValue jsLocationInstanceFunctionToStringBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSLocation>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    if (!BindingSecurity::shouldAllowAccessToDOMWindow(lexicalGlobalObject, castedThis->wrapped().window(), ThrowSecurityError))
        return JSValue::encode(jsUndefined());
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLUSVString>(*lexicalGlobalObject, impl.href()));
}

EncodedJSValue JSC_HOST_CALL jsLocationInstanceFunctionToString(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSLocation>::call<jsLocationInstanceFunctionToStringBody>(*lexicalGlobalObject, *callFrame, "toString");
}

void JSLocation::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSLocation*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    visitor.append(thisObject->m_ancestorOrigins);
}

void JSLocation::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSLocation*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSLocationOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsLocation = jsCast<JSLocation*>(handle.slot()->asCell());
    auto* root = WTF::getPtr(jsLocation->wrapped().window());
    if (!root)
        return false;
    if (UNLIKELY(reason))
        *reason = "Reachable from Window";
    return visitor.containsOpaqueRoot(root);
}

void JSLocationOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsLocation = static_cast<JSLocation*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsLocation->wrapped(), jsLocation);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<Location>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to Location.
    static_assert(!std::is_polymorphic<Location>::value, "Location is polymorphic but the IDL claims it is not");
    return createWrapper<Location>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, Location& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

Location* JSLocation::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSLocation*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
