/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSMediaCapabilitiesEncodingInfo.h"

#include "Document.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMGlobalObject.h"
#include "JSMediaEncodingConfiguration.h"
#include "Settings.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>


namespace WebCore {
using namespace JSC;

template<> MediaCapabilitiesEncodingInfo convertDictionary<MediaCapabilitiesEncodingInfo>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    MediaCapabilitiesEncodingInfo result;
    JSValue powerEfficientValue;
    if (isNullOrUndefined)
        powerEfficientValue = jsUndefined();
    else {
        powerEfficientValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "powerEfficient"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!powerEfficientValue.isUndefined()) {
        result.powerEfficient = convert<IDLBoolean>(lexicalGlobalObject, powerEfficientValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "powerEfficient", "MediaCapabilitiesEncodingInfo", "boolean");
        return { };
    }
    JSValue smoothValue;
    if (isNullOrUndefined)
        smoothValue = jsUndefined();
    else {
        smoothValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "smooth"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!smoothValue.isUndefined()) {
        result.smooth = convert<IDLBoolean>(lexicalGlobalObject, smoothValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "smooth", "MediaCapabilitiesEncodingInfo", "boolean");
        return { };
    }
    JSValue supportedValue;
    if (isNullOrUndefined)
        supportedValue = jsUndefined();
    else {
        supportedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "supported"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!supportedValue.isUndefined()) {
        result.supported = convert<IDLBoolean>(lexicalGlobalObject, supportedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "supported", "MediaCapabilitiesEncodingInfo", "boolean");
        return { };
    }
    JSValue supportedConfigurationValue;
    if (isNullOrUndefined)
        supportedConfigurationValue = jsUndefined();
    else {
        supportedConfigurationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "supportedConfiguration"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!supportedConfigurationValue.isUndefined()) {
        result.supportedConfiguration = convert<IDLDictionary<MediaEncodingConfiguration>>(lexicalGlobalObject, supportedConfigurationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const MediaCapabilitiesEncodingInfo& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto powerEfficientValue = toJS<IDLBoolean>(dictionary.powerEfficient);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "powerEfficient"), powerEfficientValue);
    auto smoothValue = toJS<IDLBoolean>(dictionary.smooth);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "smooth"), smoothValue);
    auto supportedValue = toJS<IDLBoolean>(dictionary.supported);
    result->putDirect(vm, JSC::Identifier::fromString(vm, "supported"), supportedValue);
    if (downcast<Document>(jsCast<JSDOMGlobalObject*>(&globalObject)->scriptExecutionContext())->settings().mediaCapabilitiesExtensionsEnabled()) {
        if (!IDLDictionary<MediaEncodingConfiguration>::isNullValue(dictionary.supportedConfiguration)) {
            auto supportedConfigurationValue = toJS<IDLDictionary<MediaEncodingConfiguration>>(lexicalGlobalObject, globalObject, IDLDictionary<MediaEncodingConfiguration>::extractValueFromNullable(dictionary.supportedConfiguration));
            result->putDirect(vm, JSC::Identifier::fromString(vm, "supportedConfiguration"), supportedConfigurationValue);
        }
    }
    return result;
}

} // namespace WebCore
