/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_CONTROLS_SCRIPT)

#include "JSMediaControlsHost.h"

#include "ActiveDOMObject.h"
#include "JSAudioTrack.h"
#include "JSAudioTrackList.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSHTMLElement.h"
#include "JSTextTrack.h"
#include "JSTextTrackList.h"
#include "RuntimeEnabledFeatures.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(MediaControlsHost::DeviceType enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("none"),
        MAKE_STATIC_STRING_IMPL("airplay"),
        MAKE_STATIC_STRING_IMPL("tvout"),
    };
    static_assert(static_cast<size_t>(MediaControlsHost::DeviceType::None) == 0, "MediaControlsHost::DeviceType::None is not 0 as expected");
    static_assert(static_cast<size_t>(MediaControlsHost::DeviceType::Airplay) == 1, "MediaControlsHost::DeviceType::Airplay is not 1 as expected");
    static_assert(static_cast<size_t>(MediaControlsHost::DeviceType::Tvout) == 2, "MediaControlsHost::DeviceType::Tvout is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, MediaControlsHost::DeviceType enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<MediaControlsHost::DeviceType> parseEnumeration<MediaControlsHost::DeviceType>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "none")
        return MediaControlsHost::DeviceType::None;
    if (stringValue == "airplay")
        return MediaControlsHost::DeviceType::Airplay;
    if (stringValue == "tvout")
        return MediaControlsHost::DeviceType::Tvout;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<MediaControlsHost::DeviceType>()
{
    return "\"none\", \"airplay\", \"tvout\"";
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsMediaControlsHostPrototypeFunctionSortedTrackListForMenu(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaControlsHostPrototypeFunctionDisplayNameForTrack(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaControlsHostPrototypeFunctionSetSelectedTextTrack(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaControlsHostPrototypeFunctionSetPreparedToReturnVideoLayerToInline(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaControlsHostPrototypeFunctionUpdateTextTrackContainer(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaControlsHostPrototypeFunctionEnteredFullscreen(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaControlsHostPrototypeFunctionExitedFullscreen(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaControlsHostPrototypeFunctionGenerateUUID(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaControlsHostPrototypeFunctionBase64StringForIconNameAndType(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaControlsHostPrototypeFunctionFormattedStringForDuration(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsMediaControlsHostCaptionMenuOffItem(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaControlsHostCaptionMenuAutomaticItem(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaControlsHostCaptionDisplayMode(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaControlsHostTextTrackContainer(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaControlsHostAllowsInlineMediaPlayback(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaControlsHostSupportsFullscreen(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaControlsHostIsVideoLayerInline(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaControlsHostUserGestureRequired(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaControlsHostIsInMediaDocument(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaControlsHostShouldForceControlsDisplay(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaControlsHostCompactMode(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaControlsHostExternalDeviceDisplayName(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaControlsHostExternalDeviceType(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaControlsHostControlsDependOnPageScaleFactor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMediaControlsHostControlsDependOnPageScaleFactor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMediaControlsHostShadowRootCSSText(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSMediaControlsHostPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSMediaControlsHostPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMediaControlsHostPrototype* ptr = new (NotNull, JSC::allocateCell<JSMediaControlsHostPrototype>(vm.heap)) JSMediaControlsHostPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMediaControlsHostPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMediaControlsHostPrototype, JSMediaControlsHostPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSMediaControlsHostPrototypeTableValues[] =
{
    { "captionMenuOffItem", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaControlsHostCaptionMenuOffItem), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "captionMenuAutomaticItem", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaControlsHostCaptionMenuAutomaticItem), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "captionDisplayMode", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaControlsHostCaptionDisplayMode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "textTrackContainer", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaControlsHostTextTrackContainer), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "allowsInlineMediaPlayback", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaControlsHostAllowsInlineMediaPlayback), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "supportsFullscreen", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaControlsHostSupportsFullscreen), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "isVideoLayerInline", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaControlsHostIsVideoLayerInline), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "userGestureRequired", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaControlsHostUserGestureRequired), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "isInMediaDocument", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaControlsHostIsInMediaDocument), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "shouldForceControlsDisplay", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaControlsHostShouldForceControlsDisplay), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "compactMode", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaControlsHostCompactMode), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "externalDeviceDisplayName", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaControlsHostExternalDeviceDisplayName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "externalDeviceType", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaControlsHostExternalDeviceType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "controlsDependOnPageScaleFactor", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaControlsHostControlsDependOnPageScaleFactor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaControlsHostControlsDependOnPageScaleFactor) } },
    { "shadowRootCSSText", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaControlsHostShadowRootCSSText), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "sortedTrackListForMenu", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMediaControlsHostPrototypeFunctionSortedTrackListForMenu), (intptr_t) (1) } },
    { "displayNameForTrack", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMediaControlsHostPrototypeFunctionDisplayNameForTrack), (intptr_t) (1) } },
    { "setSelectedTextTrack", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMediaControlsHostPrototypeFunctionSetSelectedTextTrack), (intptr_t) (1) } },
    { "setPreparedToReturnVideoLayerToInline", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMediaControlsHostPrototypeFunctionSetPreparedToReturnVideoLayerToInline), (intptr_t) (1) } },
    { "updateTextTrackContainer", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMediaControlsHostPrototypeFunctionUpdateTextTrackContainer), (intptr_t) (0) } },
    { "enteredFullscreen", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMediaControlsHostPrototypeFunctionEnteredFullscreen), (intptr_t) (0) } },
    { "exitedFullscreen", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMediaControlsHostPrototypeFunctionExitedFullscreen), (intptr_t) (0) } },
    { "generateUUID", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMediaControlsHostPrototypeFunctionGenerateUUID), (intptr_t) (0) } },
    { "base64StringForIconNameAndType", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMediaControlsHostPrototypeFunctionBase64StringForIconNameAndType), (intptr_t) (2) } },
    { "formattedStringForDuration", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMediaControlsHostPrototypeFunctionFormattedStringForDuration), (intptr_t) (1) } },
};

const ClassInfo JSMediaControlsHostPrototype::s_info = { "MediaControlsHostPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaControlsHostPrototype) };

void JSMediaControlsHostPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMediaControlsHost::info(), JSMediaControlsHostPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!RuntimeEnabledFeatures::sharedFeatures().modernMediaControlsEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("base64StringForIconNameAndType"), strlen("base64StringForIconNameAndType"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().modernMediaControlsEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("formattedStringForDuration"), strlen("formattedStringForDuration"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (!RuntimeEnabledFeatures::sharedFeatures().modernMediaControlsEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("shadowRootCSSText"), strlen("shadowRootCSSText"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
}

const ClassInfo JSMediaControlsHost::s_info = { "MediaControlsHost", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaControlsHost) };

JSMediaControlsHost::JSMediaControlsHost(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MediaControlsHost>&& impl)
    : JSDOMWrapper<MediaControlsHost>(structure, globalObject, WTFMove(impl))
{
}

void JSMediaControlsHost::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, MediaControlsHost>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSMediaControlsHost::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSMediaControlsHostPrototype::create(vm, &globalObject, JSMediaControlsHostPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSMediaControlsHost::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSMediaControlsHost>(vm, globalObject);
}

void JSMediaControlsHost::destroy(JSC::JSCell* cell)
{
    JSMediaControlsHost* thisObject = static_cast<JSMediaControlsHost*>(cell);
    thisObject->JSMediaControlsHost::~JSMediaControlsHost();
}

template<> inline JSMediaControlsHost* IDLAttribute<JSMediaControlsHost>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSMediaControlsHost*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSMediaControlsHost* IDLOperation<JSMediaControlsHost>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSMediaControlsHost*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

static inline JSValue jsMediaControlsHostCaptionMenuOffItemGetter(JSGlobalObject& lexicalGlobalObject, JSMediaControlsHost& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<TextTrack>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.captionMenuOffItem());
    return result;
}

EncodedJSValue jsMediaControlsHostCaptionMenuOffItem(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaControlsHost>::get<jsMediaControlsHostCaptionMenuOffItemGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "captionMenuOffItem");
}

static inline JSValue jsMediaControlsHostCaptionMenuAutomaticItemGetter(JSGlobalObject& lexicalGlobalObject, JSMediaControlsHost& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<TextTrack>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.captionMenuAutomaticItem());
    return result;
}

EncodedJSValue jsMediaControlsHostCaptionMenuAutomaticItem(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaControlsHost>::get<jsMediaControlsHostCaptionMenuAutomaticItemGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "captionMenuAutomaticItem");
}

static inline JSValue jsMediaControlsHostCaptionDisplayModeGetter(JSGlobalObject& lexicalGlobalObject, JSMediaControlsHost& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.captionDisplayMode());
    return result;
}

EncodedJSValue jsMediaControlsHostCaptionDisplayMode(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaControlsHost>::get<jsMediaControlsHostCaptionDisplayModeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "captionDisplayMode");
}

static inline JSValue jsMediaControlsHostTextTrackContainerGetter(JSGlobalObject& lexicalGlobalObject, JSMediaControlsHost& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<HTMLElement>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.textTrackContainer());
    return result;
}

EncodedJSValue jsMediaControlsHostTextTrackContainer(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaControlsHost>::get<jsMediaControlsHostTextTrackContainerGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "textTrackContainer");
}

static inline JSValue jsMediaControlsHostAllowsInlineMediaPlaybackGetter(JSGlobalObject& lexicalGlobalObject, JSMediaControlsHost& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.allowsInlineMediaPlayback());
    return result;
}

EncodedJSValue jsMediaControlsHostAllowsInlineMediaPlayback(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaControlsHost>::get<jsMediaControlsHostAllowsInlineMediaPlaybackGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "allowsInlineMediaPlayback");
}

static inline JSValue jsMediaControlsHostSupportsFullscreenGetter(JSGlobalObject& lexicalGlobalObject, JSMediaControlsHost& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.supportsFullscreen());
    return result;
}

EncodedJSValue jsMediaControlsHostSupportsFullscreen(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaControlsHost>::get<jsMediaControlsHostSupportsFullscreenGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "supportsFullscreen");
}

static inline JSValue jsMediaControlsHostIsVideoLayerInlineGetter(JSGlobalObject& lexicalGlobalObject, JSMediaControlsHost& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.isVideoLayerInline());
    return result;
}

EncodedJSValue jsMediaControlsHostIsVideoLayerInline(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaControlsHost>::get<jsMediaControlsHostIsVideoLayerInlineGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "isVideoLayerInline");
}

static inline JSValue jsMediaControlsHostUserGestureRequiredGetter(JSGlobalObject& lexicalGlobalObject, JSMediaControlsHost& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.userGestureRequired());
    return result;
}

EncodedJSValue jsMediaControlsHostUserGestureRequired(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaControlsHost>::get<jsMediaControlsHostUserGestureRequiredGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "userGestureRequired");
}

static inline JSValue jsMediaControlsHostIsInMediaDocumentGetter(JSGlobalObject& lexicalGlobalObject, JSMediaControlsHost& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.isInMediaDocument());
    return result;
}

EncodedJSValue jsMediaControlsHostIsInMediaDocument(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaControlsHost>::get<jsMediaControlsHostIsInMediaDocumentGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "isInMediaDocument");
}

static inline JSValue jsMediaControlsHostShouldForceControlsDisplayGetter(JSGlobalObject& lexicalGlobalObject, JSMediaControlsHost& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.shouldForceControlsDisplay());
    return result;
}

EncodedJSValue jsMediaControlsHostShouldForceControlsDisplay(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaControlsHost>::get<jsMediaControlsHostShouldForceControlsDisplayGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "shouldForceControlsDisplay");
}

static inline JSValue jsMediaControlsHostCompactModeGetter(JSGlobalObject& lexicalGlobalObject, JSMediaControlsHost& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.compactMode());
    return result;
}

EncodedJSValue jsMediaControlsHostCompactMode(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaControlsHost>::get<jsMediaControlsHostCompactModeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "compactMode");
}

static inline JSValue jsMediaControlsHostExternalDeviceDisplayNameGetter(JSGlobalObject& lexicalGlobalObject, JSMediaControlsHost& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.externalDeviceDisplayName());
    return result;
}

EncodedJSValue jsMediaControlsHostExternalDeviceDisplayName(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaControlsHost>::get<jsMediaControlsHostExternalDeviceDisplayNameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "externalDeviceDisplayName");
}

static inline JSValue jsMediaControlsHostExternalDeviceTypeGetter(JSGlobalObject& lexicalGlobalObject, JSMediaControlsHost& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<MediaControlsHost::DeviceType>>(lexicalGlobalObject, throwScope, impl.externalDeviceType());
    return result;
}

EncodedJSValue jsMediaControlsHostExternalDeviceType(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaControlsHost>::get<jsMediaControlsHostExternalDeviceTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "externalDeviceType");
}

static inline JSValue jsMediaControlsHostControlsDependOnPageScaleFactorGetter(JSGlobalObject& lexicalGlobalObject, JSMediaControlsHost& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.controlsDependOnPageScaleFactor());
    return result;
}

EncodedJSValue jsMediaControlsHostControlsDependOnPageScaleFactor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaControlsHost>::get<jsMediaControlsHostControlsDependOnPageScaleFactorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "controlsDependOnPageScaleFactor");
}

static inline bool setJSMediaControlsHostControlsDependOnPageScaleFactorSetter(JSGlobalObject& lexicalGlobalObject, JSMediaControlsHost& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setControlsDependOnPageScaleFactor(WTFMove(nativeValue));
    });
    return true;
}

bool setJSMediaControlsHostControlsDependOnPageScaleFactor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSMediaControlsHost>::set<setJSMediaControlsHostControlsDependOnPageScaleFactorSetter>(*lexicalGlobalObject, thisValue, encodedValue, "controlsDependOnPageScaleFactor");
}

static inline JSValue jsMediaControlsHostShadowRootCSSTextGetter(JSGlobalObject& lexicalGlobalObject, JSMediaControlsHost& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.shadowRootCSSText());
    return result;
}

EncodedJSValue jsMediaControlsHostShadowRootCSSText(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaControlsHost>::get<jsMediaControlsHostShadowRootCSSTextGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "shadowRootCSSText");
}

static inline JSC::EncodedJSValue jsMediaControlsHostPrototypeFunctionSortedTrackListForMenu1Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaControlsHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto trackList = convert<IDLInterface<TextTrackList>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "trackList", "MediaControlsHost", "sortedTrackListForMenu", "TextTrackList"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLSequence<IDLInterface<TextTrack>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.sortedTrackListForMenu(*trackList)));
}

static inline JSC::EncodedJSValue jsMediaControlsHostPrototypeFunctionSortedTrackListForMenu2Body(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaControlsHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto trackList = convert<IDLInterface<AudioTrackList>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "trackList", "MediaControlsHost", "sortedTrackListForMenu", "AudioTrackList"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLSequence<IDLInterface<AudioTrack>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.sortedTrackListForMenu(*trackList)));
}

static inline JSC::EncodedJSValue jsMediaControlsHostPrototypeFunctionSortedTrackListForMenuOverloadDispatcher(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaControlsHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    VM& vm = JSC::getVM(lexicalGlobalObject);
    UNUSED_PARAM(vm);
    size_t argsCount = std::min<size_t>(1, callFrame->argumentCount());
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSTextTrackList>(vm))
            return jsMediaControlsHostPrototypeFunctionSortedTrackListForMenu1Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSAudioTrackList>(vm))
            return jsMediaControlsHostPrototypeFunctionSortedTrackListForMenu2Body(lexicalGlobalObject, callFrame, castedThis, throwScope);
    }
    return argsCount < 1 ? throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject)) : throwVMTypeError(lexicalGlobalObject, throwScope);
}

EncodedJSValue JSC_HOST_CALL jsMediaControlsHostPrototypeFunctionSortedTrackListForMenu(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMediaControlsHost>::call<jsMediaControlsHostPrototypeFunctionSortedTrackListForMenuOverloadDispatcher>(*lexicalGlobalObject, *callFrame, "sortedTrackListForMenu");
}

static inline JSC::EncodedJSValue jsMediaControlsHostPrototypeFunctionDisplayNameForTrackBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaControlsHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto track = convert<IDLNullable<IDLUnion<IDLInterface<TextTrack>, IDLInterface<AudioTrack>>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.displayNameForTrack(WTFMove(track))));
}

EncodedJSValue JSC_HOST_CALL jsMediaControlsHostPrototypeFunctionDisplayNameForTrack(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMediaControlsHost>::call<jsMediaControlsHostPrototypeFunctionDisplayNameForTrackBody>(*lexicalGlobalObject, *callFrame, "displayNameForTrack");
}

static inline JSC::EncodedJSValue jsMediaControlsHostPrototypeFunctionSetSelectedTextTrackBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaControlsHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto track = convert<IDLNullable<IDLInterface<TextTrack>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "track", "MediaControlsHost", "setSelectedTextTrack", "TextTrack"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setSelectedTextTrack(WTFMove(track));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMediaControlsHostPrototypeFunctionSetSelectedTextTrack(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMediaControlsHost>::call<jsMediaControlsHostPrototypeFunctionSetSelectedTextTrackBody>(*lexicalGlobalObject, *callFrame, "setSelectedTextTrack");
}

static inline JSC::EncodedJSValue jsMediaControlsHostPrototypeFunctionSetPreparedToReturnVideoLayerToInlineBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaControlsHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto prepared = convert<IDLBoolean>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setPreparedToReturnVideoLayerToInline(WTFMove(prepared));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMediaControlsHostPrototypeFunctionSetPreparedToReturnVideoLayerToInline(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMediaControlsHost>::call<jsMediaControlsHostPrototypeFunctionSetPreparedToReturnVideoLayerToInlineBody>(*lexicalGlobalObject, *callFrame, "setPreparedToReturnVideoLayerToInline");
}

static inline JSC::EncodedJSValue jsMediaControlsHostPrototypeFunctionUpdateTextTrackContainerBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaControlsHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.updateTextTrackContainer();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMediaControlsHostPrototypeFunctionUpdateTextTrackContainer(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMediaControlsHost>::call<jsMediaControlsHostPrototypeFunctionUpdateTextTrackContainerBody>(*lexicalGlobalObject, *callFrame, "updateTextTrackContainer");
}

static inline JSC::EncodedJSValue jsMediaControlsHostPrototypeFunctionEnteredFullscreenBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaControlsHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.enteredFullscreen();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMediaControlsHostPrototypeFunctionEnteredFullscreen(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMediaControlsHost>::call<jsMediaControlsHostPrototypeFunctionEnteredFullscreenBody>(*lexicalGlobalObject, *callFrame, "enteredFullscreen");
}

static inline JSC::EncodedJSValue jsMediaControlsHostPrototypeFunctionExitedFullscreenBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaControlsHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.exitedFullscreen();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMediaControlsHostPrototypeFunctionExitedFullscreen(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMediaControlsHost>::call<jsMediaControlsHostPrototypeFunctionExitedFullscreenBody>(*lexicalGlobalObject, *callFrame, "exitedFullscreen");
}

static inline JSC::EncodedJSValue jsMediaControlsHostPrototypeFunctionGenerateUUIDBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaControlsHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.generateUUID()));
}

EncodedJSValue JSC_HOST_CALL jsMediaControlsHostPrototypeFunctionGenerateUUID(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMediaControlsHost>::call<jsMediaControlsHostPrototypeFunctionGenerateUUIDBody>(*lexicalGlobalObject, *callFrame, "generateUUID");
}

static inline JSC::EncodedJSValue jsMediaControlsHostPrototypeFunctionBase64StringForIconNameAndTypeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaControlsHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto iconName = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto iconType = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.base64StringForIconNameAndType(WTFMove(iconName), WTFMove(iconType))));
}

EncodedJSValue JSC_HOST_CALL jsMediaControlsHostPrototypeFunctionBase64StringForIconNameAndType(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMediaControlsHost>::call<jsMediaControlsHostPrototypeFunctionBase64StringForIconNameAndTypeBody>(*lexicalGlobalObject, *callFrame, "base64StringForIconNameAndType");
}

static inline JSC::EncodedJSValue jsMediaControlsHostPrototypeFunctionFormattedStringForDurationBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaControlsHost>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto durationInSeconds = convert<IDLUnrestrictedDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLDOMString>(*lexicalGlobalObject, impl.formattedStringForDuration(WTFMove(durationInSeconds))));
}

EncodedJSValue JSC_HOST_CALL jsMediaControlsHostPrototypeFunctionFormattedStringForDuration(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMediaControlsHost>::call<jsMediaControlsHostPrototypeFunctionFormattedStringForDurationBody>(*lexicalGlobalObject, *callFrame, "formattedStringForDuration");
}

void JSMediaControlsHost::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSMediaControlsHost*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSMediaControlsHostOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSMediaControlsHostOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsMediaControlsHost = static_cast<JSMediaControlsHost*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsMediaControlsHost->wrapped(), jsMediaControlsHost);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<MediaControlsHost>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to MediaControlsHost.
    static_assert(!std::is_polymorphic<MediaControlsHost>::value, "MediaControlsHost is polymorphic but the IDL claims it is not");
    return createWrapper<MediaControlsHost>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, MediaControlsHost& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

MediaControlsHost* JSMediaControlsHost::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSMediaControlsHost*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(MEDIA_CONTROLS_SCRIPT)
