/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_STREAM)

#include "JSMediaDeviceInfo.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(MediaDeviceInfo::Kind enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("audioinput"),
        MAKE_STATIC_STRING_IMPL("audiooutput"),
        MAKE_STATIC_STRING_IMPL("videoinput"),
    };
    static_assert(static_cast<size_t>(MediaDeviceInfo::Kind::Audioinput) == 0, "MediaDeviceInfo::Kind::Audioinput is not 0 as expected");
    static_assert(static_cast<size_t>(MediaDeviceInfo::Kind::Audiooutput) == 1, "MediaDeviceInfo::Kind::Audiooutput is not 1 as expected");
    static_assert(static_cast<size_t>(MediaDeviceInfo::Kind::Videoinput) == 2, "MediaDeviceInfo::Kind::Videoinput is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, MediaDeviceInfo::Kind enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<MediaDeviceInfo::Kind> parseEnumeration<MediaDeviceInfo::Kind>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "audioinput")
        return MediaDeviceInfo::Kind::Audioinput;
    if (stringValue == "audiooutput")
        return MediaDeviceInfo::Kind::Audiooutput;
    if (stringValue == "videoinput")
        return MediaDeviceInfo::Kind::Videoinput;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<MediaDeviceInfo::Kind>()
{
    return "\"audioinput\", \"audiooutput\", \"videoinput\"";
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsMediaDeviceInfoPrototypeFunctionToJSON(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsMediaDeviceInfoConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMediaDeviceInfoConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMediaDeviceInfoDeviceId(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaDeviceInfoKind(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaDeviceInfoLabel(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaDeviceInfoGroupId(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSMediaDeviceInfoPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSMediaDeviceInfoPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMediaDeviceInfoPrototype* ptr = new (NotNull, JSC::allocateCell<JSMediaDeviceInfoPrototype>(vm.heap)) JSMediaDeviceInfoPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMediaDeviceInfoPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMediaDeviceInfoPrototype, JSMediaDeviceInfoPrototype::Base);

using JSMediaDeviceInfoConstructor = JSDOMConstructorNotConstructable<JSMediaDeviceInfo>;

template<> JSValue JSMediaDeviceInfoConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSMediaDeviceInfoConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSMediaDeviceInfo::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("MediaDeviceInfo"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSMediaDeviceInfoConstructor::s_info = { "MediaDeviceInfo", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaDeviceInfoConstructor) };

/* Hash table for prototype */

static const HashTableValue JSMediaDeviceInfoPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaDeviceInfoConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaDeviceInfoConstructor) } },
    { "deviceId", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaDeviceInfoDeviceId), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "kind", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaDeviceInfoKind), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "label", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaDeviceInfoLabel), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "groupId", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaDeviceInfoGroupId), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "toJSON", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMediaDeviceInfoPrototypeFunctionToJSON), (intptr_t) (0) } },
};

const ClassInfo JSMediaDeviceInfoPrototype::s_info = { "MediaDeviceInfoPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaDeviceInfoPrototype) };

void JSMediaDeviceInfoPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMediaDeviceInfo::info(), JSMediaDeviceInfoPrototypeTableValues, *this);
}

const ClassInfo JSMediaDeviceInfo::s_info = { "MediaDeviceInfo", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaDeviceInfo) };

JSMediaDeviceInfo::JSMediaDeviceInfo(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MediaDeviceInfo>&& impl)
    : JSDOMWrapper<MediaDeviceInfo>(structure, globalObject, WTFMove(impl))
{
}

void JSMediaDeviceInfo::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, MediaDeviceInfo>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSMediaDeviceInfo::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSMediaDeviceInfoPrototype::create(vm, &globalObject, JSMediaDeviceInfoPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSMediaDeviceInfo::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSMediaDeviceInfo>(vm, globalObject);
}

JSValue JSMediaDeviceInfo::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaDeviceInfoConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSMediaDeviceInfo::destroy(JSC::JSCell* cell)
{
    JSMediaDeviceInfo* thisObject = static_cast<JSMediaDeviceInfo*>(cell);
    thisObject->JSMediaDeviceInfo::~JSMediaDeviceInfo();
}

template<> inline JSMediaDeviceInfo* IDLAttribute<JSMediaDeviceInfo>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSMediaDeviceInfo*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSMediaDeviceInfo* IDLOperation<JSMediaDeviceInfo>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSMediaDeviceInfo*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsMediaDeviceInfoConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMediaDeviceInfoPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSMediaDeviceInfo::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSMediaDeviceInfoConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMediaDeviceInfoPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsMediaDeviceInfoDeviceIdGetter(JSGlobalObject& lexicalGlobalObject, JSMediaDeviceInfo& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.deviceId());
    return result;
}

EncodedJSValue jsMediaDeviceInfoDeviceId(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaDeviceInfo>::get<jsMediaDeviceInfoDeviceIdGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "deviceId");
}

static inline JSValue jsMediaDeviceInfoKindGetter(JSGlobalObject& lexicalGlobalObject, JSMediaDeviceInfo& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<MediaDeviceInfo::Kind>>(lexicalGlobalObject, throwScope, impl.kind());
    return result;
}

EncodedJSValue jsMediaDeviceInfoKind(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaDeviceInfo>::get<jsMediaDeviceInfoKindGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "kind");
}

static inline JSValue jsMediaDeviceInfoLabelGetter(JSGlobalObject& lexicalGlobalObject, JSMediaDeviceInfo& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.label());
    return result;
}

EncodedJSValue jsMediaDeviceInfoLabel(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaDeviceInfo>::get<jsMediaDeviceInfoLabelGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "label");
}

static inline JSValue jsMediaDeviceInfoGroupIdGetter(JSGlobalObject& lexicalGlobalObject, JSMediaDeviceInfo& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.groupId());
    return result;
}

EncodedJSValue jsMediaDeviceInfoGroupId(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaDeviceInfo>::get<jsMediaDeviceInfoGroupIdGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "groupId");
}

JSC::JSObject* JSMediaDeviceInfo::serialize(JSGlobalObject& lexicalGlobalObject, JSMediaDeviceInfo& thisObject, JSDOMGlobalObject& globalObject, ThrowScope& throwScope)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto* result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto deviceIdValue = jsMediaDeviceInfoDeviceIdGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "deviceId"), deviceIdValue);

    auto kindValue = jsMediaDeviceInfoKindGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "kind"), kindValue);

    auto labelValue = jsMediaDeviceInfoLabelGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "label"), labelValue);

    auto groupIdValue = jsMediaDeviceInfoGroupIdGetter(lexicalGlobalObject, thisObject, throwScope);
    throwScope.assertNoException();
    result->putDirect(vm, Identifier::fromString(vm, "groupId"), groupIdValue);

    return result;
}

static inline EncodedJSValue jsMediaDeviceInfoPrototypeFunctionToJSONBody(JSGlobalObject* lexicalGlobalObject, CallFrame*, JSMediaDeviceInfo* thisObject, JSC::ThrowScope& throwScope)
{
    return JSValue::encode(JSMediaDeviceInfo::serialize(*lexicalGlobalObject, *thisObject, *thisObject->globalObject(), throwScope));
}

EncodedJSValue JSC_HOST_CALL jsMediaDeviceInfoPrototypeFunctionToJSON(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMediaDeviceInfo>::call<jsMediaDeviceInfoPrototypeFunctionToJSONBody>(*lexicalGlobalObject, *callFrame, "toJSON");
}

void JSMediaDeviceInfo::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSMediaDeviceInfo*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSMediaDeviceInfoOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSMediaDeviceInfoOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsMediaDeviceInfo = static_cast<JSMediaDeviceInfo*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsMediaDeviceInfo->wrapped(), jsMediaDeviceInfo);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<MediaDeviceInfo>&& impl)
{
    return createWrapper<MediaDeviceInfo>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, MediaDeviceInfo& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

MediaDeviceInfo* JSMediaDeviceInfo::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSMediaDeviceInfo*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(MEDIA_STREAM)
