/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_STREAM)

#include "JSMediaDevices.h"

#include "ActiveDOMObject.h"
#include "EventNames.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertUnion.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "JSMediaTrackConstraints.h"
#include "JSMediaTrackSupportedConstraints.h"
#include "RuntimeEnabledFeatures.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/Variant.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(MEDIA_STREAM)

String convertEnumerationToString(MediaDevices::DisplayCaptureSurfaceType enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("monitor"),
        MAKE_STATIC_STRING_IMPL("window"),
        MAKE_STATIC_STRING_IMPL("application"),
        MAKE_STATIC_STRING_IMPL("browser"),
    };
    static_assert(static_cast<size_t>(MediaDevices::DisplayCaptureSurfaceType::Monitor) == 0, "MediaDevices::DisplayCaptureSurfaceType::Monitor is not 0 as expected");
    static_assert(static_cast<size_t>(MediaDevices::DisplayCaptureSurfaceType::Window) == 1, "MediaDevices::DisplayCaptureSurfaceType::Window is not 1 as expected");
    static_assert(static_cast<size_t>(MediaDevices::DisplayCaptureSurfaceType::Application) == 2, "MediaDevices::DisplayCaptureSurfaceType::Application is not 2 as expected");
    static_assert(static_cast<size_t>(MediaDevices::DisplayCaptureSurfaceType::Browser) == 3, "MediaDevices::DisplayCaptureSurfaceType::Browser is not 3 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, MediaDevices::DisplayCaptureSurfaceType enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<MediaDevices::DisplayCaptureSurfaceType> parseEnumeration<MediaDevices::DisplayCaptureSurfaceType>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "monitor")
        return MediaDevices::DisplayCaptureSurfaceType::Monitor;
    if (stringValue == "window")
        return MediaDevices::DisplayCaptureSurfaceType::Window;
    if (stringValue == "application")
        return MediaDevices::DisplayCaptureSurfaceType::Application;
    if (stringValue == "browser")
        return MediaDevices::DisplayCaptureSurfaceType::Browser;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<MediaDevices::DisplayCaptureSurfaceType>()
{
    return "\"monitor\", \"window\", \"application\", \"browser\"";
}

#endif

#if ENABLE(MEDIA_STREAM)

template<> MediaDevices::StreamConstraints convertDictionary<MediaDevices::StreamConstraints>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    MediaDevices::StreamConstraints result;
    JSValue audioValue;
    if (isNullOrUndefined)
        audioValue = jsUndefined();
    else {
        audioValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "audio"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!audioValue.isUndefined()) {
        result.audio = convert<IDLUnion<IDLBoolean, IDLDictionary<MediaTrackConstraints>>>(lexicalGlobalObject, audioValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.audio = false;
    JSValue videoValue;
    if (isNullOrUndefined)
        videoValue = jsUndefined();
    else {
        videoValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "video"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!videoValue.isUndefined()) {
        result.video = convert<IDLUnion<IDLBoolean, IDLDictionary<MediaTrackConstraints>>>(lexicalGlobalObject, videoValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.video = false;
    return result;
}

#endif

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsMediaDevicesPrototypeFunctionEnumerateDevices(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaDevicesPrototypeFunctionGetSupportedConstraints(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaDevicesPrototypeFunctionGetUserMedia(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaDevicesPrototypeFunctionGetDisplayMedia(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsMediaDevicesConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMediaDevicesConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMediaDevicesOndevicechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMediaDevicesOndevicechange(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSMediaDevicesPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSMediaDevicesPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMediaDevicesPrototype* ptr = new (NotNull, JSC::allocateCell<JSMediaDevicesPrototype>(vm.heap)) JSMediaDevicesPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMediaDevicesPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMediaDevicesPrototype, JSMediaDevicesPrototype::Base);

using JSMediaDevicesConstructor = JSDOMConstructorNotConstructable<JSMediaDevices>;

template<> JSValue JSMediaDevicesConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSMediaDevicesConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSMediaDevices::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("MediaDevices"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSMediaDevicesConstructor::s_info = { "MediaDevices", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaDevicesConstructor) };

/* Hash table for prototype */

static const HashTableValue JSMediaDevicesPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaDevicesConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaDevicesConstructor) } },
    { "ondevicechange", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaDevicesOndevicechange), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaDevicesOndevicechange) } },
    { "enumerateDevices", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMediaDevicesPrototypeFunctionEnumerateDevices), (intptr_t) (0) } },
    { "getSupportedConstraints", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMediaDevicesPrototypeFunctionGetSupportedConstraints), (intptr_t) (0) } },
    { "getUserMedia", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMediaDevicesPrototypeFunctionGetUserMedia), (intptr_t) (0) } },
    { "getDisplayMedia", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMediaDevicesPrototypeFunctionGetDisplayMedia), (intptr_t) (0) } },
};

const ClassInfo JSMediaDevicesPrototype::s_info = { "MediaDevicesPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaDevicesPrototype) };

void JSMediaDevicesPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMediaDevices::info(), JSMediaDevicesPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!RuntimeEnabledFeatures::sharedFeatures().screenCaptureEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, reinterpret_cast<const LChar*>("getDisplayMedia"), strlen("getDisplayMedia"));
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        JSObject::deleteProperty(this, globalObject(), propertyName);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    putDirect(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().getUserMediaPrivateName(), JSFunction::create(vm, globalObject(), 0, String(), jsMediaDevicesPrototypeFunctionGetUserMedia), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

const ClassInfo JSMediaDevices::s_info = { "MediaDevices", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaDevices) };

JSMediaDevices::JSMediaDevices(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MediaDevices>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

void JSMediaDevices::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(std::is_base_of<ActiveDOMObject, MediaDevices>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

}

JSObject* JSMediaDevices::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSMediaDevicesPrototype::create(vm, &globalObject, JSMediaDevicesPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject)));
}

JSObject* JSMediaDevices::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSMediaDevices>(vm, globalObject);
}

JSValue JSMediaDevices::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaDevicesConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSMediaDevices* IDLAttribute<JSMediaDevices>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSMediaDevices*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSMediaDevices* IDLOperation<JSMediaDevices>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSMediaDevices*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsMediaDevicesConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMediaDevicesPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSMediaDevices::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSMediaDevicesConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMediaDevicesPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsMediaDevicesOndevicechangeGetter(JSGlobalObject& lexicalGlobalObject, JSMediaDevices& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().devicechangeEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsMediaDevicesOndevicechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaDevices>::get<jsMediaDevicesOndevicechangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "ondevicechange");
}

static inline bool setJSMediaDevicesOndevicechangeSetter(JSGlobalObject& lexicalGlobalObject, JSMediaDevices& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().devicechangeEvent, value);
    return true;
}

bool setJSMediaDevicesOndevicechange(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSMediaDevices>::set<setJSMediaDevicesOndevicechangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, "ondevicechange");
}

static inline JSC::EncodedJSValue jsMediaDevicesPrototypeFunctionEnumerateDevicesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSMediaDevices>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.enumerateDevices(WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMediaDevicesPrototypeFunctionEnumerateDevices(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSMediaDevices>::call<jsMediaDevicesPrototypeFunctionEnumerateDevicesBody>(*lexicalGlobalObject, *callFrame, "enumerateDevices");
}

static inline JSC::EncodedJSValue jsMediaDevicesPrototypeFunctionGetSupportedConstraintsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaDevices>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLDictionary<MediaTrackSupportedConstraints>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getSupportedConstraints()));
}

EncodedJSValue JSC_HOST_CALL jsMediaDevicesPrototypeFunctionGetSupportedConstraints(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMediaDevices>::call<jsMediaDevicesPrototypeFunctionGetSupportedConstraintsBody>(*lexicalGlobalObject, *callFrame, "getSupportedConstraints");
}

static inline JSC::EncodedJSValue jsMediaDevicesPrototypeFunctionGetUserMediaBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSMediaDevices>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto constraints = convert<IDLDictionary<MediaDevices::StreamConstraints>>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.getUserMedia(WTFMove(constraints), WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMediaDevicesPrototypeFunctionGetUserMedia(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSMediaDevices>::call<jsMediaDevicesPrototypeFunctionGetUserMediaBody>(*lexicalGlobalObject, *callFrame, "getUserMedia");
}

static inline JSC::EncodedJSValue jsMediaDevicesPrototypeFunctionGetDisplayMediaBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSMediaDevices>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto constraints = convert<IDLDictionary<MediaDevices::StreamConstraints>>(*lexicalGlobalObject, callFrame->argument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.getDisplayMedia(WTFMove(constraints), WTFMove(promise));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMediaDevicesPrototypeFunctionGetDisplayMedia(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperationReturningPromise<JSMediaDevices>::call<jsMediaDevicesPrototypeFunctionGetDisplayMediaBody>(*lexicalGlobalObject, *callFrame, "getDisplayMedia");
}

void JSMediaDevices::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSMediaDevices*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSMediaDevicesOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsMediaDevices = jsCast<JSMediaDevices*>(handle.slot()->asCell());
    if (jsMediaDevices->wrapped().hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    if (jsMediaDevices->wrapped().isFiringEventListeners()) {
        if (UNLIKELY(reason))
            *reason = "EventTarget firing event listeners";
        return true;
    }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSMediaDevicesOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsMediaDevices = static_cast<JSMediaDevices*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsMediaDevices->wrapped(), jsMediaDevices);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7MediaDevices@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore12MediaDevicesE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<MediaDevices>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7MediaDevices@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore12MediaDevicesE[2];
#endif

    // If this fails MediaDevices does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<MediaDevices>::value, "MediaDevices is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // MediaDevices has subclasses. If MediaDevices has subclasses that get passed
    // to toJS() we currently require MediaDevices you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<MediaDevices>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, MediaDevices& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

MediaDevices* JSMediaDevices::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSMediaDevices*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(MEDIA_STREAM)
