/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO) && ENABLE(WEB_AUDIO)

#include "JSMediaElementAudioSourceNode.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMWrapperCache.h"
#include "JSHTMLMediaElement.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsMediaElementAudioSourceNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMediaElementAudioSourceNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMediaElementAudioSourceNodeMediaElement(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSMediaElementAudioSourceNodePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSMediaElementAudioSourceNodePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMediaElementAudioSourceNodePrototype* ptr = new (NotNull, JSC::allocateCell<JSMediaElementAudioSourceNodePrototype>(vm.heap)) JSMediaElementAudioSourceNodePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMediaElementAudioSourceNodePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMediaElementAudioSourceNodePrototype, JSMediaElementAudioSourceNodePrototype::Base);

using JSMediaElementAudioSourceNodeConstructor = JSDOMConstructorNotConstructable<JSMediaElementAudioSourceNode>;

template<> JSValue JSMediaElementAudioSourceNodeConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSAudioNode::getConstructor(vm, &globalObject);
}

template<> void JSMediaElementAudioSourceNodeConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSMediaElementAudioSourceNode::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("MediaElementAudioSourceNode"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSMediaElementAudioSourceNodeConstructor::s_info = { "MediaElementAudioSourceNode", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaElementAudioSourceNodeConstructor) };

/* Hash table for prototype */

static const HashTableValue JSMediaElementAudioSourceNodePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaElementAudioSourceNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaElementAudioSourceNodeConstructor) } },
    { "mediaElement", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaElementAudioSourceNodeMediaElement), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSMediaElementAudioSourceNodePrototype::s_info = { "MediaElementAudioSourceNodePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaElementAudioSourceNodePrototype) };

void JSMediaElementAudioSourceNodePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMediaElementAudioSourceNode::info(), JSMediaElementAudioSourceNodePrototypeTableValues, *this);
}

const ClassInfo JSMediaElementAudioSourceNode::s_info = { "MediaElementAudioSourceNode", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaElementAudioSourceNode) };

JSMediaElementAudioSourceNode::JSMediaElementAudioSourceNode(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MediaElementAudioSourceNode>&& impl)
    : JSAudioNode(structure, globalObject, WTFMove(impl))
{
}

void JSMediaElementAudioSourceNode::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, MediaElementAudioSourceNode>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSMediaElementAudioSourceNode::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSMediaElementAudioSourceNodePrototype::create(vm, &globalObject, JSMediaElementAudioSourceNodePrototype::createStructure(vm, &globalObject, JSAudioNode::prototype(vm, globalObject)));
}

JSObject* JSMediaElementAudioSourceNode::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSMediaElementAudioSourceNode>(vm, globalObject);
}

JSValue JSMediaElementAudioSourceNode::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaElementAudioSourceNodeConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSMediaElementAudioSourceNode* IDLAttribute<JSMediaElementAudioSourceNode>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSMediaElementAudioSourceNode*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsMediaElementAudioSourceNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMediaElementAudioSourceNodePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSMediaElementAudioSourceNode::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSMediaElementAudioSourceNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMediaElementAudioSourceNodePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsMediaElementAudioSourceNodeMediaElementGetter(JSGlobalObject& lexicalGlobalObject, JSMediaElementAudioSourceNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<HTMLMediaElement>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.mediaElement());
    return result;
}

EncodedJSValue jsMediaElementAudioSourceNodeMediaElement(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaElementAudioSourceNode>::get<jsMediaElementAudioSourceNodeMediaElementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "mediaElement");
}

void JSMediaElementAudioSourceNode::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSMediaElementAudioSourceNode*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7MediaElementAudioSourceNode@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore27MediaElementAudioSourceNodeE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<MediaElementAudioSourceNode>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7MediaElementAudioSourceNode@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore27MediaElementAudioSourceNodeE[2];
#endif

    // If this fails MediaElementAudioSourceNode does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<MediaElementAudioSourceNode>::value, "MediaElementAudioSourceNode is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // MediaElementAudioSourceNode has subclasses. If MediaElementAudioSourceNode has subclasses that get passed
    // to toJS() we currently require MediaElementAudioSourceNode you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<MediaElementAudioSourceNode>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, MediaElementAudioSourceNode& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}

#endif // ENABLE(VIDEO) && ENABLE(WEB_AUDIO)
