/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_SESSION)

#include "JSMediaRemoteControls.h"

#include "ActiveDOMObject.h"
#include "EventNames.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsMediaRemoteControlsConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMediaRemoteControlsConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMediaRemoteControlsPreviousTrackEnabled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMediaRemoteControlsPreviousTrackEnabled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMediaRemoteControlsNextTrackEnabled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMediaRemoteControlsNextTrackEnabled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMediaRemoteControlsOnprevioustrack(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMediaRemoteControlsOnprevioustrack(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMediaRemoteControlsOnnexttrack(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMediaRemoteControlsOnnexttrack(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSMediaRemoteControlsPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSMediaRemoteControlsPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMediaRemoteControlsPrototype* ptr = new (NotNull, JSC::allocateCell<JSMediaRemoteControlsPrototype>(vm.heap)) JSMediaRemoteControlsPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMediaRemoteControlsPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMediaRemoteControlsPrototype, JSMediaRemoteControlsPrototype::Base);

using JSMediaRemoteControlsConstructor = JSDOMConstructor<JSMediaRemoteControls>;

template<> EncodedJSValue JSC_HOST_CALL JSMediaRemoteControlsConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSMediaRemoteControlsConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "MediaRemoteControls");
    auto object = MediaRemoteControls::create(*context);
    return JSValue::encode(toJSNewlyCreated<IDLInterface<MediaRemoteControls>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSMediaRemoteControlsConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSMediaRemoteControlsConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSMediaRemoteControls::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("MediaRemoteControls"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSMediaRemoteControlsConstructor::s_info = { "MediaRemoteControls", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaRemoteControlsConstructor) };

/* Hash table for prototype */

static const HashTableValue JSMediaRemoteControlsPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaRemoteControlsConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaRemoteControlsConstructor) } },
    { "previousTrackEnabled", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaRemoteControlsPreviousTrackEnabled), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaRemoteControlsPreviousTrackEnabled) } },
    { "nextTrackEnabled", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaRemoteControlsNextTrackEnabled), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaRemoteControlsNextTrackEnabled) } },
    { "onprevioustrack", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaRemoteControlsOnprevioustrack), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaRemoteControlsOnprevioustrack) } },
    { "onnexttrack", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaRemoteControlsOnnexttrack), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaRemoteControlsOnnexttrack) } },
};

const ClassInfo JSMediaRemoteControlsPrototype::s_info = { "MediaRemoteControlsPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaRemoteControlsPrototype) };

void JSMediaRemoteControlsPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMediaRemoteControls::info(), JSMediaRemoteControlsPrototypeTableValues, *this);
}

const ClassInfo JSMediaRemoteControls::s_info = { "MediaRemoteControls", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaRemoteControls) };

JSMediaRemoteControls::JSMediaRemoteControls(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MediaRemoteControls>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

void JSMediaRemoteControls::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, MediaRemoteControls>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSMediaRemoteControls::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSMediaRemoteControlsPrototype::create(vm, &globalObject, JSMediaRemoteControlsPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject)));
}

JSObject* JSMediaRemoteControls::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSMediaRemoteControls>(vm, globalObject);
}

JSValue JSMediaRemoteControls::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaRemoteControlsConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSMediaRemoteControls* IDLAttribute<JSMediaRemoteControls>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSMediaRemoteControls*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsMediaRemoteControlsConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMediaRemoteControlsPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSMediaRemoteControls::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSMediaRemoteControlsConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMediaRemoteControlsPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsMediaRemoteControlsPreviousTrackEnabledGetter(JSGlobalObject& lexicalGlobalObject, JSMediaRemoteControls& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.previousTrackEnabled());
    return result;
}

EncodedJSValue jsMediaRemoteControlsPreviousTrackEnabled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaRemoteControls>::get<jsMediaRemoteControlsPreviousTrackEnabledGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "previousTrackEnabled");
}

static inline bool setJSMediaRemoteControlsPreviousTrackEnabledSetter(JSGlobalObject& lexicalGlobalObject, JSMediaRemoteControls& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setPreviousTrackEnabled(WTFMove(nativeValue));
    });
    return true;
}

bool setJSMediaRemoteControlsPreviousTrackEnabled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSMediaRemoteControls>::set<setJSMediaRemoteControlsPreviousTrackEnabledSetter>(*lexicalGlobalObject, thisValue, encodedValue, "previousTrackEnabled");
}

static inline JSValue jsMediaRemoteControlsNextTrackEnabledGetter(JSGlobalObject& lexicalGlobalObject, JSMediaRemoteControls& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.nextTrackEnabled());
    return result;
}

EncodedJSValue jsMediaRemoteControlsNextTrackEnabled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaRemoteControls>::get<jsMediaRemoteControlsNextTrackEnabledGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "nextTrackEnabled");
}

static inline bool setJSMediaRemoteControlsNextTrackEnabledSetter(JSGlobalObject& lexicalGlobalObject, JSMediaRemoteControls& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setNextTrackEnabled(WTFMove(nativeValue));
    });
    return true;
}

bool setJSMediaRemoteControlsNextTrackEnabled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSMediaRemoteControls>::set<setJSMediaRemoteControlsNextTrackEnabledSetter>(*lexicalGlobalObject, thisValue, encodedValue, "nextTrackEnabled");
}

static inline JSValue jsMediaRemoteControlsOnprevioustrackGetter(JSGlobalObject& lexicalGlobalObject, JSMediaRemoteControls& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().previoustrackEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsMediaRemoteControlsOnprevioustrack(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaRemoteControls>::get<jsMediaRemoteControlsOnprevioustrackGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onprevioustrack");
}

static inline bool setJSMediaRemoteControlsOnprevioustrackSetter(JSGlobalObject& lexicalGlobalObject, JSMediaRemoteControls& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().previoustrackEvent, value);
    return true;
}

bool setJSMediaRemoteControlsOnprevioustrack(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSMediaRemoteControls>::set<setJSMediaRemoteControlsOnprevioustrackSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onprevioustrack");
}

static inline JSValue jsMediaRemoteControlsOnnexttrackGetter(JSGlobalObject& lexicalGlobalObject, JSMediaRemoteControls& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().nexttrackEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsMediaRemoteControlsOnnexttrack(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaRemoteControls>::get<jsMediaRemoteControlsOnnexttrackGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onnexttrack");
}

static inline bool setJSMediaRemoteControlsOnnexttrackSetter(JSGlobalObject& lexicalGlobalObject, JSMediaRemoteControls& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().nexttrackEvent, value);
    return true;
}

bool setJSMediaRemoteControlsOnnexttrack(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSMediaRemoteControls>::set<setJSMediaRemoteControlsOnnexttrackSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onnexttrack");
}

void JSMediaRemoteControls::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSMediaRemoteControls*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7MediaRemoteControls@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore19MediaRemoteControlsE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<MediaRemoteControls>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7MediaRemoteControls@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore19MediaRemoteControlsE[2];
#endif

    // If this fails MediaRemoteControls does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<MediaRemoteControls>::value, "MediaRemoteControls is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // MediaRemoteControls has subclasses. If MediaRemoteControls has subclasses that get passed
    // to toJS() we currently require MediaRemoteControls you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<MediaRemoteControls>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, MediaRemoteControls& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

MediaRemoteControls* JSMediaRemoteControls::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSMediaRemoteControls*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(MEDIA_SESSION)
