/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_SESSION)

#include "JSMediaSession.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSMediaRemoteControls.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(MediaSession::Kind enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("content"),
        MAKE_STATIC_STRING_IMPL("transient"),
        MAKE_STATIC_STRING_IMPL("transient-solo"),
        MAKE_STATIC_STRING_IMPL("ambient"),
    };
    static_assert(static_cast<size_t>(MediaSession::Kind::Content) == 0, "MediaSession::Kind::Content is not 0 as expected");
    static_assert(static_cast<size_t>(MediaSession::Kind::Transient) == 1, "MediaSession::Kind::Transient is not 1 as expected");
    static_assert(static_cast<size_t>(MediaSession::Kind::TransientSolo) == 2, "MediaSession::Kind::TransientSolo is not 2 as expected");
    static_assert(static_cast<size_t>(MediaSession::Kind::Ambient) == 3, "MediaSession::Kind::Ambient is not 3 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, MediaSession::Kind enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<MediaSession::Kind> parseEnumeration<MediaSession::Kind>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "content")
        return MediaSession::Kind::Content;
    if (stringValue == "transient")
        return MediaSession::Kind::Transient;
    if (stringValue == "transient-solo")
        return MediaSession::Kind::TransientSolo;
    if (stringValue == "ambient")
        return MediaSession::Kind::Ambient;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<MediaSession::Kind>()
{
    return "\"content\", \"transient\", \"transient-solo\", \"ambient\"";
}

template<> MediaSession::Metadata convertDictionary<MediaSession::Metadata>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    MediaSession::Metadata result;
    JSValue albumValue;
    if (isNullOrUndefined)
        albumValue = jsUndefined();
    else {
        albumValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "album"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!albumValue.isUndefined()) {
        result.album = convert<IDLDOMString>(lexicalGlobalObject, albumValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue artistValue;
    if (isNullOrUndefined)
        artistValue = jsUndefined();
    else {
        artistValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "artist"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!artistValue.isUndefined()) {
        result.artist = convert<IDLDOMString>(lexicalGlobalObject, artistValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue artworkValue;
    if (isNullOrUndefined)
        artworkValue = jsUndefined();
    else {
        artworkValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "artwork"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!artworkValue.isUndefined()) {
        result.artwork = convert<IDLUSVString>(lexicalGlobalObject, artworkValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue titleValue;
    if (isNullOrUndefined)
        titleValue = jsUndefined();
    else {
        titleValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "title"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!titleValue.isUndefined()) {
        result.title = convert<IDLDOMString>(lexicalGlobalObject, titleValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsMediaSessionPrototypeFunctionSetMetadata(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaSessionPrototypeFunctionDeactivate(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsMediaSessionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMediaSessionConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMediaSessionKind(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaSessionControls(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSMediaSessionPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSMediaSessionPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMediaSessionPrototype* ptr = new (NotNull, JSC::allocateCell<JSMediaSessionPrototype>(vm.heap)) JSMediaSessionPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMediaSessionPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMediaSessionPrototype, JSMediaSessionPrototype::Base);

using JSMediaSessionConstructor = JSDOMConstructor<JSMediaSession>;

template<> JSC::EncodedJSValue JSC_HOST_CALL JSMediaSessionConstructor::construct(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame)
{
    ASSERT(callFrame);
    return constructJSMediaSession(lexicalGlobalObject, *callFrame);
}

template<> JSValue JSMediaSessionConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSMediaSessionConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSMediaSession::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("MediaSession"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSMediaSessionConstructor::s_info = { "MediaSession", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaSessionConstructor) };

/* Hash table for prototype */

static const HashTableValue JSMediaSessionPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaSessionConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaSessionConstructor) } },
    { "kind", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaSessionKind), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "controls", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaSessionControls), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "setMetadata", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMediaSessionPrototypeFunctionSetMetadata), (intptr_t) (1) } },
    { "deactivate", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMediaSessionPrototypeFunctionDeactivate), (intptr_t) (0) } },
};

const ClassInfo JSMediaSessionPrototype::s_info = { "MediaSessionPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaSessionPrototype) };

void JSMediaSessionPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMediaSession::info(), JSMediaSessionPrototypeTableValues, *this);
}

const ClassInfo JSMediaSession::s_info = { "MediaSession", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaSession) };

JSMediaSession::JSMediaSession(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MediaSession>&& impl)
    : JSDOMWrapper<MediaSession>(structure, globalObject, WTFMove(impl))
{
}

void JSMediaSession::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, MediaSession>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSMediaSession::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSMediaSessionPrototype::create(vm, &globalObject, JSMediaSessionPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSMediaSession::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSMediaSession>(vm, globalObject);
}

JSValue JSMediaSession::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaSessionConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSMediaSession::destroy(JSC::JSCell* cell)
{
    JSMediaSession* thisObject = static_cast<JSMediaSession*>(cell);
    thisObject->JSMediaSession::~JSMediaSession();
}

template<> inline JSMediaSession* IDLAttribute<JSMediaSession>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSMediaSession*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSMediaSession* IDLOperation<JSMediaSession>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSMediaSession*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsMediaSessionConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMediaSessionPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSMediaSession::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSMediaSessionConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMediaSessionPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsMediaSessionKindGetter(JSGlobalObject& lexicalGlobalObject, JSMediaSession& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<MediaSession::Kind>>(lexicalGlobalObject, throwScope, impl.kind());
    return result;
}

EncodedJSValue jsMediaSessionKind(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaSession>::get<jsMediaSessionKindGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "kind");
}

static inline JSValue jsMediaSessionControlsGetter(JSGlobalObject& lexicalGlobalObject, JSMediaSession& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<MediaRemoteControls>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.controls());
    return result;
}

EncodedJSValue jsMediaSessionControls(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaSession>::get<jsMediaSessionControlsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "controls");
}

static inline JSC::EncodedJSValue jsMediaSessionPrototypeFunctionSetMetadataBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaSession>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto metadata = convert<IDLNullable<IDLDictionary<MediaSession::Metadata>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.setMetadata(WTFMove(metadata));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMediaSessionPrototypeFunctionSetMetadata(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMediaSession>::call<jsMediaSessionPrototypeFunctionSetMetadataBody>(*lexicalGlobalObject, *callFrame, "setMetadata");
}

static inline JSC::EncodedJSValue jsMediaSessionPrototypeFunctionDeactivateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaSession>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.deactivate();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMediaSessionPrototypeFunctionDeactivate(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMediaSession>::call<jsMediaSessionPrototypeFunctionDeactivateBody>(*lexicalGlobalObject, *callFrame, "deactivate");
}

void JSMediaSession::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSMediaSession*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSMediaSessionOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSMediaSessionOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsMediaSession = static_cast<JSMediaSession*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsMediaSession->wrapped(), jsMediaSession);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<MediaSession>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to MediaSession.
    static_assert(!std::is_polymorphic<MediaSession>::value, "MediaSession is polymorphic but the IDL claims it is not");
    return createWrapper<MediaSession>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, MediaSession& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

MediaSession* JSMediaSession::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSMediaSession*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(MEDIA_SESSION)
