/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#if ENABLE(MEDIA_SESSION)

#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMWrapper.h"
#include "MediaSession.h"
#include <wtf/NeverDestroyed.h>

namespace WebCore {

class WEBCORE_EXPORT JSMediaSession : public JSDOMWrapper<MediaSession> {
public:
    using Base = JSDOMWrapper<MediaSession>;
    static JSMediaSession* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, Ref<MediaSession>&& impl)
    {
        JSMediaSession* ptr = new (NotNull, JSC::allocateCell<JSMediaSession>(globalObject->vm().heap)) JSMediaSession(structure, *globalObject, WTFMove(impl));
        ptr->finishCreation(globalObject->vm());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::VM&, JSDOMGlobalObject&);
    static JSC::JSObject* prototype(JSC::VM&, JSDOMGlobalObject&);
    static MediaSession* toWrapped(JSC::VM&, JSC::JSValue);
    static void destroy(JSC::JSCell*);

    DECLARE_INFO;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

    static JSC::JSValue getConstructor(JSC::VM&, const JSC::JSGlobalObject*);
    static void analyzeHeap(JSCell*, JSC::HeapAnalyzer&);
protected:
    JSMediaSession(JSC::Structure*, JSDOMGlobalObject&, Ref<MediaSession>&&);

    void finishCreation(JSC::VM&);
};

class JSMediaSessionOwner : public JSC::WeakHandleOwner {
public:
    virtual bool isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown>, void* context, JSC::SlotVisitor&, const char**);
    virtual void finalize(JSC::Handle<JSC::Unknown>, void* context);
};

inline JSC::WeakHandleOwner* wrapperOwner(DOMWrapperWorld&, MediaSession*)
{
    static NeverDestroyed<JSMediaSessionOwner> owner;
    return &owner.get();
}

inline void* wrapperKey(MediaSession* wrappableObject)
{
    return wrappableObject;
}

WEBCORE_EXPORT JSC::JSValue toJS(JSC::JSGlobalObject*, JSDOMGlobalObject*, MediaSession&);
inline JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, MediaSession* impl) { return impl ? toJS(lexicalGlobalObject, globalObject, *impl) : JSC::jsNull(); }
JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject*, Ref<MediaSession>&&);
inline JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, RefPtr<MediaSession>&& impl) { return impl ? toJSNewlyCreated(lexicalGlobalObject, globalObject, impl.releaseNonNull()) : JSC::jsNull(); }

// Custom constructor
JSC::EncodedJSValue constructJSMediaSession(JSC::JSGlobalObject*, JSC::CallFrame&);

template<> struct JSDOMWrapperConverterTraits<MediaSession> {
    using WrapperClass = JSMediaSession;
    using ToWrappedReturnType = MediaSession*;
};
String convertEnumerationToString(MediaSession::Kind);
template<> JSC::JSString* convertEnumerationToJS(JSC::JSGlobalObject&, MediaSession::Kind);

template<> Optional<MediaSession::Kind> parseEnumeration<MediaSession::Kind>(JSC::JSGlobalObject&, JSC::JSValue);
template<> const char* expectedEnumerationValues<MediaSession::Kind>();

template<> MediaSession::Metadata convertDictionary<MediaSession::Metadata>(JSC::JSGlobalObject&, JSC::JSValue);


} // namespace WebCore

#endif // ENABLE(MEDIA_SESSION)
