/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_SOURCE)

#include "JSMediaSource.h"

#include "ActiveDOMObject.h"
#include "EventNames.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "JSSourceBuffer.h"
#include "JSSourceBufferList.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(MediaSource::EndOfStreamError enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("network"),
        MAKE_STATIC_STRING_IMPL("decode"),
    };
    static_assert(static_cast<size_t>(MediaSource::EndOfStreamError::Network) == 0, "MediaSource::EndOfStreamError::Network is not 0 as expected");
    static_assert(static_cast<size_t>(MediaSource::EndOfStreamError::Decode) == 1, "MediaSource::EndOfStreamError::Decode is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, MediaSource::EndOfStreamError enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<MediaSource::EndOfStreamError> parseEnumeration<MediaSource::EndOfStreamError>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "network")
        return MediaSource::EndOfStreamError::Network;
    if (stringValue == "decode")
        return MediaSource::EndOfStreamError::Decode;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<MediaSource::EndOfStreamError>()
{
    return "\"network\", \"decode\"";
}

String convertEnumerationToString(MediaSource::ReadyState enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("closed"),
        MAKE_STATIC_STRING_IMPL("open"),
        MAKE_STATIC_STRING_IMPL("ended"),
    };
    static_assert(static_cast<size_t>(MediaSource::ReadyState::Closed) == 0, "MediaSource::ReadyState::Closed is not 0 as expected");
    static_assert(static_cast<size_t>(MediaSource::ReadyState::Open) == 1, "MediaSource::ReadyState::Open is not 1 as expected");
    static_assert(static_cast<size_t>(MediaSource::ReadyState::Ended) == 2, "MediaSource::ReadyState::Ended is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, MediaSource::ReadyState enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<MediaSource::ReadyState> parseEnumeration<MediaSource::ReadyState>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "closed")
        return MediaSource::ReadyState::Closed;
    if (stringValue == "open")
        return MediaSource::ReadyState::Open;
    if (stringValue == "ended")
        return MediaSource::ReadyState::Ended;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<MediaSource::ReadyState>()
{
    return "\"closed\", \"open\", \"ended\"";
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsMediaSourcePrototypeFunctionAddSourceBuffer(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaSourcePrototypeFunctionRemoveSourceBuffer(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaSourcePrototypeFunctionEndOfStream(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaSourceConstructorFunctionIsTypeSupported(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaSourcePrototypeFunctionSetLiveSeekableRange(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaSourcePrototypeFunctionClearLiveSeekableRange(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsMediaSourceConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMediaSourceConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMediaSourceSourceBuffers(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaSourceActiveSourceBuffers(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaSourceDuration(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMediaSourceDuration(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMediaSourceReadyState(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaSourceOnsourceopen(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMediaSourceOnsourceopen(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMediaSourceOnsourceended(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMediaSourceOnsourceended(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMediaSourceOnsourceclose(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMediaSourceOnsourceclose(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSMediaSourcePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSMediaSourcePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMediaSourcePrototype* ptr = new (NotNull, JSC::allocateCell<JSMediaSourcePrototype>(vm.heap)) JSMediaSourcePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMediaSourcePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMediaSourcePrototype, JSMediaSourcePrototype::Base);

using JSMediaSourceConstructor = JSDOMConstructor<JSMediaSource>;

/* Hash table for constructor */

static const HashTableValue JSMediaSourceConstructorTableValues[] =
{
    { "isTypeSupported", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMediaSourceConstructorFunctionIsTypeSupported), (intptr_t) (1) } },
};

template<> EncodedJSValue JSC_HOST_CALL JSMediaSourceConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSMediaSourceConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "MediaSource");
    auto object = MediaSource::create(*context);
    return JSValue::encode(toJSNewlyCreated<IDLInterface<MediaSource>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSMediaSourceConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSMediaSourceConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSMediaSource::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("MediaSource"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    reifyStaticProperties(vm, JSMediaSource::info(), JSMediaSourceConstructorTableValues, *this);
}

template<> const ClassInfo JSMediaSourceConstructor::s_info = { "MediaSource", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaSourceConstructor) };

/* Hash table for prototype */

static const HashTableValue JSMediaSourcePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaSourceConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaSourceConstructor) } },
    { "sourceBuffers", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaSourceSourceBuffers), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "activeSourceBuffers", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaSourceActiveSourceBuffers), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "duration", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaSourceDuration), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaSourceDuration) } },
    { "readyState", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaSourceReadyState), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "onsourceopen", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaSourceOnsourceopen), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaSourceOnsourceopen) } },
    { "onsourceended", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaSourceOnsourceended), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaSourceOnsourceended) } },
    { "onsourceclose", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaSourceOnsourceclose), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaSourceOnsourceclose) } },
    { "addSourceBuffer", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMediaSourcePrototypeFunctionAddSourceBuffer), (intptr_t) (1) } },
    { "removeSourceBuffer", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMediaSourcePrototypeFunctionRemoveSourceBuffer), (intptr_t) (1) } },
    { "endOfStream", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMediaSourcePrototypeFunctionEndOfStream), (intptr_t) (0) } },
    { "setLiveSeekableRange", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMediaSourcePrototypeFunctionSetLiveSeekableRange), (intptr_t) (2) } },
    { "clearLiveSeekableRange", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMediaSourcePrototypeFunctionClearLiveSeekableRange), (intptr_t) (0) } },
};

const ClassInfo JSMediaSourcePrototype::s_info = { "MediaSourcePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaSourcePrototype) };

void JSMediaSourcePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMediaSource::info(), JSMediaSourcePrototypeTableValues, *this);
}

const ClassInfo JSMediaSource::s_info = { "MediaSource", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaSource) };

JSMediaSource::JSMediaSource(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MediaSource>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

void JSMediaSource::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(std::is_base_of<ActiveDOMObject, MediaSource>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

}

JSObject* JSMediaSource::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSMediaSourcePrototype::create(vm, &globalObject, JSMediaSourcePrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject)));
}

JSObject* JSMediaSource::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSMediaSource>(vm, globalObject);
}

JSValue JSMediaSource::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaSourceConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSMediaSource* IDLAttribute<JSMediaSource>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSMediaSource*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSMediaSource* IDLOperation<JSMediaSource>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSMediaSource*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsMediaSourceConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMediaSourcePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSMediaSource::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSMediaSourceConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMediaSourcePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsMediaSourceSourceBuffersGetter(JSGlobalObject& lexicalGlobalObject, JSMediaSource& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SourceBufferList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.sourceBuffers());
    return result;
}

EncodedJSValue jsMediaSourceSourceBuffers(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaSource>::get<jsMediaSourceSourceBuffersGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "sourceBuffers");
}

static inline JSValue jsMediaSourceActiveSourceBuffersGetter(JSGlobalObject& lexicalGlobalObject, JSMediaSource& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<SourceBufferList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.activeSourceBuffers());
    return result;
}

EncodedJSValue jsMediaSourceActiveSourceBuffers(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaSource>::get<jsMediaSourceActiveSourceBuffersGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "activeSourceBuffers");
}

static inline JSValue jsMediaSourceDurationGetter(JSGlobalObject& lexicalGlobalObject, JSMediaSource& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUnrestrictedDouble>(lexicalGlobalObject, throwScope, impl.duration());
    return result;
}

EncodedJSValue jsMediaSourceDuration(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaSource>::get<jsMediaSourceDurationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "duration");
}

static inline bool setJSMediaSourceDurationSetter(JSGlobalObject& lexicalGlobalObject, JSMediaSource& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setDuration(WTFMove(nativeValue));
    });
    return true;
}

bool setJSMediaSourceDuration(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSMediaSource>::set<setJSMediaSourceDurationSetter>(*lexicalGlobalObject, thisValue, encodedValue, "duration");
}

static inline JSValue jsMediaSourceReadyStateGetter(JSGlobalObject& lexicalGlobalObject, JSMediaSource& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<MediaSource::ReadyState>>(lexicalGlobalObject, throwScope, impl.readyState());
    return result;
}

EncodedJSValue jsMediaSourceReadyState(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaSource>::get<jsMediaSourceReadyStateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "readyState");
}

static inline JSValue jsMediaSourceOnsourceopenGetter(JSGlobalObject& lexicalGlobalObject, JSMediaSource& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().sourceopenEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsMediaSourceOnsourceopen(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaSource>::get<jsMediaSourceOnsourceopenGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onsourceopen");
}

static inline bool setJSMediaSourceOnsourceopenSetter(JSGlobalObject& lexicalGlobalObject, JSMediaSource& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().sourceopenEvent, value);
    return true;
}

bool setJSMediaSourceOnsourceopen(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSMediaSource>::set<setJSMediaSourceOnsourceopenSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onsourceopen");
}

static inline JSValue jsMediaSourceOnsourceendedGetter(JSGlobalObject& lexicalGlobalObject, JSMediaSource& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().sourceendedEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsMediaSourceOnsourceended(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaSource>::get<jsMediaSourceOnsourceendedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onsourceended");
}

static inline bool setJSMediaSourceOnsourceendedSetter(JSGlobalObject& lexicalGlobalObject, JSMediaSource& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().sourceendedEvent, value);
    return true;
}

bool setJSMediaSourceOnsourceended(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSMediaSource>::set<setJSMediaSourceOnsourceendedSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onsourceended");
}

static inline JSValue jsMediaSourceOnsourcecloseGetter(JSGlobalObject& lexicalGlobalObject, JSMediaSource& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().sourcecloseEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsMediaSourceOnsourceclose(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaSource>::get<jsMediaSourceOnsourcecloseGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onsourceclose");
}

static inline bool setJSMediaSourceOnsourcecloseSetter(JSGlobalObject& lexicalGlobalObject, JSMediaSource& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().sourcecloseEvent, value);
    return true;
}

bool setJSMediaSourceOnsourceclose(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSMediaSource>::set<setJSMediaSourceOnsourcecloseSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onsourceclose");
}

static inline JSC::EncodedJSValue jsMediaSourcePrototypeFunctionAddSourceBufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaSource>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto type = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<SourceBuffer>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.addSourceBuffer(WTFMove(type))));
}

EncodedJSValue JSC_HOST_CALL jsMediaSourcePrototypeFunctionAddSourceBuffer(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMediaSource>::call<jsMediaSourcePrototypeFunctionAddSourceBufferBody>(*lexicalGlobalObject, *callFrame, "addSourceBuffer");
}

static inline JSC::EncodedJSValue jsMediaSourcePrototypeFunctionRemoveSourceBufferBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaSource>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto buffer = convert<IDLInterface<SourceBuffer>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "buffer", "MediaSource", "removeSourceBuffer", "SourceBuffer"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.removeSourceBuffer(*buffer));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMediaSourcePrototypeFunctionRemoveSourceBuffer(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMediaSource>::call<jsMediaSourcePrototypeFunctionRemoveSourceBufferBody>(*lexicalGlobalObject, *callFrame, "removeSourceBuffer");
}

static inline JSC::EncodedJSValue jsMediaSourcePrototypeFunctionEndOfStreamBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaSource>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto error = callFrame->argument(0).isUndefined() ? Optional<Converter<IDLEnumeration<MediaSource::EndOfStreamError>>::ReturnType>() : Optional<Converter<IDLEnumeration<MediaSource::EndOfStreamError>>::ReturnType>(convert<IDLEnumeration<MediaSource::EndOfStreamError>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeEnumError(lexicalGlobalObject, scope, 0, "error", "MediaSource", "endOfStream", expectedEnumerationValues<MediaSource::EndOfStreamError>()); }));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.endOfStream(WTFMove(error)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMediaSourcePrototypeFunctionEndOfStream(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMediaSource>::call<jsMediaSourcePrototypeFunctionEndOfStreamBody>(*lexicalGlobalObject, *callFrame, "endOfStream");
}

static inline JSC::EncodedJSValue jsMediaSourceConstructorFunctionIsTypeSupportedBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto type = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLBoolean>(MediaSource::isTypeSupported(WTFMove(type))));
}

EncodedJSValue JSC_HOST_CALL jsMediaSourceConstructorFunctionIsTypeSupported(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMediaSource>::callStatic<jsMediaSourceConstructorFunctionIsTypeSupportedBody>(*lexicalGlobalObject, *callFrame, "isTypeSupported");
}

static inline JSC::EncodedJSValue jsMediaSourcePrototypeFunctionSetLiveSeekableRangeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaSource>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto start = convert<IDLDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto end = convert<IDLDouble>(*lexicalGlobalObject, callFrame->uncheckedArgument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.setLiveSeekableRange(WTFMove(start), WTFMove(end)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMediaSourcePrototypeFunctionSetLiveSeekableRange(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMediaSource>::call<jsMediaSourcePrototypeFunctionSetLiveSeekableRangeBody>(*lexicalGlobalObject, *callFrame, "setLiveSeekableRange");
}

static inline JSC::EncodedJSValue jsMediaSourcePrototypeFunctionClearLiveSeekableRangeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaSource>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    propagateException(*lexicalGlobalObject, throwScope, impl.clearLiveSeekableRange());
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMediaSourcePrototypeFunctionClearLiveSeekableRange(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMediaSource>::call<jsMediaSourcePrototypeFunctionClearLiveSeekableRangeBody>(*lexicalGlobalObject, *callFrame, "clearLiveSeekableRange");
}

void JSMediaSource::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSMediaSource*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSMediaSourceOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsMediaSource = jsCast<JSMediaSource*>(handle.slot()->asCell());
    if (jsMediaSource->wrapped().hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    if (jsMediaSource->wrapped().isFiringEventListeners()) {
        if (UNLIKELY(reason))
            *reason = "EventTarget firing event listeners";
        return true;
    }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSMediaSourceOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsMediaSource = static_cast<JSMediaSource*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsMediaSource->wrapped(), jsMediaSource);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7MediaSource@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore11MediaSourceE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<MediaSource>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7MediaSource@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore11MediaSourceE[2];
#endif

    // If this fails MediaSource does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<MediaSource>::value, "MediaSource is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // MediaSource has subclasses. If MediaSource has subclasses that get passed
    // to toJS() we currently require MediaSource you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<MediaSource>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, MediaSource& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

MediaSource* JSMediaSource::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSMediaSource*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(MEDIA_SOURCE)
