/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_STREAM)

#include "JSMediaStream.h"

#include "ActiveDOMObject.h"
#include "Document.h"
#include "EventNames.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "JSMediaStream.h"
#include "JSMediaStreamTrack.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>

#if ENABLE(MEDIA_STREAM)
#include <JavaScriptCore/IteratorOperations.h>
#endif


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsMediaStreamPrototypeFunctionGetAudioTracks(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaStreamPrototypeFunctionGetVideoTracks(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaStreamPrototypeFunctionGetTracks(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaStreamPrototypeFunctionGetTrackById(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaStreamPrototypeFunctionAddTrack(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaStreamPrototypeFunctionRemoveTrack(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsMediaStreamPrototypeFunctionClone(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsMediaStreamConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMediaStreamConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMediaStreamId(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaStreamActive(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMediaStreamOnaddtrack(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMediaStreamOnaddtrack(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMediaStreamOnremovetrack(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMediaStreamOnremovetrack(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSMediaStreamPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSMediaStreamPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMediaStreamPrototype* ptr = new (NotNull, JSC::allocateCell<JSMediaStreamPrototype>(vm.heap)) JSMediaStreamPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMediaStreamPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMediaStreamPrototype, JSMediaStreamPrototype::Base);

using JSMediaStreamConstructor = JSDOMConstructor<JSMediaStream>;

static inline EncodedJSValue constructJSMediaStream1(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSMediaStreamConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "MediaStream");
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    auto object = MediaStream::create(document);
    return JSValue::encode(toJSNewlyCreated<IDLInterface<MediaStream>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

static inline EncodedJSValue constructJSMediaStream2(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSMediaStreamConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "MediaStream");
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    auto stream = convert<IDLInterface<MediaStream>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "stream", "MediaStream", nullptr, "MediaStream"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = MediaStream::create(document, *stream);
    return JSValue::encode(toJSNewlyCreated<IDLInterface<MediaStream>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

static inline EncodedJSValue constructJSMediaStream3(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSMediaStreamConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "MediaStream");
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    auto tracks = convert<IDLSequence<IDLInterface<MediaStreamTrack>>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = MediaStream::create(document, WTFMove(tracks));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<MediaStream>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> EncodedJSValue JSC_HOST_CALL JSMediaStreamConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    size_t argsCount = std::min<size_t>(1, callFrame->argumentCount());
    if (argsCount == 0) {
#if ENABLE(MEDIA_STREAM)
        return constructJSMediaStream1(lexicalGlobalObject, callFrame);
#endif
    }
    if (argsCount == 1) {
        JSValue distinguishingArg = callFrame->uncheckedArgument(0);
#if ENABLE(MEDIA_STREAM)
        if (distinguishingArg.isObject() && asObject(distinguishingArg)->inherits<JSMediaStream>(vm))
            return constructJSMediaStream2(lexicalGlobalObject, callFrame);
#endif
#if ENABLE(MEDIA_STREAM)
        if (hasIteratorMethod(lexicalGlobalObject, distinguishingArg))
            return constructJSMediaStream3(lexicalGlobalObject, callFrame);
#endif
    }
    return throwVMTypeError(lexicalGlobalObject, throwScope);
}

template<> JSValue JSMediaStreamConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSMediaStreamConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSMediaStream::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("MediaStream"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSMediaStreamConstructor::s_info = { "MediaStream", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaStreamConstructor) };

/* Hash table for prototype */

static const HashTableValue JSMediaStreamPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaStreamConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaStreamConstructor) } },
    { "id", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaStreamId), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "active", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaStreamActive), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "onaddtrack", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaStreamOnaddtrack), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaStreamOnaddtrack) } },
    { "onremovetrack", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaStreamOnremovetrack), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaStreamOnremovetrack) } },
    { "getAudioTracks", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMediaStreamPrototypeFunctionGetAudioTracks), (intptr_t) (0) } },
    { "getVideoTracks", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMediaStreamPrototypeFunctionGetVideoTracks), (intptr_t) (0) } },
    { "getTracks", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMediaStreamPrototypeFunctionGetTracks), (intptr_t) (0) } },
    { "getTrackById", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMediaStreamPrototypeFunctionGetTrackById), (intptr_t) (1) } },
    { "addTrack", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMediaStreamPrototypeFunctionAddTrack), (intptr_t) (1) } },
    { "removeTrack", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMediaStreamPrototypeFunctionRemoveTrack), (intptr_t) (1) } },
    { "clone", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMediaStreamPrototypeFunctionClone), (intptr_t) (0) } },
};

const ClassInfo JSMediaStreamPrototype::s_info = { "MediaStreamPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaStreamPrototype) };

void JSMediaStreamPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMediaStream::info(), JSMediaStreamPrototypeTableValues, *this);
    putDirect(vm, static_cast<JSVMClientData*>(vm.clientData)->builtinNames().getTracksPrivateName(), JSFunction::create(vm, globalObject(), 0, String(), jsMediaStreamPrototypeFunctionGetTracks), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

const ClassInfo JSMediaStream::s_info = { "MediaStream", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaStream) };

JSMediaStream::JSMediaStream(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MediaStream>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

void JSMediaStream::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(std::is_base_of<ActiveDOMObject, MediaStream>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

}

JSObject* JSMediaStream::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSMediaStreamPrototype::create(vm, &globalObject, JSMediaStreamPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject)));
}

JSObject* JSMediaStream::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSMediaStream>(vm, globalObject);
}

JSValue JSMediaStream::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaStreamConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSMediaStream* IDLAttribute<JSMediaStream>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSMediaStream*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSMediaStream* IDLOperation<JSMediaStream>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSMediaStream*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsMediaStreamConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMediaStreamPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSMediaStream::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSMediaStreamConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMediaStreamPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsMediaStreamIdGetter(JSGlobalObject& lexicalGlobalObject, JSMediaStream& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.id());
    return result;
}

EncodedJSValue jsMediaStreamId(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaStream>::get<jsMediaStreamIdGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "id");
}

static inline JSValue jsMediaStreamActiveGetter(JSGlobalObject& lexicalGlobalObject, JSMediaStream& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.active());
    return result;
}

EncodedJSValue jsMediaStreamActive(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaStream>::get<jsMediaStreamActiveGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "active");
}

static inline JSValue jsMediaStreamOnaddtrackGetter(JSGlobalObject& lexicalGlobalObject, JSMediaStream& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().addtrackEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsMediaStreamOnaddtrack(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaStream>::get<jsMediaStreamOnaddtrackGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onaddtrack");
}

static inline bool setJSMediaStreamOnaddtrackSetter(JSGlobalObject& lexicalGlobalObject, JSMediaStream& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().addtrackEvent, value);
    return true;
}

bool setJSMediaStreamOnaddtrack(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSMediaStream>::set<setJSMediaStreamOnaddtrackSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onaddtrack");
}

static inline JSValue jsMediaStreamOnremovetrackGetter(JSGlobalObject& lexicalGlobalObject, JSMediaStream& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.wrapped(), eventNames().removetrackEvent, worldForDOMObject(thisObject));
}

EncodedJSValue jsMediaStreamOnremovetrack(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaStream>::get<jsMediaStreamOnremovetrackGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "onremovetrack");
}

static inline bool setJSMediaStreamOnremovetrackSetter(JSGlobalObject& lexicalGlobalObject, JSMediaStream& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    setEventHandlerAttribute(lexicalGlobalObject, thisObject, thisObject.wrapped(), eventNames().removetrackEvent, value);
    return true;
}

bool setJSMediaStreamOnremovetrack(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSMediaStream>::set<setJSMediaStreamOnremovetrackSetter>(*lexicalGlobalObject, thisValue, encodedValue, "onremovetrack");
}

static inline JSC::EncodedJSValue jsMediaStreamPrototypeFunctionGetAudioTracksBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaStream>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLSequence<IDLInterface<MediaStreamTrack>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getAudioTracks()));
}

EncodedJSValue JSC_HOST_CALL jsMediaStreamPrototypeFunctionGetAudioTracks(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMediaStream>::call<jsMediaStreamPrototypeFunctionGetAudioTracksBody>(*lexicalGlobalObject, *callFrame, "getAudioTracks");
}

static inline JSC::EncodedJSValue jsMediaStreamPrototypeFunctionGetVideoTracksBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaStream>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLSequence<IDLInterface<MediaStreamTrack>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getVideoTracks()));
}

EncodedJSValue JSC_HOST_CALL jsMediaStreamPrototypeFunctionGetVideoTracks(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMediaStream>::call<jsMediaStreamPrototypeFunctionGetVideoTracksBody>(*lexicalGlobalObject, *callFrame, "getVideoTracks");
}

static inline JSC::EncodedJSValue jsMediaStreamPrototypeFunctionGetTracksBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaStream>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLSequence<IDLInterface<MediaStreamTrack>>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getTracks()));
}

EncodedJSValue JSC_HOST_CALL jsMediaStreamPrototypeFunctionGetTracks(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMediaStream>::call<jsMediaStreamPrototypeFunctionGetTracksBody>(*lexicalGlobalObject, *callFrame, "getTracks");
}

static inline JSC::EncodedJSValue jsMediaStreamPrototypeFunctionGetTrackByIdBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaStream>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto trackId = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    return JSValue::encode(toJS<IDLInterface<MediaStreamTrack>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.getTrackById(WTFMove(trackId))));
}

EncodedJSValue JSC_HOST_CALL jsMediaStreamPrototypeFunctionGetTrackById(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMediaStream>::call<jsMediaStreamPrototypeFunctionGetTrackByIdBody>(*lexicalGlobalObject, *callFrame, "getTrackById");
}

static inline JSC::EncodedJSValue jsMediaStreamPrototypeFunctionAddTrackBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaStream>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto track = convert<IDLInterface<MediaStreamTrack>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "track", "MediaStream", "addTrack", "MediaStreamTrack"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.addTrack(*track);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMediaStreamPrototypeFunctionAddTrack(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMediaStream>::call<jsMediaStreamPrototypeFunctionAddTrackBody>(*lexicalGlobalObject, *callFrame, "addTrack");
}

static inline JSC::EncodedJSValue jsMediaStreamPrototypeFunctionRemoveTrackBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaStream>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto track = convert<IDLInterface<MediaStreamTrack>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "track", "MediaStream", "removeTrack", "MediaStreamTrack"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    impl.removeTrack(*track);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMediaStreamPrototypeFunctionRemoveTrack(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMediaStream>::call<jsMediaStreamPrototypeFunctionRemoveTrackBody>(*lexicalGlobalObject, *callFrame, "removeTrack");
}

static inline JSC::EncodedJSValue jsMediaStreamPrototypeFunctionCloneBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMediaStream>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    return JSValue::encode(toJS<IDLInterface<MediaStream>>(*lexicalGlobalObject, *castedThis->globalObject(), impl.clone()));
}

EncodedJSValue JSC_HOST_CALL jsMediaStreamPrototypeFunctionClone(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMediaStream>::call<jsMediaStreamPrototypeFunctionCloneBody>(*lexicalGlobalObject, *callFrame, "clone");
}

void JSMediaStream::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSMediaStream*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSMediaStreamOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    auto* jsMediaStream = jsCast<JSMediaStream*>(handle.slot()->asCell());
    if (jsMediaStream->wrapped().hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    if (jsMediaStream->wrapped().isFiringEventListeners()) {
        if (UNLIKELY(reason))
            *reason = "EventTarget firing event listeners";
        return true;
    }
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSMediaStreamOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsMediaStream = static_cast<JSMediaStream*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsMediaStream->wrapped(), jsMediaStream);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7MediaStream@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore11MediaStreamE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<MediaStream>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7MediaStream@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore11MediaStreamE[2];
#endif

    // If this fails MediaStream does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<MediaStream>::value, "MediaStream is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // MediaStream has subclasses. If MediaStream has subclasses that get passed
    // to toJS() we currently require MediaStream you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<MediaStream>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, MediaStream& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

MediaStream* JSMediaStream::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSMediaStream*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(MEDIA_STREAM)
