/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_STREAM) && ENABLE(WEB_AUDIO)

#include "JSMediaStreamAudioDestinationNode.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMWrapperCache.h"
#include "JSMediaStream.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsMediaStreamAudioDestinationNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMediaStreamAudioDestinationNodeConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMediaStreamAudioDestinationNodeStream(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSMediaStreamAudioDestinationNodePrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSMediaStreamAudioDestinationNodePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMediaStreamAudioDestinationNodePrototype* ptr = new (NotNull, JSC::allocateCell<JSMediaStreamAudioDestinationNodePrototype>(vm.heap)) JSMediaStreamAudioDestinationNodePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMediaStreamAudioDestinationNodePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMediaStreamAudioDestinationNodePrototype, JSMediaStreamAudioDestinationNodePrototype::Base);

using JSMediaStreamAudioDestinationNodeConstructor = JSDOMConstructorNotConstructable<JSMediaStreamAudioDestinationNode>;

template<> JSValue JSMediaStreamAudioDestinationNodeConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSAudioNode::getConstructor(vm, &globalObject);
}

template<> void JSMediaStreamAudioDestinationNodeConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSMediaStreamAudioDestinationNode::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("MediaStreamAudioDestinationNode"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSMediaStreamAudioDestinationNodeConstructor::s_info = { "MediaStreamAudioDestinationNode", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaStreamAudioDestinationNodeConstructor) };

/* Hash table for prototype */

static const HashTableValue JSMediaStreamAudioDestinationNodePrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaStreamAudioDestinationNodeConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMediaStreamAudioDestinationNodeConstructor) } },
    { "stream", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaStreamAudioDestinationNodeStream), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSMediaStreamAudioDestinationNodePrototype::s_info = { "MediaStreamAudioDestinationNodePrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaStreamAudioDestinationNodePrototype) };

void JSMediaStreamAudioDestinationNodePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMediaStreamAudioDestinationNode::info(), JSMediaStreamAudioDestinationNodePrototypeTableValues, *this);
}

const ClassInfo JSMediaStreamAudioDestinationNode::s_info = { "MediaStreamAudioDestinationNode", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMediaStreamAudioDestinationNode) };

JSMediaStreamAudioDestinationNode::JSMediaStreamAudioDestinationNode(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MediaStreamAudioDestinationNode>&& impl)
    : JSAudioNode(structure, globalObject, WTFMove(impl))
{
}

void JSMediaStreamAudioDestinationNode::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, MediaStreamAudioDestinationNode>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSMediaStreamAudioDestinationNode::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSMediaStreamAudioDestinationNodePrototype::create(vm, &globalObject, JSMediaStreamAudioDestinationNodePrototype::createStructure(vm, &globalObject, JSAudioNode::prototype(vm, globalObject)));
}

JSObject* JSMediaStreamAudioDestinationNode::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSMediaStreamAudioDestinationNode>(vm, globalObject);
}

JSValue JSMediaStreamAudioDestinationNode::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaStreamAudioDestinationNodeConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSMediaStreamAudioDestinationNode* IDLAttribute<JSMediaStreamAudioDestinationNode>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSMediaStreamAudioDestinationNode*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsMediaStreamAudioDestinationNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMediaStreamAudioDestinationNodePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSMediaStreamAudioDestinationNode::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSMediaStreamAudioDestinationNodeConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMediaStreamAudioDestinationNodePrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsMediaStreamAudioDestinationNodeStreamGetter(JSGlobalObject& lexicalGlobalObject, JSMediaStreamAudioDestinationNode& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<MediaStream>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.stream());
    return result;
}

EncodedJSValue jsMediaStreamAudioDestinationNodeStream(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMediaStreamAudioDestinationNode>::get<jsMediaStreamAudioDestinationNodeStreamGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "stream");
}

void JSMediaStreamAudioDestinationNode::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSMediaStreamAudioDestinationNode*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7MediaStreamAudioDestinationNode@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore31MediaStreamAudioDestinationNodeE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<MediaStreamAudioDestinationNode>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7MediaStreamAudioDestinationNode@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore31MediaStreamAudioDestinationNodeE[2];
#endif

    // If this fails MediaStreamAudioDestinationNode does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<MediaStreamAudioDestinationNode>::value, "MediaStreamAudioDestinationNode is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // MediaStreamAudioDestinationNode has subclasses. If MediaStreamAudioDestinationNode has subclasses that get passed
    // to toJS() we currently require MediaStreamAudioDestinationNode you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<MediaStreamAudioDestinationNode>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, MediaStreamAudioDestinationNode& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}

#endif // ENABLE(MEDIA_STREAM) && ENABLE(WEB_AUDIO)
