/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(PAYMENT_REQUEST)

#include "JSMerchantValidationEvent.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "Document.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(PAYMENT_REQUEST)

template<> MerchantValidationEvent::Init convertDictionary<MerchantValidationEvent::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    MerchantValidationEvent::Init result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bubblesValue.isUndefined()) {
        result.bubbles = convert<IDLBoolean>(lexicalGlobalObject, bubblesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.bubbles = false;
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!cancelableValue.isUndefined()) {
        result.cancelable = convert<IDLBoolean>(lexicalGlobalObject, cancelableValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.cancelable = false;
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!composedValue.isUndefined()) {
        result.composed = convert<IDLBoolean>(lexicalGlobalObject, composedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.composed = false;
    JSValue methodNameValue;
    if (isNullOrUndefined)
        methodNameValue = jsUndefined();
    else {
        methodNameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "methodName"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!methodNameValue.isUndefined()) {
        result.methodName = convert<IDLDOMString>(lexicalGlobalObject, methodNameValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.methodName = emptyString();
    JSValue validationURLValue;
    if (isNullOrUndefined)
        validationURLValue = jsUndefined();
    else {
        validationURLValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "validationURL"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!validationURLValue.isUndefined()) {
        result.validationURL = convert<IDLUSVString>(lexicalGlobalObject, validationURLValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.validationURL = emptyString();
    return result;
}

#endif

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsMerchantValidationEventPrototypeFunctionComplete(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsMerchantValidationEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMerchantValidationEventConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMerchantValidationEventMethodName(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMerchantValidationEventValidationURL(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSMerchantValidationEventPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSMerchantValidationEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMerchantValidationEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSMerchantValidationEventPrototype>(vm.heap)) JSMerchantValidationEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMerchantValidationEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMerchantValidationEventPrototype, JSMerchantValidationEventPrototype::Base);

using JSMerchantValidationEventConstructor = JSDOMConstructor<JSMerchantValidationEvent>;

template<> EncodedJSValue JSC_HOST_CALL JSMerchantValidationEventConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSMerchantValidationEventConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "MerchantValidationEvent");
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    auto type = convert<IDLDOMString>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto eventInitDict = convert<IDLDictionary<MerchantValidationEvent::Init>>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = MerchantValidationEvent::create(document, WTFMove(type), WTFMove(eventInitDict));
    return JSValue::encode(toJSNewlyCreated<IDLInterface<MerchantValidationEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object)));
}

template<> JSValue JSMerchantValidationEventConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEvent::getConstructor(vm, &globalObject);
}

template<> void JSMerchantValidationEventConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSMerchantValidationEvent::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("MerchantValidationEvent"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSMerchantValidationEventConstructor::s_info = { "MerchantValidationEvent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMerchantValidationEventConstructor) };

/* Hash table for prototype */

static const HashTableValue JSMerchantValidationEventPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMerchantValidationEventConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMerchantValidationEventConstructor) } },
    { "methodName", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMerchantValidationEventMethodName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "validationURL", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMerchantValidationEventValidationURL), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "complete", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMerchantValidationEventPrototypeFunctionComplete), (intptr_t) (1) } },
};

const ClassInfo JSMerchantValidationEventPrototype::s_info = { "MerchantValidationEventPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMerchantValidationEventPrototype) };

void JSMerchantValidationEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMerchantValidationEvent::info(), JSMerchantValidationEventPrototypeTableValues, *this);
}

const ClassInfo JSMerchantValidationEvent::s_info = { "MerchantValidationEvent", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMerchantValidationEvent) };

JSMerchantValidationEvent::JSMerchantValidationEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MerchantValidationEvent>&& impl)
    : JSEvent(structure, globalObject, WTFMove(impl))
{
}

void JSMerchantValidationEvent::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, MerchantValidationEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSMerchantValidationEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSMerchantValidationEventPrototype::create(vm, &globalObject, JSMerchantValidationEventPrototype::createStructure(vm, &globalObject, JSEvent::prototype(vm, globalObject)));
}

JSObject* JSMerchantValidationEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSMerchantValidationEvent>(vm, globalObject);
}

JSValue JSMerchantValidationEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMerchantValidationEventConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

template<> inline JSMerchantValidationEvent* IDLAttribute<JSMerchantValidationEvent>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSMerchantValidationEvent*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSMerchantValidationEvent* IDLOperation<JSMerchantValidationEvent>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSMerchantValidationEvent*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsMerchantValidationEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMerchantValidationEventPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSMerchantValidationEvent::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSMerchantValidationEventConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMerchantValidationEventPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsMerchantValidationEventMethodNameGetter(JSGlobalObject& lexicalGlobalObject, JSMerchantValidationEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.methodName());
    return result;
}

EncodedJSValue jsMerchantValidationEventMethodName(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMerchantValidationEvent>::get<jsMerchantValidationEventMethodNameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "methodName");
}

static inline JSValue jsMerchantValidationEventValidationURLGetter(JSGlobalObject& lexicalGlobalObject, JSMerchantValidationEvent& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.validationURL());
    return result;
}

EncodedJSValue jsMerchantValidationEventValidationURL(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMerchantValidationEvent>::get<jsMerchantValidationEventValidationURLGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "validationURL");
}

static inline JSC::EncodedJSValue jsMerchantValidationEventPrototypeFunctionCompleteBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMerchantValidationEvent>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto merchantSessionPromise = convert<IDLPromise<IDLAny>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.complete(merchantSessionPromise.releaseNonNull()));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMerchantValidationEventPrototypeFunctionComplete(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMerchantValidationEvent>::call<jsMerchantValidationEventPrototypeFunctionCompleteBody>(*lexicalGlobalObject, *callFrame, "complete");
}

void JSMerchantValidationEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSMerchantValidationEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7MerchantValidationEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore23MerchantValidationEventE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<MerchantValidationEvent>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7MerchantValidationEvent@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore23MerchantValidationEventE[2];
#endif

    // If this fails MerchantValidationEvent does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<MerchantValidationEvent>::value, "MerchantValidationEvent is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // MerchantValidationEvent has subclasses. If MerchantValidationEvent has subclasses that get passed
    // to toJS() we currently require MerchantValidationEvent you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<MerchantValidationEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, MerchantValidationEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}

#endif // ENABLE(PAYMENT_REQUEST)
