/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(ENCRYPTED_MEDIA)

#include "JSMockCDMFactory.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSMediaKeyEncryptionScheme.h"
#include "JSMediaKeySessionType.h"
#include "JSMediaKeysRequirement.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsMockCDMFactoryPrototypeFunctionUnregister(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsMockCDMFactorySupportedDataTypes(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMockCDMFactorySupportedDataTypes(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMockCDMFactorySupportedRobustness(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMockCDMFactorySupportedRobustness(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMockCDMFactorySupportedSessionTypes(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMockCDMFactorySupportedSessionTypes(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMockCDMFactoryDistinctiveIdentifiersRequirement(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMockCDMFactoryDistinctiveIdentifiersRequirement(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMockCDMFactoryPersistentStateRequirement(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMockCDMFactoryPersistentStateRequirement(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMockCDMFactoryCanCreateInstances(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMockCDMFactoryCanCreateInstances(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMockCDMFactorySupportsServerCertificates(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMockCDMFactorySupportsServerCertificates(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMockCDMFactorySupportsSessions(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMockCDMFactorySupportsSessions(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMockCDMFactorySupportedEncryptionSchemes(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMockCDMFactorySupportedEncryptionSchemes(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSMockCDMFactoryPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSMockCDMFactoryPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMockCDMFactoryPrototype* ptr = new (NotNull, JSC::allocateCell<JSMockCDMFactoryPrototype>(vm.heap)) JSMockCDMFactoryPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMockCDMFactoryPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMockCDMFactoryPrototype, JSMockCDMFactoryPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSMockCDMFactoryPrototypeTableValues[] =
{
    { "supportedDataTypes", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMockCDMFactorySupportedDataTypes), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMockCDMFactorySupportedDataTypes) } },
    { "supportedRobustness", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMockCDMFactorySupportedRobustness), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMockCDMFactorySupportedRobustness) } },
    { "supportedSessionTypes", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMockCDMFactorySupportedSessionTypes), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMockCDMFactorySupportedSessionTypes) } },
    { "distinctiveIdentifiersRequirement", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMockCDMFactoryDistinctiveIdentifiersRequirement), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMockCDMFactoryDistinctiveIdentifiersRequirement) } },
    { "persistentStateRequirement", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMockCDMFactoryPersistentStateRequirement), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMockCDMFactoryPersistentStateRequirement) } },
    { "canCreateInstances", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMockCDMFactoryCanCreateInstances), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMockCDMFactoryCanCreateInstances) } },
    { "supportsServerCertificates", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMockCDMFactorySupportsServerCertificates), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMockCDMFactorySupportsServerCertificates) } },
    { "supportsSessions", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMockCDMFactorySupportsSessions), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMockCDMFactorySupportsSessions) } },
    { "supportedEncryptionSchemes", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMockCDMFactorySupportedEncryptionSchemes), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMockCDMFactorySupportedEncryptionSchemes) } },
    { "unregister", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMockCDMFactoryPrototypeFunctionUnregister), (intptr_t) (0) } },
};

const ClassInfo JSMockCDMFactoryPrototype::s_info = { "MockCDMFactoryPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMockCDMFactoryPrototype) };

void JSMockCDMFactoryPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMockCDMFactory::info(), JSMockCDMFactoryPrototypeTableValues, *this);
}

const ClassInfo JSMockCDMFactory::s_info = { "MockCDMFactory", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMockCDMFactory) };

JSMockCDMFactory::JSMockCDMFactory(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MockCDMFactory>&& impl)
    : JSDOMWrapper<MockCDMFactory>(structure, globalObject, WTFMove(impl))
{
}

void JSMockCDMFactory::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, MockCDMFactory>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSMockCDMFactory::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSMockCDMFactoryPrototype::create(vm, &globalObject, JSMockCDMFactoryPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSMockCDMFactory::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSMockCDMFactory>(vm, globalObject);
}

void JSMockCDMFactory::destroy(JSC::JSCell* cell)
{
    JSMockCDMFactory* thisObject = static_cast<JSMockCDMFactory*>(cell);
    thisObject->JSMockCDMFactory::~JSMockCDMFactory();
}

template<> inline JSMockCDMFactory* IDLAttribute<JSMockCDMFactory>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSMockCDMFactory*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

template<> inline JSMockCDMFactory* IDLOperation<JSMockCDMFactory>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSMockCDMFactory*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

static inline JSValue jsMockCDMFactorySupportedDataTypesGetter(JSGlobalObject& lexicalGlobalObject, JSMockCDMFactory& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLSequence<IDLDOMString>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.supportedDataTypes());
    return result;
}

EncodedJSValue jsMockCDMFactorySupportedDataTypes(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMockCDMFactory>::get<jsMockCDMFactorySupportedDataTypesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "supportedDataTypes");
}

static inline bool setJSMockCDMFactorySupportedDataTypesSetter(JSGlobalObject& lexicalGlobalObject, JSMockCDMFactory& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLSequence<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setSupportedDataTypes(WTFMove(nativeValue));
    });
    return true;
}

bool setJSMockCDMFactorySupportedDataTypes(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSMockCDMFactory>::set<setJSMockCDMFactorySupportedDataTypesSetter>(*lexicalGlobalObject, thisValue, encodedValue, "supportedDataTypes");
}

static inline JSValue jsMockCDMFactorySupportedRobustnessGetter(JSGlobalObject& lexicalGlobalObject, JSMockCDMFactory& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLSequence<IDLDOMString>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.supportedRobustness());
    return result;
}

EncodedJSValue jsMockCDMFactorySupportedRobustness(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMockCDMFactory>::get<jsMockCDMFactorySupportedRobustnessGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "supportedRobustness");
}

static inline bool setJSMockCDMFactorySupportedRobustnessSetter(JSGlobalObject& lexicalGlobalObject, JSMockCDMFactory& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLSequence<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setSupportedRobustness(WTFMove(nativeValue));
    });
    return true;
}

bool setJSMockCDMFactorySupportedRobustness(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSMockCDMFactory>::set<setJSMockCDMFactorySupportedRobustnessSetter>(*lexicalGlobalObject, thisValue, encodedValue, "supportedRobustness");
}

static inline JSValue jsMockCDMFactorySupportedSessionTypesGetter(JSGlobalObject& lexicalGlobalObject, JSMockCDMFactory& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLSequence<IDLEnumeration<MediaKeySessionType>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.supportedSessionTypes());
    return result;
}

EncodedJSValue jsMockCDMFactorySupportedSessionTypes(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMockCDMFactory>::get<jsMockCDMFactorySupportedSessionTypesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "supportedSessionTypes");
}

static inline bool setJSMockCDMFactorySupportedSessionTypesSetter(JSGlobalObject& lexicalGlobalObject, JSMockCDMFactory& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLSequence<IDLEnumeration<MediaKeySessionType>>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setSupportedSessionTypes(WTFMove(nativeValue));
    });
    return true;
}

bool setJSMockCDMFactorySupportedSessionTypes(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSMockCDMFactory>::set<setJSMockCDMFactorySupportedSessionTypesSetter>(*lexicalGlobalObject, thisValue, encodedValue, "supportedSessionTypes");
}

static inline JSValue jsMockCDMFactoryDistinctiveIdentifiersRequirementGetter(JSGlobalObject& lexicalGlobalObject, JSMockCDMFactory& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<MediaKeysRequirement>>(lexicalGlobalObject, throwScope, impl.distinctiveIdentifiersRequirement());
    return result;
}

EncodedJSValue jsMockCDMFactoryDistinctiveIdentifiersRequirement(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMockCDMFactory>::get<jsMockCDMFactoryDistinctiveIdentifiersRequirementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "distinctiveIdentifiersRequirement");
}

static inline bool setJSMockCDMFactoryDistinctiveIdentifiersRequirementSetter(JSGlobalObject& lexicalGlobalObject, JSMockCDMFactory& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<MediaKeysRequirement>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    auto nativeValue = optionalNativeValue.value();
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setDistinctiveIdentifiersRequirement(WTFMove(nativeValue));
    });
    return true;
}

bool setJSMockCDMFactoryDistinctiveIdentifiersRequirement(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSMockCDMFactory>::set<setJSMockCDMFactoryDistinctiveIdentifiersRequirementSetter>(*lexicalGlobalObject, thisValue, encodedValue, "distinctiveIdentifiersRequirement");
}

static inline JSValue jsMockCDMFactoryPersistentStateRequirementGetter(JSGlobalObject& lexicalGlobalObject, JSMockCDMFactory& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<MediaKeysRequirement>>(lexicalGlobalObject, throwScope, impl.persistentStateRequirement());
    return result;
}

EncodedJSValue jsMockCDMFactoryPersistentStateRequirement(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMockCDMFactory>::get<jsMockCDMFactoryPersistentStateRequirementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "persistentStateRequirement");
}

static inline bool setJSMockCDMFactoryPersistentStateRequirementSetter(JSGlobalObject& lexicalGlobalObject, JSMockCDMFactory& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<MediaKeysRequirement>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    auto nativeValue = optionalNativeValue.value();
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setPersistentStateRequirement(WTFMove(nativeValue));
    });
    return true;
}

bool setJSMockCDMFactoryPersistentStateRequirement(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSMockCDMFactory>::set<setJSMockCDMFactoryPersistentStateRequirementSetter>(*lexicalGlobalObject, thisValue, encodedValue, "persistentStateRequirement");
}

static inline JSValue jsMockCDMFactoryCanCreateInstancesGetter(JSGlobalObject& lexicalGlobalObject, JSMockCDMFactory& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.canCreateInstances());
    return result;
}

EncodedJSValue jsMockCDMFactoryCanCreateInstances(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMockCDMFactory>::get<jsMockCDMFactoryCanCreateInstancesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "canCreateInstances");
}

static inline bool setJSMockCDMFactoryCanCreateInstancesSetter(JSGlobalObject& lexicalGlobalObject, JSMockCDMFactory& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setCanCreateInstances(WTFMove(nativeValue));
    });
    return true;
}

bool setJSMockCDMFactoryCanCreateInstances(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSMockCDMFactory>::set<setJSMockCDMFactoryCanCreateInstancesSetter>(*lexicalGlobalObject, thisValue, encodedValue, "canCreateInstances");
}

static inline JSValue jsMockCDMFactorySupportsServerCertificatesGetter(JSGlobalObject& lexicalGlobalObject, JSMockCDMFactory& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.supportsServerCertificates());
    return result;
}

EncodedJSValue jsMockCDMFactorySupportsServerCertificates(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMockCDMFactory>::get<jsMockCDMFactorySupportsServerCertificatesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "supportsServerCertificates");
}

static inline bool setJSMockCDMFactorySupportsServerCertificatesSetter(JSGlobalObject& lexicalGlobalObject, JSMockCDMFactory& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setSupportsServerCertificates(WTFMove(nativeValue));
    });
    return true;
}

bool setJSMockCDMFactorySupportsServerCertificates(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSMockCDMFactory>::set<setJSMockCDMFactorySupportsServerCertificatesSetter>(*lexicalGlobalObject, thisValue, encodedValue, "supportsServerCertificates");
}

static inline JSValue jsMockCDMFactorySupportsSessionsGetter(JSGlobalObject& lexicalGlobalObject, JSMockCDMFactory& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.supportsSessions());
    return result;
}

EncodedJSValue jsMockCDMFactorySupportsSessions(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMockCDMFactory>::get<jsMockCDMFactorySupportsSessionsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "supportsSessions");
}

static inline bool setJSMockCDMFactorySupportsSessionsSetter(JSGlobalObject& lexicalGlobalObject, JSMockCDMFactory& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setSupportsSessions(WTFMove(nativeValue));
    });
    return true;
}

bool setJSMockCDMFactorySupportsSessions(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSMockCDMFactory>::set<setJSMockCDMFactorySupportsSessionsSetter>(*lexicalGlobalObject, thisValue, encodedValue, "supportsSessions");
}

static inline JSValue jsMockCDMFactorySupportedEncryptionSchemesGetter(JSGlobalObject& lexicalGlobalObject, JSMockCDMFactory& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLSequence<IDLEnumeration<MediaKeyEncryptionScheme>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.supportedEncryptionSchemes());
    return result;
}

EncodedJSValue jsMockCDMFactorySupportedEncryptionSchemes(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMockCDMFactory>::get<jsMockCDMFactorySupportedEncryptionSchemesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "supportedEncryptionSchemes");
}

static inline bool setJSMockCDMFactorySupportedEncryptionSchemesSetter(JSGlobalObject& lexicalGlobalObject, JSMockCDMFactory& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLSequence<IDLEnumeration<MediaKeyEncryptionScheme>>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setSupportedEncryptionSchemes(WTFMove(nativeValue));
    });
    return true;
}

bool setJSMockCDMFactorySupportedEncryptionSchemes(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSMockCDMFactory>::set<setJSMockCDMFactorySupportedEncryptionSchemesSetter>(*lexicalGlobalObject, thisValue, encodedValue, "supportedEncryptionSchemes");
}

static inline JSC::EncodedJSValue jsMockCDMFactoryPrototypeFunctionUnregisterBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMockCDMFactory>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.unregister();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMockCDMFactoryPrototypeFunctionUnregister(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMockCDMFactory>::call<jsMockCDMFactoryPrototypeFunctionUnregisterBody>(*lexicalGlobalObject, *callFrame, "unregister");
}

void JSMockCDMFactory::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSMockCDMFactory*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSMockCDMFactoryOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSMockCDMFactoryOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsMockCDMFactory = static_cast<JSMockCDMFactory*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsMockCDMFactory->wrapped(), jsMockCDMFactory);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7MockCDMFactory@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore14MockCDMFactoryE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<MockCDMFactory>&& impl)
{

#if ENABLE(BINDING_INTEGRITY)
    void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
    void* expectedVTablePointer = __identifier("??_7MockCDMFactory@WebCore@@6B@");
#else
    void* expectedVTablePointer = &_ZTVN7WebCore14MockCDMFactoryE[2];
#endif

    // If this fails MockCDMFactory does not have a vtable, so you need to add the
    // ImplementationLacksVTable attribute to the interface definition
    static_assert(std::is_polymorphic<MockCDMFactory>::value, "MockCDMFactory is not polymorphic");

    // If you hit this assertion you either have a use after free bug, or
    // MockCDMFactory has subclasses. If MockCDMFactory has subclasses that get passed
    // to toJS() we currently require MockCDMFactory you to opt out of binding hardening
    // by adding the SkipVTableValidation attribute to the interface IDL definition
    RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    return createWrapper<MockCDMFactory>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, MockCDMFactory& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

MockCDMFactory* JSMockCDMFactory::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSMockCDMFactory*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(ENCRYPTED_MEDIA)
