/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(CONTENT_FILTERING)

#include "JSMockContentFilterSettings.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(MockContentFilterSettings::DecisionPoint enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("afterWillSendRequest"),
        MAKE_STATIC_STRING_IMPL("afterRedirect"),
        MAKE_STATIC_STRING_IMPL("afterResponse"),
        MAKE_STATIC_STRING_IMPL("afterAddData"),
        MAKE_STATIC_STRING_IMPL("afterFinishedAddingData"),
        MAKE_STATIC_STRING_IMPL("never"),
    };
    static_assert(static_cast<size_t>(MockContentFilterSettings::DecisionPoint::AfterWillSendRequest) == 0, "MockContentFilterSettings::DecisionPoint::AfterWillSendRequest is not 0 as expected");
    static_assert(static_cast<size_t>(MockContentFilterSettings::DecisionPoint::AfterRedirect) == 1, "MockContentFilterSettings::DecisionPoint::AfterRedirect is not 1 as expected");
    static_assert(static_cast<size_t>(MockContentFilterSettings::DecisionPoint::AfterResponse) == 2, "MockContentFilterSettings::DecisionPoint::AfterResponse is not 2 as expected");
    static_assert(static_cast<size_t>(MockContentFilterSettings::DecisionPoint::AfterAddData) == 3, "MockContentFilterSettings::DecisionPoint::AfterAddData is not 3 as expected");
    static_assert(static_cast<size_t>(MockContentFilterSettings::DecisionPoint::AfterFinishedAddingData) == 4, "MockContentFilterSettings::DecisionPoint::AfterFinishedAddingData is not 4 as expected");
    static_assert(static_cast<size_t>(MockContentFilterSettings::DecisionPoint::Never) == 5, "MockContentFilterSettings::DecisionPoint::Never is not 5 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, MockContentFilterSettings::DecisionPoint enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<MockContentFilterSettings::DecisionPoint> parseEnumeration<MockContentFilterSettings::DecisionPoint>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "afterWillSendRequest")
        return MockContentFilterSettings::DecisionPoint::AfterWillSendRequest;
    if (stringValue == "afterRedirect")
        return MockContentFilterSettings::DecisionPoint::AfterRedirect;
    if (stringValue == "afterResponse")
        return MockContentFilterSettings::DecisionPoint::AfterResponse;
    if (stringValue == "afterAddData")
        return MockContentFilterSettings::DecisionPoint::AfterAddData;
    if (stringValue == "afterFinishedAddingData")
        return MockContentFilterSettings::DecisionPoint::AfterFinishedAddingData;
    if (stringValue == "never")
        return MockContentFilterSettings::DecisionPoint::Never;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<MockContentFilterSettings::DecisionPoint>()
{
    return "\"afterWillSendRequest\", \"afterRedirect\", \"afterResponse\", \"afterAddData\", \"afterFinishedAddingData\", \"never\"";
}

String convertEnumerationToString(MockContentFilterSettings::Decision enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("allow"),
        MAKE_STATIC_STRING_IMPL("block"),
    };
    static_assert(static_cast<size_t>(MockContentFilterSettings::Decision::Allow) == 0, "MockContentFilterSettings::Decision::Allow is not 0 as expected");
    static_assert(static_cast<size_t>(MockContentFilterSettings::Decision::Block) == 1, "MockContentFilterSettings::Decision::Block is not 1 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < WTF_ARRAY_LENGTH(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(JSGlobalObject& lexicalGlobalObject, MockContentFilterSettings::Decision enumerationValue)
{
    return jsStringWithCache(&lexicalGlobalObject, convertEnumerationToString(enumerationValue));
}

template<> Optional<MockContentFilterSettings::Decision> parseEnumeration<MockContentFilterSettings::Decision>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto stringValue = value.toWTFString(&lexicalGlobalObject);
    if (stringValue == "allow")
        return MockContentFilterSettings::Decision::Allow;
    if (stringValue == "block")
        return MockContentFilterSettings::Decision::Block;
    return WTF::nullopt;
}

template<> const char* expectedEnumerationValues<MockContentFilterSettings::Decision>()
{
    return "\"allow\", \"block\"";
}

// Attributes

JSC::EncodedJSValue jsMockContentFilterSettingsEnabled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMockContentFilterSettingsEnabled(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMockContentFilterSettingsBlockedString(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMockContentFilterSettingsBlockedString(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMockContentFilterSettingsModifiedRequestURL(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMockContentFilterSettingsModifiedRequestURL(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMockContentFilterSettingsDecisionPoint(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMockContentFilterSettingsDecisionPoint(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMockContentFilterSettingsDecision(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMockContentFilterSettingsDecision(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMockContentFilterSettingsUnblockRequestDecision(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMockContentFilterSettingsUnblockRequestDecision(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMockContentFilterSettingsUnblockRequestURL(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSMockContentFilterSettingsPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSMockContentFilterSettingsPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMockContentFilterSettingsPrototype* ptr = new (NotNull, JSC::allocateCell<JSMockContentFilterSettingsPrototype>(vm.heap)) JSMockContentFilterSettingsPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMockContentFilterSettingsPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMockContentFilterSettingsPrototype, JSMockContentFilterSettingsPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSMockContentFilterSettingsPrototypeTableValues[] =
{
    { "enabled", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMockContentFilterSettingsEnabled), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMockContentFilterSettingsEnabled) } },
    { "blockedString", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMockContentFilterSettingsBlockedString), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMockContentFilterSettingsBlockedString) } },
    { "modifiedRequestURL", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMockContentFilterSettingsModifiedRequestURL), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMockContentFilterSettingsModifiedRequestURL) } },
    { "decisionPoint", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMockContentFilterSettingsDecisionPoint), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMockContentFilterSettingsDecisionPoint) } },
    { "decision", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMockContentFilterSettingsDecision), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMockContentFilterSettingsDecision) } },
    { "unblockRequestDecision", static_cast<unsigned>(JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMockContentFilterSettingsUnblockRequestDecision), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMockContentFilterSettingsUnblockRequestDecision) } },
    { "unblockRequestURL", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMockContentFilterSettingsUnblockRequestURL), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSMockContentFilterSettingsPrototype::s_info = { "MockContentFilterSettingsPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMockContentFilterSettingsPrototype) };

void JSMockContentFilterSettingsPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMockContentFilterSettings::info(), JSMockContentFilterSettingsPrototypeTableValues, *this);
}

const ClassInfo JSMockContentFilterSettings::s_info = { "MockContentFilterSettings", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMockContentFilterSettings) };

JSMockContentFilterSettings::JSMockContentFilterSettings(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MockContentFilterSettings>&& impl)
    : JSDOMWrapper<MockContentFilterSettings>(structure, globalObject, WTFMove(impl))
{
}

void JSMockContentFilterSettings::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, MockContentFilterSettings>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSMockContentFilterSettings::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSMockContentFilterSettingsPrototype::create(vm, &globalObject, JSMockContentFilterSettingsPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSMockContentFilterSettings::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSMockContentFilterSettings>(vm, globalObject);
}

void JSMockContentFilterSettings::destroy(JSC::JSCell* cell)
{
    JSMockContentFilterSettings* thisObject = static_cast<JSMockContentFilterSettings*>(cell);
    thisObject->JSMockContentFilterSettings::~JSMockContentFilterSettings();
}

template<> inline JSMockContentFilterSettings* IDLAttribute<JSMockContentFilterSettings>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSMockContentFilterSettings*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

static inline JSValue jsMockContentFilterSettingsEnabledGetter(JSGlobalObject& lexicalGlobalObject, JSMockContentFilterSettings& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.enabled());
    return result;
}

EncodedJSValue jsMockContentFilterSettingsEnabled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMockContentFilterSettings>::get<jsMockContentFilterSettingsEnabledGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "enabled");
}

static inline bool setJSMockContentFilterSettingsEnabledSetter(JSGlobalObject& lexicalGlobalObject, JSMockContentFilterSettings& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setEnabled(WTFMove(nativeValue));
    });
    return true;
}

bool setJSMockContentFilterSettingsEnabled(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSMockContentFilterSettings>::set<setJSMockContentFilterSettingsEnabledSetter>(*lexicalGlobalObject, thisValue, encodedValue, "enabled");
}

static inline JSValue jsMockContentFilterSettingsBlockedStringGetter(JSGlobalObject& lexicalGlobalObject, JSMockContentFilterSettings& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.blockedString());
    return result;
}

EncodedJSValue jsMockContentFilterSettingsBlockedString(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMockContentFilterSettings>::get<jsMockContentFilterSettingsBlockedStringGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "blockedString");
}

static inline bool setJSMockContentFilterSettingsBlockedStringSetter(JSGlobalObject& lexicalGlobalObject, JSMockContentFilterSettings& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setBlockedString(WTFMove(nativeValue));
    });
    return true;
}

bool setJSMockContentFilterSettingsBlockedString(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSMockContentFilterSettings>::set<setJSMockContentFilterSettingsBlockedStringSetter>(*lexicalGlobalObject, thisValue, encodedValue, "blockedString");
}

static inline JSValue jsMockContentFilterSettingsModifiedRequestURLGetter(JSGlobalObject& lexicalGlobalObject, JSMockContentFilterSettings& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.modifiedRequestURL());
    return result;
}

EncodedJSValue jsMockContentFilterSettingsModifiedRequestURL(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMockContentFilterSettings>::get<jsMockContentFilterSettingsModifiedRequestURLGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "modifiedRequestURL");
}

static inline bool setJSMockContentFilterSettingsModifiedRequestURLSetter(JSGlobalObject& lexicalGlobalObject, JSMockContentFilterSettings& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLDOMString>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setModifiedRequestURL(WTFMove(nativeValue));
    });
    return true;
}

bool setJSMockContentFilterSettingsModifiedRequestURL(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSMockContentFilterSettings>::set<setJSMockContentFilterSettingsModifiedRequestURLSetter>(*lexicalGlobalObject, thisValue, encodedValue, "modifiedRequestURL");
}

static inline JSValue jsMockContentFilterSettingsDecisionPointGetter(JSGlobalObject& lexicalGlobalObject, JSMockContentFilterSettings& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<MockContentFilterSettings::DecisionPoint>>(lexicalGlobalObject, throwScope, impl.decisionPoint());
    return result;
}

EncodedJSValue jsMockContentFilterSettingsDecisionPoint(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMockContentFilterSettings>::get<jsMockContentFilterSettingsDecisionPointGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "decisionPoint");
}

static inline bool setJSMockContentFilterSettingsDecisionPointSetter(JSGlobalObject& lexicalGlobalObject, JSMockContentFilterSettings& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<MockContentFilterSettings::DecisionPoint>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    auto nativeValue = optionalNativeValue.value();
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setDecisionPoint(WTFMove(nativeValue));
    });
    return true;
}

bool setJSMockContentFilterSettingsDecisionPoint(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSMockContentFilterSettings>::set<setJSMockContentFilterSettingsDecisionPointSetter>(*lexicalGlobalObject, thisValue, encodedValue, "decisionPoint");
}

static inline JSValue jsMockContentFilterSettingsDecisionGetter(JSGlobalObject& lexicalGlobalObject, JSMockContentFilterSettings& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<MockContentFilterSettings::Decision>>(lexicalGlobalObject, throwScope, impl.decision());
    return result;
}

EncodedJSValue jsMockContentFilterSettingsDecision(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMockContentFilterSettings>::get<jsMockContentFilterSettingsDecisionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "decision");
}

static inline bool setJSMockContentFilterSettingsDecisionSetter(JSGlobalObject& lexicalGlobalObject, JSMockContentFilterSettings& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<MockContentFilterSettings::Decision>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    auto nativeValue = optionalNativeValue.value();
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setDecision(WTFMove(nativeValue));
    });
    return true;
}

bool setJSMockContentFilterSettingsDecision(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSMockContentFilterSettings>::set<setJSMockContentFilterSettingsDecisionSetter>(*lexicalGlobalObject, thisValue, encodedValue, "decision");
}

static inline JSValue jsMockContentFilterSettingsUnblockRequestDecisionGetter(JSGlobalObject& lexicalGlobalObject, JSMockContentFilterSettings& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLEnumeration<MockContentFilterSettings::Decision>>(lexicalGlobalObject, throwScope, impl.unblockRequestDecision());
    return result;
}

EncodedJSValue jsMockContentFilterSettingsUnblockRequestDecision(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMockContentFilterSettings>::get<jsMockContentFilterSettingsUnblockRequestDecisionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "unblockRequestDecision");
}

static inline bool setJSMockContentFilterSettingsUnblockRequestDecisionSetter(JSGlobalObject& lexicalGlobalObject, JSMockContentFilterSettings& thisObject, JSValue value, ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(throwScope);
    auto& impl = thisObject.wrapped();
    auto optionalNativeValue = parseEnumeration<MockContentFilterSettings::Decision>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    if (UNLIKELY(!optionalNativeValue))
        return false;
    auto nativeValue = optionalNativeValue.value();
    AttributeSetter::call(lexicalGlobalObject, throwScope, [&] {
        return impl.setUnblockRequestDecision(WTFMove(nativeValue));
    });
    return true;
}

bool setJSMockContentFilterSettingsUnblockRequestDecision(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    return IDLAttribute<JSMockContentFilterSettings>::set<setJSMockContentFilterSettingsUnblockRequestDecisionSetter>(*lexicalGlobalObject, thisValue, encodedValue, "unblockRequestDecision");
}

static inline JSValue jsMockContentFilterSettingsUnblockRequestURLGetter(JSGlobalObject& lexicalGlobalObject, JSMockContentFilterSettings& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.unblockRequestURL());
    return result;
}

EncodedJSValue jsMockContentFilterSettingsUnblockRequestURL(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMockContentFilterSettings>::get<jsMockContentFilterSettingsUnblockRequestURLGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "unblockRequestURL");
}

void JSMockContentFilterSettings::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSMockContentFilterSettings*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSMockContentFilterSettingsOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSMockContentFilterSettingsOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsMockContentFilterSettings = static_cast<JSMockContentFilterSettings*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsMockContentFilterSettings->wrapped(), jsMockContentFilterSettings);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<MockContentFilterSettings>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to MockContentFilterSettings.
    static_assert(!std::is_polymorphic<MockContentFilterSettings>::value, "MockContentFilterSettings is polymorphic but the IDL claims it is not");
    return createWrapper<MockContentFilterSettings>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, MockContentFilterSettings& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

MockContentFilterSettings* JSMockContentFilterSettings::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSMockContentFilterSettings*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(CONTENT_FILTERING)
