/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#pragma once

#include "IDLTypes.h"
#include "JSCallbackData.h"
#include "MutationCallback.h"
#include <wtf/Forward.h>

namespace WebCore {

class JSMutationCallback final : public MutationCallback {
public:
    static Ref<JSMutationCallback> create(JSC::JSObject* callback, JSDOMGlobalObject* globalObject)
    {
        return adoptRef(*new JSMutationCallback(callback, globalObject));
    }

    virtual ScriptExecutionContext* scriptExecutionContext() const { return ContextDestructionObserver::scriptExecutionContext(); }

    virtual ~JSMutationCallback();
    JSCallbackDataWeak* callbackData() { return m_data; }

    // Functions
    CallbackResult<typename IDLVoid::ImplementationType> handleEvent(typename IDLInterface<MutationObserver>::ParameterType thisObject, typename IDLSequence<IDLInterface<MutationRecord>>::ParameterType mutations, typename IDLInterface<MutationObserver>::ParameterType observer) override;

private:
    JSMutationCallback(JSC::JSObject*, JSDOMGlobalObject*);

    bool hasCallback() const final { return m_data && m_data->callback(); }

    void visitJSFunction(JSC::SlotVisitor&) override;

    JSCallbackDataWeak* m_data;
};

JSC::JSValue toJS(MutationCallback&);
inline JSC::JSValue toJS(MutationCallback* impl) { return impl ? toJS(*impl) : JSC::jsNull(); }

} // namespace WebCore
