/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSMutationObserver.h"

#include "ActiveDOMObject.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertCallbacks.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSMutationCallback.h"
#include "JSMutationRecord.h"
#include "JSNode.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

template<> MutationObserver::Init convertDictionary<MutationObserver::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    MutationObserver::Init result;
    JSValue attributeFilterValue;
    if (isNullOrUndefined)
        attributeFilterValue = jsUndefined();
    else {
        attributeFilterValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "attributeFilter"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!attributeFilterValue.isUndefined()) {
        result.attributeFilter = convert<IDLSequence<IDLDOMString>>(lexicalGlobalObject, attributeFilterValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue attributeOldValueValue;
    if (isNullOrUndefined)
        attributeOldValueValue = jsUndefined();
    else {
        attributeOldValueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "attributeOldValue"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!attributeOldValueValue.isUndefined()) {
        result.attributeOldValue = convert<IDLBoolean>(lexicalGlobalObject, attributeOldValueValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue attributesValue;
    if (isNullOrUndefined)
        attributesValue = jsUndefined();
    else {
        attributesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "attributes"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!attributesValue.isUndefined()) {
        result.attributes = convert<IDLBoolean>(lexicalGlobalObject, attributesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue characterDataValue;
    if (isNullOrUndefined)
        characterDataValue = jsUndefined();
    else {
        characterDataValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "characterData"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!characterDataValue.isUndefined()) {
        result.characterData = convert<IDLBoolean>(lexicalGlobalObject, characterDataValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue characterDataOldValueValue;
    if (isNullOrUndefined)
        characterDataOldValueValue = jsUndefined();
    else {
        characterDataOldValueValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "characterDataOldValue"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!characterDataOldValueValue.isUndefined()) {
        result.characterDataOldValue = convert<IDLBoolean>(lexicalGlobalObject, characterDataOldValueValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue childListValue;
    if (isNullOrUndefined)
        childListValue = jsUndefined();
    else {
        childListValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "childList"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!childListValue.isUndefined()) {
        result.childList = convert<IDLBoolean>(lexicalGlobalObject, childListValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.childList = false;
    JSValue subtreeValue;
    if (isNullOrUndefined)
        subtreeValue = jsUndefined();
    else {
        subtreeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "subtree"));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!subtreeValue.isUndefined()) {
        result.subtree = convert<IDLBoolean>(lexicalGlobalObject, subtreeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.subtree = false;
    return result;
}

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsMutationObserverPrototypeFunctionObserve(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsMutationObserverPrototypeFunctionDisconnect(JSC::JSGlobalObject*, JSC::CallFrame*);
JSC::EncodedJSValue JSC_HOST_CALL jsMutationObserverPrototypeFunctionTakeRecords(JSC::JSGlobalObject*, JSC::CallFrame*);

// Attributes

JSC::EncodedJSValue jsMutationObserverConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMutationObserverConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);

class JSMutationObserverPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSMutationObserverPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMutationObserverPrototype* ptr = new (NotNull, JSC::allocateCell<JSMutationObserverPrototype>(vm.heap)) JSMutationObserverPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMutationObserverPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMutationObserverPrototype, JSMutationObserverPrototype::Base);

using JSMutationObserverConstructor = JSDOMConstructor<JSMutationObserver>;

template<> EncodedJSValue JSC_HOST_CALL JSMutationObserverConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    auto* castedThis = jsCast<JSMutationObserverConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto callback = convert<IDLCallbackFunction<JSMutationCallback>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), *castedThis->globalObject(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentMustBeFunctionError(lexicalGlobalObject, scope, 0, "callback", "MutationObserver", nullptr); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = MutationObserver::create(callback.releaseNonNull());
    return JSValue::encode(toJSNewlyCreated<IDLInterface<MutationObserver>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(object)));
}

template<> JSValue JSMutationObserverConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSMutationObserverConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSMutationObserver::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("MutationObserver"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSMutationObserverConstructor::s_info = { "MutationObserver", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMutationObserverConstructor) };

/* Hash table for prototype */

static const HashTableValue JSMutationObserverPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMutationObserverConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMutationObserverConstructor) } },
    { "observe", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMutationObserverPrototypeFunctionObserve), (intptr_t) (1) } },
    { "disconnect", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMutationObserverPrototypeFunctionDisconnect), (intptr_t) (0) } },
    { "takeRecords", static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { (intptr_t)static_cast<RawNativeFunction>(jsMutationObserverPrototypeFunctionTakeRecords), (intptr_t) (0) } },
};

const ClassInfo JSMutationObserverPrototype::s_info = { "MutationObserverPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMutationObserverPrototype) };

void JSMutationObserverPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMutationObserver::info(), JSMutationObserverPrototypeTableValues, *this);
}

const ClassInfo JSMutationObserver::s_info = { "MutationObserver", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMutationObserver) };

JSMutationObserver::JSMutationObserver(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MutationObserver>&& impl)
    : JSDOMWrapper<MutationObserver>(structure, globalObject, WTFMove(impl))
{
}

void JSMutationObserver::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, MutationObserver>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSMutationObserver::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSMutationObserverPrototype::create(vm, &globalObject, JSMutationObserverPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSMutationObserver::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSMutationObserver>(vm, globalObject);
}

JSValue JSMutationObserver::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMutationObserverConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSMutationObserver::destroy(JSC::JSCell* cell)
{
    JSMutationObserver* thisObject = static_cast<JSMutationObserver*>(cell);
    thisObject->JSMutationObserver::~JSMutationObserver();
}

template<> inline JSMutationObserver* IDLOperation<JSMutationObserver>::cast(JSGlobalObject& lexicalGlobalObject, CallFrame& callFrame)
{
    return jsDynamicCast<JSMutationObserver*>(JSC::getVM(&lexicalGlobalObject), callFrame.thisValue());
}

EncodedJSValue jsMutationObserverConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMutationObserverPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSMutationObserver::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSMutationObserverConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMutationObserverPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSC::EncodedJSValue jsMutationObserverPrototypeFunctionObserveBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMutationObserver>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    auto target = convert<IDLInterface<Node>>(*lexicalGlobalObject, callFrame->uncheckedArgument(0), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "target", "MutationObserver", "observe", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto options = convert<IDLDictionary<MutationObserver::Init>>(*lexicalGlobalObject, callFrame->argument(1));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    propagateException(*lexicalGlobalObject, throwScope, impl.observe(*target, WTFMove(options)));
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMutationObserverPrototypeFunctionObserve(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMutationObserver>::call<jsMutationObserverPrototypeFunctionObserveBody>(*lexicalGlobalObject, *callFrame, "observe");
}

static inline JSC::EncodedJSValue jsMutationObserverPrototypeFunctionDisconnectBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMutationObserver>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    impl.disconnect();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsMutationObserverPrototypeFunctionDisconnect(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMutationObserver>::call<jsMutationObserverPrototypeFunctionDisconnectBody>(*lexicalGlobalObject, *callFrame, "disconnect");
}

static inline JSC::EncodedJSValue jsMutationObserverPrototypeFunctionTakeRecordsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSMutationObserver>::ClassParameter castedThis, JSC::ThrowScope& throwScope)
{
    UNUSED_PARAM(lexicalGlobalObject);
    UNUSED_PARAM(callFrame);
    UNUSED_PARAM(throwScope);
    auto& impl = castedThis->wrapped();
    auto implResult = impl.takeRecords();
    return JSValue::encode(toJS<IDLSequence<IDLInterface<MutationRecord>>>(*lexicalGlobalObject, *castedThis->globalObject(), WTFMove(implResult.records)));
}

EncodedJSValue JSC_HOST_CALL jsMutationObserverPrototypeFunctionTakeRecords(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    return IDLOperation<JSMutationObserver>::call<jsMutationObserverPrototypeFunctionTakeRecordsBody>(*lexicalGlobalObject, *callFrame, "takeRecords");
}

void JSMutationObserver::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSMutationObserver*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSMutationObserver::visitOutputConstraints(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSMutationObserver*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSMutationObserver::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSMutationObserver*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

void JSMutationObserverOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsMutationObserver = static_cast<JSMutationObserver*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsMutationObserver->wrapped(), jsMutationObserver);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<MutationObserver>&& impl)
{
    // If you hit this failure the interface definition has the ImplementationLacksVTable
    // attribute. You should remove that attribute. If the class has subclasses
    // that may be passed through this toJS() function you should use the SkipVTableValidation
    // attribute to MutationObserver.
    static_assert(!std::is_polymorphic<MutationObserver>::value, "MutationObserver is polymorphic but the IDL claims it is not");
    return createWrapper<MutationObserver>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, MutationObserver& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

MutationObserver* JSMutationObserver::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSMutationObserver*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
