/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSMutationRecord.h"

#include "ActiveDOMObject.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMWrapperCache.h"
#include "JSNode.h"
#include "JSNodeList.h"
#include "ScriptExecutionContext.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

JSC::EncodedJSValue jsMutationRecordConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
bool setJSMutationRecordConstructor(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::EncodedJSValue);
JSC::EncodedJSValue jsMutationRecordType(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMutationRecordTarget(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMutationRecordAddedNodes(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMutationRecordRemovedNodes(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMutationRecordPreviousSibling(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMutationRecordNextSibling(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMutationRecordAttributeName(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMutationRecordAttributeNamespace(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);
JSC::EncodedJSValue jsMutationRecordOldValue(JSC::JSGlobalObject*, JSC::EncodedJSValue, JSC::PropertyName);

class JSMutationRecordPrototype : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSMutationRecordPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSMutationRecordPrototype* ptr = new (NotNull, JSC::allocateCell<JSMutationRecordPrototype>(vm.heap)) JSMutationRecordPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSMutationRecordPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSMutationRecordPrototype, JSMutationRecordPrototype::Base);

using JSMutationRecordConstructor = JSDOMConstructorNotConstructable<JSMutationRecord>;

template<> JSValue JSMutationRecordConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSMutationRecordConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->prototype, JSMutationRecord::prototype(vm, globalObject), JSC::PropertyAttribute::DontDelete | JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->name, jsNontrivialString(vm, String("MutationRecord"_s)), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
}

template<> const ClassInfo JSMutationRecordConstructor::s_info = { "MutationRecord", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMutationRecordConstructor) };

/* Hash table for prototype */

static const HashTableValue JSMutationRecordPrototypeTableValues[] =
{
    { "constructor", static_cast<unsigned>(JSC::PropertyAttribute::DontEnum), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMutationRecordConstructor), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(setJSMutationRecordConstructor) } },
    { "type", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMutationRecordType), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "target", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMutationRecordTarget), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "addedNodes", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMutationRecordAddedNodes), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "removedNodes", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMutationRecordRemovedNodes), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "previousSibling", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMutationRecordPreviousSibling), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "nextSibling", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMutationRecordNextSibling), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "attributeName", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMutationRecordAttributeName), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "attributeNamespace", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMutationRecordAttributeNamespace), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
    { "oldValue", static_cast<unsigned>(JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute), NoIntrinsic, { (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMutationRecordOldValue), (intptr_t) static_cast<PutPropertySlot::PutValueFunc>(0) } },
};

const ClassInfo JSMutationRecordPrototype::s_info = { "MutationRecordPrototype", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMutationRecordPrototype) };

void JSMutationRecordPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSMutationRecord::info(), JSMutationRecordPrototypeTableValues, *this);
}

const ClassInfo JSMutationRecord::s_info = { "MutationRecord", &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSMutationRecord) };

JSMutationRecord::JSMutationRecord(Structure* structure, JSDOMGlobalObject& globalObject, Ref<MutationRecord>&& impl)
    : JSDOMWrapper<MutationRecord>(structure, globalObject, WTFMove(impl))
{
}

void JSMutationRecord::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    ASSERT(inherits(vm, info()));

    static_assert(!std::is_base_of<ActiveDOMObject, MutationRecord>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

}

JSObject* JSMutationRecord::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return JSMutationRecordPrototype::create(vm, &globalObject, JSMutationRecordPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype()));
}

JSObject* JSMutationRecord::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSMutationRecord>(vm, globalObject);
}

JSValue JSMutationRecord::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMutationRecordConstructor>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSMutationRecord::destroy(JSC::JSCell* cell)
{
    JSMutationRecord* thisObject = static_cast<JSMutationRecord*>(cell);
    thisObject->JSMutationRecord::~JSMutationRecord();
}

template<> inline JSMutationRecord* IDLAttribute<JSMutationRecord>::cast(JSGlobalObject& lexicalGlobalObject, EncodedJSValue thisValue)
{
    return jsDynamicCast<JSMutationRecord*>(JSC::getVM(&lexicalGlobalObject), JSValue::decode(thisValue));
}

EncodedJSValue jsMutationRecordConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMutationRecordPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSMutationRecord::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

bool setJSMutationRecordConstructor(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue)
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSMutationRecordPrototype*>(vm, JSValue::decode(thisValue));
    if (UNLIKELY(!prototype)) {
        throwVMTypeError(lexicalGlobalObject, throwScope);
        return false;
    }
    // Shadowing a built-in constructor
    return prototype->putDirect(vm, vm.propertyNames->constructor, JSValue::decode(encodedValue));
}

static inline JSValue jsMutationRecordTypeGetter(JSGlobalObject& lexicalGlobalObject, JSMutationRecord& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.type());
    return result;
}

EncodedJSValue jsMutationRecordType(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMutationRecord>::get<jsMutationRecordTypeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "type");
}

static inline JSValue jsMutationRecordTargetGetter(JSGlobalObject& lexicalGlobalObject, JSMutationRecord& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<Node>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.target());
    return result;
}

EncodedJSValue jsMutationRecordTarget(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMutationRecord>::get<jsMutationRecordTargetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "target");
}

static inline JSValue jsMutationRecordAddedNodesGetter(JSGlobalObject& lexicalGlobalObject, JSMutationRecord& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<NodeList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.addedNodes());
    return result;
}

EncodedJSValue jsMutationRecordAddedNodes(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMutationRecord>::get<jsMutationRecordAddedNodesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "addedNodes");
}

static inline JSValue jsMutationRecordRemovedNodesGetter(JSGlobalObject& lexicalGlobalObject, JSMutationRecord& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLInterface<NodeList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.removedNodes());
    return result;
}

EncodedJSValue jsMutationRecordRemovedNodes(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMutationRecord>::get<jsMutationRecordRemovedNodesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "removedNodes");
}

static inline JSValue jsMutationRecordPreviousSiblingGetter(JSGlobalObject& lexicalGlobalObject, JSMutationRecord& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<Node>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.previousSibling());
    return result;
}

EncodedJSValue jsMutationRecordPreviousSibling(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMutationRecord>::get<jsMutationRecordPreviousSiblingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "previousSibling");
}

static inline JSValue jsMutationRecordNextSiblingGetter(JSGlobalObject& lexicalGlobalObject, JSMutationRecord& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLInterface<Node>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.nextSibling());
    return result;
}

EncodedJSValue jsMutationRecordNextSibling(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMutationRecord>::get<jsMutationRecordNextSiblingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "nextSibling");
}

static inline JSValue jsMutationRecordAttributeNameGetter(JSGlobalObject& lexicalGlobalObject, JSMutationRecord& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeName());
    return result;
}

EncodedJSValue jsMutationRecordAttributeName(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMutationRecord>::get<jsMutationRecordAttributeNameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "attributeName");
}

static inline JSValue jsMutationRecordAttributeNamespaceGetter(JSGlobalObject& lexicalGlobalObject, JSMutationRecord& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeNamespace());
    return result;
}

EncodedJSValue jsMutationRecordAttributeNamespace(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMutationRecord>::get<jsMutationRecordAttributeNamespaceGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "attributeNamespace");
}

static inline JSValue jsMutationRecordOldValueGetter(JSGlobalObject& lexicalGlobalObject, JSMutationRecord& thisObject, ThrowScope& throwScope)
{
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    JSValue result = toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.oldValue());
    return result;
}

EncodedJSValue jsMutationRecordOldValue(JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName)
{
    return IDLAttribute<JSMutationRecord>::get<jsMutationRecordOldValueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, "oldValue");
}

void JSMutationRecord::visitChildren(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSMutationRecord*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSMutationRecord::visitOutputConstraints(JSCell* cell, SlotVisitor& visitor)
{
    auto* thisObject = jsCast<JSMutationRecord*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

void JSMutationRecord::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSMutationRecord*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url " + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSMutationRecordOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSMutationRecordOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsMutationRecord = static_cast<JSMutationRecord*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsMutationRecord->wrapped(), jsMutationRecord);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<MutationRecord>&& impl)
{
    return createWrapper<MutationRecord>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, MutationRecord& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

MutationRecord* JSMutationRecord::toWrapped(JSC::VM& vm, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSMutationRecord*>(vm, value))
        return &wrapper->wrapped();
    return nullptr;
}

}
